C     RENBR(JOBGRF/JOBS - CHECK ALLOCATION OF INTERVIEWS)
C
C     DONALD BARTH, YALE SCHOOL OF MANAGEMENT
C
C     THIS PROGRAM IS PART OF THE JOB INTERVIEW REQUEST SYSTEM
C
C     *****************************************************
C     *                                                   *
C     *  ARRAYS LIMITING SIZE OF CASE HANDLED BY PROGRAM  *
C     *                                                   *
C     *****************************************************
C
C     ARRAYS WHICH STORE INFORMATION ABOUT ALL FIRMS RECRUITING
C
C     NUMBER = THE IDENTIFICATION CODE FOR FIRM
C     KNTOPN = HOW MANY INTERVIEWS ARE BEING HELD
      DIMENSION KNTOPN(200),NUMBER(200)
C
C     ************************************************************
C     *                                                          *
C     *  ARRAYS INDENPENDENT OF NUMBER OF STUDENTS OR SCHEDULES  *
C     *                                                          *
C     ************************************************************
C
C     ARRAY WHICH STORES OVERALL INFORMATION ABOUT NUMBERS GRANTED
C     DIMENSION NUMGRF(LMTXXX,LMTYYY)
      DIMENSION NUMGRF(22,22)
C
C     IDENTIFICATION OF EACH FIRM
C     LTRINC = THE NAME OF THE FIRM
C     LTRDPT = THE DIVISION NAMES
C     LTRADR = THE LOCATION OF THE FIRM
      DIMENSION LTRINC(40),LTRDPT(30),LTRADR(30)
C
C     LTRTIM = CURRENT DATE AND TIME PRINTABLE BY 15A1 FORMAT
C     LTRGOT = WORD GOTTEN FOR USE IN GRAPH
      DIMENSION LTRTIM(15),LTRGOT(6)
C
C     IPREFR = DESIRED STARTING TIMES
C     KNTTAD = KOUNT OF THOSE SPECIFYING TIME AND DATE
C     KNTTND = KOUNT OF THOSE SPECIFYING TIME NOT DATE
      DIMENSION IPREFR(13),KNTTAD(13),KNTTND(13)
C
C     IDENTIFICATION OF EACH USER
C     LTRWHO = THE NAME OF THE ACCOUNT
C     LTRNAM = THE NAME OF THE STUDENT
C     LTRPSW = THE PASSWORD USED BY THE STUDENT
      DIMENSION LTRWHO(40),LTRNAM(30),LTRPSW(20)
C
C     LTRBFR = INPUT/OUTPUT BUFFER
      DIMENSION LTRBFR(80)
C
C     ODD LETTERS
      DATA LTRSPA/1H /
C
C     UNIT NUMBERS FOR TERMINAL AND FILES
      DATA ITTY,IDISK,JDISK,KDISK,LDISK/5,1,20,21,22/
C
C     DIMENSIONS OF ARRAYS CONTAINING CHARACTER INFORMATION
      DATA LMTINC,LMTDPT,LMTADR,LMTBFR,LMTNAM,LMTGOT/
     1 40,30,30,80,30,6/
C
C     DIMENSIONS OF ARRAYS LIMITING SIZE OF CASE HANDLED
C     LMTFRM = MAXIMUM NUMBER OF FIRMS
C     LMTPRF = MAXIMUM NUMBER OF TIME PREFERENCES
C     LMTXXX = MAXIMUM WIDTH OF THE GRAPH
C     LMTYYY = MAXIMUM HEIGHT OF GRAPH
      DATA LMTFRM,LMTPRF,LMTXXX,LMTYYY/
     1 200,13,22,22/
C
C     WORD GOTTEN FOR LABELING GRAPH
      DATA LTRGOT/1HG,1Ho,1Ht,1Ht,1He,1Hn/
C
C     TELL USER WHAT PROGRAM THIS IS
      WRITE(ITTY,1)
    1 FORMAT(' JOBGRF'/
     1' Check allocation of interviews by either JOBBIG or JOBSLO'/
     21X)
C
C     **************************************
C     *                                    *
C     *  READ THE ADMINISTRATOR FIRM FILE  *
C     *                                    *
C     **************************************
C
      WRITE(ITTY,2)
    2 FORMAT(' ***** Input files *****')
      CALL LCLOPN( 5,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      READ(IDISK,3)IAUTHR,ICLASS,JMOVE,JPASS,IVERSN,NUMADM
    3 FORMAT(6I)
      READ(IDISK,4)KNTINC,MAXNUM,MANNER,MAXSTG,MAXRND,
     1 MAXALL,MAXBID,MAXPAY
    4 FORMAT(8I)
      IF(KNTINC.LE.0)GO TO 13
      IF(KNTINC.GT.LMTFRM)GO TO 61
      DO 12 NOWINC=1,KNTINC
      READ(IDISK,5)LTRINC
      READ(IDISK,6)LTRDPT
      READ(IDISK,7)LTRADR
      READ(IDISK,8)NUMBER(NOWINC),LENGTH,
     1KNTOPN(NOWINC),INTRVW,IUSDUP,
     2INCLSD,JNCLSD
    5 FORMAT(40A1)
    6 FORMAT(30A1)
    7 FORMAT(30A1)
    8 FORMAT(7I)
      LIMIT=INTRVW
      IF(LIMIT.LE.0)GO TO 11
      DO 10 I=1,LIMIT
      READ(IDISK,9)JDATE,
     1JFIRST,JFINAL,JSCHDL
    9 FORMAT(4I)
   10 CONTINUE
   11 CONTINUE
   12 CONTINUE
   13 CALL LCLCLS( 5,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     CHECK THAT THIS WAS CORRECT VERSION OF FIRM FILE
      IF(IAUTHR.LT.1)GO TO 67
      IF(IAUTHR.GT.3)GO TO 67
      IF(IAUTHR.EQ.1)GO TO 65
      IF(IAUTHR.EQ.3)GO TO 65
C
C     **********************************************
C     *                                            *
C     *  CHART INTERVIEWS GOTTEN VERSUS REQUESTED  *
C     *                                            *
C     **********************************************
C
C     ZERO OUT THE PERFORMANCE ARRAY
      DO 14 I=1,LMTXXX
      DO 14 J=1,LMTYYY
      NUMGRF(I,J)=0
   14 CONTINUE
      DO 15 I=1,LMTPRF
      KNTTAD(I)=0
      KNTTND(I)=0
   15 CONTINUE
C     KNTTD1 = ASKED FOR TIME NOT DATE, DID NOT GET TIME
C     KNTTD2 = ASKED FOR TIME AND DATE, GOT NEITHER
C     KNTTD3 = ASKED FOR TIME AND DATE, GOT ONLY DATE
C     KNTTD4 = ASKED FOR DATE ONLY, DID NOT GET DATE
C     KNTTD5 = ASKED FOR DATE ONLY, GOT DATE
C     KNTTD6 = DID NOT ASK FOR EITHER DATE OR TIME
      KNTTD1=0
      KNTTD2=0
      KNTTD3=0
      KNTTD4=0
      KNTTD5=0
      KNTTD6=0
C
C     GET NAME OF INPUT FILE
      WRITE(ITTY,16)
   16 FORMAT('  Intermediate student request file (file 6)? or')
      CALL LCLOPN( 8,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     READ THE STUDENTS DECISION FILE
      NOWSTD=0
   17 NOWSTD=NOWSTD+1
      READ(IDISK,18,END=34)IAUTHR,ICLASS,IMOVE,IPASS,
     1 IVERSN,NUMWHO,LTRPSW
      READ(IDISK,19)ISUBMT,IUSED,KNTSIN,LOCKUP,IMANNR,
     1 KNTALL,IGVBAK
   18 FORMAT(6I,20A1)
   19 FORMAT(7I)
      READ(IDISK,20)LTRWHO
   20 FORMAT(40A1)
      READ(IDISK,21)LTRNAM
   21 FORMAT(30A1)
C
C     SPACE DOWN OVER REQUESTS FOR THIS STUDENT
      KNTGET=0
      IF(KNTSIN.LE.0)GO TO 31
      DO 30 KOMPNY=1,KNTSIN
      READ(IDISK,22)NUMVOT,KNDVOT,KNTPRF,
     1IDATE,KLOSED,IRANK,JRANK,
     2KLOCK,MTIME,MDATE,MRECRT,ISOURC
   22 FORMAT(12I)
      IF(IMOVE.NE.JMOVE)GO TO 24
      IF(IPASS.GT.JPASS)GO TO 24
      IF(KLOSED.NE.0)GO TO 24
      LOCATN=0
   23 LOCATN=LOCATN+1
      IF(LOCATN.GT.KNTINC)GO TO 24
      IF(NUMVOT.NE.NUMBER(LOCATN))GO TO 23
      IF(JRANK.LE.KNTOPN(LOCATN))KNTGET=KNTGET+1
   24 CONTINUE
      IF(KNTPRF.LE.0)GO TO 28
      IF(KNTPRF.GT.LMTPRF)GO TO 63
      READ(IDISK,25)(IPREFR(I),I=1,KNTPRF)
   25 FORMAT(13I)
      IF(KLOCK.EQ.0)GO TO 30
      IF(IDATE.EQ.0)GO TO 26
      IF(MDATE.EQ.IDATE)GO TO 26
      KNTTD2=KNTTD2+1
      GO TO 30
   26 DO 27 I=1,KNTPRF
      IF(MTIME.NE.IPREFR(I))GO TO 27
      IF(IDATE.EQ.0)KNTTND(I)=KNTTND(I)+1
      IF(IDATE.NE.0)KNTTAD(I)=KNTTAD(I)+1
      GO TO 30
   27 CONTINUE
      IF(IDATE.EQ.0)KNTTD1=KNTTD1+1
      IF(IDATE.NE.0)KNTTD3=KNTTD3+1
      GO TO 30
   28 IF(KLOCK.EQ.0)GO TO 30
      IF(IDATE.EQ.0)GO TO 29
      IF(MDATE.NE.IDATE)KNTTD4=KNTTD4+1
      IF(MDATE.EQ.IDATE)KNTTD5=KNTTD5+1
      GO TO 30
   29 KNTTD6=KNTTD6+1
   30 CONTINUE
C
C     READ THE - AT END OF STUDENT ENTRY
   31 READ(IDISK,32)LTREND
   32 FORMAT(1A1)
C
C     INCREMENT COUNT OF REQUESTED AND GOTTEN INTERVIEWS
      IF(IMOVE.NE.JMOVE)GO TO 33
      IF(IPASS.GT.JPASS)GO TO 33
      KNTSIN=KNTSIN+1
      IF(KNTSIN.GT.LMTXXX)KNTSIN=LMTXXX
      KNTGET=KNTGET+1
      IF(KNTGET.GT.LMTYYY)KNTGET=LMTYYY
      NUMGRF(KNTSIN,KNTGET)=NUMGRF(KNTSIN,KNTGET)+1
   33 GO TO 17
   34 CONTINUE
      CALL LCLCLS( 8,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     FIND OUT THE LIMITING VALUES OF X AND Y FOR GRAPH
      K=LMTXXX-1
      L=LMTYYY-1
      MAXXXX=1
      MAXYYY=1
      DO 36 I=1,K
      DO 35 J=1,L
      IF(NUMGRF(I,J).EQ.0)GO TO 35
      IF(MAXXXX.LT.I)MAXXXX=I
      IF(MAXYYY.LT.J)MAXYYY=J
   35 CONTINUE
   36 CONTINUE
      MAXXXX=MAXXXX+1
      MAXYYY=MAXYYY+1
      DO 37 I=1,LMTXXX
      NUMGRF(I,MAXYYY)=NUMGRF(I,LMTYYY)
   37 CONTINUE
      DO 38 J=1,LMTYYY
      NUMGRF(MAXXXX,J)=NUMGRF(LMTXXX,J)
   38 CONTINUE
C
C     WRITE THE GRAPH OF REQUESTED VERSUS GOTTEN INTERVIEWS
      WRITE(ITTY,39)
   39 FORMAT(' Horizontal axis is number requested, Vert',
     1'ical is number gotten'/' Values in chart are numb',
     2'ers of students asking and getting this many'/' T',
     3'op line and right column are overflow outside ran',
     4'ge which is represented'/1X)
      DO 40 I=1,MAXXXX
      DO 40 J=1,MAXYYY
      IF(NUMGRF(I,J).GT.999)NUMGRF(I,J)=999
   40 CONTINUE
      DO 46 NOWYYY=1,MAXYYY
      J=MAXYYY-NOWYYY+1
      K=J-1
      L=NOWYYY-MAXYYY+LMTGOT
      IF(MAXYYY.LT.LMTGOT)L=NOWYYY
      IF(L.LE.0)GO TO 43
      IF(NOWYYY.EQ.1)WRITE(ITTY,41)LTRGOT(L),
     1 (NUMGRF(I,J),I=1,MAXXXX)
      IF(NOWYYY.GT.1)WRITE(ITTY,42)LTRGOT(L),
     1 K,(NUMGRF(I,J),I=1,MAXXXX)
   41 FORMAT(1X,1A1,4X,30I3)
   42 FORMAT(1X,1A1,1I3,1X,30I3)
      GO TO 46
   43 IF(NOWYYY.EQ.1)WRITE(ITTY,44)(NUMGRF(I,J),I=1,MAXXXX)
      IF(NOWYYY.GT.1)WRITE(ITTY,45)K,(NUMGRF(I,J),I=1,MAXXXX)
   44 FORMAT(6X,30I3)
   45 FORMAT(1X,1I4,1X,30I3)
   46 CONTINUE
      WRITE(ITTY,47)
   47 FORMAT(1X)
      J=MAXXXX-2
      WRITE(ITTY,48)(I,I=1,J)
   48 FORMAT(6X,'  0',30I3)
      WRITE(ITTY,49)
   49 FORMAT(8X,'Requested')
C
C     SUMMARIZE TIME ASSIGNMENTS
C     KNTTD1 = ASKED FOR TIME NOT DATE, DID NOT GET TIME
C     KNTTD2 = ASKED FOR TIME AND DATE, GOT NEITHER
C     KNTTD3 = ASKED FOR TIME AND DATE, GOT ONLY DATE
C     KNTTD4 = ASKED FOR DATE ONLY, DID NOT GET DATE
C     KNTTD5 = ASKED FOR DATE ONLY, GOT DATE
C     KNTTD6 = DID NOT ASK FOR EITHER DATE OR TIME
      WRITE(ITTY,50)
   50 FORMAT(1X/' Summary of students getting time preferences')
      WRITE(ITTY,51)KNTTD6
   51 FORMAT(1X/' Did not ask for either date or time'/
     1'   Got'/
     2'  None'/
     31X,1I5)
      WRITE(ITTY,52)KNTTD4,KNTTD5
   52 FORMAT(1X/' Asked for date but not for time'/
     1'   Got  Got'/
     2'  None Date'/
     31X,1I5,1I5)
      WRITE(ITTY,53)
   53 FORMAT(1X/' Asked for time but not for date')
      J=1
      DO 54 I=1,LMTPRF
      IF(KNTTND(I).NE.0)J=I
   54 CONTINUE
      WRITE(ITTY,55)(I,I=1,J)
      WRITE(ITTY,56)KNTTD1,(KNTTND(I),I=1,J)
   55 FORMAT(
     1'   Got       Got  ...'/
     21X,' None',5X,13I5)
   56 FORMAT(1X,1I5,5X,13I5)
      WRITE(ITTY,57)
   57 FORMAT(1X/' Asked for both times and date')
      J=1
      DO 58 I=1,LMTPRF
      IF(KNTTAD(I).NE.0)J=I
   58 CONTINUE
      WRITE(ITTY,59)(I,I=1,J)
      WRITE(ITTY,60)KNTTD2,KNTTD3,(KNTTAD(I),I=1,J)
   59 FORMAT(
     1'   Got  Got  Got  ...'/
     2'  None Date',13I5)
   60 FORMAT(1X,2I5,13I5)
      GO TO 69
C
C     ********************
C     *                  *
C     *  ERROR MESSAGES  *
C     *                  *
C     ********************
C
   61 WRITE(ITTY,62)LMTFRM
   62 FORMAT(' More than',1I5,' firms in firm schedule file')
      GO TO 69
   63 WRITE(ITTY,64)LMTPRF
   64 FORMAT(' More than',1I5,' time preferences in request file')
      GO TO 69
   65 WRITE(ITTY,66)
   66 FORMAT(' Firm file was written by wrong program')
      GO TO 69
   67 WRITE(ITTY,68)
   68 FORMAT(' Input file is not a firm file')
      GO TO 69
   69 STOP
      END
