IDENTIFICATION DIVISION.
PROGRAM-ID.	RPGLLL.
DATE-WRITTEN.	APRIL 13, 1976.
AUTHOR.	HAL ROACH.
INSTALLATION.	CERRITOS COLLEGE.
REMARKS.	PROGRAM TO UPDATE L DATA CARD.
ENVIRONMENT DIVISION.
CONFIGURATION SECTION.
SOURCE-COMPUTER.	DECSYSTEM-10.
OBJECT-COMPUTER.	DECSYSTEM-10.
SPECIAL-NAMES.
	CONSOLE IS TTY.
	CHANNEL (1) IS HOF.
INPUT-OUTPUT SECTION.
FILE-CONTROL.
	SELECT PROGRAM-FILE ASSIGN TO DSK
	ACCESS MODE IS RANDOM
	ACTUAL KEY IS PROGRAM-KEY
	FILE LIMIT IS 99999.
DATA DIVISION.
FILE SECTION.
FD	PROGRAM-FILE
	BLOCK CONTAINS 8 RECORDS
	LABEL RECORDS ARE STANDARD
	VALUE OF IDENTIFICATION IS PROGRAM-IDENTIFICATION
	DATA RECORD IS PROGRAM-RECORD.
01	PROGRAM-RECORD	PIC X(90).
WORKING-STORAGE SECTION.
77	NUM-IT-2		PIC 99.
77	NUM-IT-3		PIC 999.
77	ELE-9			PIC 99.
77	CLEAR-IT		PIC X(27)	VALUE SPACES.
77	CLEAR-3300		PIC X(19)	VALUE SPACES.
77	ERROR-CODE		PIC X.
77	I			PIC S9(5)	COMP.
77	J			PIC S9(5)	COMP.
77	K			PIC S9(5)	COMP.
77	L			PIC 9(5)	COMP.
77	PROGRAM-KEY		PIC 9(5)	COMP.
77	NEXT-PROGRAM		PIC X(6).
01	ELEM-NO.
	02 ELE-NUM	PIC XX.
01	NO-ELEM REDEFINES ELEM-NO.
	02 NUM-ELE	PIC 99.
01	DATA-STORAGE.
	02 DATA-A	PIC X(8)	OCCURS 5 TIMES.
01	THE-DATA.
	02 DATA-13.
	  03 DATA-12.
	    04 DATA-1	PIC X.
	    04 DATA-2	PIC X.
	  03 DATA-3	PIC X.
	02 FILLER	PIC X(5).
01	PROGRAM-ZERO.
	02 FILLER		PIC X(80).
	02 PROGRAM-REC-NO	PIC 9(5).
	02 PROGRAM-LAST-REC	PIC 9(5).
01	PROGRAM-MAIN.
	02 PROGRAM-PAGE		PIC 99.
	02 PROGRAM-LINE		PIC 999.
	02 PROGRAM-FORM		PIC X.
	02 PROGRAM-INFO.
	  03 FILLER		PIC X.
	  03 STAR-COMMENT	PIC X(67).
	02 PROGRAM-IDENT	PIC X(6).
	02 PROGRAM-ACT-REC	PIC 9(5).
	02 PROGRAM-FILL		PIC 9(5).
01	PROG-INFO.
	02 FILENAME.
	  03 THE-STARE	PIC X.
	  03 FILLER	PIC X(7).
	02 NUM-LIN-1	PIC XXX.
	02 LIN-NUM-1 REDEFINES NUM-LIN-1	PIC ZZ9.
	02 FOR-LEN	PIC XX.
	02 NUM-LIN-2	PIC XXX.
	02 LIN-NUM-2 REDEFINES NUM-LIN-2	PIC ZZ9.
	02 OVR-LIN	PIC XX.
	02 FILLER	PIC X(50).
01	PROG-COMMENT.
	02 THE-STAR	PIC X	VALUE "*".
	02 THE-COMMENT	PIC X(67).
01	TUBE-TITLE.
	02 TUBE-LINE-0.
	  03 FILLER		PIC X(4)	VALUE "PAGE".
	  03 DISPLAY-PAGE	PIC ZZZ.
	  03 FILLER		PIC X(5)	VALUE " LINE".
	  03 DISPLAY-LINE	PIC Z(4).
	  03 FILLER		PIC X(34)	VALUE
	  " L DATA CARD".
	02 TUBE-LINE-1	PIC X(57)	VALUE
	"ELEMENT ELEMENT                                ELEMENT".
	02 TUBE-LINE-2	PIC X(57)	VALUE
	"NUMBER  DESCRIPTION                            [ENTRY]".
01	TUBE-DISPLAY.
	02 FILLER	PIC X(50)	VALUE
	"FILENAME                               [        ]".
	02 FILLER	PIC X(50)	VALUE
	"LINE NUMBER - NUMBER OF LINES PER PAGE [   ]".
	02 FILLER	PIC X(50)	VALUE
	"FORM LENGTH                            [  ]".
	02 FILLER	PIC X(50)	VALUE
	"LINE NUMBER - OVERFLOW LINE            [   ]".
	02 FILLER	PIC X(50)	VALUE
	"OVERFLOW LINE                          [  ]".
01	DISPLAY-TUBE REDEFINES TUBE-DISPLAY.
	02 FILLER	OCCURS 5 TIMES.
	  03 THE-TUBE	PIC X(50).
01	THE-NUMBER.
	02 II		PIC Z(5).
	02 FILLER	PIC XXX.
01	PROGRAM-IDENTIFICATION.
	02 PROGRAM-NAME		PIC X(6).
	02 PROGRAM-EXT		PIC XXX		VALUE "TMP".
01	PASS-IT.
	02 THE-FILE	PIC X(6).
	02 THE-TERM	PIC X.
	02 THE-ACTION	PIC XXX.
	02 THE-PAGE	PIC 99.
	02 THE-LINE	PIC 999.
	02 THE-FORM	PIC X.
	02 R-TYPE	PIC X.
01	ALL-DATA.
	02 ALL-1	PIC X.
	02 ALL-23.
	  03 ALL-2	PIC X.
	  03 ALL-3	PIC X.
	02 FILLER	PIC X(5).
PROCEDURE DIVISION.
START SECTION.
BEGIN.
	ENTER MACRO TRAP.
	MOVE SPACES TO PASS-IT.
*	DISPLAY "PASS-IT = " WITH NO ADVANCING ACCEPT PASS-IT.
	ENTER MACRO GTPRMS USING PASS-IT "X".
	IF THE-TERM = "A" OR "D" OR "V" OR "3" OR "B"
		GO TO CONT-PROG.
	DISPLAY "THE DRIVER PROGRAM WAS NOT USED".
	STOP RUN.
CONT-PROG.
	MOVE THE-FILE TO PROGRAM-NAME.
	IF  THE-ACTION = "CHG"
		PERFORM FIND-REC THRU END-FIND-REC.
	PERFORM CLEAR-SCREEN.
	ENTER MACRO SETTY USING "FORM".
	ENTER MACRO SETTY USING "NO CRLF".
	ENTER MACRO SETTY USING "WIDTH 80".
	IF THE-STARE = "*"
		MOVE 1 TO K
		MOVE THE-STARE TO DATA-1
		GO TO COMMENT-CHECK.
	MOVE THE-PAGE TO DISPLAY-PAGE.
	MOVE THE-LINE TO DISPLAY-LINE.
	DISPLAY TUBE-LINE-0.
	DISPLAY TUBE-LINE-1.
	DISPLAY TUBE-LINE-2.
	MOVE 3 TO I.
LOOP-DISPLAY.
	ADD 1 TO I.
	IF I > 8 GO TO END-DISPLAY.
	SUBTRACT 3 FROM I GIVING K.
	MOVE K TO II.
	MOVE 1 TO J.
	PERFORM CURSOR.
	DISPLAY THE-NUMBER THE-TUBE (K) WITH NO ADVANCING.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY DATA-A (K).
	GO TO LOOP-DISPLAY.
END-DISPLAY.
	IF THE-ACTION = "ADD"
		GO TO ADD-IT.
FIND-NUMBER.
	MOVE 23 TO I.
	MOVE 1 TO J.
	PERFORM CURSOR.
	DISPLAY "ELEMENT NUMBER = " WITH NO ADVANCING.
	MOVE SPACES TO ELE-NUM.
	DISPLAY ELE-NUM WITH NO ADVANCING.
	MOVE 18 TO J.
	PERFORM CURSOR.
	ACCEPT ELE-NUM.
	IF ELE-NUM = "EN"
		PERFORM CHG-REC THRU END-CHG-REC
		PERFORM CLEAR-SCREEN
		GO TO END-IT.
	MOVE NUM-ELE TO ELE-9.
	EXAMINE ELE-NUM REPLACING ALL SPACES BY ZERO.
	IF ELE-NUM IS NOT NUMERIC
		PERFORM BAD-NUMBER
		GO TO FIND-NUMBER.
	IF ELE-9 < 1 OR ELE-9 > 5
		PERFORM BAD-NUMBER
		GO TO FIND-NUMBER.
	MOVE 23 TO I.
	MOVE 20 TO J.
	PERFORM CURSOR.
	PERFORM CLEAR-LINE.
	MOVE ELE-9 TO I.
	ADD 3 TO I.
BY-NUM.
	MOVE 49 TO J.
	PERFORM CURSOR.
	SUBTRACT 3 FROM I GIVING K.
	MOVE K TO II.
ACCEPT-CHG.
	ACCEPT DATA-A (K).
	IF THE-ACTION = "ADD"
		MOVE DATA-A (K) TO ALL-DATA.
	IF ALL-1 = "/"
		GO TO CHECK-SLASH.
	IF K = 1 GO TO COMMENT-CHECK.
EDIT-IT.
	PERFORM THE-EDIT.
	IF ERROR-CODE = "X"
		MOVE SPACE TO ERROR-CODE
		MOVE 49 TO J
		PERFORM CURSOR
		GO TO ACCEPT-CHG.
	PERFORM CLEAN-IT.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY DATA-A (K).
	IF THE-ACTION = "ADD" GO TO LOOP-VALUE.
	GO TO FIND-NUMBER.
CHECK-SLASH.
	IF ALL-2 = "E"
		GO TO END-VALUE.
	MOVE ALL-23 TO NUM-IT-2.
	EXAMINE ALL-23 REPLACING ALL SPACES BY ZEROS.
	IF (ALL-23 NOT NUMERIC) OR (NUM-IT-2 > 5)  OR (NUM-IT-2 = ZERO)
		MOVE 59 TO J
		PERFORM CURSOR
		DISPLAY " BAD SWITCH"
		MOVE 49 TO J
		PERFORM CURSOR
		GO TO ACCEPT-CHG.
	MOVE NUM-IT-2 TO L.
	ADD 2 TO L.
	PERFORM CLEAN-IT.
	GO TO LOOP-VALUE.
CLEAN-IT.
	MOVE 57 TO J.
	PERFORM CURSOR.
	PERFORM CLEAR-LINE.
	MOVE 1 TO J.
	PERFORM CURSOR.
	DISPLAY THE-NUMBER THE-TUBE (K) WITH NO ADVANCING.
COMMENT-CHECK.
	MOVE DATA-A (K) TO THE-DATA.
	IF DATA-1 NOT = "*" GO TO EDIT-IT.
	PERFORM CLEAR-SCREEN.
	IF THE-ACTION = "CHG"
		DISPLAY "OLD COM" STAR-COMMENT.
	DISPLAY "         1    1    2    2    3    3    4    4    5    5    6    6    7   7".
	DISPLAY "       8901234567890123456789012345678901234567890123456789012345678901234".
	DISPLAY "NEW COM" WITH NO ADVANCING ACCEPT THE-COMMENT.
	MOVE PROG-COMMENT TO PROG-INFO.
	IF THE-ACTION = "CHG"
		PERFORM CHG-REC THRU END-CHG-REC
		PERFORM CLEAR-SCREEN
		GO TO END-IT.
	GO TO END-VALUE.
BAD-NUMBER.
	MOVE 23 TO I.
	MOVE 20 TO J.
	PERFORM CURSOR
	DISPLAY "BAD NUMBER " ELE-NUM.
FIND-REC.
	OPEN I-O PROGRAM-FILE.
	MOVE 1 TO PROGRAM-KEY.
	READ PROGRAM-FILE INVALID KEY
	DISPLAY "BAD READ CHG FILE " PROGRAM-KEY STOP RUN.
	MOVE PROGRAM-RECORD TO PROGRAM-ZERO.
LOOP-CHG.
	ADD 1 TO PROGRAM-KEY.
	IF PROGRAM-KEY > PROGRAM-LAST-REC
		DISPLAY "LOGIC ERROR IN PROGRAM" STOP RUN.
	READ PROGRAM-FILE INVALID KEY
	DISPLAY "BAD READ CHG FILE " PROGRAM-KEY STOP RUN.
	MOVE PROGRAM-RECORD TO PROGRAM-MAIN.
	IF PROGRAM-PAGE NOT = THE-PAGE GO TO LOOP-CHG.
	IF PROGRAM-LINE NOT = THE-LINE GO TO LOOP-CHG.
	MOVE PROGRAM-INFO TO PROG-INFO.
	MOVE FILENAME TO DATA-A (1).
	MOVE NUM-LIN-1 TO DATA-A (2).
	MOVE FOR-LEN TO DATA-A (3).
	MOVE NUM-LIN-2 TO DATA-A (4).
	MOVE OVR-LIN TO DATA-A (5).
END-FIND-REC.
	EXIT.
CHG-REC.
	MOVE PROG-INFO TO PROGRAM-INFO.
	MOVE PROGRAM-MAIN TO PROGRAM-RECORD.
	WRITE PROGRAM-RECORD INVALID KEY
	DISPLAY "BAD WRITE CHG " PROGRAM-KEY STOP RUN.
	CLOSE PROGRAM-FILE.
END-CHG-REC.
	EXIT.
ADD-IT.
	MOVE 3 TO I.
	MOVE I TO L.
LOOP-VALUE.
	ADD 1 TO L.
	IF L > 8 GO TO END-VALUE.
	MOVE L TO I.
	GO TO BY-NUM.
END-VALUE.
	PERFORM CLEAR-SCREEN.
	PERFORM WRITE-ADD THRU END-WRITE-ADD.
	GO TO END-IT.
CURSOR.
	IF THE-TERM = "A" ENTER MACRO CURSER USING I,J.
	IF THE-TERM = "D" ENTER MACRO CA1520 USING I,J.
	IF THE-TERM = "V" ENTER MACRO CAVT52 USING I,J.
	IF THE-TERM = "3" ENTER MACRO CA3300 USING I,J.
	IF THE-TERM = "B" ENTER MACRO CAB100 USING I,J.
CLEAR-SCREEN.
	IF THE-TERM = "A" OR "D"
		ENTER MACRO TTYOUT USING 14.
	IF THE-TERM = "V"
		ENTER MACRO CLVT52.
	IF THE-TERM = "3"
		ENTER MACRO TTYOUT USING 35,37,37,37,37.
	IF THE-TERM = "B"
		ENTER MACRO CLB100.
CLEAR-LINE.
	IF THE-TERM = "A" OR "V" OR "B"
		DISPLAY CLEAR-IT WITH NO ADVANCING.
	IF THE-TERM = "D"
		ENTER MACRO TTYOUT USING 35.
	IF THE-TERM = "3"
		DISPLAY CLEAR-3300 WITH NO ADVANCING.
THE-EDIT.
	IF K = 1 PERFORM EDIT-1 THRU END-EDIT-1.
	IF K = 2 PERFORM EDIT-2 THRU END-EDIT-2.
	IF K = 3 PERFORM EDIT-3 THRU END-EDIT-3.
	IF K = 4 PERFORM EDIT-4 THRU END-EDIT-4.
	IF K = 5 PERFORM EDIT-5 THRU END-EDIT-5.
EDIT-1.
	MOVE DATA-A (1) TO THE-DATA.
	MOVE THE-DATA TO FILENAME.
	MOVE FILENAME TO DATA-A (1).
END-EDIT-1.
	EXIT.
EDIT-2.
	MOVE DATA-A (2) TO THE-DATA.
	IF DATA-13 = SPACES
		MOVE DATA-13 TO NUM-LIN-1
		MOVE NUM-LIN-1 TO DATA-A (2)
		GO TO END-EDIT-2.
	MOVE DATA-13 TO NUM-IT-3.
	EXAMINE DATA-13 REPLACING ALL SPACES BY ZEROS.
	IF DATA-13 NOT NUMERIC GO TO ERROR-2.
	IF (NUM-IT-3 > 11) AND (NUM-IT-3 < 113)
		MOVE NUM-IT-3 TO LIN-NUM-1
		MOVE NUM-LIN-1 TO DATA-A (2)
		GO TO END-EDIT-2.
ERROR-2.
	MOVE 59 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , , OR 12-112".
	MOVE "X" TO ERROR-CODE.
END-EDIT-2.
	EXIT.
EDIT-3.
	MOVE DATA-A (3) TO THE-DATA.
	IF DATA-12 = SPACE OR "FL"
		MOVE DATA-12 TO FOR-LEN
		MOVE FOR-LEN TO DATA-A (3)
		GO TO END-EDIT-3.
	MOVE 59 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , , OR FL".
	MOVE "X" TO ERROR-CODE.
END-EDIT-3.
	EXIT.
EDIT-4.
	MOVE DATA-A (4) TO THE-DATA.
	IF DATA-13 = SPACES
		MOVE DATA-13 TO NUM-LIN-2
		MOVE NUM-LIN-2 TO DATA-A (4)
		GO TO END-EDIT-4.
	MOVE DATA-13 TO NUM-IT-3.
	EXAMINE DATA-13 REPLACING ALL SPACES BY ZEROS.
	IF DATA-13 NOT NUMERIC GO TO ERROR-4.
	IF (NUM-IT-3 > ZERO) AND (NUM-IT-3 < 113)
		MOVE NUM-IT-3 TO LIN-NUM-2
		MOVE NUM-LIN-2 TO DATA-A (4)
		GO TO END-EDIT-4.
ERROR-4.
	MOVE 59 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , , OR 1-112".
	MOVE "X" TO ERROR-CODE.
END-EDIT-4.
	EXIT.
EDIT-5.
	MOVE DATA-A (5) TO THE-DATA.
	IF DATA-12 = SPACE OR "OL"
		MOVE DATA-12 TO OVR-LIN
		MOVE OVR-LIN TO DATA-A (5)
		GO TO END-EDIT-5.
	MOVE 59 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , , OR OL".
	MOVE "X" TO ERROR-CODE.
END-EDIT-5.
	EXIT.
WRITE-ADD.
	OPEN I-O PROGRAM-FILE.
	MOVE 1 TO PROGRAM-KEY.
	READ PROGRAM-FILE INVALID KEY
	DISPLAY "BAD READ " PROGRAM-KEY STOP RUN.
	MOVE PROGRAM-RECORD TO PROGRAM-ZERO.
	MOVE PROGRAM-LAST-REC TO PROGRAM-REC-NO PROGRAM-ACT-REC.
	ADD 1 TO PROGRAM-LAST-REC.
	MOVE PROGRAM-LAST-REC TO PROGRAM-KEY.
	MOVE THE-FILE TO PROGRAM-IDENT.
	MOVE THE-PAGE TO PROGRAM-PAGE.
	MOVE THE-LINE TO PROGRAM-LINE.
	MOVE THE-FORM TO PROGRAM-FORM.
	MOVE PROG-INFO TO PROGRAM-INFO.
	MOVE PROGRAM-MAIN TO PROGRAM-RECORD.
WRITE-ADD-A.
	WRITE PROGRAM-RECORD INVALID KEY
	DISPLAY "BAD WRITE " PROGRAM-KEY STOP RUN.
	MOVE 1 TO PROGRAM-KEY.
	MOVE PROGRAM-ZERO TO PROGRAM-RECORD.
	WRITE PROGRAM-RECORD INVALID KEY
	DISPLAY "BAD WRITE " PROGRAM-KEY STOP RUN.
	CLOSE PROGRAM-FILE.
END-WRITE-ADD.
	EXIT.
END-IT.
	MOVE PROGRAM-NAME TO THE-FILE.
	MOVE "RPGSYS" TO NEXT-PROGRAM.
	ENTER MACRO SYSPRG USING NEXT-PROGRAM, PASS-IT.
END-PROGRAM.
	STOP RUN.
