@Begin(Text, RightMargin +5, LeftMargin +6)
@MajorHeading(FORVER)
FORVER is a program that takes as input a FORTRAN-10 source file and
analyses it to determine whether subroutine and function calls are
correct, both in the type of the passed arguments, and in their number.
This being one of the most common errors encountered in FORTRAN
programs, and the fact that the DEC-10 FORTRAN compiler doesn't do
anything about it are the main task in life for FORVER.
 
@Heading(How to run FORVER)
To run FORVER on the DEC-10, just give the monitor command:
@Display(.@b[R SAV:FORVER])
You will then get a message of some sort telling you the FORVER version
you're dealing with, and a prompt:
@Display(@b[FVR>])
To this you must give it the name of a FORTRAN source file, and
whatever options you want, in the format:
@Display(FVR>@b{name /sw/sw...})
Following is a description of the various options and their meanings.
 
@Heading(Description of the FORVER command line)
If you just say "FOOBAR<return>" after the "FVR>" prompt, forver will
assume the following:
@Begin(Enumerate)
Your FORTRAN source file is FOOBAR.FOR in your PPN (actually you can
give a full DEC-10 filespec like DEV:NAME.EXT[P,PN], the defaults being
DSK:.FOR[yourppn].
 
FORVER will generate a listing file FOOBAR.LSV containing a numbered
listing of your source file (optionally) as well as a second section
containing a list of all SUBROUTINES and FUNCTIONS encountered in your
source file@Foot(not only the defined routines, but also the referenced
ones, although these may not be part of this source).  In this part all
the incorrect calls will be listed showing the argument types so you
can decide what to do with them.
 
Optionally, FORVER will also generate an "attibute" file called
FOOBAR.VTR containing a compact (and readable) description of all the
entry-@|points defined in this source file.  This is necessary for,
say, subroutine packages like IMSL or NEWPLT, that are to be called
from other files.
@End(Enumerate)
 
@Heading(List of FORVER switches)
Following is a list of all valid FORVER switches (all switches may be
abbreviated to one letter).  Note also that most switches (except
/FULL) act as toggles, meaning that if you give one of them twice it's
as if you hadn't given it at all.
@Begin(Description)
@b[/VTR]@\Generate .VTR attribute file. When this switch in on, the
.VTR file corresponding to this source will be generated.
 
@b[/UNDECLARED]@\Warn the user about undeclared variables, and report
their assumed types in the listing file.
 
@b[/INIT]@\Warn the user about uninitialized variables.  This is used
to tell you about variables whose value is used (eg. in an expression)
before FORVER has seen something explicitly assigned to them (notice
that a warning of this kind is not always correct since control flow in
FORTRAN programs is seldom sequential and variables may be initialized
in other ways, not visible to FORVER, eg. in a routine call).
 
@b[/ASSIGNMENT]@\Check that all assignments are done with implicit type
conversion (eg@. this will point out statements like I@ =@ 1.5).
 
@b[/DIVISIONS]@\Warn the user about integer divisions.  This is also a
common source of hard to locate errors; this may happen for instance,
in a stapement like HALF@ =@ 1/2, where the REAL variable "HALF" will
get the value 0.0 instead of 0.5 as was probably the user's intent.
 
@b[/LIST]@\Generate the line-numbered listing of the source file.  This
option is provided so that you don't have to get the full listing in
those cases where all you want is to have a quick look at the incorrect
routine calls.
 
@b[/FULL]@\Do everything. This switch turns all the other switches ON.
@End(Description)
The default switch settings is only "/VTR".
 
When the source file has been completely scanned, and if there are some
routines that remain undefined, FORVER will prompt you with a message:
@Begin(Display)
[FVRUDS "n" undefined external references]
Search:
@End(Display)
To this prompt you must give the filespec corresponding to the .VTR
file you think will be needed.  FORVER will then tell you what it found
in that file, and continue prompting you until all references are
satisfied, or you type <return> to the "Search:" prompt, in which case
FORVER won't be able to verify the calls to the undefined routines.
 
To this you may also answer "?<return>" and FORVER will list all the
remaining undefined references, to guide you in your decision as to
what .VTR files you will search.
 
Frequently used FORTRAN subroutine packages such as IMSL or NEWPLT have
their .VTR files in device FOR:, to get the complete list of available
.VTR files, type the monitor command:
@Display(.@b[HELP FORVTR])
 
Have fun.
@End(Text)
