      SUBROUTINE LINE (X,Y,N,ILINE,ISYMB,DASH)
C
C
C    THIS ROUTINE ENABLES THE USER TO PLOT (X,Y) PAIRS OF DATA POINTS,
C      WITH SOLID, DASHED, OR NO LINE BEWTEEN POINTS AND THE OPTION
C      OF A CENTERED SYMBOL PLOTTED AT EACH POINT.
C
C
C    CALLING SEQUENCE:
C
C                CALL LINE (X,Y,N,ILINE,ISYMB,DASH)
C
C    X     - (I) ARRAY TO BE PLOTTED ALONG THE X AXIS
C
C    Y     - (I) ARRAY TO BE PLOTTED ALONG THE Y AXIS
C
C    N     - (I) THE NUMBER OF DATA POINTS IN X AND Y
C
C    ILINE - (I) THIS DESCRIBES HOW TO PLOT THE POINTS
C               ILINE = 0, PLOT ONLY THE LINES THAT CONNECTS THE POINTS
C               ILINE > 0, PLOT THE LINES THAT CONNECTS THE POINTS AND
C                          A CENTERED SYMBOL AT EACH POINT
C               ILINE < 0, PLOT ONLY A CENTERED SYMBOL AT EACH POINT
C
C    ISYMB - (I) THE NUMBER OF THE CENTERED SYMBOL TO BE USED
C
C    DASH  - (I) THE TYPE OF LINE TO PLOT (SOLID OR DASHED)
C              DASH <= 0, MAKE THE LINE SOLID
C              DASH >  0, MAKE THE LINE DASHED, DASH IS THE LENGTH OF
C                         THE DASHES
C
C
C    SUBPROGRAMS USED:
C
C      DASHLN AND SYMBOL
C
C
      DIMENSION X(1),Y(1)

      IF (N .LT. 2) RETURN

      XM = X(N+1);  DX = X(N+2);  XO = (X(1) - XM)/DX
      YM = Y(N+1);  DY = Y(N+2);  YO = (Y(1) - YM)/DY

      IF (ILINE .NE. 0) CALL SYMBOL (XO,YO,0.08,ISYMB,0.0,-1)

         DO 10 I = 2,N
         XN = (X(I) - XM)/DX
         YN = (Y(I) - YM)/DY

         IF (ILINE .GE. 0) CALL DASHLN (XO,YO,XN,YN,DASH)
         IF (ILINE .NE. 0) CALL SYMBOL (XN,YN,0.08,ISYMB,0.0,-1)

         XO = XN
10       YO = YN

      RETURN
      END
 
