CC  DASH1 and DASH2	by Joe Smith, Feb 77
C	Subroutine DASH1 (XFROM, YFROM, XTO, YTO, DASH)
C	This routine is similair to DASHLN.
C	Draws a dashed line from (XFROM,YFROM) to (XTO,YTO)
C	with dashes of length DASH.  All arguments are input parameters
C	and are not changed.  If DASH is negative or zero, DASH1 will
C	move to (XTO,YTO) with the pen up.
C
C	Comparison with DASHLN
C	DASHLN will always move with the pen up to the starting position
C	and then lower the pen.  It will do this even if the pen is in
C	the correct position.  Repeated raising and lowering of the pen
C	will damage it.  DASHLN calculates the number of dashes required
C	to travel to the ending position and then rounds down to the
C	next lower even integer.  This is so that the last dash, which
C	connects to (XTO,YTO) will be visible even if it has to be up to
C	twice as long as the other dashes.  If the distance between
C	(XFROM,YFROM) and (XTO,YTO) is less than twice the DASH length,
C	DASHLN will draw a solid line.
C
C	Differences in DASH1
C	DASH1 makes all the dashes the same size, even if the last one
C	is not visible.  It remembers how much of the last dash was
C	plotted and whether the pen was down or up.
C	If XFROM is 999.0, DASH1 will use the current X position.
C	If YFROM is 999.0, DASH1 will use the current Y position.
C	If either XFROM or YFROM is not 999.0, DASH1 will move to the
C	starting position with the pen up, and start a visible dash.
C	If both XFROM and YFROM are 999.0, DASH1 will not lift and
C	drop the pen, but will continue the dash it started, heading
C	off in the new direction.  This allows smooth curves, such
C	as sine waves, to be plotted with dashed lines.
C
C	Subroutine DASH2 (XFROM, YFROM, XTO, YTO, DASH, DDOT)
C	This routine is similair to DASH1, except that the distance
C	for the pen to be up is DDOT and need not be the same as
C	the distance for the pen to be down (DASH).
C	All arguments are input parameters and are not changed.
C	If DASH is negative or zero, DASH2 will move to (XTO,YTO)
C	with the pen up.  If DDOT is zero, DASH2 will draw a solid
C	line from (XFROM,YFROM) to (XTO,YTO).  If DDOT is negative,
C	DASH2 will draw a line of alternating dashes and dots.
C	The length of the spaces and the dots is the absolute value
C	of DDOT.  For example, if DASH = +0.4 and DDOT = -0.2,
C	DASH2 will draw a dash of 0.4 inches, a space of 0.2 inches,
C	a dot of 0.2 inches, and a space of 0.2 inches.  This pattern
C	of (DASH, SPACE, DOT, SPACE) will be repeated every inch.
C	(0.4 + 0.2 + 0.2 + 0.2 = 1.0).
C	Like DASH1, DASH2 will continue the pattern if XFROM and YFROM
C	are both 999.0
C
	SUBROUTINE DASH2 (XFROM, YFROM, XTO, YTO, DASH, DDOT)
	SPACE=DDOT		! SPACING BETWEEN DASHES
	DOT=DASH
	IF (DDOT .GT. 0.0) GOTO 10	! DASH, SPACE, DASH, SPACE
	SPACE=-DDOT		! POSITIVE DISTANCE
	DOT=SPACE		! DASH, SPACE, DOT, SPACE
	GOTO 10

	ENTRY DASH1 (XFROM, YFROM, XTO, YTO, DASH)	! LIKE DASHLN
	DOT=DASH		! MAKE EQUAL SPACING
	SPACE=DASH

10	IF (DASH .LE. 0.0) GOTO 40 ! MOVE WITH PEN UP
	CALL WHERE (XOLD, YOLD, TRAVEL)	! FIND OUT WHERE WE ARE

	IF (XFROM .NE. 999.0) XOLD=XFROM	! USE OLD VALUE IF 999
	IF (YFROM .NE. 999.0) YOLD=YFROM	! CONTINUE CURVE IF BOTH
	IF (XFROM .EQ. 999.0  .AND.  YFROM .EQ. 999.0) GOTO 20

	MODE=0			! START A DASH
	TOGO=DASH		! DISTANCE TO GO
	DISTAN=0.0		! JUST STARTED
	CALL PLOT (XOLD, YOLD, 3) ! MOVE TO STARTING POSITION

20	IF (SPACE .EQ. 0.0) GOTO 50 ! MOVE WITH PEN DOWN

30	XDIST=XTO-XOLD		! MAIN LOOP
	YDIST=YTO-YOLD		! FIND DISTANCE TO MOVE
	STEP=SQRT( XDIST*XDIST + YDIST*YDIST )
	IF (STEP+DISTAN .LE. TOGO) GOTO 70 ! PLOT THE REST OF THE DASH

	TRAVEL=(TOGO-DISTAN)/STEP ! 0 < TRAVEL < 1.0
	XOLD=TRAVEL*XDIST+XOLD	! FIND POINT TO CHANGE PEN
	YOLD=TRAVEL*YDIST+YOLD
	CALL PLOT (XOLD, YOLD, (MODE.AND.1)+2) ! MOVE TO THAT POINT
	MODE=MODE+1		!0=DASH, 1=SPACE, 2=DOT, 3=SPACE
	TOGO=SPACE		! ASSUME SO
	IF (MODE .EQ. 2) TOGO=DOT
	IF (MODE .EQ. 4) MODE=0	! MODE HAS A CYCLE OF 4
	IF (MODE .EQ. 0) TOGO=DASH
	DISTAN=0.0		! DISTANCE TRAVELLED IN THIS MODE
	GOTO 30			! LOOP UNTIL WE GET TO XTO,YTO



40	MODE=1			! PEN UP
	GOTO 60

50	MODE=0			! PEN DOWN
60	DISTAN=0.0
	STEP=0.0		! SO DISTAN WILL BE 0.0

70	XOLD=XTO		! DON'T CHANGE XTO AND YTO
	YOLD=YTO
	CALL PLOT (XOLD, YOLD, (MODE.AND.1)+2) ! LAST MOVE
	DISTAN=DISTAN+STEP	! REMEMBER DISTAN AND MODE FOR NEXT TIME
	RETURN			! AFTER GOING TO XTO,YTO
	END
  
