      SUBROUTINE DASHLN (XO,YO,XN,YN,DASH)
C
C
C    THIS ROUTINE ALLOWS THE USER TO MAKE SOLID OR DASHED LINES.
C
C
C    CALLING SEQUENCE:
C
C                CALL DASHLN (XO,YO,XN,YN,DASH)
C
C    (XO,YO) - (I) THE STARTING COORDINATE OF THE SEGMENT TO DRAW
C
C    (XN,YN) - (I) THE ENDING COORDINATE OF THE SEGMENT TO DRAW
C
C    DASH    - (I) THE LENGTH OF THE DASHES (NOTE: IF DASH IS LESS THAN
C                OR EQUAL TO 0. A SOLID LINE IS DRAWN)
C
C
C    SUBPROGRAMS USED:
C
C      IFIX, SQRT AND PLOT
C
C
      EQUIVALENCE (I,D)
      INTEGER PEN,PENUP,PENDWN
      DATA PENDWN,PENUP/2,3/

      CALL PLOT (XO,YO,PENUP)

      IF (DASH .LE. 0) GOTO 20

      DX = XN - XO
      DY = YN - YO
      D = SQRT(DX * DX + DY * DY) / DASH
      N = IFIX(D) .AND. "777777777776

      IF (N .EQ. 0) GOTO 20

      DX = DX / D
      DY = DY / D
      PEN = 6

         DO 10 I = 1,N
         CALL PLOT (DX,DY,PEN)
10       PEN = PEN .XOR. 1

20    CALL PLOT (XN,YN,PENDWN)

      RETURN
      END
