C     RENBR(JOBTST/JOBS - CHANGE PRIORITIES IN TEST CASES)
C
C     DONALD BARTH, YALE SCHOOL OF MANAGEMENT
C
C     THIS PROGRAM IS PART OF THE JOB INTERVIEW REQUEST SYSTEM
C
C     ARRAYS WHICH STORE INFORMATION ABOUT ALL FIRMS RECRUITING
C
C     FOLLOWING ARRAYS STORE ALPHABETIC INFORMATION FOR EACH FIRM
      DIMENSION LTRINC(40),LTRDPT(30),LTRADR(30)
C
C     ARRAYS WHICH STORE FIRMS REQUESTED BY THIS STUDENT
      DIMENSION NUMVOT(100),KNDVOT(100),IRANK(100),IPREFR(13,100),
     1KNTPRF(100),KLOCK(100),KLOSED(100),JRANK(100),MTIME(100),
     2MDATE(100),MRECRT(100),IDATE(100),ISOURC(100),MJRRNK(100)
C
C     IDENTIFICATION OF THIS USER
      DIMENSION LTRWHO(40),LTRNAM(30),LTRPSW(20)
C
C     UNIT NUMBERS FOR TERMINAL AND FILES
      DATA ITTY,IDISK,JDISK,KDISK,LDISK/5,1,20,21,22/
C
C     DIMENSIONS OF ARRAYS CONTAINING CHARACTER INFORMATION
      DATA LMTINC,LMTDPT,LMTADR,LMTNAM,LMTWHO,LMTPSW/
     1 40,30,30,30,40,20/
C
C     DIMENSIONS OF ARRAYS LIMITING SIZE OF CASE HANDLED
C     LMTSIN = MAXIMUM REQUESTS BY 1 STUDENT
C     LMTPRF = MAXIMUM NUMBER OF TIME PREFERENCES FOR EACH REQUEST
      DATA LMTSIN,LMTPRF/
     1 100,13/
C
C     MULTIPLICATION FACTOR FOR PRIORITY 1 THRU N VALUES
      DATA INTRVL/10/
C
C     INFORM USER OF WHAT PROGRAM THIS IS
      WRITE(ITTY,1)
    1 FORMAT(' JOBTST'/' Changes priorities in JOBS test cases'/1X)
C
C     ESTABLISH RANDOM FUNCTION KERNEL
      WRITE(ITTY,2)
    2 FORMAT(' Base random sequence upon what kernel? ',$)
      READ(ITTY,3)KERNEL
    3 FORMAT(I)
      IF(KERNEL.LT.0)WRITE(ITTY,4)
    4 FORMAT(' Negative kernel indicates verification not real run')
      IF(KERNEL.GE.0)CALL SETRAN(KERNEL)
C
C     ASK FOR TYPE OF NEW TEST CASES
      WRITE(ITTY,5)
    5 FORMAT(
     1'  1 ranked requests. If request fails, boost lower priority'/
     2'  2 ranked requests. No boosting of lower priority requests'/
     3' 11 A/B priority bids.  Total of A''s fixed during season'/
     4' 12 A/B priority bids.  Total of A''s fixed during round'/
     5' 13 A/B priority bids.  Total of A''s fixed for each stage'/
     6' 21 auction.  Total bid fixed for entire season'/
     7' 22 auction.  Total bid fixed for single round'/
     8' 23 auction.  Total bid fixed for each stage')
    6 WRITE(ITTY,7)
    7 FORMAT(' Convert to priority type? ',$)
      READ(ITTY,8)NEWMNR
    8 FORMAT(I)
      IF(NEWMNR.EQ.1)GO TO 10
      IF(NEWMNR.EQ.2)GO TO 10
      IF(NEWMNR.EQ.11)GO TO 11
      IF(NEWMNR.EQ.12)GO TO 11
      IF(NEWMNR.EQ.13)GO TO 11
      IF(NEWMNR.EQ.21)GO TO 14
      IF(NEWMNR.EQ.22)GO TO 14
      IF(NEWMNR.EQ.23)GO TO 14
      WRITE(ITTY,9)
    9 FORMAT(' Priority type must be 1,2,11,12,13,21,22,23')
      GO TO 6
C
C     ESTABLISH LIMITS OF PRIORITIES
   10 MAXONE=0
      MAXTTL=0
      GO TO 17
   11 MAXONE=0
      WRITE(ITTY,12)
   12 FORMAT(' Total number of A requests per student? ',$)
      READ(ITTY,13)MAXTTL
   13 FORMAT(I)
      GO TO 17
   14 WRITE(ITTY,15)
   15 FORMAT(' Maximum amount bid by 1 student on 1 request? ',$)
      READ(ITTY,13)MAXONE
      WRITE(ITTY,16)
   16 FORMAT('          Total amount to be bid by 1 student? ',$)
      READ(ITTY,13)MAXTTL
      GO TO 17
   17 CONTINUE
      WRITE(ITTY,18)
   18 FORMAT(42H Answer following question with one of fol,
     114Hlowing values:/31H -1=Simulate running of student,
     236H and administrator programs.  Retain/4X,7Hranking,
     349H order from previous stage.  Randomize current st,
     413Hage.  Ranking/4X,24Hprogram can be run next./2H  ,
     549H0 or greater=Simulate running of ranking program ,
     621Hupon indicated number/4X,21Hof requests picked at,
     740H random for each student.  Treat rest of/4X,3Hreq,
     849Huests as being made in new stage.  Randomize prio,
     914Hrities in each)
      WRITE(ITTY,19)
   19 FORMAT(4X,39Hstage.  Assignment program can be run n,
     14Hext.)
      WRITE(ITTY,20)
   20 FORMAT(
     1' Treat how many requests as from previous stage? ',$)
      READ(ITTY,13)MAXLOK
C
C     OPEN INPUT AND OUTPUT ADMINISTRATOR FILES
      WRITE(ITTY,21)
   21 FORMAT(' ***** Input files *****')
      IF(MAXLOK.GE.0)GO TO 24
      WRITE(ITTY,22)
   22 FORMAT('   Original administrator firm file (file 1)? or')
      CALL LCLOPN(5,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLCLS(5,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      WRITE(ITTY,23)
   23 FORMAT('      Original student request file (file 2)? or'/
     1'  Intermediate student request file (file 6)? or')
      CALL LCLOPN(8,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLCLS(8,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      GO TO 25
   24 CALL LCLOPN(1,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLCLS(1,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLOPN(2,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLCLS(2,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      GO TO 25
   25 WRITE(ITTY,26)
   26 FORMAT(' ***** Output files *****')
      IF(MAXLOK.GE.0)GO TO 27
      CALL LCLOPN(1,1,3,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLCLS(1,1,3,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLOPN(2,1,3,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLCLS(2,1,3,ITTY,IDISK,JDISK,KDISK,LDISK)
      GO TO 28
   27 CALL LCLOPN(5,1,3,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLCLS(5,1,3,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLOPN(6,1,3,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLCLS(6,1,3,ITTY,IDISK,JDISK,KDISK,LDISK)
   28 CONTINUE
C
C     OPEN THE FIRM SCHEDULE FILES
      IF(MAXLOK.GE.0)GO TO 29
      CALL LCLOPN(5,0,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLOPN(1,0,3,ITTY,IDISK,JDISK,KDISK,LDISK)
      GO TO 30
   29 CALL LCLOPN(1,0,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLOPN(5,0,3,ITTY,IDISK,JDISK,KDISK,LDISK)
   30 CONTINUE
C
C     READ HEADER INFORMATION
      READ(IDISK,31)IAUTHR,ICLASS,IMOVE,IPASS,IVERSN,NUMWHO
   31 FORMAT(6I)
      READ(IDISK,32)KNTINC,MAXNUM,MANNER,MAXSTG,MAXRND,
     1 MAXALL,MAXBID,MAXPAY
   32 FORMAT(8I)
C
C     WRITE HEADER INFORMATION
      MANNER=NEWMNR
      MAXBID=MAXONE
      MAXPAY=MAXTTL
      IF(MAXLOK.GE.0)GO TO 33
      IAUTHR=1
      IPASS=IPASS+1
      GO TO 34
   33 IAUTHR=2
   34 CONTINUE
      WRITE(KDISK,35)IAUTHR,ICLASS,IMOVE,IPASS,IVERSN,NUMWHO
   35 FORMAT(5I6,1I7)
      WRITE(KDISK,36)KNTINC,MAXNUM,MANNER,MAXSTG,MAXRND,
     1 MAXALL,MAXBID,MAXPAY
   36 FORMAT(6I6,2I10)
C
C     COPY INFORMATION ABOUT EACH FIRM
      IF(KNTINC.LE.0)GO TO 47
      DO 46 NOWINC=1,KNTINC
C
C     READ INFORMATION FOR FIRM
      READ(IDISK,37)LTRINC
      WRITE(KDISK,37)LTRINC
   37 FORMAT(40A1)
      READ(IDISK,38)LTRDPT
      WRITE(KDISK,38)LTRDPT
   38 FORMAT(30A1)
      READ(IDISK,39)LTRADR
      WRITE(KDISK,39)LTRADR
   39 FORMAT(30A1)
      READ(IDISK,40)NUMBER,LENGTH,KNTOPN,INTRVW,
     1IUSDUP,INCLSD,JNCLSD
   40 FORMAT(7I)
      WRITE(KDISK,41)NUMBER,LENGTH,KNTOPN,INTRVW,
     1IUSDUP,INCLSD,JNCLSD
   41 FORMAT(7I6)
      IF(INTRVW.LE.0)GO TO 45
      DO 44 IPERSN=1,INTRVW
      READ(IDISK,43)JDATE,JFIRST,JFINAL,JSCHDL
      WRITE(KDISK,42)JDATE,JFIRST,JFINAL,JSCHDL
   42 FORMAT(4I6)
   43 FORMAT(4I)
   44 CONTINUE
   45 CONTINUE
C
C     ALL RECRUITERS COPIED FOR COMPANY
   46 CONTINUE
C
C     ALL COMPANIES COPIED
   47 CONTINUE
C
C     CLOSE INPUT AND OUTPUT ADMINISTRATOR FILES
      IF(MAXLOK.GE.0)GO TO 48
      CALL LCLCLS(5,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLCLS(1,1,3,ITTY,IDISK,JDISK,KDISK,LDISK)
      GO TO 49
   48 CALL LCLCLS(1,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLCLS(5,1,3,ITTY,IDISK,JDISK,KDISK,LDISK)
   49 CONTINUE
C
C     ***************************
C     *                         *
C     *  READ STUDENT REQUESTS  *
C     *                         *
C     ***************************
C
C     OPEN THE INDIVIDUAL DECISION FILE FOR READING
      IF(MAXLOK.GE.0)GO TO 50
      CALL LCLOPN(8,0,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLOPN(2,0,3,ITTY,IDISK,JDISK,KDISK,LDISK)
      GO TO 51
   50 CALL LCLOPN(2,0,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLOPN(6,0,3,ITTY,IDISK,JDISK,KDISK,LDISK)
   51 CONTINUE
C
C     READ THE STUDENTS DECISION FILE
   52 READ(IDISK,53,END=106)IAUTHR,ICLASS,IMOVE,IPASS,IVERSN,NUMWHO,
     1LTRPSW
      READ(IDISK,54)ISUBMT,IUSED,KNTSIN,LOCKUP,MANNER,
     1 KNTALL,IGVBAK
   53 FORMAT(6I,20A1)
   54 FORMAT(7I)
      READ(IDISK,55)LTRWHO
      READ(IDISK,55)LTRNAM
   55 FORMAT(60A1)
      IF(KNTSIN.LE.0)GO TO 59
      IF(KNTSIN.GT.LMTSIN)GO TO 109
      DO 58 KOMPNY=1,KNTSIN
      READ(IDISK,56)NUMVOT(KOMPNY),KNDVOT(KOMPNY),KNTPRF(KOMPNY),
     1IDATE(KOMPNY),KLOSED(KOMPNY),IRANK(KOMPNY),JRANK(KOMPNY),
     2KLOCK(KOMPNY),MTIME(KOMPNY),MDATE(KOMPNY),MRECRT(KOMPNY),
     3ISOURC(KOMPNY)
   56 FORMAT(12I)
      LIMIT=KNTPRF(KOMPNY)
      IF(LIMIT.GT.LMTPRF)GO TO 111
      IF(LIMIT.GT.0)READ(IDISK,57)(IPREFR(I,KOMPNY),I=1,LIMIT)
   57 FORMAT(13I)
   58 CONTINUE
   59 READ(IDISK,60)LTREND
   60 FORMAT(1A1)
C
C     ************************************
C     *                                  *
C     *  CONVERT REQUESTS TO NEW SYSTEM  *
C     *                                  *
C     ************************************
C
C     SORT FIRM NUMBERS SO RANDOM ORDER SAVE FOR SAME KERNEL
      LOWSIN=LOCKUP+1
      IF(MAXLOK.GE.0)LOWSIN=1
      IF(LOWSIN.GE.KNTSIN)GO TO 65
      DO 63 KOMPNY=LOWSIN,KNTSIN
      DO 62 J=KOMPNY,KNTSIN
      IF(NUMVOT(KOMPNY).LE.NUMVOT(J))GO TO 62
      L               = NUMVOT(KOMPNY)
      NUMVOT(KOMPNY)  = NUMVOT(J)
      NUMVOT(J)       = L
      L               = KNDVOT(KOMPNY)
      KNDVOT(KOMPNY)  = KNDVOT(J)
      KNDVOT(J)       = L
      L               = KNTPRF(KOMPNY)
      KNTPRF(KOMPNY)  = KNTPRF(J)
      KNTPRF(J)       = L
      L               = IDATE(KOMPNY)
      IDATE(KOMPNY)   = IDATE(J)
      IDATE(J)        = L
      L               = KLOSED(KOMPNY)
      KLOSED(KOMPNY)  = KLOSED(J)
      KLOSED(J)       = L
      L               = ISOURC(KOMPNY)
      ISOURC(KOMPNY)  = ISOURC(J)
      ISOURC(J)       = L
      DO 61 M=1,LMTPRF
      L               = IPREFR(M,KOMPNY)
      IPREFR(M,KOMPNY)= IPREFR(M,J)
      IPREFR(M,J)     = L
   61 CONTINUE
   62 CONTINUE
   63 CONTINUE
      DO 64 I=LOWSIN,KNTSIN
      IRANK(I)=0
      JRANK(I)=0
      KLOCK(I)=0
      MTIME(I)=0
      MDATE(I)=0
      MRECRT(I)=0
   64 CONTINUE
   65 CONTINUE
C
C     SIMULATE PREVIOUS CASE
C     NOTE THAT ALL TESTS OF MAXLOK HAVE SAME SENSE
      IF(MAXLOK.GE.0)GO TO 66
      GO TO 71
   66 LOCKUP=MAXLOK
      IF(LOCKUP.GT.KNTSIN)LOCKUP=KNTSIN
      IF(KNTSIN.LE.0)GO TO 91
      CALL RANK(KERNEL,MJRRNK,1,KNTSIN,0)
      KNTFRM=0
      DO 68 KOMPNY=1,KNTSIN
      IF(MJRRNK(KOMPNY).GT.LOCKUP)GO TO 68
      KNTFRM=KNTFRM+1
      J=KNTFRM
      L               = NUMVOT(KOMPNY)
      NUMVOT(KOMPNY)  = NUMVOT(J)
      NUMVOT(J)       = L
      L               = KNDVOT(KOMPNY)
      KNDVOT(KOMPNY)  = KNDVOT(J)
      KNDVOT(J)       = L
      L               = KNTPRF(KOMPNY)
      KNTPRF(KOMPNY)  = KNTPRF(J)
      KNTPRF(J)       = L
      L               = IDATE(KOMPNY)
      IDATE(KOMPNY)   = IDATE(J)
      IDATE(J)        = L
      L               = KLOSED(KOMPNY)
      KLOSED(KOMPNY)  = KLOSED(J)
      KLOSED(J)       = L
      L               = ISOURC(KOMPNY)
      ISOURC(KOMPNY)  = ISOURC(J)
      ISOURC(J)       = L
      DO 67 M=1,LMTPRF
      L               = IPREFR(M,KOMPNY)
      IPREFR(M,KOMPNY)= IPREFR(M,J)
      IPREFR(M,J)     = L
   67 CONTINUE
   68 CONTINUE
      DO 69 I=1,KNTSIN
      IRANK(I)=0
      JRANK(I)=0
      KLOCK(I)=0
      MTIME(I)=0
      MDATE(I)=0
      MRECRT(I)=0
   69 CONTINUE
      IF(LOCKUP.EQ.0)GO TO 70
      CALL RANK(KERNEL,IRANK,1,LOCKUP,0)
   70 GO TO 74
C
C     CHECK IF KEEP OLD PRIORITY VALUES FOR PREVIOUS STAGE
   71 IF(NEWMNR.GT.20)GO TO 73
      IF(NEWMNR.GT.10)GO TO 72
      IF(MANNER.GT.10)GO TO 74
      GO TO 85
   72 IF(MANNER.LT.10)GO TO 74
      IF(MANNER.GT.20)GO TO 74
      GO TO 85
   73 IF(MANNER.LT.20)GO TO 74
      GO TO 85
C
C     CONVERT RANKINGS FOR ON FIRM LIST INTO RANK 1 THRU N
   74 IF(LOCKUP.LE.0)GO TO 85
      K=0
      L=0
      I=0
   75 DO 77 J=1,LOCKUP
      IF(K.GE.IRANK(J))GO TO 77
      IF(K.EQ.L)GO TO 76
      IF(L.LE.IRANK(J))GO TO 77
   76 L=IRANK(J)
   77 CONTINUE
      IF(K.EQ.L)GO TO 79
      DO 78 J=1,LOCKUP
      IF(IRANK(J).NE.L)GO TO 78
      I=I+1
      JRANK(J)=I
   78 CONTINUE
      K=L
      GO TO 75
   79 DO 80 J=1,LOCKUP
      IRANK(J)=JRANK(J)
   80 CONTINUE
C
C     DEFINE PRIORITY VALUES FOR PREVIOUS STAGE
      LOCATN=0
      NEWTTL=MAXTTL
   81 LOCATN=LOCATN+1
      IF(LOCATN.GT.LOCKUP)GO TO 85
      IF(NEWMNR.GT.20)GO TO 83
      IF(NEWMNR.GT.10)GO TO 82
      KNDVOT(LOCATN)=INTRVL*IRANK(LOCATN)
      GO TO 81
   82 KNDVOT(LOCATN)=1
      IF(IRANK(LOCATN).GT.MAXTTL)KNDVOT(LOCATN)=2
      GO TO 81
   83 IDENOM=100*101
      IF(IRANK(LOCATN).LE.100)IDENOM=IRANK(LOCATN)*(IRANK(LOCATN)+1)
      IVALUE=NEWTTL/IDENOM
      JVALUE=1
   84 KVALUE=IVALUE
      IVALUE=IVALUE/10
      JVALUE=10*JVALUE
      IF(IVALUE.GT.0)GO TO 84
      JVALUE=JVALUE/10
      KNDVOT(LOCATN)=KVALUE*JVALUE
      IF(KNDVOT(LOCATN).GT.MAXONE)KNDVOT(LOCATN)=MAXONE
      NEWTTL=NEWTTL-KNDVOT(LOCATN)
      GO TO 81
C
C     RANDOMIZE THE CURRENT STAGE
   85 IF(LOCKUP.GE.KNTSIN)GO TO 91
      LOWSIN=LOCKUP+1
      CALL RANK(KERNEL,MJRRNK,LOWSIN,KNTSIN,0)
C
C     DEFINE PRIORITY VALUES FOR CURRENT STAGE
      LOCATN=LOCKUP
      NEWTTL=MAXTTL
   86 LOCATN=LOCATN+1
      IF(LOCATN.GT.KNTSIN)GO TO 90
      IF(NEWMNR.GT.20)GO TO 88
      IF(NEWMNR.GT.10)GO TO 87
      KNDVOT(LOCATN)=INTRVL*MJRRNK(LOCATN)
      GO TO 86
   87 KNDVOT(LOCATN)=1
      IF(MJRRNK(LOCATN).GT.MAXTTL)KNDVOT(LOCATN)=2
      GO TO 86
   88 IDENOM=100*101
      IF(MJRRNK(LOCATN).LE.100)IDENOM=MJRRNK(LOCATN)*(MJRRNK(LOCATN)+1)
      IVALUE=NEWTTL/IDENOM
      JVALUE=1
   89 KVALUE=IVALUE
      IVALUE=IVALUE/10
      JVALUE=10*JVALUE
      IF(IVALUE.GT.0)GO TO 89
      JVALUE=JVALUE/10
      KNDVOT(LOCATN)=KVALUE*JVALUE
      IF(KNDVOT(LOCATN).GT.MAXONE)KNDVOT(LOCATN)=MAXONE
      NEWTTL=NEWTTL-KNDVOT(LOCATN)
      GO TO 86
   90 CONTINUE
   91 CONTINUE
C
C     GET TOTAL AMOUNT USED SO FAR
      LOCATN=0
      IUSED=0
   92 LOCATN=LOCATN+1
      IF(LOCATN.GT.KNTSIN)GO TO 95
      IF(NEWMNR.GT.20)GO TO 94
      IF(NEWMNR.GT.10)GO TO 93
      GO TO 92
   93 IF(KNDVOT(LOCATN).EQ.1)IUSED=IUSED+1
      GO TO 92
   94 IUSED=IUSED+KNDVOT(LOCATN)
      GO TO 92
   95 MANNER=NEWMNR
      IF(MAXLOK.GE.0)GO TO 96
      IAUTHR=11
      IPASS=IPASS+1
      GO TO 97
   96 IAUTHR=12
   97 CONTINUE
C
C     *****************************************
C     *                                       *
C     *  WRITE REQUESTS MADE BY THIS STUDENT  *
C     *                                       *
C     *****************************************
C
C     WRITE THE STUDENTS DECISION FILE
      WRITE(KDISK,98)IAUTHR,ICLASS,IMOVE,IPASS,IVERSN,NUMWHO,
     1LTRPSW
      WRITE(KDISK,99)ISUBMT,IUSED,KNTSIN,LOCKUP,MANNER,
     1 KNTALL,IGVBAK
   98 FORMAT(5I6,1I7,1X,20A1)
   99 FORMAT(1I6,1I10,4I6,1I10)
      WRITE(KDISK,100)LTRWHO
      WRITE(KDISK,100)LTRNAM
  100 FORMAT(60A1)
      IF(KNTSIN.LE.0)GO TO 104
      DO 103 KOMPNY=1,KNTSIN
      WRITE(KDISK,101)NUMVOT(KOMPNY),KNDVOT(KOMPNY),KNTPRF(KOMPNY),
     1IDATE(KOMPNY),KLOSED(KOMPNY),IRANK(KOMPNY),JRANK(KOMPNY),
     2KLOCK(KOMPNY),MTIME(KOMPNY),MDATE(KOMPNY),MRECRT(KOMPNY),
     3ISOURC(KOMPNY)
  101 FORMAT(1I6,1I10,10I6)
      LIMIT=KNTPRF(KOMPNY)
      IF(LIMIT.GT.0)WRITE(KDISK,102)(IPREFR(I,KOMPNY),I=1,LIMIT)
  102 FORMAT(13I6)
  103 CONTINUE
  104 WRITE(KDISK,105)LTREND
  105 FORMAT(1A1)
      GO TO 52
  106 IF(MAXLOK.GE.0)GO TO 107
      CALL LCLCLS(8,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLCLS(2,1,3,ITTY,IDISK,JDISK,KDISK,LDISK)
      GO TO 108
  107 CALL LCLCLS(2,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLCLS(6,1,3,ITTY,IDISK,JDISK,KDISK,LDISK)
  108 GO TO 113
C
C     ERROR MESSAGES
  109 WRITE(ITTY,110)NUMWHO
  110 FORMAT(' Student',1I7,' has made too many requests')
      GO TO 113
  111 WRITE(ITTY,112)NUMWHO
  112 FORMAT(' Student',1I7,' has given too many time preferences')
      GO TO 113
C
C     ALL DONE
  113 STOP
      END
