C     RENBR(RSMADM/RESUME ADMINISTRATIVE FUNCTIONS)
C
C     DONALD BARTH, YALE SCHOOL OF MANAGEMENT
C
C     ADMINISTRATOR PROGRAM FOR STUDENT RESUME SYSTEM
C
      DIMENSION LTRTXT(10000),LNGLIN(300),LNGSEC(100),
     1MARKER(300),LTRUSR(40),LTRLPT(22),LNGLPT(3),NYEAR(10),
     2LTRTTL(2000),KNTTTL(100),JSTATE(10),LTRNPT(21),LNGNPT(3),
     3LTRBFR(80),LTRWHO(40),LWRWHO(40),LTRPSW(20),LWRPSW(20),
     4LTRWID(2500),NSTATE(16),LTRSTT(72),LTRRES(4),LWRRES(4)
C
C     RESERVED NAMES OF SECTIONS
      DATA LTRRES/1HN,1HA,1HM,1HE/
      DATA LWRRES/1Hn,1Ha,1Hm,1He/
C
C     MENU OF TYPES OF PROOFS
C     CONTINUOUS, PAGED, TYPESET
      DATA LTRLPT/
     11HC,1HO,1HN,1HT,1HI,1HN,1HU,1HO,1HU,1HS,
     21HP,1HA,1HG,1HE,1HD,
     31HT,1HY,1HP,1HE,1HS,1HE,1HT/
      DATA LNGLPT/10,5,7/
C     NONE, TYPEWRITER, PRINTER
      DATA LTRNPT/
     11HN,1HO,1HN,1HE,
     21HP,1HR,1HI,1HN,1HT,1HE,1HR,
     31HT,1HY,1HP,1HE,1HW,1HR,1HI,1HT,1HE,1HR/
      DATA LNGNPT/4,7,10/
C
C     DESCRIPTIONS OF STATES
      DATA LTRSTT/
     1 1HR,1HE,1HP,1HL,1HA,1HC,1HE,1HD,
     2 1H ,1H ,1H ,1HD,1HR,1HA,1HF,1HT,
     3 1H ,1H ,1HS,1HU,1HB,1HM,1HI,1HT,
     4 1HS,1HB,1HM,1HT,1H+,1HP,1HR,1HF,
     5 1H ,1H ,1HE,1HD,1HI,1HT,1HE,1HD,
     6 1HE,1HD,1HI,1HT,1H+,1HP,1HR,1HF,
     7 1HT,1HR,1HA,1HN,1HS,1HM,1HI,1HT,
     8 1H ,1HB,1HL,1HO,1HC,1HK,1HE,1HD,
     9 1H ,1H ,1H ,1H ,1HS,1HA,1HM,1HE/
C
C     LNGSTT = LENGTH OF SINGLE STATE NAME
      DATA LNGSTT/8/
C
C     DIMENSIONS OF ARRAYS
      DATA LMTLTT,LMTSEC,LMTWHO/2000,100,40/
      DATA LMTBFR,LMTTXT,LMTLIN,LMTWID,LMTCLS,LMTPSW,LMTSTT/
     1 80,10000,300,2500,10,20,10/
      DATA IDISK,JDISK,KDISK,ITTY/1,20,21,5/
      DATA LTRSPA/1H /
C
C     LMTTYP = MAXIMUM NUMBER OF LINES ON A TYPED PAGE
C     LMTPRI = MAXIMUM NUMBER OF LINES ON A TYPESET PAGE
      DATA LMTTYP,LMTPRI/60,66/
C
C     LNGCRT = 2 LESS THAN NUMBER OF LINES ON A VIDEO SCREEN
      DATA LNGCRT/22/
C
C     INITIALIZE COUNTS
      KNTSHO=0
      IVIDEO=0
      DO 1 I=1,16
      NSTATE(I)=0
    1 CONTINUE
C
C     TELL USER WHAT PROGRAM THIS IS
      WRITE(ITTY,2)
    2 FORMAT(' RSMADM (09/83)'/
     1' RESUME ADMINISTRATIVE FUNCTIONS'/1X)
C
C     IDENTIFY CURRENT USER
      CALL RSMWHO(LTRWHO,IPRJCT,IPRGRM,NUMWHO)
C
C     DETERMINE IF CURRENT USER IS ENABLED AS ADMINISTRATOR
      CALL RSMCHK(LTRWHO,LWRWHO,LMTWHO,IPRJCT,IPRGRM, IDISK,
     1 IYEAR,ICHECK,IPRINT,JVIDEO,LTRBFR,LMTBFR,ITTY,NUMWHO)
      MINCLS=ICHECK
      MAXCLS=IPRINT
      IXYZZY=IYEAR
      IF(IXYZZY.GE.0)GO TO 3
      IF(MINCLS.GT.MAXCLS)GO TO 5
      IF(IXYZZY.EQ.-3)GO TO 9
      IF(IXYZZY.EQ.-2)GO TO 7
    3 WRITE(ITTY,4)
    4 FORMAT(1X/' You are not validated as the administrator'/1X)
      GO TO 334
    5 WRITE(ITTY,6)
    6 FORMAT(' Class range excludes all resumes'/1X)
      GO TO 334
    7 WRITE(ITTY,8)MINCLS,MAXCLS
    8 FORMAT(' Proofs submitted resumes for classes',
     1 1I4,' to',1I4,' and unsubmits them')
      GO TO 128
C
C     *********************************
C     *                               *
C     *  ASK USER WHAT IS TO BE DONE  *
C     *                               *
C     *********************************
C
C     BASIC FUNCTION
    9 WRITE(ITTY,10)
   10 FORMAT(
     1' Specify 1 number to select among following functions'/
     2' 1=List student names, status and numbers in output file'/
     3' 2=Unsubmit'/
     4' 3=Submit'/
     5' 4=Proof'/
     6' 5=Transmit'/
     7' 6=Proof and unsubmit'/
     8' 7=Change number or password or class of resume file'/
     9' 8=Block file from any further use')
   11 WRITE(ITTY,12)
   12 FORMAT(' Which function? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 9
      IF(MAXBFR.EQ.0)GO TO 13
      LOWBFR=1
      CALL DAHEFT(0,0,0,LTRBFR,LMTBFR,
     1LOWBFR,KIND,ISHIFT,JSHIFT,KSHIFT,LSHIFT,IVALUE,
     2VALUE)
      GO TO(13,13,15),KIND
   13 WRITE(ITTY,14)
   14 FORMAT(' You must select 1 function')
      GO TO 11
   15 MASTER=IVALUE
      IF(MASTER.LE.0)GO TO 16
      IF(MASTER.GT.8)GO TO 16
      GO TO 18
   16 WRITE(ITTY,17)
   17 FORMAT(' Value must be in range 1 through 7')
      GO TO 11
   18 CONTINUE
C
C     TELL USER WHAT NAME OF OUTPUT FILE WILL BE
      IF(MASTER.EQ.1)WRITE(ITTY,19)
   19 FORMAT(' List will be in file RESUME.LST')
      IF(MASTER.EQ.4)WRITE(ITTY,20)
      IF(MASTER.EQ.6)WRITE(ITTY,20)
   20 FORMAT(' Proofs will be in file RESUME.PRF')
C
C     ASK TYPE OF PROOF FILE
      IF(MASTER.EQ.4)GO TO 21
      IF(MASTER.EQ.6)GO TO 21
      GO TO 43
   21 WRITE(ITTY,22)
   22 FORMAT(' CONTINUOUS, PAGED or TYPESET format? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 23
      LOWBFR=1
      CALL DAVERB(1,22,LTRLPT,1,3,
     1LNGLPT,LTRBFR,MAXBFR,LOWBFR,KIND,MATCH,LCNWRD,
     2LCNKNT,LCNBFR)
      GO TO(25,25,27,27,25),KIND
   23 WRITE(ITTY,24)
   24 FORMAT(
     1' Type 1 of the following words to select type of resume'/
     2' CONTINUOUS For typed resume book having 1 page per student.'/
     3'            Lines divided same as when typed on typewriter.'/
     4'            Long resumes are not divided into multiple pages.'/
     5' PAGED      For individual resumes requested by students.'/
     6'            Lines divided same as when typed on typewriter.'/
     7'            Long resumes are divided into several pages.'/
     8' TYPESET    For checking resumes before these are transmitted.'/
     9'            Lines will be divided same as when typeset.')
      GO TO 21
   25 WRITE(ITTY,26)
   26 FORMAT(' Type ? for instructions')
      GO TO 21
   27 IF(LOWBFR.GT.MAXBFR)GO TO 28
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 25
   28 GO TO(29,30,31),MATCH
C     CONTINUOUS
   29 IVARY=0
      JVARY=3
      KVARY=2
      LVARY=1
      MVARY=1
      NVARY=1
      GO TO 32
C     PAGED
   30 IVARY=LMTTYP
      JVARY=3
      KVARY=2
      LVARY=1
      MVARY=1
      NVARY=2
      GO TO 32
C     TYPESET
   31 IVARY=0
      JVARY=2
      KVARY=3
      LVARY=2
      MVARY=1
      NVARY=3
      GO TO 32
C
C     ASK HOW BOLDING AND UNDERLINING ARE TO BE PERFORMED
   32 WRITE(ITTY,33)
   33 FORMAT(' Type of bolding (NONE, PRINTER, TYPEWRITER)? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 34
      LOWBFR=1
      CALL DAVERB(1,21,LTRNPT,1,3,
     1LNGNPT,LTRBFR,MAXBFR,LOWBFR,KIND,MATCH,LCNWRD,
     2LCNKNT,LCNBFR)
      GO TO(36,36,38,38,36),KIND
   34 WRITE(ITTY,35)
   35 FORMAT(
     1' Type 1 of the following words to select type of bolding used'/
     2' NONE       if resume are not to show bolding and underlining.'/
     3' PRINTER    if bolding and underlining are to be included and'/
     4'            resumes will be printed on the fast printer.'/
     5' TYPEWRITER if bolding and underlining are to be included and'/
     6'            resumes will be typed on letter quality typewriter.')
      GO TO 32
   36 WRITE(ITTY,37)
   37 FORMAT(' Type ? for instructions')
      GO TO 32
   38 IF(LOWBFR.GT.MAXBFR)GO TO 39
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 36
   39 GO TO(40,41,42),MATCH
C     NONE
   40 JVARY=1
      GO TO 43
C     PRINTER
   41 JVARY=2
      GO TO 43
C     TYPEWRITER
   42 JVARY=3
      GO TO 43
   43 CONTINUE
C
C     IF RENAMING FILE, ASK FOR NEW SCHEME
      IF(MASTER.NE.7)GO TO 51
   44 WRITE(ITTY,45)
   45 FORMAT(
     1' Type 1 number to select type of account students will use'/
     2' 1=Students run from own accounts without passwords'/
     3' 2=Students use passwords assigned by administrator'/
     4' 3=Students select their own passwords')
   46 WRITE(ITTY,47)
   47 FORMAT(' Convert to which type of account? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 44
      IF(MAXBFR.EQ.0)GO TO 46
      LOWBFR=1
      CALL DAHEFT(0,0,0,LTRBFR,LMTBFR,
     1LOWBFR,KIND,ISHIFT,JSHIFT,KSHIFT,LSHIFT,IVALUE,
     2VALUE)
      GO TO(46,46,48),KIND
   48 KNDPSW=IVALUE
      IF(KNDPSW.LE.0)GO TO 49
      IF(KNDPSW.GT.3)GO TO 49
      GO TO 51
   49 WRITE(ITTY,50)
   50 FORMAT(' Number must be in range 1 through 3')
      GO TO 46
   51 CONTINUE
C
C     ASK IF RESUMES WILL BE SELECTED INDIVIDUALLY
   52 WRITE(ITTY,53)
   53 FORMAT(' Will resumes be selected individually (Y or N)? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(52,52,56,57,54),KNDYES
   54 WRITE(ITTY,55)
   55 FORMAT(
     1' Type one of the following'/
     2' YES  to select individual resumes by class and student'/
     3'      number or password.'/
     4' NO   to select a group of resumes according to some'/
     5'      combination of class, state and modification date.')
      GO TO 52
C     YES, INDIVIDUALLY SELECTED RESUMES
   56 IFLOOP=0
      GO TO 58
C     NO, GROUP OF RESUMES
   57 IFLOOP=1
   58 CONTINUE
C
C     ASK IF RESUMES ARE TO BE PROCESSED IN ALPHABETICAL ORDER
      IF(IFLOOP.EQ.0)GO TO 129
   59 WRITE(ITTY,60)
   60 FORMAT(' Process resumes in preselected order (Y or N)? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(59,59,63,64,61),KNDYES
   61 WRITE(ITTY,62)
   62 FORMAT(
     1' Type one of the following'/
     2' YES  to process resumes in order indicated in the RESUME.SRT'/
     3'      file.  You must have run this program to produce a list'/
     4'      file, then have run RSMSRT program to sort list file.'/
     5' NO   to process resumes in numerical order.')
      GO TO 59
C     YES, PRESELECTED ORDER
   63 IFLOOP=2
      GO TO 65
C     NO, ORDER OF APPEARANCE IN ACCOUNT
   64 IFLOOP=1
   65 CONTINUE
C
C     ASK USER WHICH YEAR CLASS IS TO BE PROCESSED
   66 IF(MASTER.EQ.1)WRITE(ITTY,67)
      IF(MASTER.EQ.2)WRITE(ITTY,68)
      IF(MASTER.EQ.3)WRITE(ITTY,69)
      IF(MASTER.EQ.4)WRITE(ITTY,70)
      IF(MASTER.EQ.5)WRITE(ITTY,71)
      IF(MASTER.EQ.6)WRITE(ITTY,72)
      IF(MASTER.EQ.7)WRITE(ITTY,73)
      IF(MASTER.EQ.8)WRITE(ITTY,74)
   67 FORMAT(' List information for which classes (-1=all)? ',$)
   68 FORMAT(' Unsubmit which classes (-1=all)? ',$)
   69 FORMAT(' Submit which classes (-1=all)? ',$)
   70 FORMAT(' Proof which classes (-1=all)? ',$)
   71 FORMAT(' Transmit which classes (-1=all)? ',$)
   72 FORMAT(' Proof and unsubmit which classes (-1=all)? ',$)
   73 FORMAT(' New number/password/class for which origin',
     1'al classes (-1=all)? ',$)
   74 FORMAT(' Block which classes (-1=all)? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO  78
      IF(MAXBFR.EQ.0)GO TO 83
      KNTCLS=0
      LOWBFR=0
   75 CALL GETNUM(0,LTRBFR,MAXBFR,LOWBFR,KIND  ,
     1    IVALUE,VALUE )
      GO TO(82,87,75,76),KIND
   76 IF(KNTCLS.GE.LMTCLS)GO TO 80
      IF(IVALUE.LT.0)GO TO 77
      IF(IVALUE.LT.MINCLS)GO TO 85
      IF(IVALUE.GT.MAXCLS)GO TO 85
   77 KNTCLS=KNTCLS+1
      NYEAR(KNTCLS)=IVALUE
      GO TO 75
   78 WRITE(ITTY,79)LMTCLS,MINCLS,MAXCLS
   79 FORMAT(
     1' Type 1 to',1I4,' numbers in range',1I4,' to',1I4,
     2' to select resumes in these classes.'/
     3' Type -1 to select all classes.')
      GO TO 66
   80 WRITE(ITTY,81)LMTCLS
   81 FORMAT(' You cannot specify over',1I4,' class numbers'/
     1' Please retype the entire list of classes')
      GO TO 66
   82 IF(KNTCLS.GT.0)GO TO 89
   83 WRITE(ITTY,84)
   84 FORMAT(' You must specify at least 1 class')
      GO TO 66
   85 WRITE(ITTY,86)MINCLS,MAXCLS
   86 FORMAT(' Classes must be in range',1I5,' to',1I5/
     1' Please retype the entire list of classes')
      GO TO 66
   87 WRITE(ITTY,88)
   88 FORMAT(' Please retype the entire list of classes')
      GO TO 66
   89 IF(KNTCLS.GT.1)WRITE(ITTY,90)(NYEAR(I),I=1,KNTCLS)
   90 FORMAT(' Classes:',10I6)
      LYEAR=NYEAR(1)
C
C     ASK WHAT COLLECTION IS DESIRED
   91 WRITE(ITTY,92)
   92 FORMAT(' Type 1 or more of the following numbers'/
     1' 0=REPLACED'/
     2' 1=DRAFT'/
     3' 2=SUBMITTED'/
     4' 3=SUBMIT+PROOF'/
     5' 4=EDITED'/
     6' 5=EDIT+PROOF'/
     7' 6=TRANSMITTED'/
     8' 7=BLOCKED'/
     9' Type -1 for all states DRAFT through TRANSMITTED.')
   93 WRITE(ITTY,94)
   94 FORMAT(' Process which states (-1=all)? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 91
      IF(MAXBFR.EQ.0)GO TO 100
      KNTSTT=0
      LOWBFR=0
   95 CALL GETNUM(0,LTRBFR,MAXBFR,LOWBFR,KIND  ,
     1    IVALUE,VALUE )
      GO TO(99,104,95,96),KIND
   96 IF(KNTSTT.GE.LMTSTT)GO TO 97
      IF(IVALUE.GT.7)GO TO 102
      KNTSTT=KNTSTT+1
      JSTATE(KNTSTT)=IVALUE
      GO TO 95
   97 WRITE(ITTY,98)LMTSTT
   98 FORMAT(' You cannot specify over',1I4,' states.'/
     1' Please retype the entire list of states.')
      GO TO 93
   99 IF(KNTSTT.GT.0)GO TO 106
  100 WRITE(ITTY,101)
  101 FORMAT(' You must specify at least 1 state')
      GO TO 93
  102 WRITE(ITTY,103)
  103 FORMAT(' Numbers must be -1 or in range 0 through 7'/
     1' Please retype the entire list of states.')
      GO TO 93
  104 WRITE(ITTY,105)
  105 FORMAT(' Please retype the entire list of states')
      GO TO 93
  106 IF(KNTSTT.GT.1)WRITE(ITTY,107)(JSTATE(I),I=1,KNTSTT)
  107 FORMAT(' States:',10I6)
C
C     ASK FOR EARLIEST MODIFICATION DATE
  108 WRITE(ITTY,109)
  109 FORMAT(' Reject resumes created before what date? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 111
      IF(MAXBFR.EQ.0)GO TO 113
      LOWBFR=1
      CALL DADATE(1,LTRBFR,MAXBFR,LOWBFR,KIND  ,
     1   KDAY  ,KMONTH,KYEAR ,LCNBFR)
      IF(KDAY.LE.0)GO TO 115
      IF(KMONTH.LE.0)GO TO 115
      IF(KYEAR.LT.0)GO TO 115
      IF(KYEAR.LT.100)KYEAR=KYEAR+1900
      IF(KYEAR.LE.1980)KYEAR=KYEAR+100
      CALL DAWEEK(0,ISMITH,KDAY,KMONTH,KYEAR,IWEEK)
      WRITE(ITTY,110)KMONTH,KDAY,KYEAR
  110 FORMAT(' Month:',1I3,', Day:',1I3,', Year:',1I5)
      GO TO 117
  111 WRITE(ITTY,112)
  112 FORMAT(' Type the date using any conventional notation.'/
     1' Suggested forms are 13-Jan-83 or January 13, 1983')
      GO TO 108
  113 WRITE(ITTY,114)
  114 FORMAT(' Date must be supplied')
      GO TO 108
  115 WRITE(ITTY,116)
  116 FORMAT(' Illegal form for date.'/
     1' Suggested forms are 13-Jan-83 or January 13, 1983')
      GO TO 108
  117 CONTINUE
C
C     ASK FOR LATEST MODIFICATION DATE
  118 WRITE(ITTY,119)
  119 FORMAT(' Reject resumes created after what date? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 121
      IF(MAXBFR.EQ.0)GO TO 123
      LOWBFR=1
      CALL DADATE(1,LTRBFR,MAXBFR,LOWBFR,KIND  ,
     1   KDAY  ,KMONTH,KYEAR ,LCNBFR)
      IF(KDAY.LE.0)GO TO 125
      IF(KMONTH.LE.0)GO TO 125
      IF(KYEAR.LT.0)GO TO 125
      IF(KYEAR.LT.100)KYEAR=KYEAR+1900
      IF(KYEAR.LE.1980)KYEAR=KYEAR+100
      CALL DAWEEK(0,KSMITH,KDAY,KMONTH,KYEAR,IWEEK)
      WRITE(ITTY,120)KMONTH,KDAY,KYEAR
  120 FORMAT(' Month:',1I3,', Day:',1I3,', Year:',1I5)
      GO TO 127
  121 WRITE(ITTY,122)
  122 FORMAT(' Type the date using any conventional notation.'/
     1' Suggested forms are 13-Jan-83 or January 13, 1983')
      GO TO 118
  123 WRITE(ITTY,124)
  124 FORMAT(' Date must be supplied')
      GO TO 118
  125 WRITE(ITTY,126)
  126 FORMAT(' Illegal form for date.'/
     1' Suggested forms are 13-Jan-83 or January 13, 1983')
      GO TO 118
  127 CONTINUE
      GO TO 130
C
C     WORD PROCESSING HANDLING OF SUBMITTED RESUMES ONLY
C     PROOF AND UNSUBMIT
  128 MASTER=6
C     BY ORDER OF FILES IN DIRECTORY
      IFLOOP=1
C     TYPE OF PROOF
      IVARY=LMTTYP
      JVARY=3
      KVARY=2
      LVARY=1
      MVARY=1
      NVARY=2
C     ANY SUBMITTED OR HIGHER STATE RESUME
      KNTSTT=5
      JSTATE(1)=2
      JSTATE(2)=3
      JSTATE(3)=4
      JSTATE(4)=5
      JSTATE(5)=6
C     ANY YEAR
      ISMITH=0
      KSMITH=0
C     ANY CLASS VALIDATED BY THE RESUME.WHO FILE
      KNTCLS=1
      NYEAR(1)=-1
      LYEAR=NYEAR(1)
      GO TO 214
C
C     INDIVIDUALLY SELECTED RESUMES
  129 ISMITH=0
      KSMITH=0
      KNTSTT=3
      JSTATE(1)=0
      JSTATE(2)=-1
      JSTATE(3)=7
      GO TO 130
C
C     *******************************************
C     *                                         *
C     *  ASK USER IF SPECIFICATONS ARE CORRECT  *
C     *                                         *
C     *******************************************
C
C     LIST OVERALL FUNCTION
  130 WRITE(ITTY,131)
  131 FORMAT(1X/' *** Summary of Selection Rules ***'/1X)
      IF(MASTER.EQ.1)WRITE(ITTY,132)
  132 FORMAT(
     1' List current state, student and class numbers an',
     2'd student name')
      IF(MASTER.EQ.2)WRITE(ITTY,133)
  133 FORMAT(
     1' Place resumes in UNSUBMIT state regardless of original state')
      IF(MASTER.EQ.3)WRITE(ITTY,134)
  134 FORMAT(
     1' Place resumes in SUBMIT state regardless of original state')
      IF(MASTER.EQ.4)WRITE(ITTY,135)
  135 FORMAT(' Proof resumes'/
     1' Place resumes in SUBMIT+PROOF state if in SUBMIT state'/
     2' Place resumes in EDIT+PROOF state if in EDIT state'/
     3' Retain all other states')
      IF(MASTER.EQ.5)WRITE(ITTY,136)
  136 FORMAT(' Transmit resumes'/
     1' Place resumes in TRANSMIT state regardless of original state')
      IF(MASTER.EQ.6)WRITE(ITTY,137)
  137 FORMAT(' Proof resumes'/
     1' Place resumes in UNSUBMIT state regardless of original state')
      IF(MASTER.EQ.7)WRITE(ITTY,138)
  138 FORMAT(
     1' Change number or password or class for a group of resumes'/
     2' Resulting resume will have state of original resume'/
     3' Place original resume in REPLACED state')
      IF(MASTER.EQ.8)WRITE(ITTY,139)
  139 FORMAT(' Block any further use of resumes')
C
C     TYPE OF PROOF
      IF(MASTER.EQ.4)GO TO 140
      IF(MASTER.EQ.6)GO TO 140
      GO TO 147
  140 IF(NVARY.EQ.1)WRITE(ITTY,141)
      IF(NVARY.EQ.2)WRITE(ITTY,142)
      IF(NVARY.EQ.3)WRITE(ITTY,143)
  141 FORMAT(
     1' Resumes will not be split into pages'/
     2' Lines will be divided same as when typed on typewriter')
  142 FORMAT(
     1' Long resumes will be split into pages'/
     2' Lines will be divided same as when typed on typewriter')
  143 FORMAT(
     1' Resumes will not be split into pages'/
     2' Line lengths will be same as when resumes are typeset')
      IF(JVARY.EQ.1)WRITE(ITTY,144)
      IF(JVARY.EQ.2)WRITE(ITTY,145)
      IF(JVARY.EQ.3)WRITE(ITTY,146)
  144 FORMAT(' Resumes will not include bolding and underlining')
  145 FORMAT(' Resumes should be printed on fast printer')
  146 FORMAT(' Resumes must be typed on letter quality typewriter')
  147 CONTINUE
C
C     PASSWORD SCHEME IF RENAME FILE
      IF(MASTER.NE.7)GO TO 151
      IF(KNDPSW.EQ.1)WRITE(ITTY,148)
  148 FORMAT(
     1' Students will run from own accounts without passwords')
      IF(KNDPSW.EQ.2)WRITE(ITTY,149)
  149 FORMAT(
     1' Students will use passwords assigned by administrator')
      IF(KNDPSW.EQ.3)WRITE(ITTY,150)
  150 FORMAT(
     1' Students will select their own passwords')
  151 CONTINUE
C
C     POOL OF RESUMES
      IF(IFLOOP.EQ.0)WRITE(ITTY,152)
  152 FORMAT(' Resumes will be selected by number and class')
      IF(IFLOOP.EQ.1)WRITE(ITTY,153)
  153 FORMAT(
     1' Resumes will be selected in their order in directory')
      IF(IFLOOP.EQ.2)WRITE(ITTY,154)
  154 FORMAT(' Resumes will be selected in preselected order')
C
C     CLASSES
      IF(IFLOOP.EQ.0)GO TO 158
      DO 157 I=1,KNTCLS
      IF(NYEAR(I).LT.0)WRITE(ITTY,155)
  155 FORMAT(' Process any class')
      IF(NYEAR(I).GE.0)WRITE(ITTY,156)NYEAR(I)
  156 FORMAT(' Process class',1I5)
  157 CONTINUE
  158 CONTINUE
C
C     STATES
      IF(IFLOOP.EQ.0)GO TO 169
      DO 168 I=1,KNTSTT
      IF(JSTATE(I).LT.0)WRITE(ITTY,159)
      IF(JSTATE(I).EQ.0)WRITE(ITTY,160)
      IF(JSTATE(I).EQ.1)WRITE(ITTY,161)
      IF(JSTATE(I).EQ.2)WRITE(ITTY,162)
      IF(JSTATE(I).EQ.3)WRITE(ITTY,163)
      IF(JSTATE(I).EQ.4)WRITE(ITTY,164)
      IF(JSTATE(I).EQ.5)WRITE(ITTY,165)
      IF(JSTATE(I).EQ.6)WRITE(ITTY,166)
      IF(JSTATE(I).EQ.7)WRITE(ITTY,167)
  159 FORMAT(' Process any state except REPLACED and BLOCKED')
  160 FORMAT(' Process REPLACED state')
  161 FORMAT(' Process DRAFT state')
  162 FORMAT(' Process SUBMITTED state')
  163 FORMAT(' Process SUBMIT+PROOF state')
  164 FORMAT(' Process EDITED state')
  165 FORMAT(' Process EDIT+PROOF state')
  166 FORMAT(' Process TRANSMITTED state')
  167 FORMAT(' Process BLOCKED state')
  168 CONTINUE
  169 CONTINUE
C
C     CUT-OFF DATE
      IF(IFLOOP.EQ.0)GO TO 172
      CALL DAWEEK(-1,ISMITH,JDAY,JMONTH,JYEAR,IWEEK)
      WRITE(ITTY,170)JMONTH,JDAY,JYEAR
  170 FORMAT(' Reject resumes written before Month:',
     11I3,', Day:',1I3,', Year:',1I5)
      CALL DAWEEK(-1,KSMITH,JDAY,JMONTH,JYEAR,IWEEK)
      WRITE(ITTY,171)JMONTH,JDAY,JYEAR
  171 FORMAT(' Reject resumes written after  Month:',
     11I3,', Day:',1I3,', Year:',1I5)
  172 CONTINUE
C
C     ASK IF THESE ARE CORRECT
      WRITE(ITTY,173)
  173 FORMAT(1X)
  174 WRITE(ITTY,175)
  175 FORMAT(' Are all of the above specifications correct? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(174,174,178,176,174),KNDYES
  176 WRITE(ITTY,177)
  177 FORMAT(' Cancelling currently selected criteria')
      GO TO 9
  178 IF(IFLOOP.NE.0)GO TO 214
      GO TO 179
C
C     **************************************************
C     *                                                *
C     *  GET YEAR AND STUDENT NUMBER OF SINGLE RESUME  *
C     *                                                *
C     **************************************************
C
C     GET CLASS NUMBER OF NEXT SINGLE RESUME
  179 IF(MASTER.EQ.1)WRITE(ITTY,180)
      IF(MASTER.EQ.2)WRITE(ITTY,181)
      IF(MASTER.EQ.3)WRITE(ITTY,182)
      IF(MASTER.EQ.4)WRITE(ITTY,183)
      IF(MASTER.EQ.5)WRITE(ITTY,184)
      IF(MASTER.EQ.6)WRITE(ITTY,185)
      IF(MASTER.EQ.7)WRITE(ITTY,186)
      IF(MASTER.EQ.8)WRITE(ITTY,187)
  180 FORMAT(' List information for which class (-1=exit)? ',$)
  181 FORMAT(' Unsubmit which class (-1=exit)? ',$)
  182 FORMAT(' Submit which class (-1=exit)? ',$)
  183 FORMAT(' Proof which class (-1=exit)? ',$)
  184 FORMAT(' Transmit which class (-1=exit)? ',$)
  185 FORMAT(' Proof and unsubmit which class (-1=exit)? ',$)
  186 FORMAT(' New number/password/class for which origi',
     1'nal class (-1=exit)? ',$)
  187 FORMAT(' Block which class (-1=exit)? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO  190
      IF(MAXBFR.EQ.0)GO TO 195
      KNTCLS=0
      LOWBFR=0
  188 CALL GETNUM(0,LTRBFR,MAXBFR,LOWBFR,KIND  ,
     1    IVALUE,VALUE )
      GO TO(194,199,188,189),KIND
  189 IF(KNTCLS.GE.1)GO TO 192
      IF(IVALUE.LT.0)GO TO 327
      IF(IVALUE.LT.MINCLS)GO TO 197
      IF(IVALUE.GT.MAXCLS)GO TO 197
      KNTCLS=KNTCLS+1
      NYEAR(KNTCLS)=IVALUE
      GO TO 188
  190 WRITE(ITTY,191)MINCLS,MAXCLS
  191 FORMAT(
     1' Type 1 number in range',1I4,' to',1I4,
     2' to select class for next resume.'/
     3' Type -1 to exit.')
      GO TO 179
  192 WRITE(ITTY,193)
  193 FORMAT(' You can only specify 1 class')
      GO TO 179
  194 IF(KNTCLS.GT.0)GO TO 201
  195 WRITE(ITTY,196)
  196 FORMAT(' You must specify 1 class')
      GO TO 179
  197 WRITE(ITTY,198)MINCLS,MAXCLS
  198 FORMAT(' Class must be in range',1I5,' to',1I5)
      GO TO 179
  199 WRITE(ITTY,200)
  200 FORMAT(' Please retype the class')
      GO TO 179
  201 LYEAR=NYEAR(1)
C
C     GET STUDENT NUMBER FOR NEXT SINGLE RESUME
  202 WRITE(ITTY,203)
  203 FORMAT(' Number of individual resume (-2 by passwo',
     1'rd,-1 to exit)? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 204
      IF(MAXBFR.EQ.0)GO TO 179
      LOWBFR=1
      CALL DAHEFT(0,0,0,LTRBFR,LMTBFR,
     1LOWBFR,KIND,ISHIFT,JSHIFT,KSHIFT,LSHIFT,IVALUE,
     2VALUE)
      GO TO(204,204,206),KIND
  204 WRITE(ITTY,205)
  205 FORMAT(
     1' Type the number which identifies the resume to be processed'/
     2' This number is based on password or individual account used.'/
     3' It identifies the student in the class.  It is not the class.'/
     4' Type -2 to select resume by student selected password.'/
     5' Type -1 to exit.'/
     6' Or merely press the RETURN key to select another class.')
      GO TO 202
  206 IF(IVALUE.GE.0)GO TO 211
      IF(IVALUE.EQ.-2)GO TO 207
      IF(IVALUE.EQ.-1)GO TO 327
      GO TO 204
  207 CALL PASWRD(LTRPSW,LMTPSW,ITTY,LNGPSW,NUMWHO,
     1LTRBFR,LMTBFR)
      IF(NUMWHO.GE.0)GO TO 209
      WRITE(ITTY,208)
  208 FORMAT(' Type the password which was selected by the student')
      GO TO 207
  209 IVALUE=NUMWHO
      WRITE(ITTY,210)IVALUE
  210 FORMAT(' This password translates to number',1I7)
  211 IF(IVALUE.LE.999999)GO TO 213
      WRITE(ITTY,212)
  212 FORMAT(' Number must be in range 0 through 999999')
      GO TO 202
  213 JOBUSR=IVALUE
      GO TO 223
C
C     ************************************
C     *                                  *
C     *  IDENTIFY NEXT RESUME IN SERIES  *
C     *                                  *
C     ************************************
C
C     GET FIRST STUDENT FILE IN SEQUENCE
  214 IF(IFLOOP.EQ.2)GO TO 216
      KNTFIL=0
      GO TO 222
C
C     OPEN NEXT STUDENT FILE IN SEQUENCE
  215 IF(IFLOOP.EQ.2)GO TO 217
      GO TO 222
C
C     PREPARE TO READ NUMBERS AND YEARS FROM SORTED FILE
  216 CALL RSMOPN(15,NUMWHO,IYEAR,ITTY,JDISK,IFOPEN)
      IF(IFOPEN.EQ.0)GO TO 220
      GO TO 217
C
C     GET NEXT NUMBER AND YEAR FROM SORTED FILE
  217 READ(JDISK,218,END=219)ISEQNC,JOBUSR,LYEAR
  218 FORMAT(1I5,8X,1I6,7X,1I3)
      IF(ISEQNC.EQ.0)GO TO 217
      GO TO 223
  219 CALL RSMCLS(15,NUMWHO,IYEAR,ITTY,JDISK,IFCLOS)
      GO TO 327
  220 WRITE(ITTY,221)
  221 FORMAT(' Cannot open sorted file')
      GO TO 334
C
C     IDENTIFY NEXT RESUME FILE IN STORAGE AREA
  222 CALL RSMDIR(JDISK ,KNTFIL,JOBUSR,LYEAR ,IFOPEN)
      IF(IFOPEN.EQ.0)GO TO 327
      GO TO 223
C
C     *****************************
C     *                           *
C     *  READ CONTENTS OF RESUME  *
C     *                           *
C     *****************************
C
C     CHECK IF NEXT RESUME FILE IS IN PROPER YEAR
  223 IF(LYEAR.LT.MINCLS)GO TO 226
      IF(LYEAR.GT.MAXCLS)GO TO 226
      DO 224 I=1,KNTCLS
      IF(NYEAR(I).LT.0)GO TO 225
      IF(NYEAR(I).EQ.LYEAR)GO TO 225
  224 CONTINUE
      GO TO 226
C
C     OPEN NEXT RESUME FILE
  225 CALL RSMOPN(3,JOBUSR,LYEAR,ITTY,IDISK,IFOPEN)
      IF(IFOPEN.NE.0)GO TO 227
  226 IF(IFLOOP.EQ.0)GO TO 322
      IF(IFLOOP.EQ.2)GO TO 217
      GO TO 222
C
C     READ HEADER INFORMATION IN RESUME FILE
  227 READ(IDISK,228,END=232,ERR=232)ISTATE,IPRINT,IVERSN,MYEAR,
     1JDAY,JMONTH,JYEAR,NUMWHO,LTRUSR,LTRPSW
  228 FORMAT(2I1,2I3,3I2,1I6,40A1,20A1)
C
C     DETERMINE WHETHER THE RESUME IS IN PROPER STATE
      IF(IFLOOP.EQ.0)GO TO 233
      DO 229 I=1,KNTSTT
      IF(ISTATE.EQ.JSTATE(I))GO TO 231
  229 CONTINUE
      IF(ISTATE.EQ.0)GO TO 232
      IF(ISTATE.EQ.7)GO TO 232
      DO 230 I=1,KNTSTT
      IF(JSTATE(I).LT.0)GO TO 231
  230 CONTINUE
      GO TO 232
  231 KYEAR=JYEAR+1900
      IF(KYEAR.LE.1980)KYEAR=KYEAR+100
      CALL DAWEEK(0,JSMITH,JDAY,JMONTH,KYEAR,IWEEK)
      IF(ISMITH.EQ.0)GO TO 233
      IF(JSMITH.LT.ISMITH)GO TO 232
      IF(JSMITH.GT.KSMITH)GO TO 232
      GO TO 233
  232 CALL RSMCLS(3,JOBUSR,LYEAR,ITTY,IDISK,IFCLOS)
      GO TO 326
C
C     INITIALIZE STORAGE
  233 MAXLTT=0
      MAXSEC=0
      KNTLIN=0
      KNTTXT=0
      MAXSEC=MAXSEC+1
      KNTTTL(MAXSEC)=0
      LNGSEC(MAXSEC)=1
      KNTLIN=KNTLIN+1
      LNGLIN(KNTLIN)=0
      MARKER(KNTLIN)=0
C
C     GET PREVIOUS CONTENTS OF FILE, IF ANY
      CALL RSMOLD(IVERSN,NOWSEC,IDISK,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL)
      CALL RSMCLS(3,JOBUSR,LYEAR,ITTY,IDISK,IFCLOS)
C
C     *************************
C     *                       *
C     *  LOCATE NAME SECTION  *
C     *                       *
C     *************************
C
      MAXPRT=0
      MRKSEC=0
      NOWLIN=0
      IF(MAXSEC.LE.0)GO TO 242
      DO 241 NEWSEC=1,MAXSEC
      INISEC=MRKSEC+1
      MRKSEC=MRKSEC+KNTTTL(NEWSEC)
      MAXLIN=LNGSEC(NEWSEC)
C
C     CHECK IF THE NAME IS ONE OF THOSE RESERVED
      J=0
      K=4
      IF((MRKSEC-INISEC+1).NE.4)GO TO 235
      DO 234 I=INISEC,MRKSEC
      J=J+1
      IF(LTRTTL(I).EQ.LTRRES(J))GO TO 234
      IF(LTRTTL(I).EQ.LWRRES(J))GO TO 234
      GO TO 235
  234 CONTINUE
      GO TO 238
C
C     SKIP OVER LINES OF SECTION NOT HAVING RESERVED NAME
  235 IF(MAXLIN.EQ.0)GO TO 237
      DO 236 I=1,MAXLIN
      NOWLIN=NOWLIN+1
      MAXPRT=MAXPRT+LNGLIN(NOWLIN)
  236 CONTINUE
  237 GO TO 241
C
C     NAME SECTION FOUND
  238 INIPRT=MAXPRT+1
      IF(MAXLIN.EQ.0)GO TO 240
      DO 239 I=1,MAXLIN
      NOWLIN=NOWLIN+1
      MAXPRT=MAXPRT+LNGLIN(NOWLIN)
  239 CONTINUE
  240 GO TO 243
  241 CONTINUE
  242 INIPRT=MAXPRT+1
  243 CONTINUE
C
C     ****************************************
C     *                                      *
C     *  IF PROCESSING INDIVIDUAL RESUMES,   *
C     *  ASK USER IF THIS IS THE ONE WANTED  *
C     *                                      *
C     ****************************************
C
      IF(MASTER.EQ.7)GO TO 244
      IF(IFLOOP.NE.0)GO TO 265
  244 CONTINUE
C
C     IDENTIFY RESUME TO ADMINISTRATOR
      WRITE(ITTY,245)
  245 FORMAT(1X/' *** Description of resume ***'/1X)
      IF(INIPRT.GT.MAXPRT)WRITE(ITTY,246)
  246 FORMAT('    Name: *** NO NAME ***')
      IF(INIPRT.LE.MAXPRT)WRITE(ITTY,247)(LTRTXT(I),I=INIPRT,MAXPRT)
  247 FORMAT('    Name: ',100A1)
      WRITE(ITTY,248)LTRUSR
  248 FORMAT(' Account: ',40A1)
      WRITE(ITTY,249)JOBUSR,LYEAR,LTRPSW
  249 FORMAT('  Number:',1I7,', Class:',1I4,', Password: ',20A1)
      WRITE(ITTY,250)JMONTH,JDAY,JYEAR
  250 FORMAT('   Month:',1I3,', Day:',1I3,', Year:',1I5)
C
C     REPORT STATE OF RESUME
      IF(ISTATE.EQ.0)WRITE(ITTY,251)
  251 FORMAT('  Status: Replaced')
      IF(ISTATE.EQ.1)WRITE(ITTY,252)
  252 FORMAT('  Status: Draft only')
      IF(ISTATE.EQ.2)WRITE(ITTY,253)
  253 FORMAT('  Status: Submitted')
      IF(ISTATE.EQ.3)WRITE(ITTY,254)
  254 FORMAT('  Status: Submitted+Proofed')
      IF(ISTATE.EQ.4)WRITE(ITTY,255)
  255 FORMAT('  Status: Edited')
      IF(ISTATE.EQ.5)WRITE(ITTY,256)
  256 FORMAT('  Status: Edited+Proofed')
      IF(ISTATE.EQ.6)WRITE(ITTY,257)
  257 FORMAT('  Status: Transmitted')
      IF(IFLOOP.NE.0)GO TO 265
      IF(MASTER.EQ.1)GO TO 265
C
C     CONFIRM THAT THIS IS THE CORRECT RESUME
      WRITE(ITTY,258)
  258 FORMAT(1X)
  259 WRITE(ITTY,260)
  260 FORMAT(' Is this the correct resume? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(259,259,263,324,261),KNDYES
  261 WRITE(ITTY,262)
  262 FORMAT(' Answer'/
     1' YES if you want to process this resume'/
     2'  NO if you do not want to process this resume')
      GO TO 259
  263 WRITE(ITTY,264)
  264 FORMAT(' Processing')
C
C     *****************************
C     *                           *
C     *  CHANGE STATUS OF RESUME  *
C     *                           *
C     *****************************
C
C     TELL IF STUDENT NUMBER OR CLASS INCONSISTENT
  265 IF(JOBUSR.NE.NUMWHO)GO TO 266
      IF(LYEAR.NE.MYEAR)GO TO 266
      GO TO 268
  266 WRITE(ITTY,267)JOBUSR,LYEAR,NUMWHO,MYEAR
  267 FORMAT(' WARNING: File',1I7,'.',1I3,
     1' internally is for',1I7,'.',1I3)
  268 CONTINUE
C
C     CHANGE STATUS
      KSTATE=ISTATE
      NUMWHO=JOBUSR
      MYEAR=LYEAR
      DO 269 I=1,LMTPSW
      LWRPSW(I)=LTRPSW(I)
  269 CONTINUE
      GO TO(300,270,271,272,273,270,275,274),MASTER
  270 ISTATE=1
      GO TO 296
  271 ISTATE=2
      GO TO 296
  272 IF(ISTATE.EQ.2)ISTATE=3
      IF(ISTATE.EQ.4)ISTATE=5
      GO TO 296
  273 ISTATE=6
      GO TO 296
  274 ISTATE=7
      GO TO 296
C
C     IF RENAMING, GET STUDENT PASSWORD IF NEEDED
  275 WRITE(ITTY,276)
  276 FORMAT(' Specify information needed to access resu',
     1'lting resume')
      IF(KNDPSW.EQ.1)GO TO 280
  277 CALL PASWRD(LTRPSW,LMTPSW,ITTY,LNGPSW,NUMWHO,
     1LTRBFR,LMTBFR)
      IF(NUMWHO.GE.0)GO TO 279
      WRITE(ITTY,278)LMTPSW
  278 FORMAT(' Word or phrase of from 1 to',1I3,
     1' letters or digits must be supplied')
      GO TO 277
  279 CONTINUE
C
C     IF RENAMING, GET STUDENT NUMBER IF NEEDED
      IF(KNDPSW.NE.2)GO TO 286
  280 WRITE(ITTY,281)JOBUSR
  281 FORMAT(' New Student Number (-1=',1I6,')? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 283
      IF(MAXBFR.EQ.0)GO TO 283
      LOWBFR=1
      CALL DAHEFT(0,0,0,LTRBFR,LMTBFR,
     1LOWBFR,KIND,ISHIFT,JSHIFT,KSHIFT,LSHIFT,IVALUE,
     2VALUE)
      GO TO(283,283,282),KIND
  282 NUMWHO=IVALUE
      IF(NUMWHO.LT.0)GO TO 285
      IF(NUMWHO.GT.999999)GO TO 283
      GO TO 286
  283 WRITE(ITTY,284)
  284 FORMAT(' Student number must be in range 0 to 999999')
      GO TO 280
  285 NUMWHO=JOBUSR
  286 CONTINUE
C
C     IF RENAMING FILE, GET NEW YEAR NUMBER
  287 WRITE(ITTY,288)LYEAR
  288 FORMAT(' New class (-1=',1I3,')? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 290
      IF(MAXBFR.EQ.0)GO TO 290
      LOWBFR=1
      CALL DAHEFT(0,0,0,LTRBFR,LMTBFR,
     1LOWBFR,KIND,ISHIFT,JSHIFT,KSHIFT,LSHIFT,IVALUE,
     2VALUE)
      GO TO(290,290,289),KIND
  289 MYEAR=IVALUE
      IF(MYEAR.LT.0)GO TO 292
      IF(MYEAR.LT.MINCLS)GO TO 290
      IF(MYEAR.GT.MAXCLS)GO TO 290
      GO TO 293
  290 WRITE(ITTY,291)MINCLS,MAXCLS
  291 FORMAT(' Class must be in range',1I5,' to',1I5)
      GO TO 287
  292 MYEAR=LYEAR
  293 CONTINUE
C
C     MAKE SURE RENAMED FILE DOES NOT ALREADY EXIST
      IF(NUMWHO.NE.JOBUSR)GO TO 294
      IF(MYEAR.NE.LYEAR)GO TO 294
      GO TO 297
  294 CALL RSMOPN(3,NUMWHO,MYEAR,ITTY,IDISK,IFOPEN)
      IF(IFOPEN.EQ.0)GO TO 297
      READ(IDISK,298)LSTATE
      CALL RSMCLS(3,NUMWHO,MYEAR,ITTY,IDISK,IFCLOS)
      IF(LSTATE.EQ.0)GO TO 297
      WRITE(ITTY,295)NUMWHO,MYEAR
  295 FORMAT(' File for student',1I7,' in class',1I4,' already exists'/
     1' You must make another selection')
      GO TO 275
C
C     REWRITE RESUME FILE WITH NEW STATUS
  296 IF(ISTATE.EQ.KSTATE)GO TO 300
  297 CALL RSMOPN(5,NUMWHO,MYEAR,ITTY,IDISK,IFOPEN)
      WRITE(IDISK,298)ISTATE,IPRINT,IVERSN,MYEAR,
     1JDAY,JMONTH,JYEAR,NUMWHO,LTRUSR,LTRPSW
  298 FORMAT(2I1,2I3,3I2,1I6,40A1,20A1)
      CALL RSMSAV(NOWSEC,IDISK,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL)
      CALL RSMCLS(5,NUMWHO,MYEAR,ITTY,IDISK,IFCLOS)
C
C     REWRITE OLD RESUME SHOWING IT HAS BEEN REPLACED
      IF(NUMWHO.NE.JOBUSR)GO TO 299
      IF(MYEAR.NE.LYEAR)GO TO 299
      GO TO 300
  299 MSTATE=0
      CALL RSMOPN(5,JOBUSR,LYEAR,ITTY,IDISK,IFOPEN)
      WRITE(IDISK,298)MSTATE,IPRINT,IVERSN,LYEAR,
     1JDAY,JMONTH,JYEAR,JOBUSR,LTRUSR,LWRPSW
      CALL RSMSAV(NOWSEC,IDISK,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL)
      CALL RSMCLS(5,JOBUSR,LYEAR,ITTY,IDISK,IFCLOS)
      GO TO 300
C
C     RECORD HOW MANY OF EACH STATE FOUND
  300 KNTSHO=KNTSHO+1
      I=KSTATE+KSTATE+1
      J=ISTATE+ISTATE+2
      NSTATE(I)=NSTATE(I)+1
      NSTATE(J)=NSTATE(J)+1
C
C     **************************************
C     *                                    *
C     *  GENERATE LIST OF CURRENT RESUMES  *
C     *                                    *
C     **************************************
C
C     OPEN FILE TO CONTAIN THE LIST
      IF(IFLOOP.EQ.0)GO TO 301
      IF(KNTSHO.GT.1)GO TO 305
  301 IF(MASTER.NE.1)GO TO 303
      WRITE(ITTY,302)
  302 FORMAT(
     1'      OLD      NEW STDNT YEAR NAME',26X,'PASSWORD'/
     2'   STATUS   STATUS'/1X)
      IF(KNTSHO.GT.1)GO TO 305
      CALL TTYSIM(KDISK)
      CALL RSMOPN(9,JOBUSR,LYEAR,ITTY,KDISK,IFOPEN)
      WRITE(KDISK,302)
      GO TO 305
  303 WRITE(ITTY,304)
  304 FORMAT(
     1'      OLD      NEW STDNT YEAR NAME'/
     2'   STATUS   STATUS'/1X)
  305 CONTINUE
C
C     ADD NAME AND STATUS TO THE LIST
      J=INIPRT-1
      IF(J.LT.(MAXPRT-30))J=MAXPRT-30
      DO 306 I=1,30
      J=J+1
      LTRBFR(I)=LTRSPA
      IF(J.LE.MAXPRT)LTRBFR(I)=LTRTXT(J)
  306 CONTINUE
      L=LNGSTT*(KSTATE+1)
      K=L-LNGSTT+1
      N=LNGSTT*(ISTATE+1)
      IF(ISTATE.EQ.KSTATE)N=LNGSTT*9
      M=N-LNGSTT+1
      IF(INIPRT.LE.MAXPRT)GO TO 309
      IF(MASTER.NE.1)GO TO 308
      WRITE(ITTY,307)(LTRSTT(I),I=K,L),(LTRSTT(I),I=M,N),
     1 NUMWHO,MYEAR,LTRPSW
      WRITE(KDISK,307)(LTRSTT(I),I=K,L),(LTRSTT(I),I=M,N),
     1 NUMWHO,MYEAR,LTRPSW
  307 FORMAT(1X,8A1,1X,8A1,1I7,1I4,1X,'*** NO NAME ***',15X,20A1)
      GO TO 312
  308 WRITE(ITTY,307)(LTRSTT(I),I=K,L),(LTRSTT(I),I=M,N),
     1 NUMWHO,MYEAR
      GO TO 312
  309 IF(MASTER.NE.1)GO TO 311
      WRITE(ITTY,310)(LTRSTT(I),I=K,L),(LTRSTT(I),I=M,N),
     1 NUMWHO,MYEAR,(LTRBFR(I),I=1,30),LTRPSW
      WRITE(KDISK,310)(LTRSTT(I),I=K,L),(LTRSTT(I),I=M,N),
     1 NUMWHO,MYEAR,(LTRBFR(I),I=1,30),LTRPSW
  310 FORMAT(1X,8A1,1X,8A1,1I7,1I4,1X,100A1)
      GO TO 312
  311 WRITE(ITTY,310)(LTRSTT(I),I=K,L),(LTRSTT(I),I=M,N),
     1 NUMWHO,MYEAR,(LTRBFR(I),I=1,30)
  312 CONTINUE
C
C     **************************************
C     *                                    *
C     *  BRANCH TO CODE TO PROCESS RESUME  *
C     *                                    *
C     **************************************
C
      GO TO(326,326,326,313,315,313,326,326),MASTER
C
C     ******************************
C     *                            *
C     *  GENERATE PROOF OF RESUME  *
C     *                            *
C     ******************************
C
C     OPEN FILE TO CONTAIN THE PROOFS
  313 IF(KNTSHO.GT.1)GO TO 314
      CALL TTYSIM(KDISK)
      CALL RSMOPN(10,JOBUSR,LYEAR,ITTY,KDISK,IFOPEN)
C
C     ADD PROOF TO THE FILE
  314 ILOCAL=0
      NOWSEC=0
      CALL RSMPRF(NOWSEC,ILOCAL,ITTY,KDISK,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL,KNTOUT,IVARY,JVARY,
     3KVARY,LVARY,MVARY,LTRWID,LMTWID,MAXBFR,LMTBFR,LTRBFR,IVIDEO,
     4LNGCRT,KNTPAG,IONPAG)
      GO TO 326
C
C     *****************************************
C     *                                       *
C     *  TRANSMIT RESUME TO PRINTING SERVICE  *
C     *                                       *
C     *****************************************
C
C     GET NUMBER TO BE USED AS NAME OF TRANSMITTED FILE
  315 IF(IFLOOP.EQ.2)GO TO 320
      WRITE(ITTY,316)JOBUSR
  316 FORMAT(
     1' Number to be name of transmitted file (-1=',1I6,')? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 318
      IF(MAXBFR.EQ.0)GO TO 318
      LOWBFR=1
      CALL DAHEFT(0,0,0,LTRBFR,LMTBFR,
     1LOWBFR,KIND,ISHIFT,JSHIFT,KSHIFT,LSHIFT,IVALUE,
     2VALUE)
      GO TO(318,318,317),KIND
  317 IF(IVALUE.LT.0)GO TO 321
      IF(IVALUE.GT.999999)GO TO 318
      JOBUSR=IVALUE
      GO TO 321
  318 WRITE(ITTY,319)
  319 FORMAT(' Number must be in range 0 through 999999.'/
     1' If you type 1 here, then file named 1. is transmitted.'/
     2' Choose -1 if file number is to be same as student number.')
      GO TO 315
  320 JOBUSR=ISEQNC
  321 CONTINUE
C
C     TRANSMIT THE RESUME
      CALL TTYSIM(KDISK)
      CALL RSMOPN(8,JOBUSR,LYEAR,ITTY,KDISK,IFOPEN)
      ILOCAL=0
      NOWSEC=0
      IVARY=0
      JVARY=1
      KVARY=4
      LVARY=2
      MVARY=0
      CALL RSMPRF(NOWSEC,ILOCAL,ITTY,KDISK,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL,KNTOUT,IVARY,JVARY,
     3KVARY,LVARY,MVARY,LTRWID,LMTWID,MAXBFR,LMTBFR,LTRBFR,IVIDEO,
     4LNGCRT,KNTPAG,IONPAG)
      CALL RSMCLS(8,JOBUSR,LYEAR,ITTY,KDISK,IFCLOS)
      GO TO 326
C
C     ******************************
C     *                            *
C     *  DONE WITH CURRENT RESUME  *
C     *                            *
C     ******************************
C
C     ADMINISTRATOR MESSAGES
  322 WRITE(ITTY,323)
  323 FORMAT(' Resume does not exist')
      GO TO 326
  324 WRITE(ITTY,325)
  325 FORMAT(' Cancelling request')
      GO TO 326
C
C     PREPARE FOR NEXT FILE
  326 IF(IFLOOP.EQ.0)GO TO 202
      GO TO 215
C
C     WRITE FINAL SUMMARY
  327 WRITE(ITTY,328)(NSTATE(I),I=1,16),KNTSHO,KNTSHO
      IF(KNTSHO.LE.0)GO TO 334
      IF(MASTER.EQ.1)WRITE(KDISK,328)(NSTATE(I),I=1,16),
     1 KNTSHO,KNTSHO
  328 FORMAT(1X/'                   Old    New'/
     1'                Status Status'/
     2'      Replaced:',2I7/
     3'    Draft only:',2I7/
     4'     Submitted:',2I7/
     5'  Submit+proof:',2I7/
     6'        Edited:',2I7/
     7'    Edit+proof:',2I7/
     8'   Transmitted:',2I7/
     9'       Blocked:',2I7/
     1'                 -----  -----'/
     2'         Total:',2I7/1X)
      IF(MASTER.EQ.1)GO TO 332
      IF(MASTER.EQ.4)GO TO 329
      IF(MASTER.EQ.6)GO TO 329
      GO TO 334
C
C     CLOSE THE PROOF FILE
  329 IF(KNTSHO.EQ.0)GO TO 331
      WRITE(KDISK,330)
  330 FORMAT(1H1,' ')
      CALL RSMCLS(10,JOBUSR,LYEAR,ITTY,KDISK,IFCLOS)
  331 GO TO 334
C
C     CLOSE THE FILE CONTAINING LIST OF NAMES
  332 IF(KNTSHO.EQ.0)GO TO 333
      CALL RSMCLS(9,JOBUSR,LYEAR,ITTY,KDISK,IFCLOS)
  333 GO TO 334
  334 STOP
      END
