      SUBROUTINE RNOASK(MASTER,ITTY,JTTY,IDISK,JDISK,NDISK,
     1JOFFST,ITRMNL,JTRMNL,IRANGE,JRANGE,KRANGE)
C     RENBR(/FANCIEST PDP10 USER COMMAND PARSER)
C
C     DONALD E. BARTH, YALE SCHOOL OF MANAGEMENT
C
C     MASTER = 0 ON INPUT, FIRST  TIME  THAT  THE  USER  IS
C              BEING  ASKED  TO  SPECIFY  FILES.   USER  IS
C              REQUIRED TO SPECIFY INPUT FILE.   MASTER  IS
C              RETURNED UNCHANGED BY THIS PROGRAM.
C            = 1 ON INPUT,  SECOND OR SUBSEQUENT TIME  THAT
C              USER IS BEING ASKED TO SPECIFY FILES.  IF NO
C              INPUT FILE  IS  SPECIFIED,  THEN  MASTER  IS
C              RETURNED  UNCHANGED  AND  EXIT IS ASSUMED BY
C              MAIN PROGRAM.  IF INPUT FILE  IS  SPECIFIED,
C              THEN MASTER IS RETURNED SET TO -1.
C            = 2 ON INPUT,  USER IS TO  BE ASKED TO SPECIFY
C              SPLICE FILE.   MASTER IS RETURNED UNCHANGED,
C              SINCE A NULL ANSWER IS NOT ALLOWED.
C            = 3 ON INPUT,  ALL OF THE PREVIOUSLY SPECIFIED
C              SOURCE  FILE  HAS  BEEN READ.  THE USER CAN,
C              BUT NEED NOT,  SPECIFY  AN  ADDITIONAL  FILE
C              WHICH  IS  TO  CONTINUE  THE  TEXT.   IF  AN
C              ADDITIONAL FILE IS SPECIFIED, THEN MASTER IS
C              RETURNED  SET  TO  -3.   MASTER  IS RETURNED
C              UNCHANGED  IF  THE  USER DOES NOT SPECIFY AN
C              ADDITIONAL FILE.
C     ITTY   = UNIT NUMBER FOR MESSAGES TO BE SEEN BY USER
C     JTTY   = UNIT NUMBER FROM WHICH USER RESPONSE IS READ
C     IDISK  = UNIT NUMBER FROM WHICH INPUT SOURCE FILE  IS
C              TO BE READ
C     JDISK  = UNIT  NUMBER  TO  WHICH OUTPUT FILE IS TO BE
C              WRITTEN
C     NDISK  = UNIT NUMBER FROM  WHICH SPLICE FILE IS TO BE
C              READ.
C     JOFFST = RETURNED  WITH OFFSET  TO BE APPLIED  TO THE
C              RESULTING   DOCUMENT  IN  ADDITION  TO  THAT
C              SPECIFIED IN THE SOURCE FILE.
C     ITRMNL = 0, RETURNED IF OUTPUT IS TO BE TO DISK FILE.
C            = 1, RETURNED IF  OUTPUT IS  TO BE TO TERMINAL
C              AND  FROFF IS TO  PAUSE AT TOP OF  EACH PAGE
C              FOR SEPARATE SHEETS  OF PAPER TO BE INSERTED
C              INTO THE TERMINAL.
C            = -1, RETURNED IF OUTPUT IS TO BE TO TERMINAL,
C              BUT  FROFF IS  NOT TO  PAUSE AT  TOP OF EACH
C              PAGE.
C     JTRMNL = 0, RETURNED IF ULTIMATE OUTPUT DEVICE CANNOT
C              DO HALF-LINE FEEDS.
C            = 1, RETURNED IF OUTPUT DEVICE USED FOR DRAFTS
C              CANNOT DO HALF-LINE FEEDS, BUT DOCUMENT WILL
C              ULTIMATELY  BE  PRODUCED  ON  OUTPUT  DEVICE
C              WHICH CAN DO HALF-LINE FEEDS.
C            = 2,   RETURNED  IF  OUTPUT  DEVICE   CAN   DO
C              HALF-LINE  FEEDS  TO POSITION LOWER ON PAGE,
C              BUT CANNOT THEN RETURN TO HIGHER POSITION.
C            = 3,   RETURNED  IF  OUTPUT  DEVICE   CAN   DO
C              HALF-LINE FEEDS IN BOTH DIRECTIONS.
C     IRANGE = SERIAL NUMBER OF FIRST PAGE TO BE SHOWN
C     JRANGE = SERIAL NUMBER OF LAST PAGE TO BE SHOWN
C     KRANGE = -1, ALREADY BEYOND REQUESTED PAGE RANGE
C            = 0 OR 1, STILL PRODUCING REQUESTED PAGES
C
C     ITEMS WHICH MUST BE KEPT FROM LAST CALL OF RNOASK
      COMMON/RNBSEV/KIND,ITRACE,LCNRIT,LNGFIL(2)
      COMMON/RNBEIG/LTRCMD(72),LTRFIL(40,2)
C
C     ITEMS WHICH ARE NOT KEPT FROM LAST CALL OF REUSER
      DIMENSION LTRABC(26),LWRABC(26),LTRDGT(10)
      DIMENSION INILOC(3),KNTCHR(3)
      DATA MAXFIL,MAXCHR,MAXSTR,MAXBFR/2,40,3,72/
      DATA ICMD/2/
      DATA LTRPLS,LTRMNS/1H+,1H-/
      DATA LTRABC /1HA,1HB,1HC,1HD,1HE,1HF,1HG,1HH,1HI,1HJ,
     1 1HK,1HL,1HM,1HN,1HO,1HP,1HQ,1HR,1HS,1HT,1HU,1HV,1HW,
     2 1HX,1HY,1HZ/
      DATA LWRABC /1Ha,1Hb,1Hc,1Hd,1He,1Hf,1Hg,1Hh,1Hi,1Hj,
     1 1Hk,1Hl,1Hm,1Hn,1Ho,1Hp,1Hq,1Hr,1Hs,1Ht,1Hu,1Hv,1Hw,
     2 1Hx,1Hy,1Hz/
      DATA LTRDGT /1H0,1H1,1H2,1H3,1H4,1H5,1H6,1H7,1H8,1H9/
C
C     CLEAR DEFAULT VALUES
    1 IF(MASTER.GT.1)GO TO 6
      IF(MASTER.EQ.0)WRITE(ITTY,2)
    2 FORMAT(14H FROFF ( 6/82)/17H Type /H for Help)
      GO TO 4
    3 KIND=1
    4 IF(MASTER.EQ.0)KIND=0
      IRANGE=0
      JRANGE=9999
      ITRMNL=0
      LPTTTY=0
      ITRACE=0
      JOFFST=0
      JTRMNL=0
    5 CONTINUE
C
C     GET NEXT COMPONENT OF COMMAND TYPED BY USER
    6 CALL REFILE(MAXFIL,ITTY,JTTY,ICMD,MAXSTR,
     1MAXBFR,MAXCHR,ITRACE,KIND,LTRFIL,LNGFIL,LCNRIT,
     2LTRCMD,MAXFLG,INILOC,KNTCHR,LCNOW,MASTER)
      GO TO(43,43,43,32,32,7),KIND
C
C     DECIDE WHICH SWITCH WAS GIVEN
    7 IF(MAXFLG.LE.0)GO TO 6
      IF(KNTCHR(1).LE.0)GO TO 6
      LOCFLG=INILOC(1)
      LTRNOW=LTRCMD(LOCFLG)
      KNDFLG=0
      IF(MASTER.GT.1)GO TO 6
      KNTFLG=1
    8 KNDFLG=KNDFLG+1
      IF(KNDFLG.GT.26)GO TO 6
      IF(LTRABC(KNDFLG).EQ.LTRNOW)GO TO 9
      IF(LWRABC(KNDFLG).NE.LTRNOW)GO TO 8
C     GO TO( A, B, C, D, E, F, G, H, I, J,
C    1       K, L, M, N, O, P, Q, R, S, T,
C    2       U, V, W, X, Y, Z),KNDFLG
    9 IF(MASTER.EQ.2)GO TO 6
      GO TO( 6,10,16, 6,11, 6, 6,12, 6, 6,
     1       6, 6, 6, 6,13,14, 6,13, 6,15,
     2       6, 16, 6, 6, 6,17),KNDFLG
C
C     /BEGIN
   10 IRANGE=0
      GO TO 18
C
C     /END
   11 JRANGE=0
      GO TO 18
C
C     /HELP COMMAND
   12 CALL RNOHLP(ITTY)
      GO TO 3
C
C     /OFFSET OR /RIGHT COMMAND
   13 JOFFST=0
      GO TO 18
C
C     /PAUSE COMMAND
   14 ITRMNL=1
      LPTTTY=1
      GO TO 18
C
C     /TERMINAL COMMAND
   15 JTRMNL=0
      GO TO 18
C
C     /VIEW COMMAND
   16 IF(ITRMNL.EQ.0)ITRMNL=-1
      LPTTTY=1
      GO TO 18
C
C     /Z (LISTS FILES OPENED) COMMAND
   17 ITRACE=1
      GO TO 6
C
C     EVALUATE NUMBERS IN RANGE OF SWITCH
   18 IF(KNDFLG.LE.0)GO TO 6
      LMTFLG=LOCFLG+KNTCHR(1)
      LOCFLG=LOCFLG+1
   19 NUMFLG=0
      IF(LOCFLG.GE.LMTFLG)GO TO 21
      LTRNOW=LTRCMD(LOCFLG)
      IF(LTRNOW.EQ.LTRPLS)GO TO 22
      IF(LTRNOW.EQ.LTRMNS)GO TO 22
      DO 20 L=1,10
      IF(LTRNOW.EQ.LTRDGT(L))GO TO 22
   20 CONTINUE
   21 IF(KNTFLG.GE.MAXFLG)GO TO 26
      KNTFLG=KNTFLG+1
      IF(KNTCHR(KNTFLG).LE.0)GO TO 26
      LOCFLG=INILOC(KNTFLG)
      LMTFLG=LOCFLG+KNTCHR(KNTFLG)
   22 I=0
      IF(LTRCMD(LOCFLG).EQ.LTRPLS)GO TO 23
      IF(LTRCMD(LOCFLG).NE.LTRMNS)GO TO 24
      I=1
   23 LOCFLG=LOCFLG+1
   24 IF(LOCFLG.GE.LMTFLG)GO TO 26
      LTRNOW=LTRCMD(LOCFLG)
      LOCFLG=LOCFLG+1
      DO 25 L=1,10
      IF(LTRDGT(L).NE.LTRNOW)GO TO 25
      NUMFLG=(10*NUMFLG)+L-1
      GO TO 24
   25 CONTINUE
      LOCFLG=LOCFLG-1
   26 IF(I.EQ.0)GO TO 27
      NUMFLG=-NUMFLG
      IF(KNDFLG.NE.9)NUMFLG=0
C     GO TO( A, B, C, D, E, F, G, H, I, J,
C    1       K, L, M, N, O, P, Q, R, S, T,
C    2       U, V, W, X, Y, Z),KNDFLG
   27 GO TO( 6,28, 6, 6,29, 6, 6, 6, 6, 6,
     1       6, 6, 6, 6,31, 6, 6,31, 6,30,
     2       6, 6, 6, 6, 6, 6),KNDFLG
C
C     /BEGIN
   28 IRANGE=NUMFLG
      GO TO 6
C
C     /END
   29 JRANGE=NUMFLG
      GO TO 6
C
C     /TERMINAL
   30 JTRMNL=NUMFLG
      GO TO 6
C
C     /OFFSET OR /RANGE
   31 JOFFST=NUMFLG
      GO TO 6
C
C     OPEN FIRST SOURCE FILE
   32 IF(MASTER.EQ.2)GO TO 33
      IF(MASTER.EQ.3)GO TO 34
      IF(LNGFIL(LCNRIT).LE.0)GO TO 41
      CALL REOPEN(2,IDISK,LCNRIT,LNGFIL,LTRFIL,
     1MAXFIL,MAXCHR,ITRACE,ITTY,LPTTTY,NOTOPN)
      IF(NOTOPN.NE.0)GO TO 37
C
C     OPEN OUTPUT FILE
      KNDONE=LCNRIT-1
      CALL REOPEN(4,JDISK,KNDONE,LNGFIL,LTRFIL,
     1MAXFIL,MAXCHR,ITRACE,ITTY,LPTTTY,NOTOPN)
      IF(NOTOPN.NE.0)GO TO 35
      MASTER=-MASTER
      IF(LPTTTY.LE.0)GO TO 44
      IF(ITRMNL.EQ.0)ITRMNL=-1
      GO TO 44
C
C     OPEN SPLICE FILE
   33 IF(LNGFIL(LCNRIT).EQ.0)GO TO 6
      CALL REOPEN(5,NDISK,LCNRIT,LNGFIL,LTRFIL,
     1MAXFIL,MAXCHR,ITRACE,ITTY,LPTTTY,NOTOPN)
      IF(NOTOPN.NE.0)GO TO 39
      GO TO 44
C
C     OPEN SECOND OR SUBSEQUENT NORMAL SOURCE FILE
   34 IF(LNGFIL(LCNRIT).LE.0)GO TO 41
      IF(KRANGE.LT.0)GO TO 6
      CALL REOPEN(5,IDISK,LCNRIT,LNGFIL,LTRFIL,
     1MAXFIL,MAXCHR,ITRACE,ITTY,LPTTTY,NOTOPN)
      IF(NOTOPN.NE.0)GO TO 37
      MASTER=-MASTER
      GO TO 44
C
C     ERROR IN COMMAND TYPED BY USER
   35 I=LNGFIL(KNDONE)
      WRITE(ITTY,36)(LTRFIL(J,KNDONE),J=1,I)
   36 FORMAT(26H Cannot write output file ,100A1)
      GO TO 3
   37 I=LNGFIL(LCNRIT)
      WRITE(ITTY,38)(LTRFIL(J,LCNRIT),J=1,I)
   38 FORMAT(25H Cannot read source file ,100A1)
      IF(MASTER.EQ.3)GO TO 6
      GO TO 3
   39 I=LNGFIL(LCNRIT)
      WRITE(ITTY,40)(LTRFIL(J,LCNRIT),J=1,I)
   40 FORMAT(25H Cannot read splice file ,100A1)
      KIND=1
      GO TO 6
   41 WRITE(ITTY,42)
   42 FORMAT(30H Source file must be specified)
      IF(MASTER.EQ.3)GO TO 6
      GO TO 3
C
C     RETURN TO MAIN PROGRAM
   43 IF(MASTER.EQ.0)GO TO 5
      IF(MASTER.NE.2)GO TO 44
      IF(KIND.EQ.1)GO TO 5
      KIND=3
      GO TO 5
   44 CONTINUE
      RETURN
      END
      SUBROUTINE REFILE(MAXFIL,  ITTY,  JTTY,  ICMD,MAXSTR,
     1    MAXBFR,MAXCHR,ITRACE,  KIND,LTRFIL,LNGFIL,LCNRIT,
     2    LTRCMD,MAXFLG,INILOC,KNTCHR,LCNOWN,MASTER)
C     RENBR(REFIL1/PDP10 STORE OUTPUT AND INPUT FILE NAMES)
C     RENBR/M:99999
C
C     DONALD E. BARTH, YALE SCHOOL OF MANAGEMENT
C
C     MAXFIL = 1 MORE THAN NUMBER  OF  FILE  SPECIFICATIONS
C              WHICH  CAN  APPEAR  TO  LEFT  OF EQUAL SIGN.
C              THIS IS MAXIMUM VALUE OF SUBSCRIPT OF LNGFIL
C              ARRAY  AND MAXIMUM VALUE OF SECOND SUBSCRIPT
C              OF LTRFIL ARRAY.
C     ITTY   = NUMBER OF UNIT TO WHICH TERMINAL  OUTPUT  IS
C              TO BE WRITTEN.
C     JTTY   = NUMBER OF UNIT FROM WHICH TERMINAL INPUT  IS
C              TO BE READ.
C     ICMD   = NUMBER  OF  UNIT  FROM  WHICH  COMMAND  FILE
C              INDICATED BY AT SIGN IS TO BE READ.
C     MAXSTR = DIMENSION OF INILOC  AND  KNTCHR  ARRAYS  IN
C              WHICH DESCRIPTIONS OF COMPONENTS OF SWITCHES
C              ARE RETURNED AND WHICH ARE  USED  INTERNALLY
C              WITHIN   THIS   ROUTINE   FOR   STORAGE   OF
C              DESCRIPTIONS  OF  COMPONENTS  OF  EACH  FILE
C              SPECIFICATION.   MAXSTR SHOULD HAVE VALUE OF
C              AT LEAST 3.
C     MAXBFR = DIMENSION OF LTRCMD ARRAY  INTO  WHICH  EACH
C              LINE  OF COMMANDS TYPED BY USER OR READ FROM
C              COMMAND FILE ARE STORED IN  MULTIPLE  OF  A1
C              FORMAT.    MAXBFR   IS   MAXIMUM  NUMBER  OF
C              CHARACTERS  WHICH  CAN  APPEAR   IN   SINGLE
C              COMMAND LINE.  MAXBFR MUST NOT EXCEED 132.
C     MAXCHR = MAXIMUM NUMBER OF CHARACTERS  WHICH  CAN  BE
C              STORED   IN   ANY  ONE  FILE  SPECIFICATION.
C              MAXCHR IS FIRST DIMENSION OF LTRFIL ARRAY.
C     ITRACE = 0, INPUT IF DESCRIPTIONS OF FILES ARE NOT TO
C              BE  WRITTEN  TO USER TERMINAL WHENEVER FILES
C              ARE OPENED.
C            = 1,  INPUT  IF   USER   SELECTS   /Z   SWITCH
C              INDICATING THAT DESCRIPTIONS OF FILES ARE TO
C              BE WRITTEN TO USER TERMINAL  WHENEVER  FILES
C              ARE OPENED.
C
C     FOLLOWING ARGUMENT MUST BE SET BEFORE THIS ROUTINE IS
C     FIRST CALLED, BUT THEN VALUE RETURNED BY THIS ROUTINE
C     SHOULD BE SENT TO  FOLLOWING  CALL  OF  THIS  ROUTINE
C     UNCHANGED.
C
C     KIND   = SHOULD  BE  INPUT  SET  TO  ZERO  WHEN  THIS
C              ROUTINE   IS   FIRST   CALLED,  OR  WHENEVER
C              INTERPRETATION OF PREVIOUS SET  OF  COMMANDS
C              IS   TO  BE  ABANDONED.   KIND  IS  RETURNED
C              DESCRIBING  REASON  WHY  CONTROL  HAS   BEEN
C              TRANSFERRED  BACK  TO  CALLING  PROGRAM, AND
C              SHOULD NOT BE CHANGED BY CALLING PROGRAM  IF
C              THIS  ROUTINE  IS  TO  BE  CALLED  AGAIN  TO
C              CONTINUE INTERPRETATION OF SAME SEQUENCE  OF
C              COMMANDS.
C            = 1, RETURNED IF NO MORE  FILE  SPECIFICATIONS
C              REMAIN TO  BE EVALUATED.
C            = 2, RETURNED IF KIND WAS INPUT CONTAINING THE
C              VALUE 1 OR 2 AND THE NEXT  LINE TYPED BY THE
C              USER IS EMPTY.
C            = 3, RETURNED IF SEMICOLON WAS FOUND.  IF THIS
C              ROUTINE  IS CALLED AGAIN WITHOUT KIND HAVING
C              FIRST BEEN ZEROED, THEN  EVALUATION  OF  NEW
C              SET  OF FILE SPECIFICATIONS WILL BE BEGUN IN
C              TEXT  APPEARING  TO  RIGHT   OF   SEMICOLON.
C              APPEARANCE    OF    SEMICOLON    WHEN   FILE
C              SPECIFICATION IS KNOWN BY THIS ROUTINE TO BE
C              INCOMPLETE  WILL  NOT BE REPORTED SINCE TEXT
C              TO RIGHT OF SEMICOLON IS TREATED  AS  IF  IT
C              CONTINUED  FILE SPECIFICATIONS ON SUBSEQUENT
C              LINE OF INPUT.
C            = 4, RETURNED IF THIS ROUTINE IS REPORTING ALL
C              OF  FILE SPECIFICATIONS APPEARING TO LEFT OF
C              EQUAL  SIGN   TOGETHER   WITH   FIRST   FILE
C              SPECIFICATION  TO RIGHT OF EQUAL SIGN, OR IF
C              THIS  ROUTINE  IS   REPORTING   FIRST   FILE
C              SPECIFICATION     IN    SERIES    OF    FILE
C              SPECIFICATIONS WHICH DOES NOT INCLUDE  EQUAL
C              SIGN.
C            = 5, RETURNED IF  THIS  ROUTINE  IS  REPORTING
C              SECOND  OR  SUBSEQUENT FILE SPECIFICATION TO
C              RIGHT OF EQUAL SIGN, OR IF THIS  ROUTINE  IS
C              REPORTING    SECOND   OR   SUBSEQUENT   FILE
C              SPECIFICATION    IN    SERIES    OF     FILE
C              SPECIFICATIONS  WHICH DOES NOT INCLUDE EQUAL
C              SIGN.
C            = 6, RETURNED IF  THIS  ROUTINE  IS  RETURNING
C              DESCRIPTION  OF  SWITCH IN INITAL AND LENGTH
C              ARRAY LOCATIONS HAVING SUBSCRIPTS 1  THROUGH
C              MAXFLG.  LCNOWN IS RETURNED CONTAINING VALUE
C              OF SUBSCRIPT OF LOCATIONS IN NEWNUL, NEWDSK,
C              NEWNAM AND NEWPTH ARRAYS WHICH WILL DESCRIBE
C              FILE  SPECIFICATION  WHEN   KIND   IS   NEXT
C              RETURNED SET TO EITHER 4 OR 5.
C
C     FOLLOWING  ARGUMENTS  ARE  USED  BOTH  FOR  RETURNING
C     INFORMATION  TO CALLING PROGRAM AND FOR COMMUNICATING
C     WITH SUBSEQUENT  CALLS  OF  THIS  ROUTINE.   ORIGINAL
C     CONTENTS OF THESE ARGUMENTS ARE IGNORED.
C
C     LTRFIL = IF KIND IS RETURNED SET TO EITHER  4  OR  5,
C              THEN LOCATIONS IN LTRFIL ARRAY HAVING SECOND
C              SUBSCRIPTS 1  THROUGH  LCNRIT  ARE  RETURNED
C              CONTAINING  THE  CHARACTERS FORMING THE FILE
C              SPECIFICATIONS AS TYPED BY THE USER.
C     LGNFIL = IF KIND IS RETURNED SET TO EITHER  4  OR  5,
C              THEN THE LNGFIL ARRAY CONTAINS THE NUMBER OF
C              CHARACTERS   IN    EACH    OF    THE    FILE
C              SPECIFICATIONS RETURNED IN THE LTRFIL ARRAY.
C     LCNRIT = IF KIND IS RETURNED SET TO EITHER  4  OR  5,
C              THEN  LCNRIT IS RETURNED CONTAINING VALUE OF
C              SUBSCRIPT OF LOCATIONS IN LNGFIL  ARRAY  AND
C              SECOND  SUBSCRIPT  OF  LOCATIONS  IN  LTRFIL
C              ARRAY  WHICH  DESCRIBE  FILE   SPECIFICATION
C              WHICH  APPEARS  TO  RIGHT OF EQUAL SIGN.  IF
C              KIND IS RETURNED SET TO 4 AND IF  LCNRIT  IS
C              GREATER  THAN  ONE,  THEN LOWER LOCATIONS IN
C              THESE ARRAYS  DESCRIBE  FILE  SPECIFICATIONS
C              APPEARING TO LEFT OF EQUAL SIGN.  IF KIND IS
C              RETURNED SET TO  5,  THEN  LOCATIONS  WITHIN
C              THESE  ARRAYS HAVING LOWER SUBSCRIPTS SHOULD
C              BE IGNORED.
C     LTRCMD = ARRAY  INTO  WHICH  THIS  ROUTINE  CAN  READ
C              CHARACTERS   TYPED  BY  USER  OR  READ  FROM
C              COMMAND FILE.
C     MAXFLG = IF KIND IS RETURNED SET TO 6, THEN MAXFLG IS
C              RETURNED  CONTAINING  SUPSCRIPT OF LOCATIONS
C              IN INILOC AND KNTCHR ARRAYS  WHICH  DESCRIBE
C              RIGHTMOST COMPONENT OF SWITCH.
C     INILOC = IF KIND IS RETURNED SET TO 6, THEN LOCATIONS
C              IN  INILOC ARRAY HAVING SUBSCRIPTS 1 THROUGH
C              VALUE  OF  MAXFLG  ARE  RETURNED  CONTAINING
C              VALUES  OF  SUBSCRIPTS  OF  LOCATIONS WITHIN
C              LTRCMD ARRAY AT WHICH EACH OF COMPONENTS  OF
C              SWITCH START.
C     KNTCHR = IF KIND IS RETURNED SET TO 6, THEN LOCATIONS
C              IN  INILOC ARRAY HAVING SUBSCRIPTS 1 THROUGH
C              VALUE  OF  MAXFLG  ARE  RETURNED  CONTAINING
C              NUMBER   OF   CHARACTERS   WITHIN   EACH  OF
C              COMPONENTS OF SWITCH.  MISSING COMPONENT  OF
C              SWITCH  IS INDICATED BY ZERO VALUE IN KNTCHR
C              ARRAY.
C     LCNOWN = IF KIND IS RETURNED SET TO 6, THEN LCNOWN IS
C              RETURNED  CONTAINING  VALUE  OF SUBSCRIPT OF
C              LOCATIONS IN LNGFIL AND LTRFIL ARRAYS  WHICH
C              WILL  DESCRIBE  FILE SPECIFICATION WHEN KIND
C              IS NEXT RETURNED SET TO EITHER 4 OR 5.
C
      COMMON/RNBNIN/KNTFIL,MANY,IEOF,IAFTER,LOWBFR
      DIMENSION LTRFIL(MAXCHR,MAXFIL),LNGFIL(MAXFIL)
      DIMENSION INILOC(MAXSTR),KNTCHR(MAXSTR),
     1LTRCMD(MAXBFR),
     2KOLECT(10),NUMTWO(2)
C
C     DECIDE WHETHER ARE STARTING OR CONTINUING EVALUATION
      INIKND=KIND
      IF(KIND.EQ.6)GO TO 9
      IF(KIND.GE.4)GO TO 30
      LCNRIT=0
      KNTFIL=0
      IAFTER=0
      MANY=0
      IF(KIND.EQ.3)GO TO 9
C
C     READ CONTENTS OF NEXT LINE
      IF(MASTER.NE.2)WRITE(ITTY,1)
    1 FORMAT(14H Source file? ,$)
      IF(MASTER.EQ.2)WRITE(ITTY,34)
   34 FORMAT(14H Splice file? ,$)
      GO TO 4
    2 WRITE(ITTY,3)
    3 FORMAT(2H &,$)
    4 READ(JTTY,5,END=10)LTRCMD
    5 FORMAT(132A1)
      IEOF=0
      GO TO 7
    6 READ(ICMD,5,END=100)LTRCMD
      IEOF=1
    7 LOWBFR=1
      GO TO 9
    8 LCNRIT=1
      KNTFIL=0
C
C     LOCATE NEXT FILE SPECIFICATION
    9 CALL REFLAG(1,MAXSTR,MAXBFR,LTRCMD,
     1LOWBFR,MANY,KIND,INILOC,KNTCHR,MAXNAM,
     2MAXFLG,KONTNT,MINPRT)
      GO TO(11,11,14,16,18,19),KIND
C
C     END OF LINE, END OF FILE OR SEMICOLON FOUND
  100 CLOSE(UNIT=ICMD)
   10 KIND=1
      IEOF=0
   11 IF(IAFTER.LT.0)GO TO 15
      IF(IAFTER.EQ.1)GO TO 15
      IF(KNTFIL.GT.0)GO TO 13
      IF(LCNRIT.EQ.0)GO TO 17
      IF(KIND.EQ.2)GO TO 12
      IF(IEOF.EQ.0)GO TO 33
      GO TO 6
   12 KIND=3
      GO TO 33
   13 IF(KIND.EQ.2)LOWBFR=LOWBFR-1
      GO TO 29
C
C     EQUAL SIGN FOUND
   14 IF(IAFTER.GT.0)GO TO 27
      MANY=-1
      IAFTER=0
      LCNRIT=-1
      GO TO 9
C
C     AMPERSAND FOUND OR MORE FILES NEEDED
   15 KNTFIL=KNTFIL-1
      MANY=-1
      IAFTER=0
   16 INIKND=0
   17 IF(KIND.EQ.2)GO TO 9
      IF(IEOF.NE.0)GO TO 6
      IF(INIKND.LE.0)GO TO 2
      IF(INIKND.GT.2)GO TO 2
      KIND=2
      GO TO 33
C
C     EXTRA COMMA FOUND
   18 IF(IAFTER.GT.0)GO TO 27
      KNTFIL=KNTFIL+1
      LNGFIL(KNTFIL)=0
      IAFTER=1
      GO TO 22
C
C     STORE FILE SPECIFICATION
   19 IF(KONTNT.EQ.0)GO TO 23
      IF(IAFTER.GT.0)GO TO 28
      NXTFIL=KNTFIL+1
      LNGFIL(NXTFIL)=0
      IF(MAXNAM.LE.0)GO TO 21
      J=KNTCHR(1)
      IF(J.GT.MAXCHR)J=MAXCHR
      IF(J.LE.0)GO TO 21
      LNGFIL(NXTFIL)=J
      K=INILOC(1)
      DO 20 I=1,J
      LTRFIL(I,NXTFIL)=LTRCMD(K)
   20 K=K+1
   21 IF(KONTNT.GE.2)GO TO 24
      KNTFIL=NXTFIL
      IAFTER=2
   22 IF(LCNRIT.NE.0)GO TO 9
      IF(KNTFIL.LT.MAXFIL)IAFTER=IAFTER-2
      GO TO 9
C
C     ALLOW CALLING PROGRAM TO EVALUATE SWITCH
   23 LCNOWN=KNTFIL
      KIND=6
      IF(MANY.GT.0)GO TO 33
      IF(IAFTER.GT.0)GO TO 28
      MANY=-1
      LCNOWN=LCNOWN+1
      GO TO 33
C
C     OPEN COMMAND FILE SPECIFIED BY USER
   24 CALL REOPEN(1,ICMD,NXTFIL,LNGFIL,LTRFIL,
     1MAXFIL,MAXCHR,ITRACE,ITTY,I,IERR)
      IF(IERR.EQ.0)GO TO 6
      J=LNGFIL(NXTFIL)
      IF(J.LE.0)GO TO 26
      WRITE(ITTY,25)(LTRFIL(I,NXTFIL),I=1,J)
   25 FORMAT(26H Cannot read command file ,100A1)
      GO TO 2
   26 WRITE(ITTY,25)
      GO TO 2
C
C     PREPARE TO RETURN RESULTS TO CALLING PROGRAM
   27 MANY=-1
      GO TO 29
   28 LOWBFR=MINPRT
   29 IAFTER=0
      IF(LCNRIT.GT.0)GO TO 31
      KIND=4
      IF(LCNRIT.LT.0)GO TO 32
      LCNRIT=1
      GO TO 33
   30 LCNRIT=LCNRIT+1
   31 IF(LCNRIT.GT.KNTFIL)GO TO 8
      KIND=5
      GO TO 33
   32 LCNRIT=KNTFIL
C
C     RETURN TO CALLING PROGRAM
   33 RETURN
C696002136255$&
      END
      SUBROUTINE REFLAG(LOWSTR,MAXSTR,MAXBFR,LTRCMD,LOWBFR,
     1    MANY  ,KIND  ,INILOC,KNTCHR,MAXNAM,MAXFLG,KONTNT,
     2    MINPRT)
C     RENBR(REFLG1/PDP10 FIND SWITCHES AND FILE NAMES)
C     RENBR/M:99999
C
C     DONALD E. BARTH, YALE SCHOOL OF MANAGEMENT
C
C     ROUTINE TO LOCATE FILE SPECIFICATIONS AND SWITCHES IN
C     TEXT  TYPED  BY  USER.  THE FILE SPECIFICATION OR THE
C     COMPONENTS OF THE  SWITCH  FIELD  ARE  IDENTIFIED  BY
C     LOCATION AND LENGTH IN THE BUFFER.
C
C     THE FOLLOWING ARGUMENTS ARE USED ONLY FOR INPUT.
C
C     LOWSTR = SUBSCRIPT OF FIRST  LOCATION  WITHIN  INILOC
C              AND   KNTCHR  WHICH  CAN  BE  USED  TO  HOLD
C              POSITION AND LENGTH OF FILE SPECIFICATION OR
C              OF COMPONENTS OF SWITCH.
C     MAXSTR = SUBSCRIPT OF FINAL  LOCATION  WITHIN  INILOC
C              AND   KNTCHR  WHICH  CAN  BE  USED  TO  HOLD
C              POSITION AND LENGTH OF FILE SPECIFICATION OR
C              OF COMPONENTS OF SWITCH.
C     MAXBFR = SUBSCRIPT OF LOCATION  WITHIN  LTRCMD  ARRAY
C              WHICH  CONTAINS RIGHTMOST CHARACTER TYPED BY
C              USER.
C
C     FOLLOWING ARGUMENTS ARE USED FOR BOTH INPUT  TO,  AND
C     OUTPUT FROM THIS ROUTINE.
C
C     LTRCMD = ARRAY CONTAINING IN LOCATIONS LTRCMD(LOWBFR)
C              THROUGH  LTRCMD(MAXBFR)  CHARACTERS  READ BY
C              CALLING PROGRAM WITH MULTIPLE OF  A1  FORMAT
C              AND   WHICH  CAN  FORM  FILE  SPECIFICATION.
C              CONTENTS  OF  LTRCMD  ARRAY   ARE   RETURNED
C              UNCHANGED,  WITH  EXCEPTION  THAT PORTION OF
C              TEXT STRING TO RIGHT OF ADJACENT APOSTROPHES
C              IS MOVED 1 CHARACTER TO LEFT.
C     LOWBFR = SUBSCRIPT  OF  FIRST   (LEFTMOST)   LOCATION
C              WITHIN LTRCMD ARRAY WHICH CONTAINS CHARACTER
C              WHICH CAN BE  PART  OF  FILE  SPECIFICATION.
C              LOWBFR   IS   RETURNED   POINTING  TO  FIRST
C              CHARACTER  WHICH  SHOULD  BE  EVALUATED   BY
C              SUBSEQUENT  CALL TO THIS ROUTINE, OR ELSE IS
C              RETURNED POINTING BEYOND END  OF  BUFFER  IF
C              BUFFER IS EMPTY OR IF BUFFER CONTAINS MERELY
C              COMMENT.
C     MANY   = SHOULD BE INPUT CONTAINING  ZERO  EACH  TIME
C              THIS  ROUTINE  IS CALLED TO BEGIN PROCESSING
C              OF A NEW LOGICAL SECTION  OF  TEXT,  AS  FOR
C              EXAMPLE  WHEN BEGINNING PROCESSING OF A LINE
C              OF TEXT NOT TIED TO THE PREVIOUS LINE BY  AN
C              AMPERSAND  AT  THE END OF THE PREVIOUS LINE,
C              OR WHEN PROCESSING THE TEXT TO THE RIGHT  OF
C              A  SEMICOLON  OR  TO  THE RIGHT OF AN EQUALS
C              SIGN.
C            = RETURNED CONTAINING  THE  VALUE  WHICH  MANY
C              SHOULD  HAVE  WHEN THIS ROUTINE OR ANY OTHER
C              IN  THE  FASP  PACKAGE  HAVING  MANY  AS  AN
C              ARGUMENT IS NEXT CALLED.  THE RETURNED VALUE
C              OF MANY SHOULD NOT BE CHANGED BY THE CALLING
C              PROGRAM  UNLESS  THE  INTERPRETATION  OF THE
C              CONTENTS OF THE BUFFER  IS  BEING  ABANDONED
C              PREMATURELY,  IN  WHICH  CASE MANY SHOULD BE
C              RESET TO HAVE A ZERO VALUE.
C            = -1, RETURNED IF A  MISSING  ITEM  IS  TO  BE
C              INDICATED  IF  THE NEXT ROUTINE ENCOUNTERS A
C              LEADING  COMMA  OR  FINDS  THAT  THE  BUFFER
C              CONTAINS   NOTHING  OTHER  THAN  A  POSSIBLE
C              COMMENT.  MANY IS RETURNED CONTAINING -1  IF
C              A  COMMA  PRECEDES  EITHER AN AMPERSAND OR A
C              SWITCH FIELD.
C            = 0, RETURNED IF  A  MISSING  ITEM  IS  TO  BE
C              INDICATED  IF  THE NEXT ROUTINE ENCOUNTERS A
C              LEADING COMMA, BUT A  MISSING  ITEM  IS  NOT
C              INDICATED  IF  THE  BUFFER  CONTAINS NOTHING
C              OTHER THAN  A  POSSIBLE  COMMENT.   MANY  IS
C              RETURNED  CONTAINING ZERO IF BUFFER IS FOUND
C              TO BE EMPTY, OR IF FIRST PRINTING  CHARACTER
C              AT OR TO RIGHT OF LTRCMD(LOWBFR) IS FOUND TO
C              BE EXCLAMATION POINT,  SEMICOLON  OR  EQUALS
C              SIGN.   THESE ARE ALL CONDITIONS UNDER WHICH
C              NEXT CALL TO  THIS  ROUTINE  WOULD  EVALUATE
C              START  OF  NEW GROUP OF FILE SPECIFICATIONS.
C              MANY IS RETURNED UNCHANGED IF A SWITCH FIELD
C              IS FOUND AT THE START OF THE CONTENTS OF THE
C              BUFFER.
C            = 1, RETURNED IF A MISSING ITEM IS NOT  TO  BE
C              INDICATED  IF  THE NEXT ROUTINE ENCOUNTERS A
C              LEADING  COMMA  OR  FINDS  THAT  THE  BUFFER
C              CONTAINS   NOTHING  OTHER  THAN  A  POSSIBLE
C              COMMENT.  MANY IS RETURNED CONTAINING ONE IF
C              A FILE SPECIFICATION CONSISTING OF MORE THAN
C              JUST A  SWITCH  FIELD  IS  FOUND,  OR  IF  A
C              MISSING ITEM IS BEING INDICATED.
C
C     FOLLOWING ARGUMENTS ARE USED ONLY FOR OUTPUT.   THEIR
C     INPUT VALUES ARE IGNORED.
C
C     KIND   = RETURNED    DESCRIBING    TYPE    OF    ITEM
C              ENCOUNTERED.
C            = 1,   NOTHING,   EXCEPT   POSSIBLY    COMMENT
C              INDICATED  BY LEADING EXCLAMATION POINT, WAS
C              FOUND AT  OR  TO  RIGHT  OF  LTRCMD(LOWBFR).
C              LOWBFR  IS  RETURNED  POINTING BEYOND END OF
C              BUFFER.
C            = 2, FIRST PRINTING CHARACTER AT OR  TO  RIGHT
C              OF  LTRCMD(LOWBFR)  IS SEMICOLON.  LOWBFR IS
C              RETURNED POINTING TO CHARACTER TO  RIGHT  OF
C              SEMICOLON.   IT  IS  SUGGESTED  THAT CALLING
C              PROGRAM TREAT THIS  AS  INDICATION  BY  USER
C              THAT  PRECEDING  COMMAND  HAS BEEN COMPLETED
C              AND THAT SUBSEQUENT COMMAND WILL  FOLLOW  ON
C              SAME LINE.
C            = 3, FIRST PRINTING CHARACTER AT OR  TO  RIGHT
C              OF LTRCMD(LOWBFR) IS EQUALS SIGN.  LOWBFR IS
C              RETURNED POINTING TO CHARACTER TO  RIGHT  OF
C              EQUALS SIGN.
C            = 4, FIRST PRINTING CHARACTER AT OR  TO  RIGHT
C              OF  LTRCMD(LOWBFR) IS AMPERSAND.  CHARACTERS
C              TO  RIGHT  OF  AMPERSAND  ARE  TAKEN  TO  BE
C              COMMENT.  LOWBFR IS RETURNED POINTING BEYOND
C              END OF BUFFER.  IT IS SUGGESTED THAT CALLING
C              PROGRAM  TREAT  THIS AS REQUEST BY USER THAT
C              COMMAND  BE  CONTINUED  ON  FOLLOWING  LINE.
C              EFFECT  IS  NOT  QUITE  SAME  AS IF USER HAD
C              TYPED ALL OF FILE SPECIFICATIONS  ON  SINGLE
C              LINE  SINCE  FILE  SPECIFICATION  CANNOT  BE
C              SPLIT ACROSS LINE BOUNDARY.
C            = 5, MISSING FILE SPECIFICATION WAS  INDICATED
C              BY AN EXTRA COMMA.
C            = 6, FILE SPECIFICATION IS BEING  RETURNED  IF
C              MAXNAM  IS  RETURNED  EQUAL  TO  LOWSTR,  OR
C              SWITCH IS RETURNED IF MAXFLG IS RETURNED SET
C              GREATER THAN OR EQUAL TO LOWSTR.
C     INILOC = IF KIND IS RETURNED CONTAINING 6 AND  MAXNAM
C              IS   RETURNED  SET  EQUAL  TO  LOWSTR,  THEN
C              INILOC(LOWSTR) IS  RETURNED  CONTAINING  THE
C              SUBSCRIPT OF THE LTRCMD ARRAY LOCATION WHICH
C              CONTAINS THE FIRST PRINTING CHARACTER OF THE
C              FILE  SPECIFICATION  AND  KNTCHR(LOWSTR)  IS
C              RETURNED CONTAINING THE NUMBER OF CHARACTERS
C              (INCLUDING  EMBEDDED  SPACES)  IN  THE  FILE
C              SPECIFICATION.
C            = IF KIND IS RETURNED CONTAINING 6 AND  MAXFLG
C              IS  RETURNED  SET TO LOWSTR OR GREATER, THEN
C              LOCATIONS       INILOC(LOWSTR)       THROUGH
C              INILOC(MAXFLG)  CONTAIN  LOCATIONS IN BUFFER
C              OF INITIAL CHARACTERS  OF  WORDS  IN  SWITCH
C              FIELD,  AND LOCATIONS KNTCHR(LOWSTR) THROUGH
C              KNTCHR(MAXFLG)   CONTAINING    NUMBERS    OF
C              CHARACTERS  IN  WORDS IN SWITCH FIELD.  IF A
C              TEXT  STRING  DELIMITED  BY  APOSTROPHES  IS
C              FOUND,  THEN  MAXFLG WILL BE RETURNED SET TO
C              LOWSTR, AND THE INITIAL APOSTROPHE  WILL  BE
C              POINTED TO BY INILOC(LOWSTR).
C     KNTCHR = ARRAY   RETURNED   CONTAINING   NUMBERS   OF
C              CHARACTERS  IN EACH OF WORDS FOR WHICH FIRST
C              CHARACTERS ARE IN BUFFER LOCATIONS INDICATED
C              BY  VALUES  IN  INILOC ARRAY.  SUBSCRIPTS OF
C              INILOC  ARRAY  AND  KNTCHR  ARRAY  LOCATIONS
C              DESCRIBING PARTICULAR WORD ARE IDENTICAL.
C     MAXNAM = RETURNED  SET  TO   LOWSTR-1   IF   A   FILE
C              SPECIFICATION WAS NOT FOUND.
C            = RETURNED   SET   TO   LOWSTR   IF   A   FILE
C              SPECIFICATION WAS FOUND.
C     MAXFLG = RETURNED SET TO LOWSTR-1 IF A  SWITCH  FIELD
C              OR  TEXT STRING DELIMITED BY APOSTROPHES WAS
C              NOT FOUND.
C            = IF A SWITCH FIELD OR TEXT  STRING  DELIMITED
C              BY  APOSTROPHES  WAS  FOUND,  THEN MAXFLG IS
C              RETURNED CONTAINING SUBSCRIPT OF INILOC  AND
C              KNTCHR  ARRAY LOCATIONS DESCRIBING RIGHTMOST
C              WORD OF SWITCH FIELD.
C     KONTNT = 0, NEITHER FILE SPECIFICATION  NOR  AT  SIGN
C              FOUND.
C            = 1, FILE SPECIFICATION BUT NOT AT SIGN FOUND.
C            = 2, AT SIGN BUT NOT FILE SPECIFICATION FOUND.
C            = 3,  BOTH  FILE  SPECIFICATION  AND  AT  SIGN
C              FOUND.
C     MINPRT = SUBSCRIPT OF  LTRCMD  ARRAY  LOCATION  WHICH
C              CONTAINS    FIRST    CHARACTER    OF    FILE
C              SPECIFICATION OR SWITCH IF KIND IS  RETURNED
C              CONTAINING VALUE OF 6.
C
      DIMENSION KNTCHR(MAXSTR),INILOC(MAXSTR),
     1LTRCMD(MAXBFR)
C
C     CCCC       AAA UU   UU TTTTTTTT IIII  OOOO   NN    NN
C   CC          AAAA UU   UU    TT     II  OO  OO  NNN   NN
C  CC          AA AA UU   UU    TT     II OO    OO NNNN  NN
C  CC         AA  AA UU   UU    TT     II OO    OO NN NN NN
C  CC        AAAAAAA UU   UU    TT     II OO    OO NN  NNNN
C   CC      AA    AA  UU UU     TT     II  OO  OO  NN   NNN
C     CCCC AA     AA   UUU      TT    IIII  OOOO   NN    NN
C
C     LEFT AND RIGHT SQUARE  BRACKETS MUST BE DEFINED USING
C     OCTAL NOTATION FOR PDP10 F40 COMPILER.  LET FOLLOWING
C     COMMENT BE THE COMPILED DATA STATEMENT IF F40 IS USED
C      DATA LTROPN,LTRCLS/"555004020100,"565004020100/
      DATA LTROPN,LTRCLS/1H[,1H]/
C
      DATA LTRCLN,LTRCMA,LTRSLA,LTRQOT,LTRSEM,
     1LTRAND,LTREXC,LTREQL,LTRATS,LTRSPC,LTRTAB/1H:,
     21H,,1H/,1H',1H;,1H&,1H!,1H=,1H@,1H ,"045004020100/
C
C     MAJOR  = -2 OR LESS, NAME IN RANGE OF LEFT BRACKET
C            = -1, NAME BUT NOT IN RANGE OF LEFT BRACKET
C            = 0, NEITHER NAME OR SWITCH FOUND YET
C            = 1, AFTER SLASH OR COLON AFTER SLASH
C
      MAXNAM=0
      MAXFLG=0
      KONTNT=0
      KIND=1
      MAJOR=0
      IF(MANY.GE.0)GO TO 3
      KIND=5
      MANY=1
      GO TO 3
    1 KOUNT=0
      INIBFR=LOWBFR
    2 LOWBFR=LOWBFR+1
    3 IF(LOWBFR.GT.MAXBFR)GO TO 24
      LTRNOW=LTRCMD(LOWBFR)
      IF(LTRNOW.EQ.LTRSPC)GO TO 2
      IF(LTRNOW.EQ.LTRTAB)GO TO 2
      IF(MAJOR.EQ.0)MINPRT=LOWBFR
C
C     CHECK FOR GENERAL PUNCTUATION CHARACTERS
      IF(LTRNOW.EQ.LTRSEM)GO TO 19
      IF(LTRNOW.EQ.LTRAND)GO TO 22
      IF(LTRNOW.EQ.LTREXC)GO TO 23
      IF(LTRNOW.EQ.LTREQL)GO TO 20
      IF(LTRNOW.EQ.LTRSLA)GO TO 16
      IF(LTRNOW.EQ.LTRATS)GO TO 14
      IF(LTRNOW.EQ.LTRQOT)GO TO 9
      IF(MAJOR.LT.-1)GO TO 8
      IF(LTRNOW.EQ.LTRCMA)GO TO 18
      IF(MAJOR.EQ.0)GO TO 4
      IF(KOUNT.GT.0)GO TO 5
    4 INIBFR=LOWBFR
      IF(MAJOR.LE.0)GO TO 7
    5 IF(MAJOR.LE.0)GO TO 8
C
C     EXTEND SWITCH FIELD
    6 IF(LTRNOW.EQ.LTRCLN)GO TO 26
      IF((INIBFR+KOUNT).LT.LOWBFR)GO TO 24
      KOUNT=KOUNT+1
      GO TO 2
C
C     FIRST CHARACTER IN NAME
    7 INDRCT=MANY
      IF(KIND.EQ.5)INDRCT=-1
      MANY=1
      KIND=6
      MAJOR=-1
C
C     EXTEND NAME
    8 KOUNT=LOWBFR-INIBFR+1
      IF(LTRNOW.EQ.LTROPN)MAJOR=MAJOR-1
      IF(LTRNOW.EQ.LTRCLS)MAJOR=MAJOR+1
      IF(MAJOR.GE.0)MAJOR=-1
      GO TO 2
C
C     APOSTROPHE STARTS TEXT STRING
    9 IF(MAJOR.NE.0)GO TO 24
      IF(KIND.EQ.5)MANY=-1
      KIND=6
      INIBFR=LOWBFR
      I=LOWBFR
      MIDPRT=LOWBFR
   10 IF(I.GE.MAXBFR)GO TO 12
      I=I+1
      LOWBFR=LOWBFR+1
      LTRCMD(LOWBFR)=LTRCMD(I)
      IF(LTRCMD(I).EQ.LTRSPC)GO TO 10
      IF(LTRCMD(I).EQ.LTRTAB)GO TO 10
      MIDPRT=LOWBFR
      IF(LTRCMD(I).NE.LTRQOT)GO TO 10
      IF(I.GE.MAXBFR)GO TO 11
      IF(LTRCMD(I+1).NE.LTRQOT)GO TO 11
      I=I+1
      GO TO 10
   11 MIDPRT=MIDPRT-1
   12 KOUNT=MIDPRT-INIBFR+1
   13 LOWBFR=LOWBFR+1
      IF(LOWBFR.GT.I)GO TO 26
      LTRCMD(LOWBFR)=LTRSPC
      GO TO 13
C
C     AT SIGN
   14 IF(MAJOR.GT.0)GO TO 24
      IF(KONTNT.GE.2)GO TO 24
      KONTNT=KONTNT+2
      IF(MAJOR.EQ.0)GO TO 15
      MANY=INDRCT
      GO TO 24
   15 MAJOR=-1
      GO TO 17
C
C     INITIAL SLASH FOUND
   16 IF(MAJOR.NE.0)GO TO 24
      MAJOR=1
   17 IF(KIND.EQ.5)MANY=-1
      KIND=6
      GO TO 1
C
C     COMMA FOUND OTHER THAN IN NUMBER SECTION
   18 IF(KIND.NE.1)GO TO 24
      KIND=5
      IF(MANY.GT.0)GO TO 2
      GO TO 29
C
C     SEMICOLON FOUND
   19 IF(KIND.NE.1)GO TO 24
      KIND=2
      GO TO 21
C
C     EQUALS SIGN FOUND
   20 IF(KIND.NE.1)GO TO 24
      KIND=3
   21 LOWBFR=LOWBFR+1
      GO TO 29
C
C     AMPERSAND FOUND
   22 IF(MAJOR.NE.0)GO TO 24
      IF(KIND.EQ.5)MANY=-1
      KIND=4
C
C     EXCLAMATION POINT FOUND
   23 LOWBFR=MAXBFR+1
C
C     TERMINATE GROUP OF NAMES OR NUMBERS
   24 IF(MAJOR.EQ.0)GO TO 29
      IF(MAJOR.GT.0)GO TO 25
      IF(KONTNT.EQ.0)KONTNT=1
      IF(KONTNT.EQ.2)KONTNT=3
      MAXNAM=1
      KNTCHR(1)=KOUNT
      INILOC(1)=INIBFR
      GO TO 29
   25 MAJOR=0
   26 IF(MAXFLG.GE.MAXSTR)GO TO 28
      MAXFLG=MAXFLG+1
   27 KNTCHR(MAXFLG)=KOUNT
      INILOC(MAXFLG)=INIBFR
   28 IF(MAJOR.GT.0)GO TO 1
C
C     RETURN TO CALLING PROGRAM
   29 IF(KIND.EQ.5)MANY=1
      IF(KIND.LT.4)MANY=0
      RETURN
C800079448226[]:';&!@
      END
      SUBROUTINE REOPEN(KNDFIL,IUNIT,LOCFIL,LNGFIL,LTRFIL,
     1MAXFIL,MAXCHR,ITRACE,ITTY,LPTTTY,NOTOPN)
C     RENBR(REOPN1/PDP10 OPEN INPUT AND OUTPUT FILES)
C     RENBR/M:99999
C
C     DONALD E. BARTH, YALE SCHOOL OF MANAGEMENT
C
C     THIS DECSYSTEM10 ROUTINE OPENS THE INPUT  AND  OUTPUT
C     FILES  WHICH  HAVE  BEEN  SPECIFIED BY THE USER.  THE
C     REPART ROUTINE IS FIRST  CALLED  TO  SPLIT  THE  FILE
C     SPECIFICATION  INTO  ITS COMPONENT PARTS:  THE DEVICE
C     NAME, THE FILE  NAME,  AND  THE  DIRECTORY.   MISSING
C     COMPONENTS  ARE  SUPPLIED  BY  THIS  ROUTINE, AND THE
C     FILES ARE THEN OPENED.
C
C     KNDFIL = SPECIFIES TYPE OF FILE TO BE OPENED.
C            = 1, OPEN INPUT COMMAND FILE.
C            = 2, OPEN FIRST  INPUT  SOURCE  FILE.   OUTPUT
C              FILES HAVE NOT YET BEEN OPENED.
C            = 3, OPEN OUTPUT RENUMBERED FILE.
C            = 4, OPEN OUTPUT LISTING FILE.
C            = 5, OPEN SECOND OR  SUBSEQUENT  INPUT  SOURCE
C              FILE.   ALL  OUTPUT  FILES HAVE ALREADY BEEN
C              OPENED.
C     IUNIT  = NUMBER SELECTING THE DEVICE UPON  WHICH  THE
C              FILE IS TO BE OPENED.
C     LOCFIL = SERIAL NUMBER WITHIN THE LNGFIL  AND  LTRFIL
C              ARRAYS  OF  THE  DESCRIPTION  OF THE CURRENT
C              FILE RELATIVE TO  THE  DESCRIPTIONS  OF  ALL
C              FILES.
C     LNGFIL = ARRAY CONTAINING NUMBERS  OF  CHARACTERS  IN
C              FILE DESCRIPTIONS IN THE LTRFIL ARRAY.
C     LTRFIL = ARRAY CONTAINING THE FILE DESCRIPTIONS TYPED
C              BY THE USER.
C     MAXFIL = 1 MORE THAN NUMBER  OF  FILE  SPECIFICATIONS
C              WHICH  CAN  APPEAR  TO  LEFT  OF EQUAL SIGN.
C              THIS IS MAXIMUM VALUE OF SUBSCRIPT OF LNGFIL
C              ARRAY  AND MAXIMUM VALUE OF SECOND SUBSCRIPT
C              OF LTRFIL ARRAY.
C     MAXCHR = MAXIMUM NUMBER OF CHARACTERS IN ANY  1  FILE
C              DESCRIPTION IN THE LTRFIL ARRAY.
C     ITRACE = 0, INPUT IF DESCRIPTIONS OF FILES ARE NOT TO
C              BE  WRITTEN  TO USER TERMINAL WHENEVER FILES
C              ARE OPENED.
C            = 1,  INPUT  IF   USER   SELECTS   /Z   SWITCH
C              INDICATING THAT DESCRIPTIONS OF FILES ARE TO
C              BE WRITTEN TO USER TERMINAL  WHENEVER  FILES
C              ARE OPENED.
C     ITTY   = UNIT  NUMBER  TO  WHICH   DESCRIPTIONS   ARE
C              WRITTEN IF ITRACE=1.
C     LPTTTY = INPUT CONTAINING 0 IF USER DID  NOT  SPECIFY
C              /V SWITCH.  THE /V SWITCH FORCES THE LISTING
C              TO BE WRITTEN ONTO THE CONTROLLING TERMINAL.
C            = INPUT CONTAINING  1  IF  USER  SPECIFIED  /V
C              SWITCH.
C            = RETURNED SET TO 1 IF LPTTTY WAS INPUT SET TO
C              1  OR  IF  THE NAME OF THE OUTPUT DEVICE FOR
C              THE LISTING WAS TTY:.
C     NOTOPN = RETURNED SET TO 0 IF FILE  WAS  SUCCESSFULLY
C              OPENED.
C            = RETURNED SET TO  1  IF  FILE  COULD  NOT  BE
C              OPENED.
C
      COMMON/RNBTEN/MISONE,MISTWO
      COMMON/RNBELE/LTRFIV(5),LTRSIX(6),LTRPTH(6)
      DOUBLE PRECISION LA5NAM,LA5PTH(3)
      DIMENSION LNGFIL(MAXFIL),LTRFIL(MAXCHR,MAXFIL),
     1LTRDVC(5),LTRNAM(10),LTRSFD(6),LTREXT(15),LTRRNB(6),
     2LTRTTY(5),LWRTTY(3),LTRDSK(5),LTRLPT(5),LWRLPT(3),
     3NUMPTH(2)
      EQUIVALENCE(NUMPTH(1),LA5PTH(1))
      DATA LTREXT/1HC,1HM,1HD,
     1            1HR,1HN,1HO,
     2            1HN,1HE,1HW,
     3            1HD,1HO,1HC,
     4            1HR,1HN,1HO/
      DATA LTRRNB/1HF,1HR,1HO,1HF,1HF,1H /
      DATA LTRTTY/1HT,1HT,1HY,1H ,1H /
      DATA LWRTTY/1Ht,1Ht,1Hy/
      DATA LTRDSK/1HD,1HS,1HK,1H ,1H /
      DATA LTRLPT/1HL,1HP,1HT,1H ,1H /
      DATA LWRLPT/1Hl,1Hp,1Ht/
      DATA LTRDOT,LTRSPC/1H.,1H /
C
C     PARSE DECSYSTEM10 FILE SPECIFICATION
      CALL REPART(MAXFIL,LTRFIL,MAXCHR,LOCFIL,LNGFIL,
     1LTRDVC,LTRNAM,NUMONE,NUMTWO,LTRSFD)
C
C     SUPPLY DEFAULT FILE NAME IF NEEDED
      IF(LTRNAM(1).EQ.LTRSPC)GO TO 2
      IF(KNDFIL.NE.2)GO TO 7
      DO 1 I=1,6
    1 LTRSIX(I)=LTRNAM(I)
      GO TO 7
    2 GO TO(3,38,5,5,38),KNDFIL
    3 DO 4 I=1,6
    4 LTRNAM(I)=LTRRNB(I)
      GO TO 7
    5 DO 6 I=1,6
    6 LTRNAM(I)=LTRSIX(I)
C
C     SUPPLY DEFAULT EXTENSION IF NEEDED
    7 IF2TRY=0
      IF(LTRNAM(7).EQ.LTRDOT)GO TO 9
      LTRNAM(7)=LTRDOT
      IF2TRY=1
      IF(KNDFIL.EQ.2)GO TO 9
      IF(KNDFIL.EQ.5)GO TO 9
      IF2TRY=0
      J=(3*KNDFIL)-2
      DO 8 I=8,10
      LTRNAM(I)=LTREXT(J)
    8 J=J+1
C
C     SUPPLY DEFAULT DEVICE IF NEEDED
    9 IF(LTRDVC(1).EQ.LTRSPC)GO TO 15
      GO TO(26,22,26,10,22),KNDFIL
   10 DO 11 I=1,3
      IF(LTRDVC(I).EQ.LTRTTY(I))GO TO 11
      IF(LTRDVC(I).NE.LWRTTY(I))GO TO 12
   11 CONTINUE
      LPTTTY=1
      GO TO 26
   12 DO 13 I=1,3
      IF(LTRDVC(I).EQ.LTRLPT(I))GO TO 13
      IF(LTRDVC(I).NE.LWRLPT(I))GO TO 14
   13 CONTINUE
      LPTTTY=-1
      GO TO 26
   14 LPTTTY=0
      GO TO 26
   15 GO TO(20,20,20,16,24),KNDFIL
   16 IF(LPTTTY.GT.0)GO TO 18
      DO 17 I=1,5
   17 LTRDVC(I)=LTRDSK(I)
      LPTTTY=0
      GO TO 26
   18 DO 19 I=1,5
   19 LTRDVC(I)=LTRTTY(I)
      GO TO 26
   20 DO 21 I=1,5
   21 LTRDVC(I)=LTRDSK(I)
      IF(KNDFIL.NE.2)GO TO 26
   22 DO 23 I=1,5
   23 LTRFIV(I)=LTRDVC(I)
      GO TO 26
   24 DO 25 I=1,5
   25 LTRDVC(I)=LTRFIV(I)
C
C     SUPPLY DEFAULT PATH IF NEEDED
   26 GO TO(31,29,31,31,27),KNDFIL
   27 IF(NUMONE.NE.0)GO TO 29
      NUMONE=MISONE
      NUMTWO=MISTWO
      DO 28 I=1,6
   28 LTRSFD(I)=LTRPTH(I)
   29 MISONE=NUMONE
      MISTWO=NUMTWO
      DO 30 I=1,6
   30 LTRPTH(I)=LTRSFD(I)
C
C     CONVERT USER SPECIFIED INFORMATION TO A5 FORM
   31 ENCODE(5,32,LA5DVC)LTRDVC
   32 FORMAT(5A1)
C     THIS PATCH ADDED BECAUSE DECSYSTEM10 FORTRAN10
C     VERSION 6 DOES NOT ALLOW BLANKS IN FILE NAMES
      I=0
      DO 43 J=1,10
      IF(LTRNAM(J).EQ.LTRSPC)GO TO 43
      I=I+1
      IF(I.EQ.J)GO TO 43
      LTRNAM(I)=LTRNAM(J)
      LTRNAM(J)=LTRSPC
   43 CONTINUE
      ENCODE(10,33,LA5NAM)LTRNAM
   33 FORMAT(10A1)
      DO 34 I=1,3
   34 LA5PTH(I)=0
      IF(NUMONE.EQ.0)GO TO 36
      NUMPTH(1)=NUMONE
      NUMPTH(2)=NUMTWO
      IF(LTRSFD(1).EQ.LTRSPC)GO TO 36
      ENCODE(6,35,LA5PTH(2))LTRSFD
   35 FORMAT(6A1)
C
C     ATTEMPT TO OPEN THE FILE
   36 NOTOPN=0
      IF(KNDFIL.EQ.3)GO TO 37
      IF(KNDFIL.EQ.4)GO TO 37
C
C     OPEN INPUT FILE
      OPEN(UNIT=IUNIT,DEVICE=LA5DVC,FILE=LA5NAM,
     1DIRECTORY=LA5PTH,ACCESS='SEQIN',ERR=41)
      GO TO 39
   41 IF(IF2TRY.EQ.0)GO TO 38
      IF2TRY=0
      J=(3*KNDFIL)-2
      DO 42 I=8,10
      LTRNAM(I)=LTREXT(J)
   42 J=J+1
      GO TO 31
C
C     OPEN OUTPUT FILE
   37 OPEN(UNIT=IUNIT,DEVICE=LA5DVC,FILE=LA5NAM,
     1DIRECTORY=LA5PTH,ACCESS='SEQOUT',
     2CARRIAGECONTROL='FORTRAN',ERR=38)
      GO TO 39
C
C     RETURN TO CALLING PROGRAM
   38 NOTOPN=1
   39 IF(ITRACE.NE.0)WRITE(ITTY,40)KNDFIL,NOTOPN,LA5DVC,
     1LA5NAM,NUMPTH,LA5PTH(2)
   40 FORMAT(1X,3HKND,1I2,1X,3HERR,I2,1X,1A5,1H:,1A10,
     11H[,1O6,1H,,1O6,1H,,1A6,1H])
      RETURN
C043749646106':[]
      END
      SUBROUTINE REPART(MAXFIL,LTRFIL,MAXCHR,LOCFIL,LNGFIL,
     1LTRDVC,LTRNAM,NUMONE,NUMTWO,LTRSFD)
C     RENBR(REPRT1/PDP10 FIND COMPONENTS OF FILE NAMES)
C     RENBR/M:99999
C
C     DONALD E. BARTH, YALE SCHOOL OF MANAGEMENT
C
C     THIS   DECSYSTEM10   ROUTINE    SPLITS    THE    FILE
C     SPECIFICATION  TYPED  BY  THE USER INTO ITS COMPONENT
C     PARTS.
C
C     MAXFIL = 1 MORE THAN NUMBER  OF  FILE  SPECIFICATIONS
C              WHICH  CAN  APPEAR  TO  LEFT  OF EQUAL SIGN.
C              THIS IS MAXIMUM VALUE OF SUBSCRIPT OF LNGFIL
C              ARRAY  AND MAXIMUM VALUE OF SECOND SUBSCRIPT
C              OF LTRFIL ARRAY.
C     LTRFIL = ARRAY CONTAINING THE FILE DESCRIPTIONS TYPED
C              BY THE USER.
C     MAXCHR = MAXIMUM NUMBER OF CHARACTERS IN ANY  1  FILE
C              DESCRIPTION IN THE LTRFIL ARRAY.
C     LOCFIL = SERIAL NUMBER WITHIN THE LNGFIL  AND  LTRFIL
C              ARRAYS  OF  THE  DESCRIPTION  OF THE CURRENT
C              FILE RELATIVE TO  THE  DESCRIPTIONS  OF  ALL
C              FILES.
C     LNGFIL = ARRAY CONTAINING NUMBERS  OF  CHARACTERS  IN
C              FILE DESCRIPTIONS IN THE LTRFIL ARRAY.
C     LTRDVC = RETURNED   CONTAINING   CHARACTERS   FORMING
C              DEVICE NAME.
C     LTRNAM = RETURNED CONTAINING CHARACTERS FORMING  FILE
C              NAME AND EXTENSION.
C     NUMONE = RETURNED CONTAINING VALUE OF FIRST NUMBER IN
C              DIRECTORY INSIDE BRACKETS.
C     NUMTWO = RETURNED CONTAINING VALUE OF  SECOND  NUMBER
C              IN DIRECTORY INSIDE BRACKETS.
C     LTRSFD = RETURNED CONTAINING CHARACTERS FORMING THIRD
C              ITEM INSIDE BRACKETS.
C
      DIMENSION LTRFIL(MAXCHR,MAXFIL),LTRNAM(10),LTRDVC(5),
     1LTRSFD(6),LTRDGT(8),LNGFIL(MAXFIL)
C
C     CCCC       AAA UU   UU TTTTTTTT IIII  OOOO   NN    NN
C   CC          AAAA UU   UU    TT     II  OO  OO  NNN   NN
C  CC          AA AA UU   UU    TT     II OO    OO NNNN  NN
C  CC         AA  AA UU   UU    TT     II OO    OO NN NN NN
C  CC        AAAAAAA UU   UU    TT     II OO    OO NN  NNNN
C   CC      AA    AA  UU UU     TT     II  OO  OO  NN   NNN
C     CCCC AA     AA   UUU      TT    IIII  OOOO   NN    NN
C
C     LEFT AND RIGHT SQUARE  BRACKETS MUST BE DEFINED USING
C     OCTAL NOTATION FOR PDP10 F40 COMPILER.  LET FOLLOWING
C     COMMENT BE THE COMPILED DATA STATEMENT IF F40 IS USED
C      DATA LTROPN,LTRCLS/"555004020100,"565004020100/
C
      DATA LTROPN,LTRCLS/1H[,1H]/
      DATA LTRDGT/1H0,1H1,1H2,1H3,1H4,1H5,1H6,1H7/
      DATA LTRDOT,LTRCLN,LTRCMA,LTRSPC,LTRTAB/
     11H.,1H:,1H,,1H ,"045004020100/
      MAXPRT=0
      IF(LOCFIL.GT.0)MAXPRT=LNGFIL(LOCFIL)
C
C     LOCATE DIRECTORY INSIDE BRACKETS
      INIPTH=0
    1 INIPTH=INIPTH+1
      IF(INIPTH.GT.MAXPRT)GO TO 3
      IF(LTRFIL(INIPTH,LOCFIL).NE.LTROPN)GO TO 1
      LMTPTH=INIPTH
    2 LMTPTH=LMTPTH+1
      IF(LMTPTH.GT.MAXPRT)GO TO 4
      IF(LTRFIL(LMTPTH,LOCFIL).NE.LTRCLS)GO TO 2
      GO TO 4
    3 LMTPTH=INIPTH-1
C
C     LOCATE DEVICE NAME TO LEFT OF COLON
    4 LMTDSK=0
    5 LMTDSK=LMTDSK+1
      IF(LMTDSK.GT.MAXPRT)GO TO 8
      IF(LMTDSK.LT.INIPTH)GO TO 6
      IF(LMTDSK.GT.LMTPTH)GO TO 6
      LMTDSK=LMTPTH
      GO TO 5
    6 IF(LTRFIL(LMTDSK,LOCFIL).NE.LTRCLN)GO TO 5
    7 INIDSK=1
      IF(INIPTH.GT.LMTPTH)GO TO 9
      IF(LMTDSK.GT.LMTPTH)INIDSK=LMTPTH+1
      GO TO 9
    8 INIDSK=LMTDSK+1
C
C     LOCATE FILE NAME
    9 ININAM=0
      IF(INIDSK.LE.LMTDSK)ININAM=LMTDSK
   10 ININAM=ININAM+1
      IF(ININAM.GT.MAXPRT)GO TO 12
      IF(ININAM.GT.LMTPTH)GO TO 11
      IF(ININAM.LT.INIPTH)GO TO 11
      ININAM=LMTPTH
      GO TO 10
   11 IF(LTRFIL(ININAM,LOCFIL).EQ.LTRSPC)GO TO 10
      IF(LTRFIL(ININAM,LOCFIL).EQ.LTRTAB)GO TO 10
      LMTNAM=MAXPRT
      IF(INIPTH.GT.LMTPTH)GO TO 13
      IF(ININAM.LT.INIPTH)LMTNAM=INIPTH-1
      GO TO 13
   12 LMTNAM=ININAM-1
C
C     COLLECT 5 LETTERS OF DEVICE NAME
   13 DO 17 INDEX=1,5
      LTRDVC(INDEX)=LTRSPC
   14 IF(INIDSK.GE.LMTDSK)GO TO 17
      IF(LTRFIL(INIDSK,LOCFIL).EQ.LTRSPC)GO TO 15
      IF(LTRFIL(INIDSK,LOCFIL).NE.LTRTAB)GO TO 16
   15 INIDSK=INIDSK+1
      GO TO 14
   16 LTRDVC(INDEX)=LTRFIL(INIDSK,LOCFIL)
      INIDSK=INIDSK+1
   17 CONTINUE
C
C     COLLECT 6 LETTERS OF NAME, PERIOD AND EXTENSION
      DO 22 INDEX=1,10
      LTRNAM(INDEX)=LTRSPC
      IF(INDEX.NE.7)GO TO 19
   18 IF(ININAM.GT.LMTNAM)GO TO 22
      IF(LTRFIL(ININAM,LOCFIL).EQ.LTRDOT)GO TO 21
      ININAM=ININAM+1
      GO TO 18
   19 IF(ININAM.GT.LMTNAM)GO TO 22
      IF(LTRFIL(ININAM,LOCFIL).EQ.LTRDOT)GO TO 22
      IF(LTRFIL(ININAM,LOCFIL).EQ.LTRSPC)GO TO 20
      IF(LTRFIL(ININAM,LOCFIL).NE.LTRTAB)GO TO 21
   20 ININAM=ININAM+1
      GO TO 19
   21 LTRNAM(INDEX)=LTRFIL(ININAM,LOCFIL)
      ININAM=ININAM+1
   22 CONTINUE
C
C     EVALUATE PROJECT AND PROGRAMMER NUMBERS
      IPART=0
   23 NUMTWO=0
   24 INIPTH=INIPTH+1
      IF(INIPTH.GE.LMTPTH)GO TO 26
      LTRNOW=LTRFIL(INIPTH,LOCFIL)
      DO 25 I=1,8
      IF(LTRDGT(I).NE.LTRNOW)GO TO 25
      NUMTWO=(8*NUMTWO)+I-1
      GO TO 24
   25 CONTINUE
      IF(LTRNOW.NE.LTRCMA)GO TO 24
   26 IF(IPART.NE.0)GO TO 27
      IPART=1
      NUMONE=NUMTWO
      GO TO 23
C
C     COLLECT 6 LETTERS OF SUBFILE DIRECTORY NAME
   27 DO 29 INDEX=1,6
      LTRSFD(INDEX)=LTRSPC
   28 INIPTH=INIPTH+1
      IF(INIPTH.GE.LMTPTH)GO TO 29
      IF(LTRFIL(INIPTH,LOCFIL).EQ.LTRSPC)GO TO 28
      IF(LTRFIL(INIPTH,LOCFIL).EQ.LTRTAB)GO TO 28
      LTRSFD(INDEX)=LTRFIL(INIPTH,LOCFIL)
   29 CONTINUE
      RETURN
C880801883569[]:
      END
