IDENTIFICATION DIVISION.
PROGRAM-ID.	RPGCCC.
DATE-WRITTEN.	APRIL 13, 1976.
AUTHOR.	HAL ROACH.
INSTALLATION.	CERRITOS COLLEGE.
REMARKS.	PROGRAM TO UPDATE C DATA CARD.
ENVIRONMENT DIVISION.
CONFIGURATION SECTION.
SOURCE-COMPUTER.	DECSYSTEM-10.
OBJECT-COMPUTER.	DECSYSTEM-10.
SPECIAL-NAMES.
	CONSOLE IS TTY.
	CHANNEL (1) IS HOF.
INPUT-OUTPUT SECTION.
FILE-CONTROL.
	SELECT PROGRAM-FILE ASSIGN TO DSK
	ACCESS MODE IS RANDOM
	ACTUAL KEY IS PROGRAM-KEY
	FILE LIMIT IS 99999.
DATA DIVISION.
FILE SECTION.
FD	PROGRAM-FILE
	BLOCK CONTAINS 8 RECORDS
	LABEL RECORDS ARE STANDARD
	VALUE OF IDENTIFICATION IS PROGRAM-IDENTIFICATION
	DATA RECORD IS PROGRAM-RECORD.
01	PROGRAM-RECORD	PIC X(90).
WORKING-STORAGE SECTION.
77	NUM-IT-1			PIC 9.
77	NUM-IT-2			PIC 99.
77	NUM-IT-3			PIC 999.
77	NUM-IT-6		PIC 9(6).
77	ELE-9			PIC 99.
77	FINAL-VALUE		PIC 99.
77	CLEAR-IT		PIC X(31)	VALUE SPACES.
77	CLEAR-3300		PIC X(23)	VALUE SPACES.
77	ERROR-CODE		PIC X.
77	I			PIC S9(5)	COMP.
77	J			PIC S9(5)	COMP.
77	K			PIC S9(5)	COMP.
77	L			PIC S9(5)	COMP.
77	PROGRAM-KEY		PIC 9(5)	COMP.
77	NEXT-PROGRAM		PIC X(6).
01	END-SIDE	PIC X.
01	END-CHG REDEFINES END-SIDE.
	02 THE-SIDE	PIC 9.
01	ELEM-NO.
	02 ELE-NUM	PIC XX.
01	NO-ELEM REDEFINES ELEM-NO.
	02 NUM-ELE	PIC 99.
01	DATA-STORAGE.
	02 DATA-A	PIC X(15)	OCCURS 18 TIMES.
01	THE-DATA.
	02 DATA-110.
	  03 DATA-16.
	    04 DATA-15.
	      05 DATA-13.
	        06 DATA-12.
	          07 DATA-1	PIC X.
	          07 DATA-2	PIC X.
	        06 DATA-3	PIC X.
	      05 DATA-5		PIC XX.
	    04 DATA-6		PIC X.
	  03 DATA-10		PIC X(4).
	02 FILLER	PIC X(5).
01	PROGRAM-ZERO.
	02 FILLER		PIC X(80).
	02 PROGRAM-REC-NO	PIC 9(5).
	02 PROGRAM-LAST-REC	PIC 9(5).
01	PROGRAM-MAIN.
	02 PROGRAM-PAGE		PIC 99.
	02 PROGRAM-LINE		PIC 999.
	02 PROGRAM-FORM		PIC X.
	02 PROGRAM-INFO.
	  03 FILLER		PIC X.
	  03 STAR-COMMENT	PIC X(67).
	02 PROGRAM-IDENT	PIC X(6).
	02 PROGRAM-ACT-REC	PIC 9(5).
	02 PROGRAM-FILL		PIC 9(5).
01	PROG-INFO.
	02 CON-LEV.
	  03 THE-STARE	PIC X.
	  03 FILLER	PIC X.
	02 NOT-1	PIC X.
	02 IND-1	PIC XX.
	02 DNI-1 REDEFINES IND-1	PIC 99.
	02 NOT-2	PIC X.
	02 IND-2	PIC XX.
	02 DNI-2 REDEFINES IND-2	PIC 99.
	02 NOT-3	PIC X.
	02 IND-3	PIC XX.
	02 DNI-3 REDEFINES IND-3	PIC 99.
	02 FAC-1	PIC X(10).
	02 OPER		PIC X(5).
	02 FAC-2	PIC X(10).
	02 RES-FIE	PIC X(6).
	02 FIE-LEN	PIC XXX.
	02 LEN-FIE REDEFINES FIE-LEN	PIC ZZ9.
	02 DEC-POS	PIC X.
	02 HAL-ADJ	PIC X.
	02 HIGH-IT	PIC XX.
	02 IT-HIGH REDEFINES HIGH-IT	PIC 99.
	02 LOW-IT	PIC XX.
	02 IT-LOW REDEFINES LOW-IT	PIC 99.
	02 EQUAL-IT	PIC XX.
	02 IT-EQUAL REDEFINES EQUAL-IT	PIC 99.
	02 COMMENT	PIC X(15).
01	PROG-COMMENT.
	02 THE-STAR	PIC X	VALUE "*".
	02 THE-COMMENT	PIC X(67).
01	TUBE-TITLE.
	02 TUBE-LINE-0.
	  03 FILLER		PIC X(4)	VALUE "PAGE".
	  03 DISPLAY-PAGE	PIC ZZZ.
	  03 FILLER		PIC X(5)	VALUE " LINE".
	  03 DISPLAY-LINE	PIC Z(4).
	  03 FILLER		PIC X(21)	VALUE
	" C DATA CARD".
	02 TUBE-LINE-1	PIC X(51)	VALUE
	"ELEMENT ELEMENT                ELEMENT".
	02 TUBE-LINE-2	PIC X(51)	VALUE
	"NUMBER  DESCRIPTION            [ENTRY]".
01	TUBE-DISPLAY.
	02 FILLER	PIC X(40)	VALUE
	"CONTROL LEVEL          [  ]".
	02 FILLER	PIC X(40)	VALUE
	"NOT - 1                [ ]".
	02 FILLER	PIC X(40)	VALUE
	"INDICATOR - 1          [  ]".
	02 FILLER	PIC X(40)	VALUE
	"NOT - 2                [ ]".
	02 FILLER	PIC X(40)	VALUE
	"INDICATOR - 2          [  ]".
	02 FILLER	PIC X(40)	VALUE
	"NOT - 3                [ ]".
	02 FILLER	PIC X(40)	VALUE
	"INDICATOR - 3          [  ]".
	02 FILLER	PIC X(40)	VALUE
	"FACTOR - 1             [          ]".
	02 FILLER	PIC X(40)	VALUE
	"OPERATION              [     ]".
	02 FILLER	PIC X(40)	VALUE
	"FACTOR - 2             [          ]".
	02 FILLER	PIC X(40)	VALUE
	"RESULT FIELD           [      ]".
	02 FILLER	PIC X(40)	VALUE
	"FIELD LENGTH           [   ]".
	02 FILLER	PIC X(40)	VALUE
	"DECIMAL POSITION       [ ]".
	02 FILLER	PIC X(40)	VALUE
	"HALF ADJUST            [ ]".
	02 FILLER	PIC X(40)	VALUE
	"RESULT INDICATOR-HIGH  [  ]".
	02 FILLER	PIC X(40)	VALUE
	"RESULT INDICATOR-LOW   [  ]".
	02 FILLER	PIC X(40)	VALUE
	"RESULT INDICATOR-EQUAL [  ]".
	02 FILLER	PIC X(40)	VALUE
	"COMMENT                [               ]".
01	DISPLAY-TUBE REDEFINES TUBE-DISPLAY.
	02 FILLER	OCCURS 18 TIMES.
	  03 THE-TUBE	PIC X(40).
01	THE-NUMBER.
	02 II		PIC Z(5).
	02 FILLER	PIC XXX.
01	PROGRAM-IDENTIFICATION.
	02 PROGRAM-NAME		PIC X(6).
	02 PROGRAM-EXT		PIC XXX		VALUE "TMP".
01	PASS-IT.
	02 THE-FILE	PIC X(6).
	02 THE-TERM	PIC X.
	02 THE-ACTION	PIC XXX.
	02 THE-PAGE	PIC 99.
	02 THE-LINE	PIC 999.
	02 THE-FORM	PIC X.
	02 R-TYPE	PIC X.
01	ALL-DATA.
	02 ALL-1	PIC X.
	02 ALL-23.
	  03 ALL-2	PIC X.
	  03 ALL-3	PIC X.
	02 FILLER	PIC X(12).
PROCEDURE DIVISION.
START SECTION.
BEGIN.
	ENTER MACRO TRAP.
	MOVE SPACES TO PASS-IT.
*	DISPLAY "PASS-IT = " WITH NO ADVANCING ACCEPT PASS-IT.
	ENTER MACRO GTPRMS USING PASS-IT "X".
	IF THE-TERM = "A" OR "D" OR "V" OR "3" OR "B"
		GO TO CONT-PROG.
	DISPLAY "THE DRIVER PROGRAM WAS NOT USED".
	STOP RUN.
CONT-PROG.
	PERFORM CLEAR-SCREEN.
	ENTER MACRO SETTY USING "FORM".
	ENTER MACRO SETTY USING "NO CRLF".
	ENTER MACRO SETTY USING "WIDTH 80".
	MOVE THE-FILE TO PROGRAM-NAME.
	IF THE-ACTION = "CHG"
		PERFORM FIND-REC THRU END-FIND-REC.
	PERFORM CLEAR-SCREEN.
	IF THE-STARE = "*"
		MOVE 1 TO K
		MOVE THE-STARE TO DATA-1
		GO TO COMMENT-CHECK.
	MOVE THE-PAGE TO DISPLAY-PAGE.
	MOVE THE-LINE TO DISPLAY-LINE.
	DISPLAY TUBE-LINE-0.
	DISPLAY TUBE-LINE-1.
	DISPLAY TUBE-LINE-2.
	MOVE 3 TO I.
LOOP-DISPLAY.
	ADD 1 TO I.
	IF I > 21 GO TO END-DISPLAY.
	SUBTRACT 3 FROM I GIVING K.
	MOVE K TO II.
	MOVE 1 TO J.
	PERFORM CURSOR.
	DISPLAY THE-NUMBER THE-TUBE (K) WITH NO ADVANCING.
	MOVE 33 TO J.
	PERFORM CURSOR.
	DISPLAY DATA-A (K).
	GO TO LOOP-DISPLAY.
END-DISPLAY.
	IF THE-ACTION = "ADD"
		MOVE 3 TO I
		GO TO ADD-IT.
FIND-NUMBER.
	MOVE 23 TO I.
	MOVE 1 TO J.
	PERFORM CURSOR.
	DISPLAY "ELEMENT NUMBER = " WITH NO ADVANCING.
	MOVE SPACES TO ELE-NUM.
	DISPLAY ELE-NUM WITH NO ADVANCING.
	MOVE 18 TO J.
	PERFORM CURSOR.
	ACCEPT ELE-NUM.
	IF ELE-NUM = "EN"
		PERFORM CHG-REC THRU END-CHG-REC
		PERFORM CLEAR-SCREEN
		GO TO END-IT.
	MOVE NUM-ELE TO ELE-9.
	EXAMINE ELE-NUM REPLACING ALL SPACES BY ZERO.
	IF ELE-NUM IS NOT NUMERIC
		PERFORM BAD-NUMBER
		GO TO FIND-NUMBER.
	IF ELE-9 < 1 OR ELE-9 > 18
		PERFORM BAD-NUMBER
		GO TO FIND-NUMBER.
	MOVE 23 TO I.
	MOVE 20 TO J.
	PERFORM CURSOR.
	PERFORM CLEAR-LINE.
	MOVE ELE-9 TO I.
	ADD 3 TO I.
BY-NUM.
	MOVE 33 TO J.
	SUBTRACT 3 FROM I GIVING K.
	MOVE K TO II.
ACCEPT-CHG.
	PERFORM CURSOR.
	ACCEPT DATA-A (K).
	IF THE-ACTION = "ADD"
		MOVE DATA-A (K) TO ALL-DATA.
	IF ALL-1 = "/"
		GO TO CHECK-SLASH.
	IF K = 1 GO TO COMMENT-CHECK.
EDIT-IT.
	PERFORM THE-EDIT THRU END-THE-EDIT.
	IF ERROR-CODE = "X"
		MOVE SPACE TO ERROR-CODE
		MOVE 33 TO J
		PERFORM CURSOR
		GO TO ACCEPT-CHG.
	PERFORM CLEAN-IT.
	MOVE 33 TO J.
	PERFORM CURSOR.
	DISPLAY DATA-A (K).
	IF K = 3 OR 5 OR 7 OR 15 OR 16 OR 17
		PERFORM CLEAR-NEXT.
	IF THE-ACTION = "ADD" GO TO LOOP-VALUE.
	GO TO FIND-NUMBER.
CLEAR-NEXT.
	MOVE 49 TO J.
	ADD 1 TO I.
	PERFORM CURSOR.
	PERFORM CLEAR-LINE.
	SUBTRACT 1 FROM I.
CHECK-SLASH.
	IF ALL-2 = "E"
		GO TO END-VALUE.
	MOVE ALL-23 TO NUM-IT-2.
	EXAMINE ALL-23 REPLACING ALL SPACES BY ZEROS.
	IF (ALL-23 NOT NUMERIC) OR (NUM-IT-2 > 18) OR (NUM-IT-2 = ZERO)
		MOVE 49 TO J
		PERFORM CURSOR
		DISPLAY " BAD SWITCH"
		MOVE 33 TO J
		PERFORM CURSOR
		GO TO ACCEPT-CHG.
	MOVE NUM-IT-2 TO L.
	ADD 2 TO L.
	PERFORM CLEAN-IT.
	GO TO LOOP-VALUE.
CLEAN-IT.
	MOVE 49 TO J.
	PERFORM CURSOR.
	PERFORM CLEAR-LINE.
	MOVE 1 TO J.
	PERFORM CURSOR.
	DISPLAY THE-NUMBER THE-TUBE (K) WITH NO ADVANCING.
COMMENT-CHECK.
	MOVE DATA-A (K) TO THE-DATA.
	IF DATA-1 NOT = "*" GO TO EDIT-IT.
	PERFORM CLEAR-SCREEN.
	IF THE-ACTION = "CHG"
		DISPLAY "OLD COM" STAR-COMMENT.
	DISPLAY "         1    1    2    2    3    3    4    4    5    5    6    6    7   7".
	DISPLAY "       8901234567890123456789012345678901234567890123456789012345678901234".
	DISPLAY "NEW COM" WITH NO ADVANCING ACCEPT THE-COMMENT.
	MOVE PROG-COMMENT TO PROG-INFO.
	IF THE-ACTION = "CHG"
		PERFORM CHG-REC THRU END-CHG-REC
		PERFORM CLEAR-SCREEN
		GO TO END-IT.
	GO TO END-VALUE.
BAD-NUMBER.
	MOVE 23 TO I.
	MOVE 20 TO J.
	PERFORM CURSOR.
	DISPLAY " BAD NUMBER " ELE-NUM.
FIND-REC.
	OPEN I-O PROGRAM-FILE.
	MOVE 1 TO PROGRAM-KEY.
	READ PROGRAM-FILE INVALID KEY
	DISPLAY "BAD READ CHG FILE " PROGRAM-KEY STOP RUN.
	MOVE PROGRAM-RECORD TO PROGRAM-ZERO.
LOOP-CHG.
	ADD 1 TO PROGRAM-KEY.
	IF PROGRAM-KEY > PROGRAM-LAST-REC
		DISPLAY "LOGIC ERROR IN PROGRAM" STOP RUN.
	READ PROGRAM-FILE INVALID KEY
	DISPLAY "BAD READ CHG FILE " PROGRAM-KEY STOP RUN.
	MOVE PROGRAM-RECORD TO PROGRAM-MAIN.
	IF PROGRAM-PAGE NOT = THE-PAGE GO TO LOOP-CHG.
	IF PROGRAM-LINE NOT = THE-LINE GO TO LOOP-CHG.
	MOVE PROGRAM-INFO TO PROG-INFO.
	MOVE CON-LEV TO DATA-A (1).
	MOVE NOT-1 TO DATA-A (2).
	MOVE IND-1 TO DATA-A (3).
	MOVE NOT-2 TO DATA-A (4).
	MOVE IND-2 TO DATA-A (5).
	MOVE NOT-3 TO DATA-A (6).
	MOVE IND-3 TO DATA-A (7).
	MOVE FAC-1 TO DATA-A (8).
	MOVE OPER TO DATA-A (9).
	MOVE FAC-2 TO DATA-A (10).
	MOVE RES-FIE TO DATA-A (11).
	MOVE FIE-LEN TO DATA-A (12).
	MOVE DEC-POS TO DATA-A (13).
	MOVE HAL-ADJ TO DATA-A (14).
	MOVE HIGH-IT TO DATA-A (15).
	MOVE LOW-IT TO DATA-A (16).
	MOVE EQUAL-IT TO DATA-A (17).
	MOVE COMMENT TO DATA-A (18).
END-FIND-REC.
	EXIT.
CHG-REC.
	MOVE PROG-INFO TO PROGRAM-INFO.
	MOVE PROGRAM-MAIN TO PROGRAM-RECORD.
	WRITE PROGRAM-RECORD INVALID KEY
	DISPLAY "BAD WRITE CHG " PROGRAM-KEY STOP RUN.
	CLOSE PROGRAM-FILE.
END-CHG-REC.
	EXIT.
ADD-IT.
	MOVE I TO L.
LOOP-VALUE.
	ADD 1 TO L.
	IF L > 21 GO TO END-VALUE.
	MOVE L TO I.
	GO TO BY-NUM.
END-VALUE.
	PERFORM CLEAR-SCREEN.
	PERFORM WRITE-ADD THRU END-WRITE-ADD.
	GO TO END-IT.
CURSOR.
	IF THE-TERM = "A" ENTER MACRO CURSER USING I,J.
	IF THE-TERM = "D" ENTER MACRO CA1520 USING I,J.
	IF THE-TERM = "V" ENTER MACRO CAVT52 USING I,J.
	IF THE-TERM = "3" ENTER MACRO CA3300 USING I,J.
	IF THE-TERM = "B" ENTER MACRO CAB100 USING I,J.
CLEAR-SCREEN.
	IF THE-TERM = "A" OR "D"
		ENTER MACRO TTYOUT USING 14.
	IF THE-TERM = "V"
		ENTER MACRO CLVT52.
	IF THE-TERM = "3"
		ENTER MACRO TTYOUT USING 35,37,37,37,37.
	IF THE-TERM = "B"
		ENTER MACRO CLB100.
CLEAR-LINE.
	IF THE-TERM = "A" OR "V" OR "B"
		DISPLAY CLEAR-IT WITH NO ADVANCING.
	IF THE-TERM = "D"
		ENTER MACRO TTYOUT USING 35.
	IF THE-TERM = "3"
		DISPLAY CLEAR-3300 WITH NO ADVANCING.
SIDE-2.
	IF THE-SIDE = 2
		ADD 12 TO I.
THE-EDIT.
	IF K = 1 PERFORM EDIT-1 THRU END-EDIT-1 GO TO END-THE-EDIT.
	IF K = 2 PERFORM EDIT-2 THRU END-EDIT-2 GO TO END-THE-EDIT.
	IF K = 3 PERFORM EDIT-3 THRU END-EDIT-3 GO TO END-THE-EDIT.
	IF K = 4 PERFORM EDIT-4 THRU END-EDIT-4 GO TO END-THE-EDIT.
	IF K = 5 PERFORM EDIT-5 THRU END-EDIT-5 GO TO END-THE-EDIT.
	IF K = 6 PERFORM EDIT-6 THRU END-EDIT-6 GO TO END-THE-EDIT.
	IF K = 7 PERFORM EDIT-7 THRU END-EDIT-7 GO TO END-THE-EDIT.
	IF K = 8 PERFORM EDIT-8 THRU END-EDIT-8 GO TO END-THE-EDIT.
	IF K = 9 PERFORM EDIT-9 THRU END-EDIT-9 GO TO END-THE-EDIT.
	IF K = 10 PERFORM EDIT-10 THRU END-EDIT-10 GO TO END-THE-EDIT.
	IF K = 11 PERFORM EDIT-11 THRU END-EDIT-11 GO TO END-THE-EDIT.
	IF K = 12 PERFORM EDIT-12 THRU END-EDIT-12 GO TO END-THE-EDIT.
	IF K = 13 PERFORM EDIT-13 THRU END-EDIT-13 GO TO END-THE-EDIT.
	IF K = 14 PERFORM EDIT-14 THRU END-EDIT-14 GO TO END-THE-EDIT.
	IF K = 15 PERFORM EDIT-15 THRU END-EDIT-15 GO TO END-THE-EDIT.
	IF K = 16 PERFORM EDIT-16 THRU END-EDIT-16 GO TO END-THE-EDIT.
	IF K = 17 PERFORM EDIT-17 THRU END-EDIT-17 GO TO END-THE-EDIT.
	IF K = 18 PERFORM EDIT-18 THRU END-EDIT-18 GO TO END-THE-EDIT.
END-THE-EDIT.
	EXIT.
EDIT-1.
	MOVE DATA-A (1) TO THE-DATA.
	IF DATA-12 = SPACE OR "LR" OR "SR" OR "AN" OR "OR"
		GO TO MOVE-1.
	IF DATA-1 = "L"
		GO TO CHECK-NUM-1.
	GO TO ERROR-1.
CHECK-NUM-1.
	IF DATA-2 NOT NUMERIC 
		GO TO ERROR-1.
MOVE-1.
	MOVE DATA-12 TO CON-LEV.
	MOVE CON-LEV TO DATA-A (1).
	GO TO END-EDIT-1.
ERROR-1.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER L0-L9,LR,SR,AN, OR OR".
	MOVE "X" TO ERROR-CODE.
END-EDIT-1.
	EXIT.
EDIT-2.
	MOVE DATA-A (2) TO THE-DATA.
	IF DATA-1 = SPACE OR "N"
		MOVE DATA-1 TO NOT-1
		MOVE NOT-1 TO DATA-A (2)
		GO TO END-EDIT-2.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY "ENTER , , OR N".
	MOVE "X" TO ERROR-CODE.
END-EDIT-2.
	EXIT.
EDIT-3.
	MOVE DATA-A (3) TO THE-DATA.
	IF DATA-12 = SPACE OR "LR" OR "MR" OR "OA" OR "OB" OR "OC"
		OR "OD" OR "OE" OR "OF" OR "OG" OR "OV"
		GO TO MOVE-3.
	IF DATA-1 = "L" OR "H" OR "U"
			GO TO CHECK-NUM-3.
	MOVE DATA-12 TO NUM-IT-2.
	EXAMINE DATA-12 REPLACING ALL SPACES BY ZEROS.
	IF DATA-12 NOT NUMERIC GO TO ERROR-3.
	IF (NUM-IT-2 > ZERO) AND (NUM-IT-2 < 100)
		MOVE NUM-IT-2 TO DNI-1
		MOVE IND-1 TO DATA-A (3)
		GO TO END-EDIT-3.
	GO TO ERROR-3.
CHECK-NUM-3.
	IF DATA-2 NOT NUMERIC
		GO TO ERROR-3.
	IF DATA-2 = ZERO
		GO TO ERROR-3.
	IF DATA-2 = "9" AND DATA-1 = "U"
		GO TO ERROR-3.
MOVE-3.
	MOVE DATA-12 TO IND-1.
	MOVE IND-1 TO DATA-A (3).
	GO TO END-EDIT-3.
ERROR-3.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , ,1-99,L1-L9,LR,MR," WITH NO ADVANCING.
	ADD 1 TO I.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " H1-H9,U1-U8,OA-OG, OR OV".
	SUBTRACT 1 FROM I.
	MOVE "X" TO ERROR-CODE.
END-EDIT-3.
	EXIT.
EDIT-4.
	MOVE DATA-A (4) TO THE-DATA.
	IF DATA-1 = SPACE OR "N"
		MOVE DATA-1 TO NOT-2
		MOVE NOT-2 TO DATA-A (4)
		GO TO END-EDIT-4.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , , OR N".
	MOVE "X" TO ERROR-CODE.
END-EDIT-4.
	EXIT.
EDIT-5.
	MOVE DATA-A (5) TO THE-DATA.
	IF DATA-12 = SPACE OR "LR" OR "MR" OR "OA" OR "OB" OR "OC"
		OR "OD" OR "OE" OR "OF" OR "OG" OR "OV"
		GO TO MOVE-5.
	IF DATA-1 = "L" OR "H" OR "U"
		GO TO CHECK-NUM-5.
	MOVE DATA-12 TO NUM-IT-2.
	EXAMINE DATA-12 REPLACING ALL SPACES BY ZEROS.
	IF DATA-12 NOT NUMERIC GO TO ERROR-5.
	IF (NUM-IT-2 > 0) AND (NUM-IT-2 < 100)
		MOVE  NUM-IT-2 TO DNI-2
		MOVE IND-2 TO DATA-A (5)
		GO TO END-EDIT-5.
	GO TO ERROR-5.
CHECK-NUM-5.
	IF DATA-2 NOT NUMERIC
		GO TO ERROR-5.
	IF DATA-2 = ZERO
		GO TO ERROR-5.
	IF DATA-2 = "9" AND DATA-1 = "U"
		GO TO ERROR-5.
MOVE-5.
	MOVE DATA-12 TO IND-2.
	MOVE IND-2 TO DATA-A (5).
	GO TO END-EDIT-5.
ERROR-5.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY "ENTER , ,1-99,L1-L9,LR,MR," WITH NO ADVANCING.
	ADD 1 TO I.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " H1-H9,U1-U8,OA-OG, OR OV".
	SUBTRACT 1 FROM I.
	MOVE "X" TO ERROR-CODE.
	GO TO END-EDIT-5.
END-EDIT-5.
	EXIT.
EDIT-6.
	MOVE DATA-A (6) TO THE-DATA.
	IF DATA-1 = SPACE OR "N"
		MOVE DATA-1 TO NOT-3
		MOVE NOT-3 TO DATA-A (6)
		GO TO END-EDIT-6.
ERROR-6.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , , OR N".
	MOVE "X" TO ERROR-CODE.
END-EDIT-6.
	EXIT.
EDIT-7.
	MOVE DATA-A (7) TO THE-DATA.
	IF DATA-12 = SPACE OR "LR" OR "MR" OR "OA" OR "OB" OR "OC"
		OR "OD" OR "OE" OR "OF" OR "OG" OR "OV"
		GO TO MOVE-7.
	IF DATA-1 = "L" OR "H" OR "U"
		GO TO CHECK-NUM-7.
	MOVE DATA-12 TO NUM-IT-2.
	EXAMINE DATA-12 REPLACING ALL SPACES BY ZEROS.
	IF DATA-12 NOT NUMERIC GO TO ERROR-7.
	IF (NUM-IT-2 > ZERO) AND (NUM-IT-2 < 100)
		MOVE NUM-IT-2 TO DNI-3
		MOVE IND-3 TO DATA-A (7)
		GO TO END-EDIT-7.
	GO TO ERROR-7.
CHECK-NUM-7.
	IF DATA-2 NOT NUMERIC
		GO TO ERROR-7.
	IF DATA-2 = ZERO
		GO TO ERROR-7.
	IF DATA-1 = "U" AND DATA-2 = "9"
		GO TO ERROR-7.
MOVE-7.
	MOVE DATA-12 TO IND-3.
	MOVE IND-3 TO DATA-A (7).
	GO TO END-EDIT-7.
ERROR-7.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , ,1-99,L1-L9,LR,MR," WITH NO ADVANCING.
	ADD 1 TO I.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " H1-H9,U1-U8,OA-OG, OR OV".
	SUBTRACT 1 FROM I.
	MOVE "X" TO ERROR-CODE.
END-EDIT-7.
	EXIT.
EDIT-8.
	MOVE DATA-A (8) TO THE-DATA.
	MOVE DATA-110 TO FAC-1.
	MOVE FAC-1 TO DATA-A (8).
END-EDIT-8.
	EXIT.
EDIT-9.
	MOVE DATA-A (9) TO THE-DATA.
	IF DATA-15 = SPACES
		GO TO MOVE-9.
	IF DATA-15 = "ADD" OR "Z-ADD" OR "SUB" OR "Z-SUB"
		OR "MULT" OR "DIV" OR "MVR" OR "XFOOT" OR "SQRT"
		GO TO MOVE-9.
	IF DATA-15 = "MOVE" OR "MOVEL" OR "MOVEA"
		GO TO MOVE-9.
	IF DATA-15 = "MLLZO" OR "MHHZO" OR "MLHZO" OR "MHLZO"
		GO TO MOVE-9.
	IF DATA-15 = "COMP" OR "TESTZ" OR "TESTN"
		GO TO MOVE-9.
	IF DATA-15 = "BITON" OR "BITOF" OR "TESTB"
		GO TO MOVE-9.
	IF DATA-15 = "SETON" OR "SETOF"
		GO TO MOVE-9.
	IF DATA-15 = "GOTO" OR "TAG"
		GO TO MOVE-9.
	IF DATA-15 = "EXIT" OR "RLABL" OR "ULABL"
		GO TO MOVE-9.
	IF DATA-15 = "LOKUP"

		GO TO MOVE-9.
	IF DATA-15 = "BEGSR" OR "ENDSR" OR "EXSR"
		GO TO MOVE-9.
	IF DATA-15 = "FORCE" OR "EXCPT" OR "DSPLY" OR "READ"
		OR "CHAIN" OR "SETLL"
		GO TO MOVE-9.
	IF DATA-15 = "DEBUG"
		GO TO MOVE-9.
	IF DATA-15 = "TIME"
		GO TO MOVE-9.
	GO TO ERROR-9.
MOVE-9.
	MOVE DATA-15 TO OPER.
	MOVE OPER TO DATA-A (9).
	GO TO END-EDIT-9.
ERROR-9.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " LOOK FOR OPERATIONS IN MANUAL".
	MOVE "X" TO ERROR-CODE.
END-EDIT-9.
	EXIT.
EDIT-10.
	MOVE DATA-A (10) TO THE-DATA.
	MOVE DATA-110 TO FAC-2.
	MOVE FAC-2 TO DATA-A (10).
END-EDIT-10.
	EXIT.
EDIT-11.
	MOVE DATA-A (11) TO THE-DATA.
	MOVE DATA-16 TO RES-FIE.
	MOVE RES-FIE TO DATA-A (11).
END-EDIT-11.
	EXIT.
EDIT-12.
	MOVE DATA-A (12) TO THE-DATA.
	IF DATA-13 = SPACE
		MOVE DATA-13 TO FIE-LEN
		MOVE FIE-LEN TO DATA-A (12)
		GO TO END-EDIT-12.
	MOVE DATA-13 TO NUM-IT-3.
	EXAMINE DATA-13 REPLACING ALL SPACES BY ZEROS.
	IF DATA-13 NOT NUMERIC GO TO ERROR-12.
	IF (NUM-IT-3 > ZERO) AND (NUM-IT-3 < 257)
		MOVE NUM-IT-3 TO LEN-FIE
		MOVE FIE-LEN TO DATA-A (12)
		GO TO END-EDIT-12.
ERROR-12.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , , OR 1-256".
	MOVE "X" TO ERROR-CODE.
END-EDIT-12.
	EXIT.
EDIT-13.
	MOVE DATA-A (13) TO THE-DATA.
	IF DATA-1 = SPACE OR DATA-1 NUMERIC
		MOVE DATA-1 TO DEC-POS
		MOVE DEC-POS TO DATA-A (13)
		GO TO END-EDIT-13.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " EMTER , , OR 1-9".
	MOVE "X" TO ERROR-CODE.
END-EDIT-13.
	EXIT.
EDIT-14.
	MOVE DATA-A (14) TO THE-DATA.
	IF DATA-1 = SPACE OR "H"
		MOVE DATA-1 TO HAL-ADJ
		MOVE HAL-ADJ TO DATA-A (14)
		GO TO END-EDIT-14.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , , OR H".
	MOVE "X" TO ERROR-CODE.
END-EDIT-14.
	EXIT.
EDIT-15.
	MOVE DATA-A (15) TO THE-DATA.
	IF DATA-12 = SPACE OR "LR" OR "OA" OR "OB" OR "OC"
		OR "OD" OR "OE" OR "OF" OR "OG" OR "OV"
		GO TO MOVE-15.
	IF DATA-1 = "H" OR "L"
		GO TO CHECK-NUM-15.
	MOVE DATA-12 TO NUM-IT-2.
	EXAMINE DATA-12 REPLACING ALL SPACES BY ZEROS.
	IF DATA-12 NOT NUMERIC GO TO ERROR-15.
	IF (NUM-IT-2 > ZERO) AND (NUM-IT-2 < 100)
		MOVE NUM-IT-2 TO IT-HIGH
		MOVE HIGH-IT TO DATA-A (15)
		GO TO END-EDIT-15.
	GO TO ERROR-15.
CHECK-NUM-15.
	IF DATA-2 NOT NUMERIC
		GO TO ERROR-15.
	IF DATA-2 = ZERO
		GO TO ERROR-15.
MOVE-15.
	MOVE DATA-12 TO HIGH-IT.
	MOVE HIGH-IT TO DATA-A (15).
	GO TO END-EDIT-15.
ERROR-15.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , ,1-99,H1-H9,L1-L9," WITH NO ADVANCING.
	ADD 1 TO I.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " LR,OA-OG, OR OV".
	SUBTRACT 1 FROM I.
	MOVE "X" TO ERROR-CODE.
END-EDIT-15.
	EXIT.
EDIT-16.
	MOVE DATA-A (16) TO THE-DATA.
	IF DATA-12 = SPACE OR "LR" OR "OA" OR "OB" OR "OC"
		OR "OD" OR "OE" OR "OF" OR "OG" OR "OV"
		GO TO MOVE-16.
	IF DATA-1 = "H" OR "L"
		GO TO CHECK-NUM-16.
	MOVE DATA-12 TO NUM-IT-2.
	EXAMINE DATA-12 REPLACING ALL SPACES BY ZEROS.
	IF DATA-12 NOT NUMERIC GO TO ERROR-16.
	IF (NUM-IT-2 > ZERO) AND (NUM-IT-2 < 100)
		MOVE NUM-IT-2 TO IT-LOW
		MOVE LOW-IT TO DATA-A (16)
		GO TO END-EDIT-16.
	GO TO ERROR-16.
CHECK-NUM-16.
	IF DATA-2 NOT NUMERIC
		GO TO ERROR-16.
	IF DATA-2 = ZERO
		GO TO ERROR-16.
MOVE-16.
	MOVE DATA-12 TO LOW-IT.
	MOVE LOW-IT TO DATA-A (16).
	GO TO END-EDIT-16.
ERROR-16.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , ,1-99,H1-H9,L1-L9," WITH NO ADVANCING.
	ADD 1 TO I.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " LR,OA-OG, OR OV".
	SUBTRACT 1 FROM I.
	MOVE "X" TO ERROR-CODE.
END-EDIT-16.
	EXIT.
EDIT-17.
	MOVE DATA-A (17) TO THE-DATA.
	IF DATA-12 = SPACE OR "LR" OR "OA" OR "OB" OR "OC"
		OR "OD" OR "OE" OR "OF" OR "OG" OR "OV"
		GO TO MOVE-17.
	IF DATA-1 = "H" OR "L"
		GO TO CHECK-NUM-17.
	MOVE DATA-12 TO NUM-IT-2.
	EXAMINE DATA-12 REPLACING ALL SPACES BY ZEROS.
	IF DATA-12 NOT NUMERIC GO TO ERROR-17.
	IF (NUM-IT-2 > ZERO) AND (NUM-IT-2 < 100)
		MOVE NUM-IT-2 TO IT-EQUAL
		MOVE EQUAL-IT TO DATA-A (17)
		GO TO END-EDIT-17.
	GO TO ERROR-17.
CHECK-NUM-17.
	IF DATA-2 NOT NUMERIC
		GO TO ERROR-17.
	IF DATA-2 = ZERO
		GO TO ERROR-17.
MOVE-17.
	MOVE DATA-12 TO EQUAL-IT.
	MOVE EQUAL-IT TO DATA-A (17).
	GO TO END-EDIT-17.
ERROR-17.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , ,1-99,H1-H9,L1-L9," WITH NO ADVANCING.
	ADD 1 TO I.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " LR,OA-OG, OR OV".
	SUBTRACT 1 FROM I.
	MOVE "X" TO ERROR-CODE.
END-EDIT-17.
	EXIT.
EDIT-18.
	MOVE DATA-A (18) TO THE-DATA.
	MOVE THE-DATA TO COMMENT.
	MOVE COMMENT TO DATA-A (18).
END-EDIT-18.
	EXIT.
WRITE-ADD.
	OPEN I-O PROGRAM-FILE.
	MOVE 1 TO PROGRAM-KEY.
	READ PROGRAM-FILE INVALID KEY
	DISPLAY "BAD READ " PROGRAM-KEY STOP RUN.
	MOVE PROGRAM-RECORD TO PROGRAM-ZERO.
	MOVE PROGRAM-LAST-REC TO PROGRAM-REC-NO PROGRAM-ACT-REC.
	ADD 1 TO PROGRAM-LAST-REC.
	MOVE PROGRAM-LAST-REC TO PROGRAM-KEY.
	MOVE THE-FILE TO PROGRAM-IDENT.
	MOVE THE-PAGE TO PROGRAM-PAGE.
	MOVE THE-LINE TO PROGRAM-LINE.
	MOVE THE-FORM TO PROGRAM-FORM.
	MOVE PROG-INFO TO PROGRAM-INFO.
	MOVE PROGRAM-MAIN TO PROGRAM-RECORD.
WRITE-ADD-A.
	WRITE PROGRAM-RECORD INVALID KEY
	DISPLAY "BAD WRITE " PROGRAM-KEY STOP RUN.
	MOVE 1 TO PROGRAM-KEY.
	MOVE PROGRAM-ZERO TO PROGRAM-RECORD.
	WRITE PROGRAM-RECORD INVALID KEY
	DISPLAY "BAD WRITE " PROGRAM-KEY STOP RUN.
	CLOSE PROGRAM-FILE.
END-WRITE-ADD.
	EXIT.
END-IT.
	MOVE PROGRAM-NAME TO THE-FILE.
	MOVE "RPGSYS" TO NEXT-PROGRAM.
	ENTER MACRO SYSPRG USING NEXT-PROGRAM, PASS-IT.
END-PROGRAM.
	STOP RUN.
