      SUBROUTINE DAGRID(JSTIFY,MAXWID,XLEFT,XRIGHT,MSHWID,
     1    LTROFF)
 C     RENBR(/RATIONALIZE SCALE OF PRINTER PLOT)
 C
  C     DONALD BARTH, HARVARD BUSINESS SCHOOL
C
  C     PROPORTIONS OF GRID SUPERIMPOSED UPON  PLOT  AREA  BY
    C     DAPLAT  ROUTINE MUST BE SPECIFIED BY CALLING PROGRAM.
    C     NUMBERS WHICH  ARE  PRINTED  BESIDE  AND  BELOW  PLOT
    C     MERELY  REPRESENT  DATA  UNIT  COORDINATES PLOTTED AT
    C     CENTERS OF COLUMNS AND LINES WHICH BEAR  GRID  LINES.
    C     RANGE  OF  DATA UNIT COORDINATES REPRESENTED BY THESE
    C     SCALES CAN  BE  DIFFICULT  TO  INTERPRET  IF  CALLING
    C     PROGRAM   HOLDS   GRID   PROPORTIONS  CONSTANT  WHILE
    C     ATTEMPTING TO OBTAIN MAXIMUM RESOLUTION BY  ADJUSTING
    C     MINIMUM  AND  MAXIMUM  COORDINATES  TO  SPREAD CURVES
    C     ACROSS FULL WIDTH OR HEIGHT OF PLOT.   DAPLAT  CANNOT
    C     ITSELF CALCULATE GRID PROPORTIONS WHICH WOULD PRODUCE
    C     MINIMUM  NUMBER  OF  NONZERO  DIGITS  IN  EACH  SCALE
    C     NUMBER.   IF  PREDETERMINED GRID SPACINGS AND OFFSETS
    C     ARE NOT NECESSARY, THEN ROUTINE DAGRID CAN BE  CALLED
    C     ONCE  FOR EACH SCALE BEFORE DATA IS PLOTTED TO SELECT
    C     GRID PROPORTIONS  AND  TO  EXPAND  COORDINATE  RANGES
    C     SLIGHTLY TO GIVE NEATER SCALE NUMBERS.
    C
  C     JSTIFY = -2, LEFT JUSTIFY LEFT GRID LINE
  C            = -1, LEFT JUSTIFY XLEFT
 C            = 0, CENTER RANGE
   C            = 1, RIGHT JUSTIFY XRIGHT
C            = 2, RIGHT JUSTIFY RIGHT GRID LINE
 C     MAXWID = WIDTH (OR HEIGHT) OF PLOT STATED  AS  NUMBER
    C              OF COLUMNS (OR LINES).
 C     XLEFT  = INPUT CONTAINING DATA UNIT COORDINATE TO  BE
    C              REPRESENTED  BY CENTER OF LEFT COLUMN (OR OF
    C              LOWER LINE) OF PLOT.
   C            = RETURNED  CONTAINING  DATA  UNIT  COORDINATE
    C              WHICH  WOULD  GIVE RATIONAL SCALE IF USED AS
    C              DATA UNIT COORDINATE REPRESENTED  BY  CENTER
    C              OF LEFT COLUMN (OR OF LOWER LINE) OF PLOT.
 C     XRIGHT = INPUT CONTAINING DATA UNIT COORDINATE TO  BE
    C              REPRESENTED BY CENTER OF RIGHT COLUMN (OR OF
    C              UPPER LINE) OF PLOT.
   C            = RETURNED  CONTAINING  DATA  UNIT  COORDINATE
    C              WHICH  WOULD  GIVE RATIONAL SCALE IF USED AS
    C              DATA UNIT COORDINATE REPRESENTED  BY  CENTER
    C              OF RIGHT COLUMN (OR OF UPPER LINE) OF PLOT.
C     MSHWID = RETURNED CONTAINING THE GRID DIVISION  WIDTH
    C              STATED  AS  THE NUMBER OF COLUMNS (OR HEIGHT
    C              STATED AS NUMBER OF LINES).  INPUT VALUE  OF
    C              MSHWID  IS  IGNORED.  A LINE SHOULD BE RULED
    C              EVERY MSHWID CHARACTERS ACROSS THE WIDTH (OR
    C              HEIGHT)  OF THE PLOT.  IF MSHWID IS RETURNED
    C              CONTAINING 10, THEN  9  COLUMNS  (OR  LINES)
    C              SHOULD APPEAR BETWEEN THE COLUMNS (OR LINES)
    C              BEARING GRID LINES.
    C            = 0,  RETURNED  IF  THIS  ROUTINE  COULD   NOT
    C              RATIONALIZE  THE  SCALE,  AS  FOR EXAMPLE IF
    C              XLEFT IS INPUT CONTAINING THE SAME VALUE  AS
    C              XRIGHT, OR IF MAXWID IS INPUT TOO SMALL.
   C     LTROFF = RETURNED CONTAINING THE  NUMBER  OF  COLUMNS
    C              (OR LINES) BY WHICH THE LEFT (OR LOWER) GRID
    C              LINE IS TO  BE  OFFSET  FROM  THE  LEFT  (OR
    C              LOWER)  EDGE  OF  THE  PLOT.  INPUT VALUE OF
    C              LTROFF IS IGNORED.  IF  LTROFF  IS  RETURNED
    C              CONTAINING  ZERO,  THEN  THE LEFT (OR LOWER)
    C              GRID LINE SHOULD  APPEAR  IN  THE  LEFT  (OR
    C              LOWER)  COLUMN  OF  THE  PLOT.  IF LTROFF IS
    C              RETURNED CONTAINING 5, THEN  5  COLUMNS  (OR
    C              LINES) OF THE PLOT AREA SHOULD APPEAR TO THE
    C              LEFT OF (OR BELOW) THE LEFTMOST (OR  LOWEST)
    C              GRID LINE.
   C
  C     SCALE RANGE TO BE BETWEEN 1.0 AND 9.999...
      IF(MAXWID.LE.0)GO TO 19
          KNTJST=0
          IF(JSTIFY.LE.0)GO TO 1
      FORMER=XLEFT
      XLEFT=XRIGHT
      XRIGHT=FORMER
        1 RANGE=XRIGHT-XLEFT
          IF(RANGE.LT.0.0)RANGE=-RANGE
          IF(RANGE.LE.0.0)GO TO 19
         SHIFTD=RANGE
      IPOWER=0
        2 IF(SHIFTD.GE.10.0)GO TO 3
        IF(SHIFTD.GE.1.0)GO TO 4
         IF(IPOWER.LT.-99)GO TO 19
        IF(IPOWER.GT.0)GO TO 4
      IPOWER=IPOWER-1
        SHIFTD=10.0*SHIFTD
          GO TO 2
    3 IF(IPOWER.GT.99)GO TO 19
         IF(IPOWER.LT.0)GO TO 4
      IPOWER=IPOWER+1
        SHIFTD=SHIFTD/10.0
          GO TO 2
C
  C     CALCULATE WIDTH OF EACH GRID DIVISION
    4 STEP=0.25
         IF(SHIFTD.GT.2.5)STEP=0.5
        IF(SHIFTD.GT.5.0)STEP=1.0
        STEP=STEP*(10.0**IPOWER)
         MSHWID=FLOAT(MAXWID-1)*(STEP/RANGE)
        IF(MSHWID.LE.0)GO TO 19
          IF(JSTIFY.NE.0)GO TO 5
      HLFWID=0.5*STEP*(FLOAT(MAXWID-1)/FLOAT(MSHWID))
      IF(XLEFT.GT.XRIGHT)HLFWID=-HLFWID
          CENTER=(XLEFT+XRIGHT)/2.0
        XLEFT=CENTER-HLFWID
         XRIGHT=CENTER+HLFWID
  C
  C     GET INTEGRAL MULTIPLE OF STEP WHICH IS JUST GREATER
 C     THAN OR EQUAL TO ABSOLUTE VALUE OF LEFT EDGE OF PLOT
    5 ORIGIN=STEP
       KOUNT=0
      COMPAR=XLEFT
      IF(COMPAR.LT.0.0)COMPAR=-COMPAR
     6 IF(ORIGIN.GE.COMPAR)GO TO 7
      IF(KOUNT.GE.10)GO TO 19
          KOUNT=KOUNT+1
          ORIGIN=10.0*ORIGIN
          GO TO 6
    7 SEARCH=ORIGIN
        8 LIMIT=10
        9 FORMER=ORIGIN
          ORIGIN=ORIGIN-SEARCH
        IF(ORIGIN.LT.COMPAR)GO TO 10
          LIMIT=LIMIT-1
          IF(LIMIT.GT.0)GO TO 9
       GO TO 11
       10 ORIGIN=FORMER
       11 IF(KOUNT.LE.0)GO TO 12
      SEARCH=SEARCH/10.0
          KOUNT=KOUNT-1
          GO TO 8
C
  C     ADJUST ORIGIN FOR DIRECTION AND SIGN OF LEFT EDGE
      12 IF(XLEFT.LE.XRIGHT)GO TO 14
      STEP=-STEP
        IF(XLEFT.LT.0.0)GO TO 13
         ORIGIN=ORIGIN+STEP
          GO TO 15
       13 ORIGIN=-ORIGIN
         GO TO 15
       14 IF(XLEFT.GE.0.0)GO TO 15
         ORIGIN=-ORIGIN+STEP
   C
  C     CALCULATE GRID PROPORTIONS
    15 LTROFF=0.5+(FLOAT(MSHWID)*((ORIGIN-XLEFT)/STEP))
          IF(LTROFF.LT.MSHWID)GO TO 16
          LTROFF=LTROFF-MSHWID
        ORIGIN=ORIGIN-STEP
       16 IF(LTROFF.LE.0)GO TO 17
          IF(JSTIFY.LT.-1)GO TO 18
         IF(JSTIFY.GT.1)GO TO 18
       17 XLEFT=ORIGIN-(STEP*(FLOAT(LTROFF)/FLOAT(MSHWID)))
         XRIGHT=ORIGIN+(STEP*(FLOAT(MAXWID-1-LTROFF)/
        1FLOAT(MSHWID)))
        IF(JSTIFY.LE.0)GO TO 20
          FORMER=XLEFT
      XLEFT=XRIGHT
      XRIGHT=FORMER
          LTROFF=MAXWID-LTROFF-1
      LTROFF=LTROFF-(MSHWID*(LTROFF/MSHWID))
          GO TO 20
    C
  C     LOOP BACK IF NEED TO JUSTIFY GRID
       18 XLEFT=ORIGIN-STEP
      KNTJST=KNTJST+1
        IF(KNTJST.LE.5)GO TO 1
C
  C     ERROR CONDITION
     19 MSHWID=0
          LTROFF=0
    C
  C     RETURN TO CALLING PROGRAM
     20 RETURN
 C635919530735
      END
    
