	SUBROUTINE DOSTF
	INCLUDE 'SYSREP.PRM'
	COMMON/HALSTF/ KRASH,KERROR
	REAL ZRESP
C
C	SYSTEM ANALYSIS AND DISPATCH MODULE
C
C	VARIABLE DEFINITIONS:
C
C	SEC	SECONDS IN TIME SPAN
C	BSPIN	BLOCKS SWAPPED IN
C	BSPOUT	BLOCKS SWAPPED OUT
C	TBPIO	TOTAL SWAPPED BLOCKS
C	TBPIOT	TBPIO/100
C	TWDCL	TOTAL WORDS CLEARED
C	SWERCT	SYSTEM-WIDE ERROR COUNT
C	RCVINT	RECIEVE INTERRUPTS
C	XMTINT	TRANSMIT INTERRUPTS
C	ECHINT	ECHO INTERRUPTS
C	ACTLN	NUMBER OF ACTIVE LINES
C	RCVD1K	RCVINT/1000
C	XMTD1K	XMTINT/1000
C	TOTUUO	TOTAL UUOS
C	ZTWDCL	WORDS CLEARED PER SECOND
C	ZTUUO	UUO'S PER SECOND
C	JCNSW	JOB CONTEXT SWITCHES
C	ZCNSW	JOB CONTEXT SWITCHES PER SECOND
C	CMD	TOTAL COMMANDS
C	LOGNUM	NUMBER LOGGED IN
C	HORR	CPU RESPONSE
C	HORS	CPU RESPONSE
C	ZRESP	RESPONSE TIME (HORR/HORS)
C	TOTJIF	TOTAL JIFFIES IN TIME SPAN
C	LOSTIM	LOST TIME (JIFFIES)
C	NULTIM	NULL TIME (JIFFIES)
C	OVHTIM	OVERHEAD TIME (JIFFIES)
C	IDLTIM	IDLE TIME (NULL-LOST)
C	ZLOST	PERCENT LOST TIME
C	ZNULL	PERCENT NULL TIME
C	ZOVH	PERCENT OVERHEAD TIME
C	ZUSER	PERCENT USER TIME
C	CORMAX	MAXIMUM CORE
C
C
C	-SEE IF SPECAIL CRASH
C
	IF (LSH(REC000(1,2),-18) .EQ. 200) GOTO 20
	IF (LSH(REC000(1,2),-18) .EQ. 300) GOTO 30
C
C	--DO DISKS FIRST
C
	CALL DSKOUT
C
C	--NOW FOR THE SCHEDULER
C
	CALL SCHOUT
1000	FORMAT(/,14X,10('* Restart *')/)
1010	FORMAT(/,14X,6('* Restart *')/)
C
C	--GET NUMBER OF SECONDS
C
	SEC = MAKSEC(REC000(10,1),REC000(10,2))
C
C	--GET BLOCKS SWAPPED IN/OUT
C
	BSPIN = REC401(2,2)-REC401(2,1)
	BSPOUT = REC401(3,2)-REC401(3,1)
	TBPIO = BSPIN+BSPOUT
	CALL PLTIT(TBPIO,9)
	TBPIOT = TBPIO/100
C
C	--GET TOTAL WORDS CLEARED
C
	TWDCL = REC401(8,2)-REC401(8,1)
C
C	--GET NUMBER OF SYSTEM ERRORS
C
	SWERCT = REC401(9,2)-REC401(9,1)
	KERROR = KERROR + SWERCT
C
C	--GET SCANNER STATS
C
	RCVINT = REC402(2,2)-REC402(2,1)
	XMTINT = REC402(3,2)-REC402(3,1)
	ECHINT = REC402(4,2)-REC402(4,1)
	RCVD1K = RCVINT/1000
	XMTD1K = XMTINT/1000
	ACTLN = REC402(5,2)
	CALL PLTIT(ACTLN,7)
C
C	--GET TOTAL UUO'S EXECUTED
C
	TOTUUO = REC501(8,2)-REC501(8,1)
C
C	--GET TOTAL WORDS CLEARED PER/FLOAT(SEC)
C
	ZTWDCL = TWDCL/SEC
	CALL PLTIT(ZTWDCL,6)
C
C	--GET TOTAL UUO'S PER/FLOAT(SEC)
C
	ZTUUO = TOTUUO/SEC
	CALL PLTIT(ZTUUO,4)
C
C	--GET JOB CONTEXT SWITCHES PER/FLOAT(SEC)
C
	JCNSW = REC501(9,2)-REC501(9,1)
	ZCNSW = JCNSW/SEC
	CALL PLTIT(ZCNSW,5)
C
C	--GET NUMBER OF COMMANDS PROCESSED
C
	CMD = REC401(11,2)-REC401(11,1)
	CALL PLTIT(CMD,2)
C
C	--GET CORMAX
C
	CORMAX = REC401(12,2)
	CORMAX = CORMAX/1000
C
C	--GET LOGNUM AND PERCNT OF TOTAL
C
	LOGNUM = REC401(6,2)
	CALL PLTIT(LOGNUM,1)
C
C	--GET SYSTEM RESPONSE TIME
C
	HORR = REC501(2,2)-REC501(2,1)
	HORS = REC501(3,2)-REC501(3,1)
	ZRESP = 0.0
	IF (HORS .EQ. 0) GOTO 50
	ZRESP = FLOAT(HORR)/FLOAT(HORS)
50	KRESP = IFIX(ZRESP)
	CALL PLTIT(KRESP,14)
C
C	--GET TOTAL JIFFIES IN SPAN (ALSO LOST,NULL,OVHD)
C
	TOTJIF = REC501(4,2)-REC501(4,1)
	LOSTIM = REC501(5,2)-REC501(5,1)
	NULTIM = REC501(6,2)-REC501(6,1)
	OVHTIM = REC501(7,2)-REC501(7,1)
	IDLTIM = NULTIM-LOSTIM
C
C	--GET PERCENTAGES
C
	ZLOST = ((LOSTIM*100)/TOTJIF)
	ZNULL = ((IDLTIM*100)/TOTJIF)  !REALLY IDLE TIME. THANKS AUSTIN!
	ZOVH  = ((OVHTIM*100)/TOTJIF)
	ZUSER = 100-(ZLOST+ZNULL+ZOVH)
C
C	--IN CASE %USER LESS THAN ZERO PERCENT
C
	IF (ZUSER .LT. 0) ZUSER  = 0
	CALL PLTIT(ZLOST,3)
	CALL PLTIT(ZNULL,11)
	CALL PLTIT(ZOVH,12)
	CALL PLTIT(ZUSER,13)
	CALL DTOUT(X1,X2,1)
	CALL DTOUT(Y1,Y2,2)
	IF (REC000(9,1) .EQ. REC000(9,2)) CALL SKONTM(REC000
	1(9,1),22)
10	FORMAT(1X,I2,':',2I1,2X,I2,':',2I1,3X,F5.1,3X,I3,3X,I3,2X
	1,I6,3X,I3,3X,I3,3X,I3,3X,I3,3X,I4,2X,I4
	2,1X,I5,3X,I3,4X,I5,3X,I4,4X,I4,4X,I5)
	WRITE(22,10) REC000(9,1),X1,X2,REC000(9,2)
	1,Y1,Y2,ZRESP,LOGNUM,SWERCT,CMD,ZNULL,ZLOST
	2,ZOVH,ZUSER,ZTUUO,ZCNSW,ZTWDCL,ACTLN,TBPIOT,RCVD1K,XMTD1K
	3,CORMAX
	RETURN
C
C	--RECOVER FROM CRASH
C
20	WRITE(22,1000)
	WRITE(24,1010)
	WRITE(23,1000)
	GOTO 40
30	WRITE(22,1000)
	WRITE(23,1000)
	WRITE(24,1010)
40	KRASH = KRASH+1
	RETURN
	END
   
