
IDENTIFICATION DIVISION.

PROGRAM-ID. SLEEPPER.
REMARKS.
	PROGRAM TO CALL THE MACRO SUBROUTINE COBSLP
	WITH A PARAMETER AREA SET UP. THE PROGRAM
	THEN GOES TO SLEEP WITH THE SPECIFIED ENABLE
	BITS SET AND FOR THE SPECIFIED INTERVAL.
	ENTERS DDT IF "DDT" OR "DEB" IS ENTERED FOR
	ENABLE BITS. [DDT EXECUTION IS DEPENDENT
	UPON THE LOADING OF DDT FROM THE SYSTEM
	LIBRARY [1,4].

	*** DEVELOPED AS A TEST FOR THE SLEEP ROUTINE COBSLP ***

AUTHOR.	DAVID RICHARD KIARSIS.
INSTALLATION.	REYNOLDS AND REYNOLDS.
DATE-WRITTEN.  25-JAN-72.
DATE-COMPILED.  25-JAN-72.
SECURITY.	TOP SECRET.

ENVIRONMENT DIVISION.

CONFIGURATION SECTION.

SOURCE-COMPUTER. PDP-10.
OBJECT-COMPUTER. PDP-10.

DATA DIVISION.

WORKING-STORAGE SECTION.

01	WAIT-ARGUMENTS.
	02	WAIT-BITS	PIC	X(6).
	02	WAIT-TIME	PIC	S9(5)	COMP.

PROCEDURE DIVISION.

START-THE-RUN.
	DISPLAY "INITIAL ENABLE BITS --> _".
	ACCEPT	WAIT-BITS.
	MOVE 0 TO WAIT-TIME.
	ENTER MACRO COBSLP USING WAIT-ARGUMENTS.
	DISPLAY "JOB NUMBER--> ",WAIT-BITS.

BEGIN.
	DISPLAY " ".
	DISPLAY "ENABLE BITS--_".
	ACCEPT WAIT-BITS.
	IF WAIT-BITS EQUALS "STOP" OR "EXIT"
		GO TO STOP-THE-RUN.
	IF WAIT-BITS EQUALS "DDT" OR "DEB"
		GO TO FIX-LITTLE-BUG.

	DISPLAY "SLEEP TIME--_".
	ACCEPT	WAIT-TIME.

GO-TO-SLEEP.
	ENTER MACRO COBSLP USING WAIT-ARGUMENTS.

BACK-FROM-LITTLE-SLEEP.
	IF WAIT-BITS EQUALS "TTY"
		DISPLAY "TELETYPE WOKE ME."
			GO TO BEGIN.
	IF WAIT-BITS EQUALS SPACES
		DISPLAY "NON-TELETYPE WAKE UP."
			GO TO BEGIN.
	IF WAIT-BITS EQUALS "ERROR"
		DISPLAY "COULDN'T GO TO SLEEP."
			GO TO BEGIN.
	DISPLAY "***UNKNOW RETURN--> ",WAIT-BITS.

FIX-LITTLE-BUG.
	DISPLAY " ".
	DISPLAY "DEBUGGER HERE_"
	ENTER MACRO DDT.

RETURN-FROM-BUG.
	DISPLAY " ".
	DISPLAY "RETURN FROM BUG".
		GO TO BEGIN.

STOP-THE-RUN.
	DISPLAY "***SLEEPPER ENDED".
	STOP RUN.
