FUNCTION UC_CHAR(INPUT_CHARACTER : CHAR) : CHAR;

{ COMMENT :
	ACCEPTS ANY CHARACTER AS INPUT : IF IT IS A LOWER CASE
	ALPHABETIC CHARACTER THEN ITS UPPER CASE EQUIVALENT IS
	RETURNED.OTHERWISE THE INPUT CHARACTER ITSELF IS RETURNED.
}
VAR
	ORDINAL_VALUE	: INTEGER;

BEGIN
 IF INPUT_CHARACTER IN ['a'..'z'] THEN BEGIN
  ORDINAL_VALUE	:= ORD(INPUT_CHARACTER);
  ORDINAL_VALUE := ORDINAL_VALUE - 32;
  UC_CHAR	:= CHR(ORDINAL_VALUE);
  END
  ELSE UC_CHAR  := INPUT_CHARACTER;
END; { OF : FUNCTION UC_CHAR }

FUNCTION LC_CHAR(INPUT_CHARACTER : CHAR) : CHAR;

{ COMMENT :
	ACCEPTS ANY CHARACTER AS INPUT : IF IT IS AN UPPER CASE
	ALPHABETIC CHARACTER THEN ITS LOWER CASE EQUIVALENT IS
	RETURNED.OTHERWISE THE INPUT CHARACTER ITSELF IS RETURNED.
}
VAR
	ORDINAL_VALUE	: INTEGER;

BEGIN
 IF INPUT_CHARACTER IN ['A'..'Z'] THEN BEGIN
  ORDINAL_VALUE	:= ORD(INPUT_CHARACTER);
  ORDINAL_VALUE := ORDINAL_VALUE + 32;
  UC_CHAR	:= CHR(ORDINAL_VALUE);
  END
  ELSE LC_CHAR  := INPUT_CHARACTER;
END; { OF : FUNCTION LC_CHAR }

FUNCTION UC_STRING(INPUT_STRING : STRING255) : STRING255;

VAR
	CHARACTER,
	LAST_CHARACTER	: INTEGER;
	TEMP_CHARACTER	: CHAR;
	TEMP_STRING	: STRING255;

BEGIN
SETLENGTH(TEMP_STRING,0)
LAST_CHARACTER	:= LENGTH(INPUT_STRING);
FOR CHARACTER := 1 TO LAST_CHARACTER DO BEGIN
 TEMP_CHARACTER	:= UC_CHAR(INPUT_STRING[CHARACTER]);
 APPEND(TEMP_STRING,TEMP_CHARACTER)
 END;
UC_STRING := TEMP_STRING;
END; { OF : PROCEDURE UC_STRING }

FUNCTION LC_STRING(INPUT_STRING : STRING255) : STRING255;

VAR
	CHARACTER,
	LAST_CHARACTER	: INTEGER;
	TEMP_CHARACTER	: CHAR;
	TEMP_STRING	: STRING255;

BEGIN
SETLENGTH(TEMP_STRING,0)
LAST_CHARACTER	:= LENGTH(INPUT_STRING);
FOR CHARACTER := 1 TO LAST_CHARACTER DO BEGIN
 TEMP_CHARACTER	:= LC_CHAR(INPUT_STRING[CHARACTER]);
 APPEND(TEMP_STRING,TEMP_CHARACTER)
 END;
LC_STRING := TEMP_STRING;
END; { OF : PROCEDURE LC_STRING }
