	REM -------FILE BIBSRCH.BAS

	REM FIRST SEGMENT OF BIBLIOGRAPHY SEARCH ROUTINE
	COMMON KEYWD$(1),LIBNAME$,RLEN%,TRUE%,AUTH.LEN%,TITL.LEN%
	COMMON MAXBIB%,MAXDESC%,MAXDEF%,MAXKEYS%,MAXCON%,CONCEPT$(1)
	COMMON ISS.LEN%,CLEAR$$,EFF%,JOUR.LEN%,KWD.LEN%,CMD$(1)
	COMMON LFT%(1),RGHT%(1),CON.KEY%(2),CON.RATE(2),QUERY$,L%

	DIM LFT%(MAXCON%), CONCEPT$(MAXCON%), CON.KEY%(MAXCON%,MAXDEF%+1)
	DIM CON.RATE(MAXCON%,MAXDEF%+1),RGHT%(MAXCON%),CMD$(MAXCON%)
	CONSOLE:ERR%=0
	XBLANK$="                                            "

	REM FUNCTION TO RECOGNIZE FUZZY OPERATORS AND PARENS
	DEF FNSPEC.CH%(DUM$,POSIT%)
	CH$=MID$(DUM$,POSIT%,1)
	FNSPEC.CH%=0
	IF (CH$="#") OR ((CH$>="'") AND (CH$<="+")) THEN FNSPEC.CH%=-1
	RETURN
	FEND

	PRINT CLEAR$$
	PRINT TAB(12); "--------BIBLIOGRAPHY SEARCH--------":PRINT

	REM READ KEYWORD VOCABULARY

	REM IF NO VOCABULARY FILE EXIT TO SYSTEM
	IF END #1 THEN 34E1
	OPEN LIBNAME$+".VOC" AS 1
	IF SIZE(LIBNAME$+".VOC")=0 THEN DELETE 1 : GOTO 34E1

	REM OTHERWISE READ IT ALL
	IF END #1 THEN 33E1
	VOC.LEN%=1
	WHILE TRUE%
  	READ #1; LINE KEYWD$(VOC.LEN%)
  	VOC.LEN%=VOC.LEN%+1
  	WEND

33E1    CLOSE 1:VOC.LEN%=VOC.LEN%-1

	REM IF NO BIBLIO FILE, EXIT TO SYSTEM
	IF END #2 THEN 34E1
	OPEN LIBNAME$+".BIB" AS 2
	IF SIZE(LIBNAME$+".BIB")=0 THEN DELETE 2 : GOTO 34E1
	CLOSE 2

	REM OTHERWISE GET A QUERY, CHECK SYNTAX AND PARSE
	GOSUB 1E1

	REM THEN DEFINE QUERY IN TERMS OF KEYWORDS IN VOCABULARY
	GOSUB 18E1

	REM NOW TO THE REST OF SEARCH ROUTINE
	CHAIN "BIBSR2"
	STOP

	REM GET AND PARSE AN INTERROGATION PHRASE

1E1 	ERR%=0

1.2E1   QUERY$=""
	PRINT "ENTER INTERROGATION PHRASE"
	INPUT ">"; LINE QUERY$:QUERY$=UCASE$(QUERY$)

	REM ROUGH SYNTAX CHECK
	I%=1
	IF LEFT$(QUERY$,1)<>"(" THEN ERR%=3:GOSUB 9E1:ERR%=0:GOTO 1.2E1
	PAREN%=0
	WHILE I%<=LEN(QUERY$)
  	IF MID$(QUERY$,I%,1)="(" THEN PAREN%=PAREN%+1
  	IF MID$(QUERY$,I%,1)=")" THEN PAREN%=PAREN%-1
  	I%=I%+1
  	WEND
	IF PAREN% THEN ERR%=4 : GOSUB 9E1: ERR%=0 : GOTO 1.2E1

	REM NOW TO PARSE
	PTR.ONE%=1 : PTR.TWO%=1: L%=0

1.1E1   WHILE (FNSPEC.CH%(QUERY$,PTR.ONE%)) AND (PTR.ONE%<LEN(QUERY$))
  	PTR.ONE%=PTR.ONE%+1
  	WEND

	IF PTR.ONE%>=LEN(QUERY$) THEN RETURN
	L%=L%+1:LFT%(L%)=PTR.ONE%:PTR.TWO%=PTR.ONE%

	WHILE NOT FNSPEC.CH%(QUERY$,PTR.TWO%)
  	PTR.TWO%=PTR.TWO%+1
  	WEND

	RGHT%(L%)=PTR.TWO%
        CONCEPT$(L%)=MID$(QUERY$,LFT%(L%),RGHT%(L%)-LFT%(L%))
        PTR.ONE%=PTR.TWO%:GOTO 1.1E1
	RETURN

9E1     REM ERROR COMMENTOR
	ON ERR% GOTO 9.1E1,9.4E1,9.5E1,9.6E1

9.1E1   PRINT "AN ILLEGAL KEYWORD INPUT--";:GOTO 9.3E1

9.2E1   PRINT "RATINGS MUST BE IN RANGE 0.0...1.0--";:GOTO 9.3E1

9.4E1   PRINT "ENTIRE PHRASE MUST BE ENCLOSED IN PARENS--";:GOTO 9.3E1

9.5E1   PRINT "RIGHT AND LEFT PARENS MUST BE BALANCED--";:GOTO 9.3E1

9.6E1   PRINT "KEYWORDS MAY NOT CONTAIN BLANKS--";

9.3E1   PRINT "RE-ENTER PHRASE":RETURN

18E1    REM DEFINE CONCEPTS IN TERMS OF KEYWORDS
	PRINT "PLEASE DEFINE EACH OF THE CONCEPTS YOU HAVE ENTERED"
	PRINT "IN TERMS OF KEYWORDS AND THEIR APPLICABILITY"
	PRINT "EXAMPLE : THEORY 0.6 APPLICATIONS 0.8":PRINT
	FOR J%=1 TO L%

18.3E1  KEY%=0:PRINT CONCEPT$(J%);:INPUT ": "; LINE CMD$(J%)
  	CMD$(J%)=UCASE$(CMD$(J%)):SW%=-1 : I%=1

	WHILE (I%<LEN(CMD$(J%))) AND (KEY%<MAXDEF%)

    	WHILE MID$(CMD$(J%),I%,1)=" " : I%=I%+1 : WEND

	DUM$=RIGHT$(CMD$(J%),LEN(CMD$(J%))-I%+1)
    	IF NOT SW% THEN 18.7E1
      	KEY%=KEY%+1:GOSUB 8E1:CON.KEY%(J%,KEY%)=KB%:SW%=0:GOTO 18.8E1

18.7E1  CH$=LEFT$(DUM$,1)
    	IF (CH$<>".") AND ((CH$<"0") OR (CH$>"9")) THEN \
      	   ERR%=5:GOSUB 9E1:ERR%=0:GOTO 18.3E1
    	IF CH$="." THEN CON.RATE(J%,KEY%)=VAL("0"+DUM$) \
           ELSE CON.RATE(J%,KEY%)=VAL(DUM$)
      	IF (CON.RATE(J%,KEY%)>1.0) OR (CON.RATE(J%,KEY%)<0.0) THEN \
           ERR%=2:GOSUB 9E1:ERR%=0:GOTO 18.3E1
        SW%=1

18.8E1  WHILE (MID$(CMD$(J%),I%,1)<>" ") AND (I%<LEN(CMD$(J%)))
      	I%=I%+1
      	WEND
    	WEND
    	CON.KEY%(J%,KEY%+1)=0 : CON.RATE(J%,KEY%+1)=0.0
  	NEXT J%:RETURN

8E1     REM BREAKOUT KEYWORD FROM INPUT STRING AND FIND NUMBER
	IR%=1
	WHILE MID$(DUM$,IR%,1)<>" " : IR%=IR%+1 : WEND
	WORD$=LEFT$(DUM$,IR%-1)+BLANK$:WORD$=LEFT$(WORD$,KWD.LEN%)
	REM BINARY SEARCH FOR WORD IN KEYWORD ARRAY
	IB%=1 : JB%=VOC.LEN%

8.1E1   KB%=(JB%+IB%)/2
	IF WORD$>KEYWD$(KB%) THEN IB%=KB%+1 ELSE JB%=KB%-1
	IF (WORD$<>KEYWD$(KB%)) AND (IB%<=JB%) THEN 8.1E1
	IF (WORD$<>KEYWD$(KB%)) THEN ERR%=1:GOSUB 9E1:ERR%=0:GOTO 18.3E1
	I%=IR%+I%-1:RETURN

	REM NO FILES

34E1    PRINT "NO LIBRARY FILE NAMED "; LIBNAME$
	INPUT "PRESS RETURN TO EXIT TO SYSTEM "; LINE ANS$
	STOP
