;This program patches MODEM7.COM so that operation on
;an Osborne 1 is achieved.
;
;  Written by J.A.O'Brien.
;
;THIS PATCH IS FOR:-
;		MODEM7.COM AS OF 12/18/80.
;
:The following console dialog
;installs the patches:-
;
;	A>ASM OZDEM.BAZ        /* OZDEM.ASM ON B: */
;	A>DDT MODEM7.COM       /* MODEM7.COM ON A: */
;	
;	*IOZDEM.HEX
;	*R
;	*G0
;
;	A>SAVE 35 MODEM7.COM
;
;....PATCH COMPLETED.
;
TRUE		EQU	0FFH
FALSE		EQU	0
;
BUFFERCODE	EQU	5F0H	;BUFFER SIZE DEFINITION LOC.
;
;      ********** NOTE **********
;
;IF THE MODEM7 SOURCE CODE HAS BEEN REASSEMBLED, 
;THE ADDRESS OF 'BUFFERCODE' MAY BE DIFFERENT.
;
;THE ORIGINAL CODE LOOKS LIKE:-
;
;BUFFERCODE	LDA	A,7
;		DCR	A
;		CMP	H
;		.
;		.
;IF 'BUFFERCODE DOES NOT EQUAL 5F0H IN YOUR OBJECT
;CODE, THEN MODIFY THE ABOVE EQUATE.
;
PORTCODE	EQU	0D000H	;PORT ACCESS CODE LOCN.
BANK1		EQU	1	;PORT FOR BANK 1 SWITCH
BANK2		EQU	0	;BANK 2 SWITCH
;
TXBUFFER	EQU	2	;TX BUFFER EMPTY BIT
RXBUFFER	EQU	1	;RX BUFFER EMPTY BIT
CLEARTOTX	EQU	8	;CLEAR TO SEND
RXREADY		EQU	RXBUFFER+CLEARTOTX
DATAPORT	EQU	2A01H	;ACIA ADDRESSES
STATUSPORT	EQU	2A00H
;
PAGEBYTE	EQU	0EF08H	;LOC'N TO SAVE BANK
;
		ORG	103H	;HOP OVER JUMP TO START
;
PMMIBYTE	DB	FALSE	;NO PMMI MODEM
IMSAIBYTE	DB	FALSE	;NO FRONT PANEL
FASTCLOCK	DB	TRUE	;4MHz Z-80
BACKUPBYTE	DB	TRUE	;YEP,BACK IT UP
EXPERTFLAG	DB	FALSE	;I'M NO EXPERT
PULSERATE	DB	0	;DIALING RATE
;
;IO ROUTINES FOLLOW
;
IN$MODCTLP	JMP	STATUS	;GET STATUS BYTE
;
OUT$MODDATP	JMP	OUTDATA	;SEND MODEM DATA
;
ANI$MODSNDB	ANI	TXBUFFER;TX BUFFER EMPTY?
		RET
;
CPI$MODSNDR	CPI	TXBUFFER
		RET
;
IN$MODDATP	JMP	INDATA	;GET MODEM DATA
;
ANI$MODRCVB	ANI	RXREADY	;DATA OK?
		RET
;
CPI$MODRCVR	CPI	RXBUFFER
		RET
;
JMP$INITMOD	JMP	INITIAL	;PUT PORT ROUTINES ABOVE 4000H
;
;THE FOLLOWING ROUTINES TO ABSOLUTLY NOTHING
;
OUT$MODCTLP	RET ! NOP ! NOP
IN$BAUDRP	RET ! NOP ! NOP
OUT$BAUDRP	RET ! NOP ! NOP
OUT$MODCTL2	RET ! NOP ! NOP
;
CRFLAG		DB	0	;CONTINUOUS REDIAL FLAG
;
NUMLIB		DB	0	;START & END OF PHONE NO. LIB
;
;THE FOLLOWING MOVES THE IO ROUTINES UP NEAR THE BDOS.
;
INITIAL	PUSH H ! PUSH D ! PUSH B
	LXI	H,MOVE1		;START OF SOURCE
	LXI	D,PORTCODE	;THE DESTINATION
	MVI	B,MOVE2-MOVE1	;LENGTH OF MOVE
MOVEIT	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MOVEIT
	POP B ! POP D ! POP H
	RET
;
;THESE IO ROUTINES WILL BE MOVED UP UNDER THE BDOS
;
;************ WARNING *************
;
;Don't use the stack in these routines because
;we left it back in bank one !
;
;
MOVE1	EQU	$		;MARKS START OF MOVE
;
STATUS	EQU	PORTCODE
;
	DI
	XRA	A
	OUT	BANK2
	STA	PAGEBYTE	;NOW IN PAGE 2
	LDA	STATUSPORT	;GET THE STATUS
	DB	8		;EX AF,AF' SAVES A REGISTER
	MVI	A,1
	OUT	BANK1
	STA	PAGEBYTE	;BACK IN PAGE 1
	DB	8		;EX AF,AF' BACK AGAIN
	EI
	RET
;
INDATA	EQU	PORTCODE+$-MOVE1
;
	DI
	XRA	A
	OUT	BANK2
	STA	PAGEBYTE	;BANK2
	LDA	DATAPORT	;GET MODEM DATA
	DB	8
	MVI	A,1
	OUT	BANK1
	STA	PAGEBYTE	;BANK1
	DB	8
	EI
	RET
;
OUTDATA	EQU	PORTCODE+$-MOVE1
;
	DB	8
	DI
	XRA	A
	OUT	BANK2
	STA	PAGEBYTE	;BANK2
	DB	8
	STA	DATAPORT
	DB	8
	MVI	A,1
	OUT	BANK1
	STA	PAGEBYTE	;BANK1
	DB	8
	EI
	RET
;
MOVE2	EQU	$
;
;THE FOLLOWING DEFINES THE UPPER LIMIT OF THE TEXT BUFFER
;
;     See note earlier re the address of this code.
;
	ORG	BUFFERCODE
;
	MVI	A,PORTCODE SHR 8;HI BYTE OF PORTCODE
	DCR	A
	NOP
;
	END
