;TITLE USER1	04/23/81	TERMINAL PATCH AREA
;	FOR WORDSTAR RELEASE 3.0, May 81 

; see Terminal Patch Area, page E-1, installation manual
;	VT52 modifications
;
OUTCHR	EQU	01EFH
MEMORY	EQU	29B8H

TBASE EQU 100H	; WHERE TO LOAD FOR NORMAL CP/M

;	ASEG	; ABSOLUTE CODE FOR LISTING
	ORG TBASE + 90H	; terminal legend coding here
	DB 'DEC VT-52 compatible terminal   '
	ORG TBASE+148H	; BEGINS AT 248 HEX OR 4448 HEX
 	PAGE 63	; SETS PAGE LENGTH

;	PATCHING NORMALLY DONE VIA INSTALL.COM
;	ADDITIONAL PATCHING FOR UNUSUAL (E.G., VT52) TERMINALS
;
;	ALWAYS PATCH: SCREEN HITE & WIDTH, CURSOR
;	ALL OTHERS ARE OPTIONS FOR SPECIAL CASES OR ENHANCEMENTS
;
HITE:	DB 24	; MUST BE EXACT SCREEN HEIGHT IN LINES
WID:	DB 80	; MUST BE <= EXACT SCREEN WIDTH
;
;	IN ALL CHAR STRINGS SENT TO TERMINAL, 
;	 FIRST BYTE IS #CHAR, THEN CHARS TO FOLLOW
;
;	CURSOR POSITIONING - MANDATORY PATCH
;			Done via ^Y, then
;			LINE # PLUS 20H,
;
ESC    EQU	01BH
;			COL # PLUS 20 H.
;	CURSOR POSITIONING LEAD-IN CHARACTER SEQUENCE:
CLEAD1:	DB 2	; NUMBER OF CHARACTERS
	DB ESC	; ESCAPE CHAR
	DB 'Y'	;
	DB 0,0,0 ; EXTRA SPACE
	DB 0,0,0
;
;	CURSOR POSITIONING STRING SENT BETWEEN LINE AND COLUMN
CLEAD2:	DB 0	;	NUMBER OF CHAR - NONE IN THIS EXAMPLE
	DB 0	; FIRST CHAR
	DB 0,0,0	; SECOND THRU 4TH
;	
;	CURSOR POSITIONING STRING SENT AFTER
;	BOTH LINE AND COLUMN HAVE BEEN SENT
CTRAIL:	DB 0	; NUMBER OF CHARACTERS
	DB 0,0,0,0

;	FLAG NON-ZERO TO SEND COLUMN BEFORE LINE
CB4LFB:	DB 0	; LINE GOES BEFORE COLUMN IN THIS EXAMPLE
;
;	OFFSET TO ADD TO LINE
LINOFF:	DB 20H	; ADD THIS TO LINE #, WHERE 0 IS TOP LINE ON SCREEN
;	OFFSET TO ADD TO COLUMN
COLOFF:	DB 20H	; ADD THIS TO COL#, WHERE 0 IS LEFT EDGE
;
;	BINARY/ASCII FLAG AND # ASCII DIGITS
ASCUR:	DB 0	; ZERO TO SEND BINARY LINE AND COLUMN
		; 2 TO SEND 2-DIGIT ASCII NUMBERS
		; 3 TO SEND 3-DIGIT ASCII NUMBERS
;	
	DB 0,0,0	; RESERVED FOR EXPANSION
;
;	PROVISION FOR POSITIONING CURSOR BY USER-CODED SUBROUTINE
;	INSTEAD OF UNDER CONTROL OF ABOVE ITEMS.
;	FOR USE IN EXCEPTIONAL CASES ONLY.
;
;	PUT A JMP INSTRUCTION IN YOUR SUBROUTINE IN THE FOLLOWING
;	3 BYTES. WHENEVER FIRST BYTE IS NON-ZERO, THIS POSITION WILL BE
;	CALLED TO POSITION CURSOR; ABOVE PATCH ITEMS WILL BE
;	DISREGARDED.
;
UCRPOS:	NOP	;	NORMALLY ZERO, OR A JMP TO YOUR
	NOP	;	SPECIAL CURSOR ROUTINE
	RET	
;
;	SEE "MORPAT" AT THE END OF THIS LISTING
;	FOR SPACE IN WHICH TO PUT THE SUBROUTINE
;
;	YOUR SUBROUTINE WILL RECEIVE LINE IN L REGISTER, (0=TOP SCREEN),
;	COLUMN IN H REGISTER (0=LEFT EDGE)
;	YOUR ROUTINME MAY MODIFY ALL REGISTERS.
;	TO OUTPUT A CHAR TO THE TERMINAL FROM WITHIN YOUR SUBROUTINE,
;	CALL OUTCHR. EXAMINE THE FOLLOWING
;	2 BYTES WITH THE DEBUGGER TO DETERMINE THE ADDRESS TO CALL IN
;	THE CURRENT RELEASE OF WORDSTAR.
;
;	* = 267H
	DW OUTCHR	; ADDRESS OF BYTE OUTPUT ROUTINE
;	
;	YOUR CUSTOM ROUTINE WILL ALSO RECEIVE THE FOLLOWING, WHICH MIGHT BE
;	USEFUL IN SPECIAL VIDEO BOARD DRIVERS:
;		DE = NUMBER OF CHAR POSITIONS FROM BEGINNING OF SCREEN
;			TO NEW CURSOR POSITION
;		BC = NUMBER OF CHAR POSITIONS FROM BEGINNING SCREEN TO
;			BEGINNING OF LINE IN WHICH CURSOR IS BEING PLACED.
;
	DB 0,0,0,0	; RESERVED BYTES
;
;
;	EVERYTHING THAT FOLLOWS IS OPTIONAL.
;	EACH ITEM RELATES TO EITHER ENHANCED PERFORMANCE
;	OR TO ACCOMODATE UNUSUAL TERMINALS.
;
;	add later after above works
;
	end