; 8080 -> 8085 OPCODE ENHANCER TABLES FOR
; BDS C VERSION 1.46
; CHRIS UNDERY APRIL 1983

;
lhlx	macro			;; HL <- *(DE)
	db	0edh
	endm

shlx	macro			;; HL -> *(DE)
	db	0d9h
	endm

DSUB	MACRO			;; DOUBLE SUBTRACT
	DB	8		;HL -= BC
	ENDM

ARHL	MACRO
	DB	10H		; HL >>= 1
	ENDM

RDEL	MACRO	
	DB	18H		; DE <<= 1 C
	ENDM

LDHI	MACRO	N		;; DE <- HL + IMMEDIATE BYTE
	DB	28H		; 
	DB	N
	ENDM

LDSI	MACRO	N		;; DE <- SP + FRAME OFFSET
	DB	38H
	DB	N		; 
	ENDM
;
RSTV	MACRO			;; RST ON OVERFLOW
	DB	0CBH
	ENDM

JNX5	MACRO			;; JMP IF NO 16 BIT UNDER/OVERFLOW
	DB	0DDH		; (DCX INX ETC)
	ENDM

JX5	MACRO			;; JMP IF UNDER/ OVERFLOW
	DB	0FDH
	ENDM
;
lxih	macro
	db	21h
	endm

externs	equ	115h

	org	100h

	DB	1		;CPU = 8085
;
; c.ccc runtime improvements
;
; long displacement , double byte indirection
; externals referenced
; possible side effect is the loss of low byte of read data
; in reg A. This hasn't caused problem as yet.
;
	db	ldei$len
ldei:	pop	h
	mov	e,m
	inx	h
	mov	d,m
	inx	h
	push	h
	lhld	externs
	dad	d
	mov	a,m
	inx	h
	mov	h,m
	mov	l,a
	ret
ldei$len equ	$-ldei
;
	db	ldeir$len
ldeir:	pop	d
	lhlx
	inx	d
	inx	d
	push	d		;save return address
	xchg
	lhld	externs
	dad	d
	xchg
	lhlx
	ret
ldeir$len equ	$-ldeir		;end of function
;
; long displacement double byte local indirection
;
	db	ldli$len
ldli:	pop	h
	mov	e,m
	inx	h
	mov	d,m
	inx	h
	push	h
	xchg
	dad	b
	mov	a,m
	inx	h
	mov	h,m
	mov	l,a
	ret
ldli$len equ	$-ldli

	db	ldlir$len
ldlir:	pop	d
	lhlx
	inx	d
	inx	d
	push	d
	dad	b
	xchg
	lhlx
	ret
ldlir$len equ	$-ldlir
;
	db	sdli$len
sdli:	pop	h
	mov	e,m
	inx	h
	push	h
	xchg
	mvi	h,0
	dad	b
	mov	a,m
	inx	h
	mov	h,m
	mov	l,a
	ret
sdli$len equ	$-sdli
;
	db	sdlir$len
sdlir:	pop	d
	lhlx
	inx	d
	push	d
	mvi	h,0
	dad	b
	xchg
	lhlx
	ret
sdlir$len equ	$-sdlir

;
; short displacement double byte indirection external referenced
;
	db	sdei$len
sdei:	pop	h
	mov	e,m
	inx	h
	push	h
	mvi	d,0
	lhld	externs
	dad	d
	mov	a,m
	inx	h
	mov	h,m
	mov	l,a
	ret
sdei$len equ	$-sdei
;
	db	sdeir$len
sdeir:	pop	d
	lhlx
	inx	d
	push	d
	xchg
	lhld	externs
	mvi	d,0
	dad	d
	xchg
	lhlx
	ret
sdeir$len equ	$-sdeir

;
;
; these sequences are very common in the inline code
; generated by the bds c compiler.
; a few micro seconds can be shaved off these instructions
;

	DB	8
	DAD	D
	LXI	D,0
	MOV	M,E
	INX	H
	MOV	M,D
	PUSH	D
;
	DB	8
	DAD	D
	XCHG
	LXI	H,0
	SHLX
	XCHG
	PUSH	D
;
; THE MOST COMMON SHORT SEQUENCES

	DB	7
	MOV	E,M
	INX	H
	MOV	D,M
	DCX	D
	MOV	M,D
	DCX	H
	MOV	M,E
;
	DB	7		;REPLACEMENT
	XCHG
	LHLX
	DCX	H
	SHLX
	XCHG
	NOP
	NOP
;
	DB	7
	MOV	E,M
	INX	H
	MOV	D,M
	INX	D
	MOV	M,D
	DCX	H
	MOV	M,E
;
	DB	7
	XCHG
	LHLX
	INX	H
	SHLX
	XCHG
	NOP
	NOP
;
;
;
	db	len1
type1:	mov e,m! inx h! mov d,m! inx d! mov m,d! dcx h! mov m,e!
	dcx d! xchg!
len1	equ	$-type1

; replacement sequence

	db	lrep1
rep1:
	xchg
	lhlx
	inx h
	shlx
	dcx h
	nop
	nop
	nop
	nop
lrep1	equ	$-rep1

;
	db	0		; THIS IS END OF FILE MARK (NULL)

	DB	LEN4
TYPE4:	DAD	B
	MOV	E,M
	INX	H
	MOV	D,M
	DCX	D
	MOV	M,D
	DCX	H
	MOV	M,E
	lxih
LEN4	EQU	$-TYPE4
;
	DB	LREP4
REP4:	DAD	B
	XCHG
	LHLX
	DCX	H
	SHLX
	XCHG
	NOP
	NOP
	lxih
LREP4	EQU	$-REP4

;
; DE = *HL--
;
	db	len6
type6:	DAD	B
	MOV	E,M
	INX	H
	MOV	D,M
	DCX	D
	MOV	M,D
	DCX	H
	MOV	M,E
LEN6	EQU	$-TYPE6

	DB	LREP6
REP6:	DAD	B
	XCHG
	LHLX
	DCX	H
	SHLX	
	XCHG	
	NOP
	NOP
LREP6	EQU	$-REP6

	dw	0			;end of table

