	NAME DEL
;DELETE COMMAND, SIMILAR TO RT-11
;
;CALL AS DEL FNAME [/NOQ]
;/NOQ OR NO WILDCARDS (? OR *) SUPPRESSES QUERY
;IF QUERY, ASKS BEFORE DELETING EACH FILE.
;
;WRITTEN BY RUSS BAKKE
;03-09-83
;
	ORG 100H	;NORMAL START
START	LD SP,2000H
	LD DE,MSG0	;BANNER
	LD C,9		;MS
	CALL DOS
;FIRST, SEE IF AN FCB WAS PASSED
	LD HL,DBUFF
	LD A,(HL)	;LENGTH OF COMD LINE
	OR A		;SET FLAGS
	JP Z,NOFIL	;NO FILE NAME PASSED
;
;SEE IF BLANK TYPE
	LD HL,FCB+9
	LD A,' '
	LD B,3
CKTYP	CP (HL)
	JR NZ,NOBLK
	INC HL
	DJNZ CKTYP
;YES--FORCE TO '???'
	LD HL,FCB+9
	LD A,'?'
	LD B,3
CK1	LD (HL),A
	INC HL
	DJNZ CK1
;
NOBLK	CALL CLRFC2
	CALL SAVFN	;SAVE FCB
;SEE IF ANY OPTIONS
	LD HL,DBUFF+1
GETOPT	LD A,(HL)
	INC HL
	CP '/'
	JR Z,OPT1
	CP 0
	JR NZ,GETOPT
;NO OPTS
NOOPT	XOR A
	LD (OPTS),A
	JR GETWC
;
OPT1	LD A,(HL)
	INC HL
	CP 'N'
	JR NZ,NOOPT
	LD A,(HL)
	INC HL
	CP 'O'
	JR NZ,NOOPT
	LD A,(HL)
	CP 'Q'
	JR NZ,NOOPT
	LD A,1
	LD (OPTS),A
;
;NOW SEE IF ANY WILDCARDS
GETWC	LD HL,FCB+1
GETWC1	LD A,(HL)
	INC HL
	CP '*'
	JR Z,SEARCH
	CP '?'
	JR Z,SEARCH
	CP 0
	JR NZ,GETWC1
	LD A,1		;NO WILDCARDS, SO NOQ
	LD (OPTS),A
;
;NOW LOOKUP FIRST FILE
SEARCH	LD DE,FCB2
	LD C,17		;SEARCH
	CALL DOS
	CP -1
	JP Z,NOFIL
;
;A CONTAINS FILE NUMBER, ENTRY IN DBUFF.
;NOTE: IN CPM IS 0-3; IN IOS MAY BE 0-255.
;SO TAKE MOD 4.
AGAIN	AND 3
	ADD A,A
	ADD A,A
	ADD A,A
	ADD A,A
	ADD A,A
	LD E,A
	LD D,0
	LD HL,DBUFF
	ADD HL,DE
	PUSH HL
;HL NOW POINTS TO FILE ENTRY
	LD A,(OPTS)
	CP 0
	JR NZ,NOQUE	;NO QUERY
	INC HL		;SKIP STARTING NULL
	PUSH HL
	LD DE,MSG1	;"DELETE?
	LD C,9		;PRINT BUFFER
	CALL DOS
	LD C,25		;GET CURRENT DR.
	CALL DOS
	ADD A,'A'
	LD E,A
	CALL CHOUT
	LD E,':'
	CALL CHOUT
	POP HL
	LD B,8		;FILENAME
	CALL LINOT
	LD E,'.'
	CALL CHOUT
	LD B,3		;EXT
	CALL LINOT
	LD E,'?'
	CALL CHOUT
	LD E,' '
	CALL CHOUT
	LD C,1		;GET ANSWER
	CALL DOS
	PUSH AF
	CP 0DH		;C/R?
	JR Z,QUER1
	LD E,0DH
	CALL CHOUT
QUER1	LD E,0AH
	CALL CHOUT
	POP AF
	CP 'Y'
	JR NZ,NEXT
;
;COPY FCB (12 CHARS) FROM HL (DBUFF)
;NOTE THAT WE MUST COPY INTO BUFFER,
;RATHER THAN USE DELETE CALL NOW, SO
;THAT WE CAN USE "FIND NEXT".
NOQUE	POP HL
	LD DE,(BUFFER)
	LD BC,12
	LDIR
	LD (BUFFER),DE
;
NEXT	LD DE,FCB2
	LD C,18		;SEARCH NEXT
	CALL DOS
	CP -1		;FOUND?
	JP NZ,AGAIN	;YES, REPEAT
;
;NOW DELETE EVERYTHING IN BUFFER
	LD HL,(BUFFER)
	LD A,0FFH
	LD (HL),A	;MARK END
	LD HL,BUFF
	LD (BUFFER),HL
DELNXT	LD HL,(BUFFER)
	LD A,(HL)
	CP 0FFH
	JR Z,DONE
	PUSH HL
	CALL CLRFCB
	POP HL
	LD DE,FCB
	LD BC,12
	LDIR		;COPY INTO FCB
	LD (BUFFER),HL
	LD DE,FCB
	LD C,19		;DELETE
	CALL DOS
	JR DELNXT
;
DONE	RST 0		;DONE, WARM START DOS
;
;
;SUBROUTINES
;
CHOUT	LD C,2		;CONSOLE OUT
	PUSH HL
	PUSH BC
	CALL DOS
	POP BC
	POP HL
	RET
;
;LINOT--SEND B CHARS FROM HL
LINOT	LD E,(HL)
	INC HL
	CALL CHOUT
	DJNZ LINOT
	RET
;
NOFIL	LD DE,MSG2
	LD C,9
	CALL DOS
	RST 0		;RET TO OS
;
SAVFN	LD HL,FCB	;SAVE FCB
	LD DE,FCB2
	LD BC,12
	LDIR
	RET
;
;CLRFCB--CLEAR FCB
CLRFCB	LD HL,FCB
CLR0	LD B,32		;# BYTES TO CLEAR
	XOR A
CLR1	LD (HL),A
	INC HL
	DJNZ CLR1
	RET
;
CLRFC2	LD HL,FCB2
	JR CLR0
;
;
;MESSAGES
;
MSG0	DEFM 'DEL.COM     03-09-83'
	DEFW 0A0DH
	DEFW 0A0DH
	DEFM '$'
;
MSG1	DEFM 'DELETE $'
;
MSG2	DEFW 0A0DH
	DEFM 'FILE NOT FOUND'
	DEFW 0A0DH
	DEFM '$'
;
;
;DATA STORAGE
;
OPTS	DEFS 1		;FLAG
FCB2	DEFS 32	;SECOND FCB
BUFFER	DEFW BUFF	;POINTS TO STORAGE
BUFF	DEFS 1024	;LOTS OF SPACE
;
;
;EQUATES
FCB	EQU 5CH
DBUFF	EQU 80H
DOS	EQU 5		;DOS CALL
	END
