;***************************************************************;
;								;
;			EPROM.ASM				;
;								;
;		LAST MODIFIED 9/27/80				;
;								;
;	EPROM PROGRAMMER SOFTWARE FOR RUNNING AN SSM - PB1	;
;	2708/2716 PROGRAMMER WITH CP/M UNDER DDT		;
;								;
;	TO RUN THIS PROGRAM, TYPE:				;
;								;
;DDT EPROM.COM(CR)						;
;								;
;	THE CONSOLE WILL RESPOND WITH:				;
;								;
;DDT VERS #.#							;
;NEXT  PC							;
;#### 0100							;
;-								;
;								;
;	INSERT A HEX FILE TO BE PLACED IN EPROM BY ENTERING:	;
;								;
;IFILENAME.HEX(CR)						;
;R[BIAS](CR)							;
;								;
;   (NOTE THAT BIAS WILL ALLOW THE ENTERED PROGRAM TO RESIDE	;
;   WITHIN 103H TO 'START' AS REQUIRED EVEN THOUGH THE PROGRAM	;
;   WAS ASSEMBLED FOR EXECUTION OUTSIDE THIS RANGE)		;
;								;
;   TO START THE PROGRAM FROM DDT, ENTER EITHER 'G(START:)'	;
;   OR 'G100'.  THE PROGRAM WILL ASK FOR EPROM TYPE SO AS	;
;   TO SET THE PROPER SIZE (1K FOR 2708 AND 2K FOR 2716/2516)	;
;   AND PROGRAMMING ROUTINE.					;
;								;
;   SUPPORTED FUNCTIONS ARE COPY, PROGRAM AND VERIFY WHICH ARE	;
;   SELF EXPLANATORY.  THE AUTOMATIC SEQUENCE FOR PROGRAMMING	;
;   AN EPROM IS TO FIRST CHECK FOR FULL ERASURE, THEN THE	;
;   PROGRAM CYCLE, FOLLOWED BY THE VERIFY ROUTINE.		;
;   (ANY FAILURE RESULTS IN AN ERROR MESSAGE AND A BELL		;
;   SO AS TO NOT GO UNNOTICED.)					;
;								;
;   AS CONTROL IS PASSED TO DDT AND YOU WISH TO			;
;   RETURN TO THE PROGRAMMER, JUST ENTER 'G' AGAIN.		;
;								;
;   EXIT FROM THE PROGRAM BY ENTERING A CONTROL C		;
;								;
;***************************************************************;

;	<<<<SET PROM AND CPORT TO AGREE WITH PB1 SWITCHES>>>>
PROM	EQU	0E000H	;SELECTED LOCATION OF SOCKETS
CPORT	EQU	70H	;   "        "     "  CONTROL PORT

CR	EQU	0DH	;CARRIGE RETURN
LF	EQU	0AH	;LINE FEED
BELL	EQU	7	;***** DING
TERM	EQU	'$'
RST7	EQU	38H

	ORG	100H

	JMP	START

	DS	4000H-$	; RAM WORKSPACE

START:	CALL	HELLO
	DB  CR,LF,'CP/M EPROM PROGRAMMER - VER 1.0',CR,LF,CR,LF,TERM
HELLO:	POP	D
	CALL	PRNMSG
TYPE:	CALL	TYPE1
	DB	CR,LF,'ENTER EPROM TYPE (2516,2716 OR 2708)  ',TERM
TYPE1:	POP	D
	CALL	PRNMSG
	CALL	GETVAL
	POP	H
	LXI	D,2708H
	CALL	CPHL
	JZ	X2708
	LXI	D,2516H
	CALL	CPHL
	JZ	X2716
	LXI	D,2716H
	CALL	CPHL
	JZ	X2716
	JMP	TYPE	;WRONG TYPE

X2708:	MVI	A,3	;PAGE COUNT - 1
	STA	SIZE
	MVI	A,1	;HARDWARE CODE
	STA	CODE
	MVI	A,250	;# OF PROGRAMMING CYCLES
	STA	NCYC
	JMP	DIRECT

X2716:	MVI	A,7	;PAGE COUNT - 1
	STA	SIZE
	MVI	A,2	;HARDWARE CODE
	STA	CODE
	MVI	A,1	;# OF PROGRAMMING CYCLES
	STA	NCYC

DIRECT:	CALL	DIR1
	DB CR,LF,'DO YOU WISH (D)DT, (C)OPY, '
	DB  '(P)ROGRAM, (V)ERIFY ? ',TERM
DIR1:	POP	D
	CALL	PRNMSG
	CALL	CI
	CPI	'C'
	LXI	H,COPY
	JZ	DIR2
	CPI	'P'
	LXI	H,PROG
	JZ	DIR2
	CPI	'V'
	LXI	H,VERIFY
	JZ	DIR2
	CPI	'D'
	JNZ	DIRECT
	LXI	H,DIRECT
	PUSH	H	;SET RETURN ADDRESS
	JMP	RST7	;DDT BREAKPOINT ENTRY
DIR2:	SHLD	OPTION

ADDR:	CALL	ADD1
	DB	CR,LF,'ENTER STARTING ADDRESS '
	DB	'OF MEMORY BLOCK IN HEX  ',TERM
ADD1:	POP	D
	CALL	PRNMSG
	CALL	GETVAL
	POP	H
	SHLD	RAM

GO:	LDA	PROM	;CLEAR PROGRAMMER
	CALL	GO1
	DB  CR,LF,'PLACE EPROM IN PROPER SOCKET '
	DB  'AND STRIKE ANY KEY',CR,LF,TERM
GO1:	POP	D
	CALL	PRNMSG
	CALL	CI
	LHLD	OPTION
	PCHL

VERIFY:	CALL	VERIF
	JMP	DIRECT

COPY:	CALL	CPY
	JMP	DIRECT

PROG:	CALL	ERACHK	;SEE IF EPROM IS ERASED
	JNZ	DIRECT	;ABORT IF NOT-
	CALL	PRG	;NOW PROGRAM
	CALL	VERIF	;AND VERIFY
	JMP	DIRECT	;THEN CHECK WHAT'S NEXT

	;***********************
	;   MAIN SUBROUTINES
	;***********************


	;	ERACHK

	;ROUTINE TO TEST FOR COMPLETE
	;ERASURE OF EPROM BEFORE PROG.

ERACHK:	LXI	H,SIZE
	MOV	C,M
	LXI	D,PROM
ERACH1:	LDAX	D	;GET BYTE FROM EPROM
	INX	D
	CPI	0FFH	;TEST FOR ERASE PATTERN
	JNZ	NERASE
	MOV	A,D
	ANA	C
	ORA	E	;CHECK FOR END
	JNZ	ERACH1
	RET
NERASE:	PUSH	PSW	;SAVE FLAGS
	CALL	NER1
	DB   CR,LF,'EPROM NOT ERASED',CR,LF,BELL,TERM
NER1:	POP	D
	CALL	PRNMSG
	POP	PSW
	RET


	;	PRG

	;ROUTINE TO PROGRAM EITHER
	;A 2708 OR 2716 EROM

PRG:	LDA	CODE	;SET HARDWARE FOR TYPE
	OUT	CPORT
	LXI	H,NCYC	;# OF PROG. CYCLES
	MOV	B,M
	LXI	H,SIZE
	MOV	C,M	;# OF PAGES -1
PRG1:	LXI	D,PROM
	LHLD	RAM
;PROGRAM THE EPROM
PRG2:	MOV	A,M
	STAX	D	;THIS STEP DOES IT
	INX	D
	INX	H
	MOV	A,D
	ANA	C
	ORA	E
	JNZ	PRG2	;GET NEXT ADDRESS
	DCR	B
	JNZ	PRG1	;LOOP FOR N CYCLES
	DCX	D
	LDAX	D	;RESET THE HARDWARE
	RET


	;	VERIF

	;ROUTINE TO VERIFY CONTENTS
	;OF AN EPROM WITH MEMORY

VERIF:	LXI	H,SIZE
	MOV	C,M
	LXI	D,PROM	;ADDRESS OF EPROM
	LHLD	RAM	;RAM TO BE COMPARED
VERF1:	MOV	B,M	;GET ORIGINAL
	LDAX	D	;THEN ROM
	INX	D
	INX	H
	CMP	B	;BETTER BE THE SAME.
	JNZ	DIFF
	MOV	A,D
	ANA	C
	ORA	E
	JNZ	VERF1	;OK SO FAR, GET NEXT
	PUSH	PSW
	CALL	VERF2
	DB  CR,LF,CR,LF,CR,LF,'<<<<<<<<<< EPROM '
	DB  'VERIFIED GOOD >>>>>>>>>>',CR,LF,TERM
VERF2:	POP	D
	CALL	PRNMSG
	POP	PSW
	RET
DIFF:	PUSH	PSW	;SAVE FLAGS
	CALL	DIFF1
	DB  CR,LF,'EPROM DOES NOT VERIFY',CR,LF,BELL,TERM
DIFF1:	POP	D
	CALL	PRNMSG
	POP	PSW
	RET


	;	CPY

	;ROUTINE TO COPY AN EPROM
	;FROM THE SOCKET TO RAM

CPY:	LXI	H,SIZE
	MOV	C,M
	LXI	D,PROM	;SOCKET ADDRESS OF MASTER
	LHLD	RAM	;POINT TO TARGET RAM
CPY1:	LDAX	D	;GET ROM DATA
	MOV	M,A	;LOAD TO RAM
	INX	D
	INX	H
	MOV	A,D
	ANA	C
	ORA	E
	JNZ	CPY1	;GO BACK FOR NEXT BYTE
	CALL	CPY2
	DB  CR,LF,CR,LF,'COPY COMPLETE',CR,LF,CR,LF,TERM
CPY2:	POP	D
	CALL	PRNMSG
	RET


	;****************************
	;  MISCELLANEOUS SUBROUTINES
	;****************************

	;	CPHL

	;ROUTINE TO COMPARE HL VS DE

CPHL:	MOV	A,H
	CMP	D
	RNZ
	MOV	A,L
	CMP	E
	RET

	;	GETVAL

	;ROUTINE TO LOAD A 16 BIT
	;VALUE FROM A HEX INPUT

GETVAL:	CALL	CI	;GET KEYBOARD BYTE
	LXI	H,0	;INITIALIZE HL
GET1:	MOV	B,A	;SAVE KEYBOARD
	CALL	NIBBLE	;CONVERT ASCII TO HEX
	JC	GET2	;NOT LEGAL
	DAD	H	;HL*16
	DAD	H
	DAD	H
	DAD	H
	ORA	L	;ADD IN NIBBLE
	MOV	L,A
	CALL	CI	;GET NEXT KEYBOARD BYTE
	JMP	GET1
GET2:	XTHL		;STICK PRAMETER ON STACK
	PUSH	H	;REPLACE RETURN
	MOV	A,B	;TEST CHARACTER
	CALL	ECHK	;FOR JUNK
	JNZ	ERROR	;JUNK OR ILLEGAL
	RET

NIBBLE:	SUI	'0'
	RC
	CPI	'G'-'0'
	CMC
	RC
	CPI	10
	CMC
	RNC
	SUI	'A'-'9'-1
	CPI	10
	RET

ECHK:	CPI	' '
	RZ
	CPI	','
	RZ
	CPI	CR
	STC
	RZ
	CMC
	RET

ERROR:	POP	H	;DUMP DATA
	POP	D
	PUSH	H
	CALL	ER1
	DB	CR,LF,'ENTER VALUE(CR)',CR,LF,TERM
ER1:	POP	D
	CALL	PRNMSG
	JMP	GETVAL

	;	CONSOLE IN

	;ROUTINE TO GET A CHARACTER
	;THROUGH CP/M FROM THE CONSOLE

CI:	PUSH B! PUSH D! PUSH H
	MVI	C,RDCON
	CALL	BDOS
	POP H! POP D! POP B
	CPI	3	;CHECK FOR ^C
	JZ	BOOT	;ABORT
	RET

	;	PRNMSG

	;ROUTINE TO PRINT A
	;MESSAGE TO THE CONSOLE
	;THROUGH CP/M

PRNMSG:	MVI	C,PRINT
	JMP	BDOS


	;	VARIABLE STORAGE

SIZE:	DS	1
CODE:	DS	1
NCYC:	DS	1
OPTION:	DS	2
RAM:	DS	2



; * * * * * * * * * * * * * * * * * * * * * * * *
;						*
;BDOS/CBIOS EQUATES (VERSION 7)			*
;						*
RDCON	EQU	1	;			*
WRCON	EQU	2	;			*
PRINT	EQU	9	;			*
OPEN	EQU	15	;0FFH=NOT FOUND		*
CLOSE	EQU	16	;   "	"		*
SRCHF	EQU	17	;   "	"		*
SRCHN	EQU	18	;   "	"		*
ERASE	EQU	19	;NO RET CODE		*
DELT	EQU	ERASE	;			*
READ	EQU	20	;0=OK, 1=EOF		*
WRITE	EQU	21	;0=OK, 1=ERR, 2=?,	*
;			0FFH=NO DIR SPC		*
MAKE	EQU	22	;0FFH=BAD		*
REN	EQU	23	;0FFH=BAD		*
STDMA	EQU	26	;			*
;						*
;						*
BOOT	EQU	0	;WARM BOOT		*
BDOS	EQU	5	;			*
FCB	EQU	5CH 	;			*
SYSSIZ	EQU	32	;SYSTEM SIZE		*
CBIOS	EQU	SYSSIZ*1024-512	;		*
SELDSK	EQU	CBIOS+1BH	;		*
SETTRK	EQU	SELDSK+3	;		*
SETSEC	EQU	SETTRK+3	;		*
SETDMA	EQU	SETSEC+3	;		*
RDSEC	EQU	SETDMA+3	;		*
WRSEC	EQU	RDSEC+3		;		*
; * * * * * * * * * * * * * * * * * * * * * * * *

	END
