;CHGLIB PROG..PROGRAM TO CHANGE DIAL LIBRARY FOR 
;MODEM7.COM EASIER THAN CHANGING ASM FILE AND
;HAVING TO REASSEMBLE IT EACH TIME YOU WANT TO
;ADD OR CHANGE NUMBERS...TONY RIBEIRO JAN 82..
;
; 02/23/83 - MODIFIED TO WORK WITH MODEM798 AND TO ACCEPT
;		LOWER CASE CONSOLE INPUT.  (BRUCE R. RATOFF)
;
;SYSTEM EQUATES
BOOT	EQU	0
BDOS	EQU	BOOT+5
SFCB1	EQU	BOOT+5CH
SFCB2	EQU	BOOT+6CH
TPA	EQU	BOOT+100H
CONIN	EQU	1
CONOT	EQU	2
LIST	EQU	5
PRINTB	EQU	9
RDCON	EQU	10
CONST	EQU	11
OPENF	EQU	15
CLOSEF	EQU	16
SRCHF	EQU	17
DELF	EQU	19
READF	EQU	20
WRITEF	EQU	21
MAKEF	EQU	22
SETDMA	EQU	26
LF	EQU	0AH
CR	EQU	0DH
;
;PROGRAM STARTS HERE
	ORG	TPA
START:	LXI	SP,STACK
	XRA	A		;CLEAR CHGSW
	STA	CHGSW
;THIS ROUTINE MOVES SOURCE AND OUTPUT FCBS AND 
;SETS BOTH CRS TO '0'

SAVFCB:	LXI	H,SFCB1		;SOURCE FCB
	LXI	D,FCB1
	CALL	MFCB
	XRA	A
	STA	FCB1+32
	LXI	H,SFCB2		;OUTPUT FCB
	LXI	D,FCB2
	CALL	MFCB
	XRA	A
	STA	FCB2+32
;DISPLAY SIGN ON MSG

	LXI	D,MPROG		
	CALL	PRTBUF		
;CHECKS TO SEE THAT A SOURCE FILE IS CALLED

	LXI	H,SFCB1+1
	MOV	A,M
	CPI	' '
	JNZ	CKDF
;IF NOT, DISPLAYS ERROR MSG AND EXITS PROG

	LXI	D,MNOSF
	JMP	DOEXIT
;CHECKS TO SEE IT AN OUTPUT FILE IS CALLED

CKDF:	LXI	H,SFCB2+1
	MOV	A,M
	CPI	' '
	JNZ	CLRBUF
;IF NOT, DISPLAYS ERROR MSG AND EXITS PROG

	LXI	D,MNODF
	JMP	DOEXIT
;THIS IS THE SUB-ROUTINE THAT MOVES FCBS

MFCB:	MVI	C,16
MFCB1:	MOV	A,M
	STAX	D
	INX	D
	INX	H
	DCR	C
	JNZ	MFCB1
	RET
;CLEARS 4000H BYTES OF RAM SO THAT NO GARBAGE APPEARS
;IN NEW COM FILE THAT IS WRITTEN.

CLRBUF:	LXI	H,BUF
	LXI	D,4000H
CLR1:	MVI	M,0
	INX	H
	DCX	D
	MOV	A,D
	ORA	E
	JNZ	CLR1
;OPENS SOURCE FILE, AND IF IT NOT FOUND, DISPLAYS
;ERROR MSG.

OPNSF:	LXI	D,FCB1
	MVI	C,OPENF
	CALL	BDOS
	INR	A
	JNZ	SRCDF
	LXI	D,MUNSF
	JMP	DOEXIT
;CKS TO SEE IF OUTPUT FILE ALREADY EXISTS.IF IT DOES 
;DISPLAYS ERROR MSG AND EXITS PROG.

SRCDF:	LXI	D,FCB2
	MVI	C,SRCHF
	CALL	BDOS
	INR	A
	JZ	DOREAD
	LXI	D,MUNDF
	JMP	DOEXIT
;DISPLAYS LOADING FILE. MSG AND LOADS SOURCE FILE

DOREAD:	LXI	D,MLOADF
	CALL	PRTBUF
	CALL	RDFILE
	JMP	ASKADR
;LOADS SOURCE FILE(CURRENT MODEM7.COM PROG) AT 'BUF'

RDFILE:	LXI	H,BUF		;START OF BUFFER RAM
	SHLD	DMADD		;STORE BUFFER POINTER
RDFIL1:	PUSH	H
	POP	D
	MVI	C,SETDMA
	CALL	BDOS
	LXI	D,FCB1
	MVI	C,READF
	CALL	BDOS
	ORA	A
	RNZ
	LHLD	DMADD
	LXI	D,128
	DAD	D
	SHLD	DMADD
	JMP	RDFIL1
;ASKS USER IF START ADDRESS OF PHONE LIBRARY IS KNOWN.
;IS ANSWER IF YES THEN PROG JMPS TO 'SETADR'
;IF NO THAN PROG FALL THRU TO 'ASKSRC'
;NOTE...THIS REFERS TO THE LABEL 'NUMBLIB' IN THE
;MODEM7 PROGRAM,WHICH IS THE START OF THE PHONE
;NUMBER LIBRARY.

ASKADR:	LXI	D,MADR
	CALL	PRTBUF
	CALL	CKCONS
	ANI	5FH		; FORCE UPPERCASE
	CPI	'Y'
	JZ	SETADR
	CPI	'N'
	JNZ	ASKADR
;IF USER DOESNT KNOW THE START ADDRESS OF LIBRARY,
;THEN PROG ASKS USER IF AN AUTO SEARCH OF START
;SHOUD BE DONE.IS USER ANSWERS  'N'  THEN PROG EXITS.
;IF THE ANSWER IS  'Y'  THEN PROG BRANCHES TO 'DOSRC'.

ASKSRC:	LXI	D,MSRCH
	CALL	PRTBUF
	CALL	CKCONS
	ANI	5FH		;FORCE UPPERCASE
	CPI	'Y'
	JZ	DOSRC
	CPI	'N'
	JNZ	ASKSRC
	JMP	DOEXT1
;USER IS ASKED FOR LIBRARY START ADDRESS....
;THE FORMAT IS FOUR(4) HEX CHARS...
;PROG THEN STORES START ADDRESS AT 'LIBSTT' AND THEN
;JMPS TO 'CMD'.

SETADR:	LXI	D,MDOADR
	CALL	MSUB1
	CALL	READC
	LDA	CONSIZ
	CPI	4
	JNZ	SETADR
	LXI	D,BUF-100H
	DAD	D		;ADJUST W/ LOAD OFFSET
	SHLD	LIBSTT
	JMP	CMD
;THIS ROUTINE WILL DO AN AUTO SEARCH OF THE START OF
;THE PHONE LIBRARY...IT LOOKS FOR THE ASCII CHARS
;'A','B','C' WITH THE PROPER SPACING(32 BYTES) AS SHOWN
;IN 'NUMBLIB'.SEARCH IS DONE ON FIRST 2K BYTES ONLY.
;SEARCH LIMIT MONITORED BY 'SRCLMT' AND 'H' REGISTER.

DOSRC:	LXI	H,BUF		;START OF BUFFER RAM
	MOV	A,H		;MONITOR LIMIT COUNT
	ADI	8		;SEARCH ONLY FIRST 2K
	STA	SRCLMT
;PROG LOOKS FOR FIRST LETTER IN SEQUENCE('A').
DOSRC1:	MOV	A,M
	CPI	'A'
	JZ	CKB
	INX	H
	LDA	SRCLMT
	CMP	H
	JNZ	DOSRC1
;SEARCH OF FIRST 2K BYTES DOESNT FIND LIBRARY SO
;PROGRAM EXITS.

SRCEXT:	LXI	D,MDLNF
	JMP	DOEXIT
;'A' IS FOUND.PROG CKS FOR 'B' BEING IN RIGHT PLACE.

CKB:	SHLD	LIBSTT
	LXI	D,32
	DAD	D
	MOV	A,M
	CPI	'B'
	JZ	CKC
;'B' NOT FOUND 32 BYTES FROM 'A' SO PROG BUMPS POINTER
;BY ONE(1) AND STARTS SEARCH FOR 'A' AGAIN.

DONXT:	LHLD	LIBSTT
	INX	H
	JMP	DOSRC1
;'A' AND 'B' FOUND IN RIGHT PLACE.PROG NOW CKS 32 BYTES
;DOWN THE LINE FOR 'C'.

CKC:	LXI	D,32
	DAD	D
	MOV	A,M
	CPI	'C'
	JNZ	DONXT
;LETTERS A,B,AND C FOUND IN PROPER SEQ AT CORRECT
;LOCATION SO PROG DISPLAYS THAT LIBRARY IS FOUND
;THEN DISPLAYS THE START ADDRESS IN HEX AND DISPS
;WHAT IT THINKS IS THE DIAL LIBRARY.

DLFND:	CALL	DCRLF
	LXI	D,MDLFND
	CALL	PRTBUF
	CALL	DSPADR
	CALL	DSPLIB
;PROG NOW ASKS USER IF THE DISPLAY LOOKS LIKE THE
;PROPER START OF THE DIAL LIBRARY.IF USER ANSWERS
;'Y' THEN PROG CONTINUES.IF  'N'  THEN  PROG GOES
;BACK AND SEARCHES SOME MORE.

DLFND1:	LXI	D,MDLOK
	CALL	PRTBUF
	CALL	CKCONS
	ANI	5FH		;FORCE UPPERCASE
	CPI	'Y'
	JZ	DLFND2
	CPI	'N'
	JNZ	DLFND1
	JMP	DONXT
;LIBRARY LOOKS OK,SO PROG CONTINUES HERE.

DLFND2:	CALL	DCRLF
;PROG DISPLAYS COMMAND LINE AND PROMPTS USER FOR CMD.
;THE D,I,AND V COMMANDS REQUIRE AND ARGUMENT WITH CMD.
;THE D,AND I CMDS NEED A LETTER 'A' TO 'Z'.
;THE V(VIEW) CMD NEEDS A LETTER AS ABOVE TO VIEW ONE
;LINE OR A '?' TO VIEW ENTIRE LIBRARY.
;THE OTHER CMDS REQUIRE NO ARGUMENT.

CMD:	CALL	DSPLIB
CMD1:	LXI	D,MCMD
	CALL	PRTBUF
	CALL	CKCONS
	CPI	3		;IF CNTRL C THEN EXIT
	JZ	EXIT
	ANI	5FH		;FORCE UPPERCASE
	CPI	'D'		;DELETE FUNCTION
	JZ	DELETE
	CPI	'I'		;INSERT FUNCTION
	JZ	INS
	CPI	'P'		;PRINTS ENTIRE LIBRARY
	JZ	PRTLIB
	CPI	'R'		;REREADS SOURCE FILE
	JZ	REREAD
	CPI	'V'		;DISPS LINE/ENTIRE LIB
	JZ	VIEW
	CPI	'W'		;WRITES OUTPUT FILE
	JZ	WRTFIL
;IF PROPER SYNTAX NOT USED,DISPLAYS ERROR MSG
;AND DISPLAYS CMD LINE AGAIN AND PROMPTS USER.

CMDERR:	LXI	D,MSYNER	;SYNTAX ERROR MSG
	CALL	PRTBUF
	JMP	CMD1
;THIS ROUTINE WILL RELOAD THE SOURCE FILE
;SO USER CAN START FROM SCRATCH AGAIN.

REREAD:	LXI	D,MLOADF	;LOADING FILE MSG
	CALL	PRTBUF
	XRA	A		;CLEAR CHGSW
	STA	CHGSW
	STA	FCB1+32		;SET FCBCR TO '0'
	CALL	RDFILE
	JMP	CMD
;DISPLAYS THE ENTIRE LIBRARY ON CONSOLE.

DSPLIB:	CALL	DCRLF
	LHLD	LIBSTT
DSPLB1:	MVI	C,1
DSPLB2:	MVI	B,32
	MOV	A,M
	CPI	0
	RZ
DSPLB3:	MOV	A,M
	CALL	DISP
	INX	H
	DCR	B
	JNZ	DSPLB3
	DCR	C
	JNZ	DSPLB4
	MVI	A,' '		;INSERT 2 SPACES
	CALL	DISP
	CALL	DISP
	JMP	DSPLB2
DSPLB4:	CALL	DCRLF
	JMP	DSPLB1
;SEND ONE CHARACTER TO CONSOLE THRU CP/M FACILITIES.
;NOTE..IF DPSW+1 IS 'CONOT',CHAR SENT TO CONSOLE.
;IF DPSW+1 IS 'LIST' THEN CHAR SENT TO LIST DEVICE.
;DPSW+1 IS SWITCHED TO 'LIST' ON (P)'PRTLIB' CMD.

DISP:	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
DPSW:	MVI	C,CONOT
	MOV	E,A
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	POP	PSW
	RET
;SEND CR,LF SEQUENCE TO CONSOLE OR LIST DEV.

DCRLF:	MVI	A,CR
	CALL	DISP
	MVI	A,LF
	CALL	DISP
	RET
;DOES A PRINT BUFFER USING CP/M FACILITIES.

PRTBUF:	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,PRINTB
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	POP	PSW
	RET
;THIS ROUTINE READS THE CONSOLE BUFFER.
;READ THE CP/M MANUALS FOR A GOOD DESCRIPTION
;OF HOW IT WORKS.
;NOTE THAT THE CONSOLE BUFFER IS STORED AT 'CONLIN',
;THE SIZE OF THE BUFFER IS STORED AT 'CONSIZ',
;AND THE MAX LENGTH OF BUFFER IS STORED AT 'CONBUF'.

MSUB1:	CALL	PRTBUF
BLNKBF:	LXI	H,CONLIN
	MVI	C,33
BLNKB1:	MVI	M,0
	INX	H
	DCR	C
	JNZ	BLNKB1
	MVI	C,RDCON
	LXI	D,CONBUF
	CALL	BDOS
	LXI	H,0
	LXI	D,CONLIN
	RET
;THIS ROUTINE TAKES THE ASCII INPUT FROM CONSOLE
;AND CONVERTS IT TO A FOUR(4) CHAR HEX NUMBER.

READC:	LDAX	D
	INX	D
	ORA	A
	RZ
	CPI	60H		;LOWER CASE ALPHA?
	JC	READC0		;NO, SKIP ADJUSTMENT
	SUI	20H		;CONVERT LC ALPHA TO UC
READC0:	DAD	H
	DAD	H
	DAD	H
	DAD	H
	SUI	48
	CPI	10
	JC	READC1
	SUI	7
READC1:	ADD	L
	MOV	L,A
	JMP	READC
;CKS CONSOLE FOR CHAR AND STORES IT 'A' REG.
CKCONS:	MVI	C,CONIN
	CALL	BDOS
	ANI	7FH	;STRIP PARITY
	RET
;'V' CMD BRANCHES HERE.IF ARGUMENT IS '?' THEN
;PROG GOES TO 'VALL'(DISP ENTIRE LIBRARY).
;ELSE ONLY ONE LINE IS DISPLAYED PER ARGUMENT.

VIEW:	CALL	CKCONS
	CPI	'?'
	JZ	VALL
	ANI	5FH		;FORCE UPPERCASE
	CALL	CKCHAR
	JC	CMDERR
	CALL	LINSEL
	MVI	B,32
	CALL	DCRLF
VONE1:	MOV	A,M
	CALL	DISP
	INX	H
	DCR	B
	JNZ	VONE1
	JMP	CMD1
VALL:	CALL	DCRLF
	CALL	DSPLIB
	JMP	CMD1
;DELETES ONE LINE OF THE LIBRARY(DENOTED BY ARGUMENT).

DELETE:	CALL	CKCONS
	CPI	3
	JZ	CMD
	ANI	5FH		;FORCE UPPERCASE
	CALL	CKCHAR
	JC	CMDERR
	CALL	LINSEL
	INX	H
	INX	H
	MVI	B,30
	CALL	DCRLF
DEL1:	MVI	M,' '
	INX	H
	DCR	B
	JNZ	DEL1
DELX:	MVI	A,1
	STA	CHGSW
	JMP	CMD
;INSERTS ONE LINE INTO LIBRARY(DENOTED BY ARGUMENT)
;IF A <CR> IS ENTERED AFTER THE 'I' CMD THEN THE
;INSERT MODE IS ABORTED,ELSE THEN ARGUMENT MUST
;BE A VALID CHAR 'A' TO 'Z' OR CONSOLE WILL
;DISPLAY A SYNTAX ERROR AND RETURN TO CMD PROMPT.
;THE VALID CHAR IS STORED IN 'LINCHR' FOR USE LATER.

INS:	CALL	CKCONS
	CPI	CR
	JZ	INEXIT
	ANI	5FH		;FORCE UPPERCASE
	CALL	CKCHAR
	JC	CMDERR
	STA	LINCHR
	PUSH	PSW
	CALL	DSPLIB
	POP	PSW
	CALL	LINSEL
	INX	H
	INX	H
	PUSH	H
;'MADDB' IS THE PROMPT LINE FOR INSERTING.

INS1:	LXI	D,MADDB
	CALL	PRTBUF
	LDA	LINCHR
	CALL	DISP
	MVI	A,'='
	CALL	DISP
	CALL	BLNKBF
	LXI	D,CONLIN
	LDA	CONSIZ
	ORA	A
	JZ	INEXIT
	CPI	30
	JNZ	INS1
	POP	H
	LXI	D,CONLIN
	MOV	B,A
INS2:	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	DCR	B
	JNZ	INS2
	JMP	DELX
;PROG COMES HERE IF ABORTING INSERT MODE.

INEXIT:	POP	H
	LXI	D,MABINS
	CALL	PRTBUF
	JMP	CMD1
;CHECKS FOR VALID CHAR 'A' TO 'Z' FROM CONSOLE.
;WILL RETURN WITH A CARRY IF CHAR NOT VALID.

CKCHAR:	CPI	'A'
	RC
	CPI	'Z'+1
	CMC
	RET
;DISPLAYS START ADDRESS ON CONSOLE.

DSPADR:	LHLD	LIBSTT
	MOV	A,H
	CALL	HEXASC
	MOV	A,L
	CALL	HEXASC
	LXI	D,MHEX
	CALL	PRTBUF
	RET
;CONVERS HEX BINARY NBR TO ASCII AND DISPS ON CONSOLE.

HEXASC:	PUSH	PSW
	RRC
	RRC
	RRC
	RRC
	CALL	OUTHEX
	POP	PSW
OUTHEX:	ANI	0FH
	ADI	90H
	DAA
	ACI	40H
	DAA
	CALL	DISP
	RET
;SELECTS LINE IN LIBRARY AS DENOTED BY A-Z ARGUMENT.

LINSEL:	ANI	1FH
	SUI	1
	LXI	D,32
	LXI	H,0
	MVI	B,8
LINSC1:	DAD	H
	RLC
	JNC	LINSC2
	DAD	D
LINSC2:	DCR	B
	JNZ	LINSC1
	XCHG
	LHLD	LIBSTT
	DAD	D
	SHLD	LINSTT
	RET
;WRITES OUTPUT FILE TO DISK STARTING FROM 'BUF'.
;THESE ARE STANDARD ROUTINES,NOTHING FANCY HERE.

WRTFIL:	LXI	D,FCB2
	MVI	C,MAKEF
	CALL	BDOS
	INR	A
	JNZ	DFOK
	LXI	D,MNOSPC
	CALL	PRTBUF
	JMP	CMD1
DFOK:	LDA	FCB1+15
	LXI	H,BUF
WRTFL1:	PUSH	PSW
	SHLD	DMADD
	PUSH	H
	POP	D
	MVI	C,SETDMA
	CALL	BDOS
	LXI	D,FCB2
	MVI	C,WRITEF
	CALL	BDOS
	ORA	A
	JZ	WRTOK
	POP	PSW
	LXI	D,FCB2
	MVI	C,CLOSEF
	CALL	BDOS
	LXI	D,MDFULL
	JMP	DOEXIT
WRTOK:	POP	PSW
	DCR	A
	ORA	A
	JZ	WRDONE
	LHLD	DMADD
	LXI	D,128
	DAD	D
	JMP	WRTFL1
WRDONE:	LXI	D,FCB2
	MVI	C,CLOSEF
	CALL	BDOS
	LXI	D,MSAVED
	JMP	DOEXIT
;PROG COMES HERE IF (P)'PRTLIB' CMD CALLED.
;WHAT IT DOES IS CHANGE 'CONOT' TO 'LIST' AT DPSW+1
;AND CHANGES BACK TO 'CONOT' AT END OF PRINTOUT.

PRTLIB:	MVI	A,LIST
	STA	DPSW+1
	CALL	DSPLIB
	CALL	DCRLF
	MVI	A,CONOT
	STA	DPSW+1
	JMP	CMD1
;THESE CONTAIN THE EXIT ROUTINES.
;IF NO INSERT OR DELETE HAS BEEN DONE,THEN 'CHGSW'
;IS '0' AND THEN PROG EXITS.IF AN INSERT OR DELETE
;HAS BEEN PERFORMED THEN 'CHGSW' WAS SET TO '1'
;AND USER IS ASKED IF NEW FILE IS TO BE SAVED.
;IF USER ANSWERS 'Y' THEN A 'WRTFIL' IS DONE AND
;PROG IS EXITED.IF ANSWER IS 'N' THEN PROG EXITS
;WITHOUT WRITING NEW FILE.

EXIT:	LDA	CHGSW
	ORA	A
	JZ	DOEXT1
EXIT1:	LXI	D,MCKSAV
	CALL	PRTBUF
	CALL	CKCONS
	ANI	5FH		;FORCE UPPERCASE
	CPI	'Y'
	JZ	WRTFIL
	CPI	'N'
	JNZ	EXIT1
	JMP	DOEXT1
DOEXIT:	CALL	PRTBUF
DOEXT1:	LXI	D,MEXIT
	CALL	PRTBUF
	JMP	BOOT
;THE DATA AREA STORES ALL THE MESSAGES,AND ALL THE 
;OTHER DATA USED BY THE PROG.

;DATA AREA
MPROG:	DB	CR,LF,'CHGLIB PROGRAM..'
	DB	'FOR CHANGING DIAL LIBRARY....'
	DB	CR,LF,'TONY RIBEIRO JAN 1982 $'
MNOSF:	DB	CR,LF,'SOURCE FILE NOT SPECIFIED....$'
MNODF:	DB	CR,LF,'OUTPUT FILE NOT SPECIFIED$'
MUNSF:	DB	CR,LF,'UNABLE TO OPEN SOURCE FILE...$'
MUNDF:	DB	CR,LF,'OUTPUT FILE ALREADY EXISTS....$'
MNOSPC:	DB	CR,LF,'NO DIRECTORY SPACE.......$'
MLOADF:	DB	CR,LF,'LOADING FILE.............$'
MADR:	DB	CR,LF,'DO YOU KNOW STARTING ADDR OF '
	DB	'DIAL LIBRARY? $'
MSRCH:	DB	CR,LF,'DO YOU WISH FOR AUTO SEARCH OF '
	DB	'THE START OF THE DIAL LIBRARY? $'
MEXIT:	DB	CR,LF,'EXITING PROG AND REBOOTING....$'
MDOADR:	DB	CR,LF,'ENTER HEX ADDR(4 CHARS) $'
MDLNF:	DB	CR,LF,'DIAL LIBRARY NOT FOUND IN '
	DB	'FIRST 255 BYTES.....$'
MDLFND:	DB	CR,LF,'DIAL LIBRARY FOUND........$'
MDLOK:	DB	CR,LF,'DOES LIBRARY LOOK RIGHT?$'
MCMD:	DB	CR,LF,'? >(D)ELETE,(I)NSERT,'
	DB	'(P)RINT LIB,(R)EAD,(V)IEW,(W)RITE $'
MSYNER:	DB	CR,LF,'SYNTAX ERROR...............$'
MABINS:	DB	CR,LF,'ABORTING INSERT MODE..NO CHGS$'
MADDB:	DB	CR,LF,'  DESC            1-XXX-XXX-XXXX'
	DB	'< 30 CHARS EXACTLY',CR,LF,'$'
MDFULL:	DB	CR,LF,'DISK FULL...................$'
MSAVED:	DB	CR,LF,'FILE SAVED ON DISK..........$'
MCKSAV:	DB	CR,LF,'WANT TO SAVE NEW FILE (Y/N)? $'
MHEX:	DB	' HEX $'
DMADD:	DW	0
LIBSTT:	DW	0
LINSTT:	DW	0
CHGSW:	DB	0
PRTSW:	DB	0
SRCLMT:	DB	0
LINCHR:	DB	0
CONBUF:	DB	CONLEN
CONSIZ:	DS	1
CONLIN:	DS	33
CONLEN:	EQU	$-CONSIZ
KPCLR:	DB	0
FCB1:	DS	36
FCB2:	DS	36
STKSPC:	DS	20
STACK:	EQU	$
BUF:	EQU	$
	END
