


								  terminfo(5)



   Name
     terminfo -	terminal capability database

   Syntax
     /usr/lib/terminfo/*/*

   Description
     The _t_e_r_m_i_n_f_o database describes terminals by giving a set of capabili-
     ties which	the terminals have, and	by describing how the operations are
     performed by the terminals.  Padding requirements and initialization
     sequences are included in _t_e_r_m_i_n_f_o.

     Entries in	_t_e_r_m_i_n_f_o consist of a number of	fields separated by commas
     (,) .  White space	after each comma (,) is	ignored.  The first entry for
     each terminal provides the	known name of the terminal, separated by
     vertical bars (|).	 The first name	given is the most common abbreviation
     for the terminal; the last	name given should be a long name fully iden-
     tifying the terminal.  All	others are understood as synonyms for the
     terminal name.  All names,	with the exception of the last,	should be in
     lowercase and cannot contain blanks; the last name	can contain uppercase
     characters	and blanks for readability.

     Terminal names, except for	the last, should be chosen using the follow-
     ing conventions:

     o+	  The piece of hardware	that makes up the terminal should have a root
	  name chosen.	For example, hp2621.

     o+	  The root name	cannot contain hyphens,	but synonyms can be used that
	  do not conflict with other names.

     o+	  Modes	that the hardware can be in, or	user preferences, should be
	  indicated by appending a hyphen and an indicator of the mode.	 For
	  example, a VT100 in 132 column mode would be vt100-w.

     o+	  The following	suffixes should	be used	where possible:

	    Suffix		   Meaning		    Example
	    -w	     Wide mode (more than 80 columns)	    vt100-w
	    -am	     With auto.	margins	(usually default)   vt100-am
	    -nam     Without automatic margins		    vt100-nam
	    -_n	     Number of lines on	the screen	    aaa-60
	    -na	     No	arrow keys (leave them in local)    c100-na
	    -_np	     Number of pages of	memory		    c100-4p
	    -rv	     Reverse video			    c100-rv

     The following headers are used in the capabilities	table:

     Variable booleans Variable	is the name by which the programmer (at	the
		       terminfo	level) accesses	the capability.

     Capname	       Short name used in the text of the database, and	is
		       used by a person	updating the database.


									    1






   terminfo(5)


     I.code	       Two-letter internal code	used in	the compiled data-
		       base, which always corresponds to the old _t_e_r_m_c_a_p
		       capability name.

     Capability	names have no hard length limit, but an	informal limit of 5
     characters	has been adopted to keep them short and	to allow the tabs in
     the source	file caps to line up nicely.  Whenever possible, names are
     chosen to be the same as, or similar to, the ANSI X3.64-1979 standard.
     Semantics are also	intended to match those	of the specification.  They
     are as follows:

     (P)     Indicates that padding may	be specified.

     (G)     Indicates that the	string is passed through tparm with parms as
	     given (#_i).

     (*)     Indicates that padding may	be based on the	number of lines
	     affected

     (#	)    Indicates the _ith parameter.
       _i


	  Variable	     Cap-     I.		Description
	  Booleans	     name    Code
   auto_left_margin,	     bw	     bw	    cub1 wraps from column 0 to	last
					    column
   auto_right_margin,	     am	     am	    Terminal has automatic margins
   beehive_glitch,	     xsb     xb	    Beehive (f1=escape,	f2=ctrl	C)
   ceol_standout_glitch,     xhp     xs	    Standout not erased	by over-
					    writing (hp)
   eat_newline_glitch,	     xenl    xn	    Newline ignored after 80 cols
					    (Concept)
   erase_overstrike,	     eo	     eo	    Can	erase overstrikes with a
					    blank
   generic_type,	     gn	     gn	    Generic line type (for ex.,	dialup,
					    switch).
   hard_copy,		     hc	     hc	    Hardcopy terminal
   has_meta_key,	     km	     km	    Has	a meta key (shift, sets
					    parity bit)
   has_status_line,	     hs	     hs	    Has	extra status line
   insert_null_glitch,	     in	     in	    Insert mode	distinguishes nulls
   memory_above,	     da	     da	    Display may	be retained above the
					    screen
   memory_below,	     db	     db	    Display may	be retained below the
					    screen
   move_insert_mode,	     mir     mi	    Safe to move while in insert mode
   move_standout_mode,	     msgr    ms	    Safe to move in standout modes
   over_strike,		     os	     os	    Terminal overstrikes
   status_line_esc_ok,	     eslok   es	    Escape can be used on the status
					    line
   teleray_glitch,	     xt	     xt	    Tabs ruin, magic so	char (Teleray
					    1061)
   tilde_glitch,	     hz	     hz	    Hazeltine; can not print tildes (~)s


   2






								  terminfo(5)


   transparent_underline,    ul	     ul	    underline character	overstrikes
   xon_xoff,		     xon     xo	    Terminal uses xon/xoff handshaking

   Numbers:
   columns,		     cols    co	    Number of columns in a line
   init_tabs,		     it	     it	    Tabs initially every # spaces
   lines,		     lines   li	    Number of lines on screen or page
   lines_of_memory,	     lm	     lm	    Lines of memory if > lines.	 0
					    means varies
   magic_cookie_glitch,	     xmc     sg	    Number of blank chars left by
					    smso or rmso
   padding_baud_rate,	     pb	     pb	    Lowest baud	where cr/nl padding
					    is needed
   virtual_terminal,	     vt	     vt	    Virtual terminal number (UNIX
					    system)
   width_status_line,	     wsl     ws	    Number of columns in status	line

   Strings:
   back_tab,		     cbt     bt	    Back tab (P)
   bell,		     bel     bl	    Audible signal (bell) (P)
   carriage_return,	     cr	     cr	    Carriage return (P*)
   change_scroll_region,     csr     cs	    Change to lines #1 through #2
					    (vt100) (PG)
   clear_all_tabs,	     tbc     ct	    Clear all tab stops	(P)
   clear_screen,	     clear   cl	    Clear screen and home cursor (P*)
   clr_eol,		     el	     ce	    Clear to end of line (P)
   clr_eos,		     ed	     cd	    Clear to end of display (P*)
   column_address,	     hpa     ch	    Set	cursor column (PG)
   command_character,	     cmdch   CC	    Term. settable cmd char in
					    prototype
   cursor_address,	     cup     cm	    Screen rel.	cursor motion row #1
					    col	#2 (PG)
   cursor_down,		     cud1    do	    Down one line
   cursor_home,		     home    ho	    Home cursor	(if no cup)
   cursor_invisible,	     civis   vi	    Make cursor	invisible
   cursor_left,		     cub1    le	    Move cursor	left one space
   cursor_mem_address,	     mrcup   CM	    Memory relative cursor addressing
   cursor_normal,	     cnorm   ve	    Make cursor	appear normal
					    (undo vs/vi)
   cursor_right,	     cuf1    nd	    Nondestructive space (cursor
					    right)
   cursor_to_ll,	     ll	     ll	    Last line, first column (if	no cup)
   cursor_up,		     cuu1    up	    Upline (cursor up)
   cursor_visible,	     cvvis   vs	    Make cursor	very visible
   delete_character,	     dch1    dc	    Delete character (P*)
   delete_line,		     dl1     dl	    Delete line	(P*)
   dis_status_line,	     dsl     ds	    Disable status line
   down_half_line,	     hd	     hd	    Half-line down (forward 1/2
					    linefeed)
   enter_alt_charset_mode,   smacs   as	    Start alternate character set (P)
   enter_blink_mode,	     blink   mb	    Turn on blinking
   enter_bold_mode,	     bold    md	    Turn on bold (extra	bright)	mode
   enter_ca_mode,	     smcup   ti	    String to begin programs that use
					    cup


									    3






   terminfo(5)


   enter_delete_mode,	     smdc    dm	    Delete mode	(enter)
   enter_dim_mode,	     dim     mh	    Turn on half-bright	mode
   enter_insert_mode,	     smir    im	    Insert mode	(enter);
   enter_protected_mode,     prot    mp	    Turn on protected mode
   enter_reverse_mode,	     rev     mr	    Turn on reverse video mode
   enter_secure_mode,	     invis   mk	    Turn on blank mode (chars
					    invisible)
   enter_standout_mode,	     smso    so	    Begin stand	out mode
   enter_underline_mode,     smul    us	    Start underscore mode
   erase_chars		     ech     ec	    Erase #1 characters	(PG)
   exit_alt_charset_mode,    rmacs   ae	    End	alternate character set	(P)
   exit_attribute_mode,	     sgr0    me	    Turn off all attributes
   exit_ca_mode,	     rmcup   te	    String to end programs that	use cup
   exit_delete_mode,	     rmdc    ed	    End	delete mode
   exit_insert_mode,	     rmir    ei	    End	insert mode
   exit_standout_mode,	     rmso    se	    End	stand out mode
   exit_underline_mode,	     rmul    ue	    End	underscore mode
   flash_screen,	     flash   vb	    Visible bell (may not move
					    cursor)
   form_feed,		     ff	     ff	    Hardcopy terminal page eject (P*)
   from_status_line,	     fsl     fs	    Return from	status line
   init_1string,	     is1     i1	    Terminal initialization string
   init_2string,	     is2     i2	    Terminal initialization string
   init_3string,	     is3     i3	    Terminal initialization string
   init_file,		     if	     if	    Name of file containing is
   insert_character,	     ich1    ic	    Insert character (P)
   insert_line,		     il1     al	    Add	new blank line (P*)
   insert_padding,	     ip	     ip	    Insert pad after character
					    inserted (p*)
   key_backspace,	     kbs     kb	    Sent by backspace key
   key_catab,		     ktbc    ka	    Sent by clear-all-tabs key
   key_clear,		     kclr    kC	    Sent by clear screen or erase key
   key_ctab,		     kctab   kt	    Sent by clear-tab key
   key_dc,		     kdch1   kD	    Sent by delete character key
   key_dl,		     kdl1    kL	    Sent by delete line	key
   key_down,		     kcud1   kd	    Sent by terminal down arrow	key
   key_eic,		     krmir   kM	    Sent by rmir or smir in insert mode
   key_eol,		     kel     kE	    Sent by clear-to-end-of-line key
   key_eos,		     ked     kS	    Sent by clear-to-end-of-screen
					    key
   key_f0,		     kf0     k0	    Sent by function key f0
   key_f1,		     kf1     k1	    Sent by function key f1
   key_f10,		     kf10    ka	    Sent by function key f10
   key_f2,		     kf2     k2	    Sent by function key f2
   key_f3,		     kf3     k3	    Sent by function key f3
   key_f4,		     kf4     k4	    Sent by function key f4
   key_f5,		     kf5     k5	    Sent by function key f5
   key_f6,		     kf6     k6	    Sent by function key f6
   key_f7,		     kf7     k7	    Sent by function key f7
   key_f8,		     kf8     k8	    Sent by function key f8
   key_f9,		     kf9     k9	    Sent by function key f9
   key_home,		     khome   kh	    Sent by home key
   key_ic,		     kich1   kI	    Sent by ins	char/enter ins mode key
   key_il,		     kil1    kA	    Sent by insert line


   4






								  terminfo(5)


   key_left,		     kcub1   kl	    Sent by terminal left arrow	key
   key_ll,		     kll     kH	    Sent by home-down key
   key_npage,		     knp     kN	    Sent by next-page key
   key_ppage,		     kpp     kP	    Sent by previous-page key
   key_right,		     kcuf1   kr	    Sent by terminal right arrow key
   key_sf,		     kind    kF	    Sent by scroll-forward/down	key
   key_sr,		     kri     kR	    Sent by scroll-backward/up key
   key_stab,		     khts    kT	    Sent by set-tab key
   key_up,		     kcuu1   ku	    Sent by terminal up	arrow key
   keypad_local,	     rmkx    ke	    Out	of "keypad transmit" mode
   keypad_xmit,		     smkx    ks	    Put	terminal in "keypad transmit"
					    mode
   lab_f0,		     lf0     l0	    Labels on function key f0 if not f0
   lab_f1,		     lf1     l1	    Labels on function key f1 if not f1
   lab_f10,		     lf10    la	    Labels on function key f10 if not
					    f10
   lab_f2,		     lf2     l2	    Labels on function key f2 if not f2
   lab_f3,		     lf3     l3	    Labels on function key f3 if not f3
   lab_f4,		     lf4     l4	    Labels on function key f4 if not f4
   lab_f5,		     lf5     l5	    Labels on function key f5 if not f5
   lab_f6,		     lf6     l6	    Labels on function key f6 if not f6
   lab_f7,		     lf7     l7	    Labels on function key f7 if not f7
   lab_f8,		     lf8     l8	    Labels on function key f8 if not f8
   lab_f9,		     lf9     l9	    Labels on function key f9 if not f9
   meta_on,		     smm     mm	    Turn on "meta mode"	(8th bit)
   meta_off,		     rmm     mo	    Turn off "meta mode"
   newline,		     nel     nw	    Newline (behaves like cr followed
					    by lf)
   pad_char,		     pad     pc	    Pad	character (rather than null)
   parm_dch,		     dch     DC	    Delete #1 chars (PG*)
   parm_delete_line,	     dl	     DL	    Delete #1 lines (PG*)
   parm_down_cursor,	     cud     DO	    Move cursor	down #1	lines (PG*)
   parm_ich,		     ich     IC	    Insert #1 blank chars (PG*)
   parm_index,		     indn    SF	    Scroll forward #1 lines (PG)
   parm_insert_line,	     il	     AL	    Add	#1 new blank lines (PG*)
   parm_left_cursor,	     cub     LE	    Move cursor	left #1	spaces (PG)
   parm_right_cursor,	     cuf     RI	    Move cursor	right #1 spaces	(PG*)
   parm_rindex,		     rin     SR	    Scroll backward #1 lines (PG)
   parm_up_cursor,	     cuu     UP	    Move cursor	up #1 lines (PG*)
   pkey_key,		     pfkey   pk	    Prog funct key #1 to type string #2
   pkey_local,		     pfloc   pl	    Prog funct key #1 to execute string
					    #2
   pkey_xmit,		     pfx     px	    Prog funct key #1 to xmit string #2
   print_screen,	     mc0     ps	    Print contents of the screen
   prtr_off,		     mc4     pf	    Turn off the printer
   prtr_on,		     mc5     po	    Turn on the	printer
   repeat_char,		     rep     rp	    Repeat char	#1 #2 times.  (PG*)
   reset_1string,	     rs1     r1	    Reset terminal completely to sane
					    modes.
   reset_2string,	     rs2     r2	    Reset terminal completely to sane
					    modes.
   reset_3string,	     rs3     r3	    Reset terminal completely to sane
					    modes.
   reset_file,		     rf	     rf	    Name of file containing reset


									    5






   terminfo(5)


					    string
   restore_cursor,	     rc	     rc	    Restore cursor to position of
					    last sc
   row_address,		     vpa     cv	    Vertical position absolute
					    (set row) (PG)
   save_cursor,		     sc	     sc	    Save cursor	position (P)
   scroll_forward,	     ind     sf	    Scroll text	up (P)
   scroll_reverse,	     ri	     sr	    Scroll text	down (P)
   set_attributes,	     sgr     sa	    Define the video attributes	(PG9)
   set_tab,		     hts     st	    Set	a tab in all rows, current
					    column
   set_window,		     wind    wi	    Current window is lines #1-#2
					    cols #3-#4
   tab,			     ht	     ta	    Tab	to next	8 space	hardware tab
					    stop
   to_status_line,	     tsl     ts	    Go to status line, column #1
   underline_char,	     uc	     uc	    Underscore one char	and move past
					    it
   up_half_line,	     hu	     hu	    Half-line up (reverse 1/2 linefeed)
   init_prog,		     iprog   iP	    Path name of program for init
   key_a1,		     ka1     K1	    Upper left of keypad
   key_a3,		     ka3     K3	    Upper right	of keypad
   key_b2,		     kb2     K2	    Center of keypad
   key_c1,		     kc1     K4	    Lower left of keypad
   key_c3,		     kc3     K5	    Lower right	of keypad
   prtr_non,		     mc5p    pO	    Turn on the	printer	for #1 bytes

     Sample Entry

     The following entry, which	describes the Concept-100, is one of the more
     complex entries in	the _t_e_r_m_i_n_f_o:

     concept100|c100|concept|c104|c100-4p|concept 100,
	am, bel=^G, blank=\EH, blink=\EC, clear=^L$<2*>, cnorm=\Ew,
	cols#80, cr=^M$<9>, cub1=^H, cud1=^J, cuf1=\E=,
	cup=\Ea%p1%' '%+%c%p2%'	'%+%c,
	cuu1=\E;, cvvis=\EW, db, dch1=\E^A$<16*>, dim=\EE, dl1=\E^B$<3*>,
	ed=\E^C$<16*>, el=\E^U$<16>, eo, flash=\Ek$<20>\EK, ht=\t$<8>,
	il1=\E^R$<3*>, in, ind=^J, .ind=^J$<9>,	ip=$<16*>,
	is2=\EU\Ef\E7\E5\E8\El\ENH\EK\E\200\Eo&\200\Eo\47\E,
	kbs=^h,	kcub1=\E>, kcud1=\E<, kcuf1=\E=, kcuu1=\E;,
	kf1=\E5, kf2=\E6, kf3=\E7, khome=\E?,
	lines#24, mir, pb#9600,	prot=\EI, rep=\Er%p1%c%p2%' '%+%c$<.2*>,
	rev=\ED, rmcup=\Ev    $<6>\Ep\r\n, rmir=\E\200,	rmkx=\Ex,
	rmso=\Ed\Ee, rmul=\Eg, rmul=\Eg, sgr0=\EN\200,
	smcup=\EU\Ev  8p\Ep\r, smir=\E^P, smkx=\EX, smso=\EE\ED,
	smul=\EG, tabs,	ul, vt#8, xenl,

     Entries can continue onto multiple	lines by placing white space at	the
     beginning of each line, with the exception	of the first line.  Comments
     can be included, as long as the comment is	preceded by a number sign
     (#).  The following list describes	terminal capabilities in more detail.




   6






								  terminfo(5)


     Types of Capabilities

     Boolean capabilities  Indicate that the terminal has some particular
			   feature.  For example, the Concept-100 has
			   automatic margins (an automatic return and
			   linefeed when the end-of-line is reached).  This
			   is described	in the Boolean capabilities column as
			   an am.

     Numeric capabilities  Provide the size of the terminal or the size	of
			   particular delays.  Numeric capabilities are	fol-
			   lowed by a number sign (#) and then the value.
			   Hence, the cols, which indicates the	number of
			   column the terminal has, provides the value 80 for
			   the Concept.

     String capabilities   Provide a sequence that can be used to perform
			   particular terminal operations.  Hence, string-
			   valued capabilities such as el (clear to the	end-
			   of-line sequence are	described the 2-character
			   code	(an equal sign (=) and then a string ending
			   at the next comma (,).  A delay in milliseconds
			   can appear anywhere in such a capability, enclosed
			   in $<..> brackets, and padding characters are sup-
			   plied by _t_p_u_t_s to provide this delay.

			   A delay can be either a number, such	as 20, or a
			   number followed by an asterisk (*), such as 3*.
			   The asterisk	(*) indicates that the padding
			   required is proportional to the number of lines
			   affected by the operation, and the amount given is
			   the per-affected-unit padding required.  (In	the
			   case	of the insert character, the factor is still
			   the number of lines affected.  This is always one,
			   unless the terminal has xenl	and the	software uses
			   it.)	When an	asterisk (*) is	specified, it is
			   sometimes useful to give a delay of the form	3.5,
			   which indicates a delay per unit to tenths of mil-
			   liseconds.  (Only one decimal place is allowed.)

     Escape sequences are provided in the string-valued	capabilities for easy
     encoding of characters there.  Both \E and	\e map to an ESCAPE charac-
     ter, ^x maps to a control-x for any appropriate x,	and the	sequences \n
     \l	\r \t \b \f \s give a newline, linefeed, return, tab, backspace,
     formfeed, and space.  Other escapes include \^ for	^, \\ for \, \,	for
     comma, \: for :, and \0 for null.	(\0 will produce \200, which does not
     terminate a string	but behaves as a null character	on most	terminals.)
     Finally, characters may be	given as three octal digits after a \.

     Sometimes individual capabilities must be commented out.  To do this,
     put a period before the capability	name.  For example, see	the second
     ind in the	previous Sample	Entry.




									    7






   terminfo(5)



     Preparing Descriptions

     This section describes how	to prepare a description of a terminal.	 The
     most effective way	to prepare a terminal description is by	imitating the
     description of a similar terminal in _t_e_r_m_i_n_f_o and to build	up a descrip-
     tion gradually.  A	very unusual terminal may expose deficiencies in the
     ability of	the _t_e_r_m_i_n_f_o file to describe the terminal.

     To	test a new terminal description, set the environment variable TER-
     MINFO to a	pathname of a directory	containing the compiled	description
     you are working on.  The programs can search this directory rather	than
     search /_u_s_r/_l_i_b/_t_e_r_m_i_n_f_o.	To get the padding for insert line right (if
     the terminal manufacturer did not document	it), edit /etc/passwd at 9600
     baud, delete 16 or	so lines from the middle of the	screen,	then type the
     character u several times quickly.	 If the	terminal behaves erratically,
     more padding is usually needed.  A	similar	test can be used for the
     insert character.

     Basic Capabilities

     The number	of columns on each line	for the	terminal is specified by the
     cols numeric capability.  If the terminal is a CRT, then the number of
     lines on the screen is given by the lines capability.  If the terminal
     wraps around to the beginning of the next line when it reaches the	right
     margin, then it should have the am	capability.  If	the terminal can
     clear its screen, leaving the cursor in the home position,	then this is
     given by the clear	string capability.  If the terminal overstrikes
     (rather than clearing a position when a character is struck over),	then
     it	should have the	os capability.	If the terminal	is a printing termi-
     nal, with no soft copy unit, give it both hc and os.  (os applies to
     storage scope terminals, such as TEKTRONIX	4010 series, as	well as	hard
     copy and APL terminals.) If there is a code to move the cursor to the
     left edge of the current row, give	this as	cr.  (Normally this will be
     carriage return, control M.) If there is a	code to	produce	an audible
     signal (bell, beep, etc), give this as bel.

     If	there is a code	to move	the cursor one position	to the left (such as
     backspace)	that capability	should be given	as cub1.  Similarly, codes to
     move to the right,	up, and	down should be given as	cuf1, cuu1, and	cud1.
     These local cursor	motions	should not alter the text they pass over; for
     example, you would	not normally use `cuf1=	' because the space would
     erase the character moved over.

				       _N_o_t_e

	  The local cursor motions encoded in _t_e_r_m_i_n_f_o are undefined at
	  the left and top edges of a CRT terminal.  Programs should
	  never	attempt	to backspace around the	left edge, unless bw is
	  given, and never attempt to go up locally off	the top.  In
	  order	to scroll text up, a program will go to	the bottom left
	  corner of the	screen and send	the ind	(index)	string.




   8






								  terminfo(5)


     To	scroll text down, a program goes to the	top left corner	of the screen
     and sends the ri (reverse index) string.  The strings ind and ri are
     undefined when not	on their respective corners of the screen.

     Parameterized versions of the scrolling sequences are indn	and rin,
     which have	the same semantics as ind and ri, except that they take	one
     parameter and scroll that many lines.  They are also undefined, except
     at	the appropriate	edge of	the screen.

     The am capability tells whether the cursor	sticks at the right edge of
     the screen	when text is output, but this does not necessarily apply to a
     cuf1 from the last	column.	 The only local	motion that is defined from
     the left edge is if bw is given, then a cub1 from the left	edge will
     move to the right edge of the previous row.  If bw	is not given, the
     effect is undefined.  This	is useful for drawing a	box around the edge
     of	the screen, for	example.  If the terminal has switch-selectable
     automatic margins,	the _t_e_r_m_i_n_f_o file usually assumes that this is on;
     that is, am.  If the terminal has a command which moves to	the first
     column of the next	line, that command can be given	as nel (newline).  It
     does not matter if	the command clears the remainder of the	current	line,
     so, if the	terminal has no	cr and lf, it may still	be possible to craft
     a working nel out of one or both of them.

     These capabilities	suffice	to describe hardcopy and glass-tty terminals.
     Thus, the Model 33	Teletype is described as:

     33|tty33|tty|model	33 teletype,
     bel=^G, cols#72, cr=^M, cud1=^J, hc, ind=^J, os,

     The Lear Siegler ADM-3 is described as:

     adm3|3|lsi	adm3,
     am, bel=^G, clear=^Z, cols#80, cr=^M, cub1=^H, cud1=^J,
     ind=^J, lines#24,

     Parameterized Strings

     Cursor addressing and other strings requiring parameters in the terminal
     are described by a	parameterized string capability, with _p_r_i_n_t_f(3s),
     such as escapes like %x.  For example, to address the cursor, the cup
     capability	is given, using	two parameters:	the row	and column to address
     to.  (Rows	and columns are	numbered from zero and refer to	the physical
     screen visible to the user, not to	any unseen memory.) If the terminal
     has memory-relative cursor	addressing, that can be	indicated by mrcup.

     The parameter mechanism uses a stack and special %	codes to manipulate
     it.  Typically a sequence pushes one of the parameters onto the stack
     and then prints it	in some	format.	 Often,	more complex operations	are
     necessary.

     The percent sign (%) encodings have the following meanings:

	  %%	    outputs `%'
	  %d	    print pop()	as in printf


									    9






   terminfo(5)


	  %2d	    print pop()	like %2d
	  %3d	    print pop()	like %3d
	  %02d
	  %03d	    as in printf
	  %c	    print pop()	gives %c
	  %s	    print pop()	gives %s

	  %p[1-9]   push ith parm
	  %P[a-z]   set	variable [a-z] to pop()
	  %g[a-z]   get	variable [a-z] and push	it
	  %'c'	    char constant c
	  %{nn}	    integer constant nn

	  %+ %-	%* %/ %m
		    arithmetic (%m is mod): push(pop() op pop())
	  %& %|	%^  bit	operations: push(pop() op pop())
	  %= %>	%<  logical operations:	push(pop() op pop())
	  %! %~	    unary operations push(op pop())
	  %i	    add	1 to first two parms (for ANSI terminals)

	  %? expr %t thenpart %e elsepart %;
		    if-then-else, %e elsepart is optional.
		    else-if's are possible ala Algol 68:
		    %? c  %t b	%e c  %t b  %e c  %t b	%e c  %t b  %e %;
		    c  a1re con1dition2s, b  2are bo3dies. 3	    4	  4
		     i			i
     Binary operations are in postfix form with	the operands in	the usual
     order.  That is, to get x-5, use %gx%{5}%-.

     Consider the HP2645, which, to get	to row 3 and column 12,	needs to be
     sent \E&a12c03Y padded for	6 milliseconds.	 Note that the order of	the
     rows and columns is inverted here,	and that the row and column are
     printed as	two digits.  Thus, its cup capability is
     cup=6\E&%p2%2dc%p1%2dY.

     The Microterm ACT-IV needs	the current row	and column sent	preceded by a
     ^T, with the row and column simply	encoded	in binary, cup=^T%p1%c%p2%c.
     Terminals that use	%c need	to be able to backspace	the cursor (cub1),
     and to move the cursor up one line	on the screen (cuu1).  This is neces-
     sary because it is	not always safe	to transmit \n ^D and \r, as the sys-
     tem may change or discard them.  (The library routines dealing with ter-
     minfo set tty modes so that tabs are never	expanded, so \t	is safe	to
     send.  This turns out to be essential for the Ann Arbor 4080.)

     A final example is	the LSI	ADM-3a,	which uses row and column offset by a
     blank character; thus cup=\E=%p1%'	'%+%c%p2%' '%+%.  After	sending	\E=,
     this pushes the first parameter, pushes the ASCII value for a space
     (32), adds	them (pushing the sum on the stack in place of the two previ-
     ous values), and outputs that value as a character.  Then,	the same is
     done for the second parameter.  More complex arithmetic is	possible
     using the stack.

     If	the terminal has row or	column absolute	cursor addressing, these can
     be	given as single	parameter capabilities hpa (horizontal position


   10






								  terminfo(5)


     absolute) and vpa (vertical position absolute).  Sometimes, these are
     shorter than the more general 2-parameter sequence	(as with the hp2645)
     and can be	used in	preference to cup . If there are parameterized local
     motions (for example, move	_n spaces to the	right),	these can be given as
     cud, cub, cuf, and	cuu, with a single parameter indicating	how many
     spaces to move.  These are	primarily useful if the	terminal does not
     have cup, such as the TEKTRONIX 4025.

     Cursor Motions

     If	the terminal has a fast	way to home the	cursor (to very	upper left
     corner of screen),	then this can be given as home.	Similarly, a fast way
     of	getting	to the lower left-hand corner can be given as ll. This may
     involve going up with cuu1	from the home position,	but a program should
     never do this itself (unless ll does), because it can make	no assumption
     about the effect of moving	up from	the home position.  Note that the
     home position is the same as addressing to	(0,0): the top left corner of
     the screen, not memory.  Thus, the	\EH sequence on	HP terminals cannot
     be	used for home.

     Area Clears

     If	the terminal can clear from the	current	position to the	end of the
     line, leaving the cursor where it is, this	should be given	as el.	If
     the terminal can clear from the current position to the end of the
     display, this should be given as ed.  Ed is only defined from the first
     column of a line.	Thus, it can be	simulated by a request to delete a
     large number of lines, if a true ed is not	available.

     Insert/delete line

     If	the terminal can open a	new blank line before the line where the cur-
     sor is, this should be given as il1; this is done only from the first
     position of a line.  The cursor must then appear on the newly blank
     line.  If the terminal can	delete the line	that the cursor	is on, this
     should be given as	dl1; this is done only from the	first position on the
     line to be	deleted.  Versions of il1 and dl1 that take a single parame-
     ter and insert or delete that many	lines can be given as il and dl.  If
     the terminal has a	settable scrolling region (like	the VT100), the	com-
     mand to set this can be described with the	csr capability,	which takes
     two parameters: the top and bottom	lines of the scrolling region.	The
     cursor position is	undefined after	using this command.  It	is possible
     to	get the	effect of insert or delete line	using this command. The	sc
     and rc (save and restore cursor) commands are also	useful.	 Inserting
     lines at the top or bottom	of the screen can also be done using ri	or
     ind on many terminals without a true insert/delete	line, and this is
     often faster even on terminals with those features.

     If	the terminal has the ability to	define a window	as part	of memory,
     which all commands	affect,	it should be given as the parameterized
     string wind.  The four parameters are the starting	and ending lines in
     memory and	the starting and ending	columns	in memory, in that order.




									   11






   terminfo(5)


     If	the terminal can retain	display	memory above, then the da capability
     should be given; if display memory	can be retained	below, then db should
     be	given.	These indicate that deleting a line or scrolling may bring
     nonblank lines up from below or that scrolling back with ri may bring
     down nonblank lines.

     Insert/Delete Character

     There are two basic kinds of intelligent terminals	with respect to
     insert/delete character that can be described using _t_e_r_m_i_n_f_o.  The	most
     common insert/delete character operations affect only the characters on
     the current line and shift	characters off the end of the line rigidly.
     Other terminals, such as the Concept-100 and the Perkin Elmer Owl,	make
     a distinction between typed and untyped blanks on the screen, shifting
     upon an insert or delete only to an untyped blank on the screen that is
     either eliminated or expanded to two untyped blanks.  You can determine
     the kind of terminal you have by clearing the screen and typing text
     separated by cursor motions.  Type	``abc	 def'',	using local cursor
     motions (not spaces) between the abc and the def.	Then, position the
     cursor before the abc and put the terminal	in insert mode.	 If typing
     characters	causes the rest	of the line to shift rigidly and characters
     fall off the end, then your terminal does not distinguish between blanks
     and untyped positions.  If	the abc	shifts over to the def which then
     move together around the end of the current line and onto the next	as
     you insert, you have the second type of terminal. You should give the
     capability	in, which stands for ``insert null''.  While these are two
     logically separate	attributes (one	line, as opposed to multiline insert
     mode, and special treatment of untyped spaces) every terminal's insert
     mode can be described with	the single attribute.

     Terminfo can describe both	terminals that have an insert mode and termi-
     nals that send a simple sequence to open a	blank position on the current
     line.  Give as smir the sequence to get into insert mode.	Give as	rmir
     the sequence to leave insert mode.	 Then, give as ich1 any	sequence
     needed to be sent just before sending the character to be inserted.
     Most terminals with a true	insert mode will not give ich1;	terminals
     that send a sequence to open a screen position should give	it here.

				       _N_o_t_e

	  If your terminal has both, insert mode is usually preferable
	  to ich1.  Do not give	both, unless the terminal actually
	  requires both	to be used in combination.

     If	post insert padding is needed, give this as a number of	milliseconds
     in	ip (a string option).  Any other sequence that may need	to be sent
     after an insert of	a single character may also be given in	ip.  If	your
     terminal needs both to be placed into an insert mode and a	special	code
     to	precede	each inserted character, both smir/rmir	and ich1 can be
     given, and	both will be used.  The	ich capability,	with one parameter,
     _n,	will repeat the	effects	of ich1	_n times.

     It	is occasionally	necessary to move around while in insert mode to
     delete characters on the same line	(for example, if there is a tab	after


   12






								  terminfo(5)


     the insertion position).  If your terminal	allows motion while in insert
     mode, you can give	the capability mir to speed up inserting.  Omitting
     mir affects only speed.   Some terminals (notably Datamedia's) must not
     have mir because of the way their insert mode works.

     Finally, you can specify dch1 to delete a single character, dch, with
     one parameter, _n, to delete _n _c_h_a_r_a_c_t_e_r_s, and delete mode by giving smdc
     and rmdc to enter and exit	delete mode (any mode the terminal needs to
     be	placed in for dch1 to work).

     A command to erase	_n characters (equivalent to outputting _n blanks,
     without moving the	cursor)	can be given as	ech with one parameter.

     Highlighting, Underlining,	and Visible Bells

     If	your terminal has one or more kinds of display attributes, these can
     be	represented in a number	of different ways.  You	should choose one
     display form as standout mode, representing a good, high contrast,	easy
     to	read, format for highlighting error messages and other important
     information.  If you have a choice, reverse video plus half-bright	is
     good, or reverse video alone.  The	sequences to enter and exit standout
     mode are given as smso and	rmso, respectively.  If	the code to change
     into or out of standout mode leaves one or	even two blank spaces on the
     screen, as	the TVI	912 and	Teleray	1061 do, then xmc should be given to
     tell how many spaces are left.

     Codes to begin underlining	and end	underlining can	be given as smul and
     rmul, respectively.  If the terminal has a	code to	underline the current
     character and move	the cursor one space to	the right, such	as the Micro-
     term Mime,	this can be given as uc.

     Other capabilities	to enter various highlighting modes include blink
     (blinking), bold (bold or extra bright), dim (dim or half-bright),	invis
     (blanking or invisible text), prot	(protected), rev (reverse video),
     sgr0 (turn	off _a_l_l	attribute modes), smacs	(enter alternate character
     set mode),	and rmacs (exit	alternate character set	mode).	Turning	on
     any of these modes	singly may or may not turn off other modes.

     If	there is a sequence to set arbitrary combinations of modes, this
     should be given as	sgr (set attributes), taking nine parameters.  Each
     parameter is either 0 or 1, as the	corresponding attribute	is on or off.
     The nine parameters are, in order:	standout, underline, reverse, blink,
     dim, bold,	blank, protect,	and alternate character	set.  Not all modes
     need be supported by sgr, only those for which corresponding separate
     attribute commands	exist.

     Terminals with the	``magic	cookie glitch''	(xmc) deposit special cookies
     when they receive mode-setting sequences, which affect the	display	algo-
     rithm rather than having extra bits for each character.  Some terminals,
     such as the HP 2621, automatically	leave standout mode when they move to
     a new line	or the cursor is addressed.  Programs using standout mode
     should exit standout mode before moving the cursor	or sending a newline,
     unless the	msgr capability, asserting that	it is safe to move in stan-
     dout mode,	is present.


									   13






   terminfo(5)


     If	the terminal has a way of flashing the screen to indicate an error
     quietly (a	bell replacement), this	can be given as	flash; however,	it
     must not move the cursor.

     If	the cursor needs to be made more visible than normal when it is	not
     on	the bottom line	(to make, for example, a non-blinking underline	into
     an	easier to find block or	blinking underline), give this sequence	as
     cvvis.  If	you wish to make the cursor completely invisible, give that
     as	civis.	The capability cnorm should be given which undoes the effects
     of	both of	these modes.

     If	the terminal needs to be in a special mode when	running	a program
     that uses these capabilities, the codes to	enter and exit this mode can
     be	given as smcup and rmcup.  This	arises,	for example, from terminals
     like the Concept-100 with more than one page of memory.  If the terminal
     has only memory-relative cursor addressing	and not	screen-relative	cur-
     sor addressing, a one screen-sized	window must be fixed into the termi-
     nal for cursor addressing to work properly.  This is also used for	the
     TEKTRONIX 4025, where smcup sets the command character to be the one
     used by terminfo.

     If	your terminal correctly	generates underlined characters	(with no spe-
     cial codes	needed)	even though it does not	overstrike, you	should give
     the capability ul.	 If overstrikes	are erasable with a blank, this
     should be indicated by giving eo.

     Keypad

     If	the terminal has a keypad that transmits codes when the	keys are
     pressed, give this	information. Note that it is not possible to handle
     terminals where the keypad	only works in local (this applies, for exam-
     ple, to the unshifted HP 2621 keys).  If the keypad can be	set to
     transmit or not transmit, give these codes	as smkx	and rmkx.  Otherwise,
     the keypad	is always assumed to transmit.	The codes sent by the left
     arrow, right arrow, up arrow, down	arrow, and home	keys can be given as
     kcub1, kcuf1, kcuu1, kcud1, and khome, respectively.  If there are	func-
     tion keys such as f0, f1, ... f10,	the codes they send can	be given as
     kf0, kf1, ... kf10.  If these keys	have labels other than the default f0
     through f10, the labels can be given as lf0, lf1, ... lf10.  The codes
     transmitted by certain other special keys can be given: kll (home down),
     kbs (backspace), ktbc (clear all tabs), kctab (clear the tab stop in
     this column), kclr	(clear screen or erase key), kdch1 (delete charac-
     ter), kdl1	(delete	line), krmir (exit insert mode), kel (clear to end of
     line), ked	(clear to end of screen), kich1	(insert	character or enter
     insert mode), kil1	(insert	line), knp (next page),	kpp (previous page),
     kind (scroll forward/down), kri (scroll backward/up), khts	(set a tab
     stop in this column).  In addition, if the	keypad has a 3 by 3 array of
     keys including the	four arrow keys, the other five	keys can be given as
     ka1, ka3, kb2, kc1, and kc3.  These keys are useful when the effects of
     a 3 by 3 directional pad are needed.

     Tabs and Initialization




   14






								  terminfo(5)


     If	the terminal has hardware tabs,	the command to advance to the next
     tab stop can be given as ht (usually CTRL I).  A backtab command which
     moves leftward to the next	tab stop can be	given as cbt.  By convention,
     if	the teletype modes indicate that tabs are being	expanded by the	com-
     puter rather than being sent to the terminal, programs should not use ht
     or	cbt, even if they are present, since the user may not have the tab
     stops properly set.  If the terminal has hardware tabs that are ini-
     tially set	every _n	spaces when the	terminal is powered up,	the numeric
     parameter it is given, showing the	number of spaces the tabs are set to.
     This is normally used by the _t_s_e_t command to determine whether to set
     the mode for hardware tab expansion and whether to	set the	tab stops.
     If	the terminal has tab stops that	can be saved in	nonvolatile memory,
     the terminfo description can assume that they are properly	set.

     Other capabilities	include	is1, is2, and is3, initialization strings for
     the terminal, iprog, the path name	of a program to	be run to initialize
     the terminal, and if, the name of a file containing long initialization
     strings.  These strings are expected to set the terminal into modes con-
     sistent with the rest of the terminfo description.	 They are normally
     sent to the terminal, by the _t_s_e_t program,	each time the user logs	in.
     They will be printed in the following order: is1, is2, setting tabs
     using tbc and hts,	if, running the	program	iprog, and finally is3.	 Most
     initialization is done with is2.  Special terminal	modes can be set up
     without duplicating strings by putting the	common sequences in is2	and
     special cases in is1 and is3.  A pair of sequences	that does a harder
     reset from	a totally unknown state	can be analogously given as rs1, rs2,
     rf, and rs3, analogous to is2 and if.  These strings are output by	the
     _r_e_s_e_t program, which is used when the terminal gets into a	wedged state.
     Commands are normally placed in rs2 and rf	only if	they produce annoying
     effects on	the screen and are not necessary when logging in.  For exam-
     ple, the command to set the vt100 into 80-column mode would normally be
     part of is2, but it causes	an annoying movement of	the screen and is not
     normally needed because the terminal is usually already in	80-column
     mode.

     If	there are commands to set and clear tab	stops, they can	be given as
     tbc (clear	all tab	stops) and hts (set a tab stop in the current column
     of	every row).  If	a more complex sequence	is needed to set the tabs
     than can be described by this, the	sequence can be	placed in is2 or if.

     Delays

     Certain capabilities control padding in the teletype driver.  These are
     primarily needed by hard copy terminals, and are used by the _t_s_e_t pro-
     gram to set teletype modes	appropriately.	Delays embedded	in the capa-
     bilities cr, ind, cub1, ff, and tab cause the appropriate delay bits to
     be	set in the teletype driver.  If	pb (padding baud rate) is given,
     these values can be ignored at baud rates below the value of pb.

     Miscellaneous

     If	the terminal requires other than a null	(zero) character as a pad,
     this can be given as pad.	Only the first character of the	pad string is
     used.


									   15






   terminfo(5)


     If	the terminal has an extra status line that is not normally used	by
     software, indicate	this fact.  If the status line is viewed as an extra
     line below	the bottom line, into which one	can cursor-address normally
     (such as the Heathkit h19's 25th line, or the 24th	line of	a vt100	which
     is	set to a 23-line scrolling region), the	capability hs should be
     given.  Special strings to	go to the beginning of the status line and to
     return from the status line can be	given as tsl and fsl.  The fsl string
     must leave	the cursor position in the same	place it was before tsl.  If
     necessary,	the sc and rc strings can be included in tsl and fsl to	get
     this effect.  The parameter tsl takes one parameter, which	is the column
     number of the status line the cursor is to	be moved to.  If escape
     sequences and other special commands, such	as tab,	work while in the
     status line, give the eslok flag.	A string that turns off	the status
     line, or otherwise	erases its contents, should be given as	dsl.  If the
     terminal has commands to save and restore the position of the cursor,
     give them as sc and rc.  The status line is normally assumed to be	the
     same width	as the rest of the screen, for example,	cols.  If the status
     line is a different width (possibly because the terminal does not allow
     an	entire line to be loaded), the width, in columns, can be indicated
     with the numeric parameter, wsl.

     If	the terminal can move up or down half a	line, you can indicate this
     with hu (half-line	up) and	hd (half-line down).  This is primarily	use-
     ful for superscripts and subscripts on hardcopy terminals.	 If a hard-
     copy terminal can eject to	the next page (form feed), give	this as	ff
     (usually CTRL L).

     If	there is a command to repeat a given character a given number of
     times (to save time transmitting a	large number of	identical charac-
     ters), you	can indicate this with the parameterized string	rep.  The
     first parameter is	the character to be repeated and the second is the
     number of times to	repeat it.  Thus, tparm(repeat_char, 'x', 10)
     represents	``xxxxxxxxxx''.

     If	the terminal has a settable command character, such as the TEKTRONIX
     4025, this	can be indicated with cmdch.  Choose a prototype command
     character to use in all capabilities.  This character is given in the
     cmdch capability to identify it.  The following convention	is supported
     on	some UNIX systems: the environment is to be searched for a CC vari-
     able, and,	if found, all occurrences of the prototype character are
     replaced with the character in the	environment variable.

     Terminal descriptions that	do not represent a specific kind of known
     terminal, such as _s_w_i_t_c_h, _d_i_a_l_u_p, _p_a_t_c_h, and _n_e_t_w_o_r_k, should include the
     gn	(generic) capability, so that programs can complain that they do not
     know how to talk to the terminal.	This capability	does not apply to
     _v_i_r_t_u_a_l terminal descriptions, for	which the escape sequences are known.

     If	the terminal uses xon/xoff handshaking for flow	control, give xon.
     Padding information should	still be included, so that routines can	make
     better decisions about costs, but actual pad characters are not
     transmitted.




   16






								  terminfo(5)


     If	the terminal has a meta	key that acts as a shift key, setting the
     eighth bit	of any character transmitted, this fact	can be indicated with
     km.  Otherwise, software assumes that the eighth bit is parity and	it is
     usually cleared.  If strings exist	to turn	this meta mode on and off,
     they can be given as smm and rmm.

     If	the terminal has more lines of memory than will	fit on the screen at
     once, the number of lines of memory can be	indicated with lm.  A value
     of	lm#0 indicates that the	number of lines	is not fixed, but that there
     is	still more memory than fits on the screen.

     If	the terminal is	one of those supported by the UNIX virtual terminal
     protocol, the terminal number can be given	as vt.

     Media copy	strings	that control an	auxiliary printer connected to the
     terminal can be given as mc0: print the contents of the screen, mc4:
     turn off the printer, and mc5: turn on the	printer.  When the printer is
     on, all text sent to the terminal is sent to the printer.	It is unde-
     fined whether the text is also displayed on the terminal screen when the
     printer is	on.  A variation mc5p takes one	parameter, and leaves the
     printer on	for as many characters as the value of the parameter. It then
     turns the printer off.  The parameter should not exceed 255.  All text,
     including mc4, is transparently passed to the printer while an mc5p is
     in	effect.

     Strings to	program	function keys can be given as pfkey, pfloc, and	pfx.
     Each of these strings takes two parameters: the function key number to
     program (from 0 to	10) and	the string to program it with.	Function key
     numbers out of this range may program undefined keys in a terminal-
     dependent manner.	The difference between the capabilities	is that	pfkey
     causes pressing the given key to be the same as the user typing the
     given string; pfloc causes	the string to be executed by the terminal in
     local; and	pfx causes the string to be transmitted	to the computer.

   Restrictions
     Hazeltine terminals, which	do not allow tilde (~) characters to be
     displayed,	should indicate	hz.

     Terminals that ignore a linefeed immediately after	an am wrap, such as
     the Concept-100 and VT100,	should indicate	xenl.

     If	el is required to get rid of standout (instead of merely writing nor-
     mal text on top of	it), xhp should	be given.

     Teleray terminals,	where tabs turn	all characters moved over to blanks,
     should indicate xt	(destructive tabs).  This glitch is also taken to
     mean that it is not possible to position the cursor on top	of a ``magic
     cookie'', that to erase standout mode it is instead necessary to use
     delete and	insert line.

     The Beehive Superbee, which is unable to correctly	transmit the escape
     or	CTRL C characters, has xsb, indicating that the	f1 key is used for
     escape and	f2 for CTRL C.	(Only certain Superbees	have this problem,
     depending on the ROM.)


									   17






   terminfo(5)


     Other specific terminal problems can be corrected by adding more capa-
     bilities of the form x_x.

     Similar Terminals

     If	there are two very similar terminals, one can be defined as being
     just like the other with certain exceptions.  The string capability use
     can be given with the name	of the similar terminal.  The capabilities
     given before use override those in	the terminal type invoked by use.  A
     capability	can be canceled	by placing xx@ to the left of the capability
     definition, where xx is the capability.  For example, the following
     entry

     2621-nl, smkx@, rmkx@, use=2621,

     defines a 2621-nl that does not have the smkx or rmkx capabilities, and
     hence does	not turn on the	function key labels when in visual mode.
     This is useful for	different modes	for a terminal,	or for different user
     preferences.

   Files

     /_u_s_r/_l_i_b/_t_e_r_m_i_n_f_o/?/*
			 Files containing terminal descriptions

   See Also
     tic(1), intro(3cur), printf(3s), term(7)
     _G_u_i_d_e _t_o _X/_O_p_e_n _c_u_r_s_e_s _S_c_r_e_e_n _H_a_n_d_l_i_n_g




























   18



