


								  termcap(3x)



   Name
     tgetent, tgetnum, tgetflag, tgetstr, tgoto, tputs - terminal independent
     operation routines

   Syntax
     char PC;
     char *BC;
     char *UP;
     short ospeed;

     tgetent(bp, name)
     char *bp, *name;

     tgetnum(id)
     char *id;

     tgetflag(id)
     char *id;

     char *
     tgetstr(id, area)
     char *id, **area;

     char *
     tgoto(cm, destcol,	destline)
     char *cm;

     tputs(cp, affcnt, outc)
     register char *cp;
     int affcnt;
     int (*outc)();

   Description
     These functions extract and use capabilities from the terminal capabil-
     ity data base _t_e_r_m_c_a_p(5).	These are low level routines; see _c_u_r_s_e_s(3x)
     for a higher level	package.

     The _t_g_e_t_e_n_t function extracts the entry for terminal _n_a_m_e into the
     buffer at _b_p. The _b_p should be a character	buffer of size 1024 and	must
     be	retained through all subsequent	calls to _t_g_e_t_n_u_m, _t_g_e_t_f_l_a_g, and
     _t_g_e_t_s_t_r.  The _t_g_e_t_e_n_t function returns -1 if it cannot open the _t_e_r_m_c_a_p
     file, 0 if	the terminal name given	does not have an entry,	and 1 if all
     goes well.	 It will look in the environment for a TERMCAP variable.  If
     found, and	the value does not begin with a	slash, and the terminal	type
     name is the same as the environment string	TERM, the TERMCAP string is
     used instead of reading the termcap file.	If it does begin with a
     slash, the	string is used as a pathname rather than /_e_t_c/_t_e_r_m_c_a_p.	This
     can speed up entry	into programs that call	_t_g_e_t_e_n_t, as well as to help
     debug new terminal	descriptions or	to make	one for	your terminal if you
     cannot write the file /_e_t_c/_t_e_r_m_c_a_p.

     The _t_g_e_t_n_u_m function gets the numeric value of capability _i_d, returning
     -1	if is not given	for the	terminal.  The _t_g_e_t_f_l_a_g	returns	1 if the


									    1






   termcap(3x)


     specified capability is present in	the terminal's entry, 0	if it is not.
     The _t_g_e_t_s_t_r function gets the string value	of capability _i_d, placing it
     in	the buffer at _a_r_e_a, advancing the _a_r_e_a pointer.	 It decodes the
     abbreviations for this field described in _t_e_r_m_c_a_p(5), except for cursor
     addressing	and padding information.

     The _t_g_o_t_o function	returns	a cursor addressing string decoded from	_c_m to
     go	to column _d_e_s_t_c_o_l in line _d_e_s_t_l_i_n_e. It uses the	external variables UP
     (from the up capability) and BC (if bc is given rather than bs) if
     necessary to avoid	placing	\n, ^D or ^@ in	the returned string.  Pro-
     grams that	call _t_g_o_t_o should be sure to turn off the XTABS	bit(s),
     because _t_g_o_t_o may now output a tab.  Note that programs using termcap
     should in general turn off	XTABS anyway, because some terminals use con-
     trol I for	other functions, such as nondestructive	space.	If a %
     sequence is given that is not understood, then _t_g_o_t_o returns "OOPS".

     The _t_p_u_t_s function	decodes	the leading padding information	of the string
     _c_p; _a_f_f_c_n_t	gives the number of lines affected by the operation, or	1 if
     this is not applicable, _o_u_t_c is a routine that is called with each	char-
     acter in turn.  The external variable _o_s_p_e_e_d should contain the output
     speed of the terminal as encoded by _s_t_t_y(3).  The external	variable PC
     should contain a pad character to be used (from the pc capability)	if a
     null (^@) is inappropriate.

   Files
     /usr/lib/libtermcap.a  -ltermcap library
     /etc/termcap	    data base

   See Also
     ex(1), curses(3x),	termcap(5)


























   2






								   termcap(5)



   Name
     termcap - terminal	capability data	base

   Syntax
     /etc/termcap

   Description
     The _t_e_r_m_c_a_p file is a data	base describing	terminals used,	for example,
     by	_v_i(1) and _c_u_r_s_e_s(3x).  Terminals are described in _t_e_r_m_c_a_p by giving a
     set of capabilities which they have and by	describing how operations are
     performed.	 Padding requirements and initialization sequences are
     included in _t_e_r_m_c_a_p.

     Entries in	_t_e_r_m_c_a_p	consist	of a number of fields separated	by colons
     (:).  The first entry for each terminal gives the names which are known
     for the terminal, separated by vertical bars (|).	The first name is
     always 2 characters long and is used by older Version 6 systems, which
     store the terminal	type in	a 16-bit word in a system-wide data base.
     The second	name given is the most common abbreviation for the terminal,
     and the last name given should be a long name fully identifying the ter-
     minal.  The second	name should contain no blanks. The last	name may con-
     tain blanks for readability.

   Capabilities
     (P) indicates padding is commonly needed for these	strings.
     (P*) indicates that padding may be	based on the number of lines affected.

     Name   Type  Pad?	Description

     ae	    str	  (P)	End alternate character	set.
     al	    str	  (P*)	Add new	blank line.
     am	    bool	Terminal has automatic margins.
     as	    str	  (P)	Start alternate	character set.
     bc	    str		Backspace, if not CTRL/H.
     bl	    str		Audible	bell character.
     bs	    bool	Terminal can backspace with CTRL/H.
     bt	    str	  (P)	Back tab.
     bw	    bool	Backspace wraps	from column 0 to last column.
     CC	    str		Command	character in prototype,	if terminal-settable.
     ca	    bool	Cursor addressable.
     cd	    str	  (P*)	Clear to end of	display.
     ce	    str	  (P)	Clear to end of	line.
     ch	    str	  (P)	Like cm, but horizontal	motion only; line stays	the same.
     cl	    str	  (P*)	Clear screen.
     cm	    str	  (P)	Cursor motion.
     co	    num		Number of columns in a line.
     cr	    str	  (P*)	Carriage return	(default CTRL/M).
     cs	    str	  (P)	Change scrolling region	(VT100); like cm.
     ct	    str		Clear all tab stops.
     cv	    str	  (P)	Like ch, but vertical only.
     da	    bool	Display	may be retained	above.
     dB	    num		Number of millisec of bs delay needed.
     db	    bool	Display	may be retained	below.


									    3






   termcap(5)


     dC	    num		Number of millisec of cr delay needed.
     dc	    str	  (P*)	Delete character.
     dF	    num		Number of millisec of ff delay needed.
     dl	    str	  (P*)	Delete line.
     dm	    str		Delete mode (enter).
     dN	    num		Number of millisec of nl delay needed.
     do	    str		Move down one line.
     ds	    str		Clear host writable status line.
     dT	    num		Number of millisec of ta delay needed.
     ed	    str		End delete mode.
     ei	    str		End insert mode; give ``:ei=:''	if ic.
     eo	    str		Can erase overstrikes with a blank.
     es	    bool	Standout mode allowed on host writable status line.
     ff	    str	  (P*)	Hard-copy terminal page	eject (default CTRL/L).
     fs	    str		Close host writable status line	to writing.
     gt	    bool	Gtty indicates tabs.
     hc	    bool	Hard-copy terminal.
     hd	    str		Half-line down (forward	1/2 linefeed).
     ho	    str		Home cursor (if	no cm).
     hs	    bool	Host writable status line capabilities.
     hu	    str		Half-line up (reverse 1/2 linefeed).
     hz	    str		Hazeltine; cannot print	tildes (~).
     ic	    str	  (P)	Insert character.
     if	    str		Name of	file containing	is.
     im	    str		Insert mode (enter); give ``:im=:'' if ic.
     in	    bool	Insert mode distinguishes nulls	on display.
     ip	    str	  (P*)	Insert pad after character inserted.
     is	    str		Terminal initialization	string.
     k0-k9  str		Sent by	"other"	function keys 0-9.
     kb	    str		Sent by	backspace key.
     kd	    str		Sent by	terminal down arrow key.
     ke	    str		Out of "keypad transmit" mode.
     kh	    str		Sent by	home key.
     kl	    str		Sent by	terminal left arrow key.
     kn	    num		Number of "other" keys.
     ko	    str		Termcap	entries	for other nonfunction keys.
     kr	    str		Sent by	terminal right arrow key.
     ks	    str		Put terminal in	"keypad	transmit" mode.
     ku	    str		Sent by	terminal up arrow key.
     l0-l9  str		Labels on "other" function keys.
     le	    str		Move cursor left one place.
     li	    num		Number of lines	on screen or page.
     ll	    str		Last line, first column	(if no cm).
     ma	    str		Arrow key map, used by vi Version 2 only.
     mb	    str		Turn on	blinking.
     md	    str		Enter bold (extra-bright) mode.
     me	    str		Turn off all attributes, normal	mode.
     mh	    str		Enter dim (half-bright)	mode.
     mi	    bool	Safe to	move while in insert mode.
     ml	    str		Memory lock on above cursor.
     mr	    str		Enter reverse mode.
     ms	    bool	Safe to	move while in standout and underline mode.
     mu	    str		Memory unlock (turn off	memory lock).
     nc	    bool	No correctly working carriage return (DM2500,H2000).


   4






								   termcap(5)


     nd	    str		Nondestructive space (cursor right).
     nl	    str	  (P*)	Newline	character (default \n).
     ns	    bool	Terminal is a CRT, but does not	scroll.
     os	    bool	Terminal overstrikes.
     pc	    str		Pad character (rather than null).
     pt	    bool	Has hardware tabs (may need to be set with is).
     rc	    str		Recover	from last save cursor (sc).
     rf	    str		Reset file, like initialization	file (if) but for reset.
     rs	    str		Reset string, like initialization string (is) but for reset.
     sc	    str		Save cursor.
     se	    str		End stand out mode.
     sf	    str	  (P)	Scroll forwards.
     sg	    num		Number of blank	chars left by so or se.
     so	    str		Begin stand out	mode.
     sr	    str	  (P)	Scroll reverse (backwards).
     st	    str		Save cursor.
     ta	    str	  (P)	Tab (other than	CTRL/I or with padding).
     tc	    str		Entry of similar terminal - must be last.
     te	    str		String to end programs that use	cm.
     ti	    str		String to begin	programs that use cm.
     ts	    str		Open host writable status line to writing.[jA.
     uc	    str		Underscore one char and	move past it.
     ue	    str		End underscore mode.
     ug	    num		Number of blank	chars left by us or ue.
     ul	    bool	Terminal underlines even though	it does	not overstrike.
     up	    str		Upline (cursor up).
     us	    str		Start underscore mode.
     vb	    str		Visible	bell (may not move cursor).
     ve	    str		Sequence to end	open/visual mode.
     vs	    str		Sequence to start open/visual mode.
     vt	    num		Virtual	terminal number.
     xb	    bool	Beehive	(f1=escape, f2=CTRL/C).
     xn	    bool	A newline is ignored after a wrap (Concept).
     xr	    bool	Return acts like ce \r \n (Delta Data).
     xs	    bool	Standout not erased by writing over it (HP 264?).
     xt	    bool	Tabs are destructive, magic so char (Teleray 1061).

     A Sample Entry

     The following entry, which	describes the Concept-100, is among the	more
     complex entries in	the _t_e_r_m_c_a_p file as of this writing.  This particular
     `Concept' entry is	outdated and is	used as	an example only:

     c1|c100|concept100:is=\EU\Ef\E7\E5\E8\El\ENH\EK\E\200\Eo&\200:\
	    :al=3*\E^R:am:bs:cd=16*\E^C:ce=16\E^S:cl=2*^L:cm=\Ea%+ %+:\
	    :co#80:dc=16\E^A:dl=3*\E^B:ei=\E\200:eo:im=\E^P:in:\
	    :ip=16*:li#24:mi:nd=\E=:se=\Ed\Ee:so=\ED\EE:ta=8\t:\
	    :ul:up=\E;:vb=\Ek\EK:xn:


     Entries can continue onto multiple	lines by giving	a backslash (\)	as
     the last character	of a line. Empty fields	can be included	for readabil-
     ity (here between the last	field on a line	and the	first field on the
     next).


									    5






   termcap(5)


     Types of Capabilities

     Capabilities in _t_e_r_m_c_a_p are of three types: Boolean capabilities that
     indicate that the terminal	has some particular feature; numeric capabil-
     ities giving the size of the terminal or the size of particular delays;
     and string	capabilities, which give a sequence that can be	used to	per-
     form particular terminal operations.

     All capabilities have 2-letter codes.  For	instance, the fact that	the
     Concept has "automatic margins" (that is, an automatic return and
     linefeed when the end of a	line is	reached) is indicated by the capabil-
     ity am.  Hence, the description of	the Concept includes am.  Numeric
     capabilities are followed by the number sign (#) and then the value.
     Thus, co, which indicates the number of columns the terminal has, gives
     the value `80' for	the Concept.

     Finally, string-valued capabilities, such as ce (clear to end-of-line
     sequence),	are given by the 2-character code: an equal sign (=) and then
     a string ending at	the next following colon (:).  A delay in mil-
     liseconds may appear after	the equal sign (=) in such a capability. Pad-
     ding characters are supplied by the editor	after the remainder of the
     string is sent to provide this delay.  The	delay can be either an
     integer, for example, ``20'', or an integer followed by an	asterisk (*),
     for example ``3*''.  An asterisk (*) indicates that the padding required
     is	proportional to	the number of lines affected by	the operation, and
     the amount	given is the per-affected-unit padding required.  When an
     asterisk (*) is specified,	it is sometimes	useful to give a delay of the
     form ``3.5'' to specify a delay per unit to tenths	of milliseconds.

     A number of escape	sequences are provided in the string-valued capabili-
     ties for easy encoding of characters there. A \E maps to an ESCAPE	char-
     acter, O^x	maps to	a CTRL/x for any appropriate x,	and the	sequences \n
     \r	\t \b \f give a	newline, return, tab, backspace	and formfeed.
     Finally, characters may be	given as three octal digits after a backslash
     (\), and the characters circumflex	(^) and	backslash (\) may be given as
     \^	and \\.	 If it is necessary to place a colon (:) in a capability, it
     must be escaped in	octal as \072.	If it is necessary to place a null
     character in a string capability, it must be encoded as \200.  The	rou-
     tines that	deal with _t_e_r_m_c_a_p use C	strings	and strip the high bits	of
     the output	very late so that a \200 comes out as a	\000 would.

     Preparing Descriptions

     This section outlines how to prepare descriptions of terminals.  The
     most effective way	to prepare a terminal description is by	imitating the
     description of a similar terminal in _t_e_r_m_c_a_p and to build up a descrip-
     tion gradually, using partial descriptions	with _e_x	to check that they
     are correct.  Be aware that a very	unusual	terminal may expose deficien-
     cies in the ability of the	_t_e_r_m_c_a_p	file to	describe it or bugs in _e_x.
     To	easily test a new terminal description,	you can	set the	environment
     variable TERMCAP to a pathname of a file containing the description you
     are working on and	the editor will	look there rather than in
     /_e_t_c/_t_e_r_m_c_a_p.  TERMCAP can	also be	set to the termcap entry itself	to
     avoid reading the file when starting up the editor.  This only works on


   6






								   termcap(5)


     Version 7 systems.

     Basic Capabilities

     The number	of columns on each line	for the	terminal is given by the co
     numeric capability.  If the terminal is a CRT, the	number of lines	on
     the screen	is given by the	li capability.	If the terminal	wraps around
     to	the beginning of the next line when it reaches the right margin, it
     should have the am	capability.  If	the terminal can clear its screen,
     this is given by the cl string capability.	 If the	terminal can back-
     space, it should have the bs capability, unless a backspace is accom-
     plished by	a character other than ^H, in which case you should give this
     character as the bc string	capability.  If	it overstrikes,	rather than
     clearing a	position when a	character is struck over, it should have the
     os	capability.

     A very important point here is that the local cursor motions encoded in
     _t_e_r_m_c_a_p are undefined at the left and top edges of	a CRT terminal.	 The
     editor will never attempt to backspace around the left edge, nor will it
     attempt to	go up locally off the top.  The	editor assumes that feeding
     off the bottom of the screen will cause the screen	to scroll up, and the
     am	capability tells whether the cursor sticks at the right	edge of	the
     screen.  If the terminal has switch-selectable automatic margins, the
     _t_e_r_m_c_a_p file usually assumes that this is on, that	is, am.

     These capabilities	suffice	to describe hard-copy and "glass-tty" termi-
     nals.  Thus, the model 33 teletype	is described as:

     t3|33|tty33:co#72:os


     The Lear Siegler ADM-3 is described as:

     cl|adm3|3|lsi adm3:am:bs:cl=^Z:li#24:co#80


     Cursor Addressing

     Cursor addressing in the terminal is described by a cm string capabil-
     ity, with _p_r_i_n_t_f(3s) types	of escapes such	as %x in it.  These substi-
     tute to encodings of the current line or column position, while other
     characters	are passed through unchanged.  If the cm string	is thought of
     as	being a	function, its arguments	are the	line and then the column to
     which motion is desired, and the %	encodings have the following mean-
     ings:

     %d	  As in	_p_r_i_n_t_f,	0 origin
     %2	  Like %2d
     %3	  Like %3d
     %.	  Like %c
     %+x  Adds _x to value, then	%.
     %>xy If value > x adds y, no output.
     %r	  Reverses order of line and column, no	output
     %i	  Increments line/column (for 1	origin)


									    7






   termcap(5)


     %%	  Gives	a single %
     %n	  Exclusive or row and column with 0140	(DM2500)
     %B	  BCD (16*(x/10)) + (x%10), no output.
     %D	  Reverse coding (x-2*(x%16)), no output. (Delta Data).

     Consider the HP2645, which, to get	to row 3 and column 12,	needs to be
     sent \E&a12c03Y padded for	6 milliseconds.	 Note that the order of	the
     rows and columns is inverted here,	and that the row and column are
     printed as	2 digits.  Thus, its cm	capability is ``cm=6\E&%r%2c%2Y''.
     The Microterm 2ACT-IV needs the current row and column sent preceded by
     a ^T, with	the row	and column simply encoded in binary, ``cm=^T%.%.''.
     Terminals that use	``%.'' need to be able to backspace the	cursor (bs or
     bc), and to move the cursor up one	line on	the screen (up introduced in
     the following section).  This is necessary	because	it is not always safe
     to	transmit \t, \n	^D, and	\r, as the system may change or	discard	them.

     A final example is	the LSI	ADM-3a,	which uses row and column offset by a
     blank character; thus "cm=\E=%+ %+	".

     Cursor Motions

     If	the terminal can move the cursor one position to the right, leaving
     the character at the current position unchanged, this sequence should be
     given as nd (non-destructive space).  If it can move the cursor up	a
     line on the screen	in the same column, this should	be given as up.	 If
     the terminal has no cursor	addressing capability, but can home the	cur-
     sor (to very upper	left corner of screen),	this can be given as ho.
     Similarly a fast way of getting to	the lower left hand corner can be
     given as ll. This may involve going up with up from the home position,
     but the editor will never do this itself, unless ll does, because it
     makes no assumption about the effect of moving up from the	home posi-
     tion.

     Area Clears

     If	the terminal can clear from the	current	position to the	end of the
     line, leaving the cursor where it is, this	should be given	as ce.	If
     the terminal can clear from the current position to the end of the
     display, this should be given as cd.  The editor only uses	cd from	the
     first column of a line.

     Insert/Delete Line

     If	the terminal can open a	new blank line before the line where the cur-
     sor is, this should be given as al; this is done only from	the first
     position of a line.  The cursor must then appear on the newly blank
     line.  If the terminal can	delete the line	which the cursor is on,	this
     should be given as	dl.  This is done only from the	first position on the
     line to be	deleted.  If the terminal can scroll the screen	backwards,
     this can be given as sb, but just al suffices.  If	the terminal can
     retain display memory above, the da capability should be given; if
     display memory can	be retained below, db should be	given.	These let the
     editor understand that deleting a line on the screen may bring nonblank
     lines up from below or that scrolling back	with sb	may bring down


   8






								   termcap(5)


     nonblank lines.

     Insert/Delete Character

     There are two basic kinds of intelligent terminals	with respect to	the
     insert/delete character that can be described using _t_e_r_m_c_a_p.  The most
     common insert/delete character operations affect only the characters on
     the current line and shift	characters off the end of the line rigidly.
     Other terminals, such as the Concept 100 and the Perkin Elmer Owl,	make
     a distinction between typed and untyped blanks on the screen, shifting
     upon an insert or delete only to an untyped blank on the screen which is
     either eliminated,	or expanded to 2 untyped blanks.  You can find out
     which kind	of terminal you	have by	clearing the screen and	typing text
     separated by cursor motions.  Type	"abc	def" using local cursor
     motions (not spaces) between the "abc" and	the "def".  Then, position
     the cursor	before the "abc" and put the terminal in insert	mode.  If
     typing characters causes the rest of the line to shift rigidly and	char-
     acters to fall off	the end, your terminal does not	distinguish between
     blanks and	untyped	positions.  If the "abc" shifts	over to	the "def" and
     then moves	with it	around the end of the current line and onto the	next
     line as you insert, you have the second type of terminal, and should
     give the capability in, which stands for "insert null".  If your termi-
     nal does something	different and unusual, you may have to modify the
     editor to get it to use the insert	mode your terminal defines.  Virtu-
     ally all terminals	that have an insert mode fall into one of these	two
     classes.

     The editor	can handle both	terminals that have an insert mode and termi-
     nals that send a simple sequence to open a	blank position on the current
     line.  Give as im the sequence to get into	insert mode, or	give it	an
     empty value if your terminal uses a sequence to insert a blank position.
     Give as ei	the sequence to	leave insert mode (give	this with an empty
     value also, if you	gave im	so).  Give as ic any sequence needed to	be
     sent just before sending the character to be inserted.  Most terminals
     with a true insert	mode will not give ic.	Terminals that send a
     sequence to open a	screen position	should give it here.  (Insert mode is
     preferable	to the sequence	to open	a position on the screen, if your
     terminal has both.) If post insert	padding	is needed, give	this as	a
     number of milliseconds in ip (a string option).  Any other	sequence that
     may need to be sent after an insert of a single character can also	be
     given in ip.

     It	is occasionally	necessary to move around while in insert mode to
     delete characters on the same line	(for example, if there is a tab	after
     the insertion position).  If your terminal	allows motion while in insert
     mode, you can give	the capability mi to speed up inserting	in this	case.
     Omitting mi affects only speed.   Some terminals (notably Datamedia's)
     must not have mi because of the way their insert mode works.

     Finally, you can specify delete mode by giving dm and ed to enter and
     exit delete mode, and dc to delete	a single character while in delete
     mode.




									    9






   termcap(5)


     Highlighting, Underlining,	and Visible Bells

     If	your terminal has sequences to enter and exit standout mode, these
     can be given as so	and se,	respectively.  If there	are several kinds of
     standout mode, such as inverse video, blinking, or	underlining.  Half-
     bright is not usually an acceptable "standout" mode, unless the terminal
     is	in inverse video mode constantly.  The preferred mode is inverse
     video by itself.  If the code to change into or out of standout mode
     leaves 1 or even 2	blank spaces on	the screen, as the TVI 912 and
     Teleray 1061 do, ug should	be given to tell how many spaces are left.

     Codes to begin underlining	and end	underlining can	be given as us and
     ue, respectively.	If the terminal	has a code to underline	the current
     character and move	the cursor one space to	the right, such	as the Micro-
     term Mime,	this can be given as uc.  (If the underline code does not
     move the cursor to	the right, give	the code followed by a nondestructive
     space.)

     Many terminals, such as the HP 2621, automatically	leave standout mode
     when they move to a new line or the cursor	is addressed.  Programs	using
     standout mode should exit standout	mode before moving the cursor or
     sending a newline.

     If	the terminal has a way of flashing the screen to indicate an error
     quietly (a	bell replacement), this	can be given as	vb; it must not	move
     the cursor.  If the terminal should be placed in a	different mode during
     open and visual modes of _e_x, this can be given as vs and ve, sent at the
     start and end of these modes respectively.	 These can be used to change,
     for example, from an underline to a block cursor and back.

     If	the terminal needs to be in a special mode when	running	a program
     that addresses the	cursor,	the codes to enter and exit this mode can be
     given as ti and te.  This arises, for example, from terminals like	the
     Concept with more than one	page of	memory.	 If the	terminal has only
     memory-relative cursor addressing and not screen-relative cursor
     addressing, a one-screen sized window must	be fixed into the terminal
     for cursor	addressing to work properly.

     If	your terminal correctly	generates underlined characters, with no spe-
     cial codes	needed,	even though it does not	overstrike, you	should give
     the capability ul.	 If overstrikes	are erasable with a blank, this
     should be indicated by giving eo.

     Keypad

     If	the terminal has a keypad that transmits codes when the	keys are
     pressed, this information can be given. Note that it is not possible to
     handle terminals where the	keypad only works in local (this applies, for
     example, to the unshifted HP 2621 keys).  If the keypad can be set	to
     transmit or not transmit, give these codes	as ks and ke.  Otherwise, the
     keypad is assumed to always transmit.  The	codes sent by the left arrow,
     right arrow, up arrow, down arrow,	and home keys can be given as kl, kr,
     ku, kd, and kh, respectively.  If there are function keys such as f0,
     f1, ..., f9, the codes they send can be given as k0, k1, ..., k9.	If


   10






								   termcap(5)


     these keys	have labels other than the default f0 through f9, the labels
     can be given as l0, l1, ..., l9.  If there	are other keys that transmit
     the same code as the terminal expects for the corresponding function,
     such as clear screen, the _t_e_r_m_c_a_p_P	2-letter codes can be given in the ko
     capability, for example, ":ko=cl,ll,sf,sb:", which	says that the termi-
     nal has clear, home down, scroll down, and	scroll up keys that transmit
     the same thing as the _c_l, _l_l, _s_f, and _s_b entries.

     The _m_a entry is also used to indicate arrow keys on terminals that	have
     single-character arrow keys.  It is obsolete, but still in	use in Ver-
     sion 2 of _v_i, which must be run on	some minicomputers due to memory lim-
     itations.	This field is redundant	with kl, kr, ku, kd, and kh.  It con-
     sists of groups of	2 characters.  In each group, the first	character is
     what an arrow key sends; the second character is the corresponding	_v_i
     command.  These commands are _h for	_k_l, _j for _k_d, _k	for _k_u,	_l for _k_r, and
     _H for _k_h.	For example, the Microterm Mime	would be ``ma=^Kj^Zk^Xl:''
     indicating	arrow keys left	(^H), down (^K), up (^Z), and right (^X).
     (There is no home key on the Mime.)

     Miscellaneous

     If	the terminal requires other than a null	(zero) character as a pad,
     this can be given as pc.

     If	tabs on	the terminal require padding, or if the	terminal uses a	char-
     acter other than ^I to tab, this can be given as ta.

     Hazeltine terminals, which	do not allow tildes (~)	to be printed, should
     indicate hz.  Datamedia terminals,	which echo carriage-return linefeed
     for a carriage return and then ignore a following linefeed, should	indi-
     cate nc.  Early Concept terminals,	which ignore a linefeed	immediately
     after an am wrap, should indicate xn.  If an erase-eol is required	to
     get rid of	standout (instead of merely writing on top of it), xs should
     be	given.	Teleray	terminals, where tabs turn all characters moved	over
     to	blanks,	should indicate	xt.  Other specific terminal problems may be
     corrected by adding more capabilities of the form x_x.

     Other capabilities	include	is, an initialization string for the termi-
     nal, and if, the name of a	file containing	long initialization strings.
     These strings are expected	to properly clear and then set the tabs	on
     the terminal, if the terminal has settable	tabs.  If both are given, is
     is	printed	before if.  This is useful where if is /_u_s_r/_l_i_b/_t_a_b_s_e_t/_s_t_d
     but is clears the tabs first.

     Similar Terminals

     If	there are two very similar terminals, one can be defined as being
     just like the other with certain exceptions.  The string capability tc
     can be given with the name	of the similar terminal.  This capability
     must be _l_a_s_t and the combined length of the two entries must not exceed
     1024. Since _t_e_r_m_l_i_b routines search the entry from	left to	right, and
     since the tc capability is	replaced by the	corresponding entry, the
     capabilities given	at the left override the ones in the similar termi-
     nal.  A capability	can be canceled	with xx@, where	xx is the capability.


									   11






   termcap(5)


     For example, the following	entry defines a	2621nl that does not have the
     ks	or ke capabilities, and	hence does not turn on the function key
     labels when in visual mode:

     hn|2621nl:ks@:ke@:tc=2621:


     This is useful for	different modes	for a terminal or for different	user
     preferences.

   Restrictions
     The _v_i and	_e_x commands allow only 256 characters for string capabili-
     ties, and the routines in _t_e_r_m_c_a_p(3x) do not check	for overflow of	this
     buffer.  The total	length of a single entry (excluding only escaped new-
     lines) cannot exceed 1024.

     The _m_a, _v_s, and _v_e	entries	are specific to	the _v_i program.

   Files

     /_e_t_c/_t_e_r_m_c_a_p	 File containing terminal descriptions

   See Also
     ex(1), more(1), tset(1), ul(1), vi(1), curses(3x),	termcap(3x)
































   12



