;
; ZSET.CMD by Prof. Timo Salmi, ts@uwasa.fi, Tue 8-Nov-94
; A script to set MsKermit to use Zmodem file transfers
;
; It also makes easy calling the kermit transfer scripts defined
; in getbin.cmd, gettext.cmd, getvtext.cmd, putbin.cmd, puttext.cmd,
; and putvtext.cmd
;
; First run this script using "take zset.cmd" at the MsKermit prompt
; Then you have at your disposal the new commands defined below
;
; Adapt the paths and ports as appropriate!
; To utilize this script fully you need DSZ.COM by Omen Technology Inc.
; And you must have a basic understanding of Zmodem file transfer
; I recommend that you get version dsz1019.zip for Zmodem transfers
; Alternatively use GSZ.EXE from garbo.uwasa.fi:/pc/termutil/gsz1129.zip
; or whichever version is current.

; Auxiliary definitions
define releasez define \%1,define \%2,define \%3, define \%4, define \%5
define beep3 echo \7\7\7

; Invoking Zmodem for a fixed connection
; Remember to adapt the paths and ports as appropriate for your configuration

define zdnfix run c:\telec\pcplus\dsz CON port 2 d rz r:,beep3
define zupfix run c:\telec\pcplus\dsz CON port 2 d sz \%1 \%2 \%3 \%4 \%5,releasez,beep3

; Invoking Zmodem for a modem file transfer with Forsberg's Omen products
define gdn run gsz F ha on port 1 est 0 9600 pY129 rz r:,beep3
define gup run gsz F ha both port 1 est 0 9600 pY129 pB4096 sz \%1 \%2 \%3 \%4 \%5,releasez,beep3

define gdn2 run gsz F ha on port 2 est 0 9600 pY129 rz r:,beep3
define gup2 run gsz F ha both port 2 est 0 9600 pY129 pB4096 sz \%1 \%2 \%3 \%4 \%5,releasez,beep3

define gdn3 run gsz F ha on port 3 est 0 9600 pY129 rz r:,beep3
define gup3 run gsz F ha both port 3 est 0 9600 pY129 pB4096 sz \%1 \%2 \%3 \%4 \%5,releasez,beep3

define zdn run dsz CON port 1 rz r:,beep3
define zup run dsz CON port 1 sz \%1 \%2 \%3 \%4 \%5,releasez,beep3

define zget run dsz CON port 1 z pL512 pw2048 rz -r r:,beep3
define zput run dsz CON port 1 z pL512 pw2048 sz \%1 \%2 \%3 \%4 \%5,releasez,beep3

define zget256 run dsz CON port 1 z pL256 pw1024 rz -r r:,beep3
define zput256 run dsz CON port 1 z pL256 pw1024 sz \%1 \%2 \%3 \%4 \%5,releasez,beep3

; Invoking Zmodem for a modem file transfer with /pc/termutil/txzm225.zip
define tdn run c:\box\boxtools\txzm -b9600 -rr:\,beep3
define tup run c:\box\boxtools\txzm -b9600 -s \%1 \%2 \%3 \%4 \%5,releasez,beep3

; Invoking Zmodem for a modem file transfer with Scott Baker's szmodem
define szdn run szmodem PORT 1 SPEED 9600 /SZPATH r:\ RZ r:\,beep3
define szup run szmodem PORT 1 SPEED 9600 /SZPATH r:\ SZ \%1 \%2 \%3 \%4 \%5,releasez,beep3

; Define synonyms for Kermit uploads and downloads
define getbin   take getbin.cmd
define gettext  take gettext.cmd
define getvtext take getvtext.cmd
define putbin   take putbin.cmd
define puttext  take puttext.cmd
define putvtext take putvtext.cmd

; For invoking an editor, The SemWare Editor in this case
; TSE is the fully commercial rendition of QEdit
; You probably have a different editor, adapt accordingly
define edit run tse2 \%1,define \%1

; For invoking MsKermit autodialing from own.cll. You have to build
; own.cll (or whatever) yourself. See sample.cll for the format.
define phone take own.cll

echo \13zset.cmd file transfer and other command abbreviations ready:\13
echo \13  KERMIT: getbin, gettext, getvtext, putbin, puttext, putvtext\13
echo \13  GSZ:    gdn, gup, gdn2, gup2, gdn3, gup3\13
echo \13  DSZ:    zdnfix, zupfix, zdn, zup, zget, zput, zget256, zput256
echo \13  OTHER:  tdn, tup, szdn, szup, edit, phone\13
