 C 0 C     Title:    ReGIS to HPGL Conversion Program C  C     Routine Name:   RGHP C  C     File  Name:     RGHP.FOR C * C     Author:         N. Hoult & C. Spence C  C     Description: C > C     This program converts a file of ReGIS commands into HPGL9 C     commands for the HP plotter.  Output may be sent to ( C     a file or directly to the plotter. C  C2 Regis_Commands_Accepted C @ C     Although any ReGIS command is accepted, only the following C     are interpreted: C A C     S(E)      -     Interpreted as end of plot.  Plotter pauses . C                     for paper to be changed. C E C     S(A[..][..])-   Interpreted as for VT125.  The /VT240 qualifier B C                     determines whether the default addressing isH C                     0-767 in the X direction (VT125) or 0-799 (VT240). C E C     W(P..)    -     Select writing pattern.  Only the form W(Pn) is J C                     implemented; commands like W(P10101010) are ignored. C - C     W(P(M..))   -   Set pattern multiplier.  C 7 C     T(S..)    -     Text size, as for VT125 or VT240.  C D C     T'...'    -     Text, as for VT125 or VT240.  Text strings mayC C  OR T"..."          contain any character except hex FF (which is A C                     translated to hex 7F) or control characters * C                     (which are ignored). C L C     P[..][..].. -   Cursor move, as for VT125 or VT240.  Both absolute andJ C                     relative moves are allowed (including a mixture suchG C                     as relative X and absolute Y), but for safety the F C                     first command following anything except a P or V1 C                     command should be absolute.  C : C     V[..][..].. -   Vector command.  See comments above. C  C     Modification List:& C     1.A  Date:  12-Nov-84   ORIGINALL C     1.B  Date:  15-Nov-84   Correct text position, ignore carr. ctl. chars. C     1.C  Date:  16-Nov-84   Trap HPIB errors/ C     1.D  Date:  20-Nov-84   Take command line ? C     1.E  Date:  26-Nov-84   Better parsing - take macrographs @ C     1.F  Date:  29-Nov-84   Better parsing - take T'...' '...', C     1.G  Date:  07-Dec-84   Accept W(P...)B C     1.H  Date:  20-Mar-85   Fix bug with zero-length input linesH C     1.I  Date:  17-Apr-85   Fix bugs with pattern control + absence of/ C                             carriage controls K C     2.A  Date:  23-May-86   Move to VAX and send output to file. Add RMSL N C                             plotter control sequences. Change initializationJ C                             sequence (simplify it). Use DCL command line/ C                             parsing routines. M C     2.B  Date:  27-May-86   Split into separate source files. Keep count of 3 C                             number of lines read. N C     2.C  Date:  02-Jun-86   Get aspect ratio right, allow better resolution,B C                             also fix faults with label positionsK C     2.D  Date:  02-Jun-86   Perform full plotter initialisation (A3 size) N C                             set character size relative rather than absoluteA C     2.E  Date:  05-Jun-86   Accept extra command line switches. K C     2.F  Date:  05-Jun-86   Use new higher resolution graphics code (x10) I C     2.G  Date:  11-Jun-86   Fix bug in handling of text strings without 6 C                             a trailing single quote.2 C     2.H  Date:  12-Aug-86   Add OFFSET parameterA C     2.I  Date:  16-Jan-87   Change to be more common with RGSX. 4 C     2.J  Date:  09-Dec-87   Set bypass mode at endE C     2.K  Date:  12-Feb-88   Allow mixed absolute and relative moves  C C C     Restrictions:   Maximum macrograph length is 1000 characters.  C 
 C2 Parameters  C 0 C     RGHP<qualifiers>  <regis_file> <hpgl_file> C B C     regis_file - Name of input file. Extension defaults to .RGS.C C     hpgl_file  - Name of output file. Extension defaults to .HPG.  C $ C     Both parameters are mandatory. C  C2 Command_Qualifiers  C 
 C/IDENTIFY C /NOIDENTIFY (D)  C H C Causes the program to print its name and version number to SYS$OUTPUT. C  C/INLINE C /NOINLINE (D)  C D C If the output file is to be plotted on a plotter that is connectedB C "in-line" between the terminal and the computer, the use of thisM C qualifier forces the plotter to come out of bypass mode at the start of the 0 C plot, and to return to bypass mode at the end. C 	 C/MONITOR  C /NOMONITOR (D) C I C RGHP sometimes takes a long time to process a file.  The MONITOR switch J C causes the number of input lines processed to be printed every 25 lines. C  C/OFFSET=(xx,yy) C /NOOFFSET (D)  C J C Allows the centre of the plot to be offset from the centre of the paper,K C e.g. for multiple plots on a single page. xx and yy are dimensions in mm, G C and must be integers.  Can only be used if the size is also specified  C explicitly (see /SIZE).  C  C/ROTATE C /NOROTATE (D)  C I C This qualifier is used for plots on A4 paper, since the HP plotter will G C not accept A4 sheets lengthways.  It causes the plot to be rotated by 
 C 90 degrees.  C 
 C/SIZE=format  C /SIZE=AUTO (D) C J C Allows the user to specify the size of the plot - the default is to fillJ C the paper in the plotter.  Allowable values for 'format' are A1, A2, A3,M C A4 (which cause the plot to fit that size of paper), or explicit dimensions H C as integer numbers of mm, i.e. (xx,yy).  If the y value is omitted, it6 C will be chosen to maintain the correct aspect ratio. C 
 C/SLANT=value  C /NOSLANT (D) C L C Forces all characters to be printed sloping, i.e. italic.  The value givenD C is the tangent of the angle; values of 0.2 or 0.3 are recommended. C  C/VT240  C /NOVT240 (D) C I C VT125 and VT240 terminals differ in their default screen mapping; for a G C VT125 the x co-ordinate range is 0-767, for a VT240 it is 0-799.  The J C VT240 switch causes the program to assume the default VT240 range.  NoteK C that since the graphics library routines in F77RGS set the screen mapping E C explicitly, there is no need to use this switch when dumping graphs # C produced by the library routines.  C  C2 Colour_Translation  C J C In ReGIS graphics, information may be written to a number of bit planes;H C for the VT125 and VT240 there are two of these, giving four options inG C all (neither, each bit plane separately, or both together).  The RGHP @ C program maps ReGIS bit planes onto HP plotter pens as follows:1 C       No bit plane    -       No pen i.e. blank % C       Bit plane 1     -       Pen 1 % C       Bit plane 2     -       Pen 2 % C       Both planes     -       Pen 3  C       (i.e. bit plane 3) C  CEND C        PROGRAM RGHP4       LOGICAL XREL,YREL,ERROR,MONITOR,VT240,IDENTIFY+       LOGICAL NOT_EMPTY,FORTRAN_CC,ARC_FLAG "       LOGICAL INLINE,ROTATE,RELPLT       CHARACTER*132 COMD       CHARACTER*7 CC       CHARACTER*8 PATTERN 1       CHARACTER EOF,ESC,CQT,NULL,SINGLE_QUOTE,EOT        PARAMETER (EOF=CHAR(255))        PARAMETER (ESC=CHAR(27))       PARAMETER (NULL=CHAR(0))#       PARAMETER (SINGLE_QUOTE='''')        PARAMETER (EOT=CHAR(3))        PARAMETER (LUNOUT=2)       DATA LUNIN/3/        DATA LUNTO/6/ (       CHARACTER*132 REGIS_FILE,HPGL_FILE-       CHARACTER*12 OFFSET_STR,SL_STR,SIZE_STR 0       LOGICAL CLI$GET_VALUE,SLANT_SPECIFIED,AUTO:       INTEGER X,XX,Y,YY,X_CENT,Y_CENT,SL_LEN,LAST_X,LAST_Y/       INTEGER CLI$PRESENT,RAD,ANGLE,OTS$CVT_T_F "       INTEGER CLI$DCL_PARSE,STATUS3       COMMON /INPUT/ LUNIN,LUNTO,FORTRAN_CC,MONITOR >       EXTERNAL LIB$GET_INPUT,RGHP_COMMAND,RMS$_EOF,CLI$_NORMAL C " C     Open standard files - output C 6       OPEN( LUNTO , FILE='SYS$OUTPUT' , STATUS='NEW' ) C  C     Parse command line C 2       STATUS=LIB$GET_FOREIGN(COMD,'RGHP> ',LENCMD)8       IF (STATUS .EQ. %LOC(RMS$_EOF)) STOP 'End of File'4       IF (.NOT.STATUS) CALL LIB$SIGNAL(%VAL(STATUS))?       STATUS=CLI$DCL_PARSE('RGHP '//COMD(:LENCMD),RGHP_COMMAND, +      &LIB$GET_INPUT,LIB$GET_INPUT,'RGHP> ') 8       IF (STATUS .EQ. %LOC(RMS$_EOF)) STOP 'End of File'@       IF (STATUS .NE. %LOC(CLI$_NORMAL)) STOP 'Error in command'4       CALL CLI$GET_VALUE( 'REGIS_FILE', REGIS_FILE )2       CALL CLI$GET_VALUE( 'HPGL_FILE', HPGL_FILE )$       MONITOR=CLI$PRESENT('MONITOR')        VT240=CLI$PRESENT('VT240')&       IDENTIFY=CLI$PRESENT('IDENTIFY')"       INLINE=CLI$PRESENT('INLINE')*       SLANT_SPECIFIED=CLI$PRESENT('SLANT')       IF (SLANT_SPECIFIED) THEN 1         CALL CLI$GET_VALUE('SLANT',SL_STR,SL_LEN) 0         IF (.NOT.OTS$CVT_T_F(SL_STR,STEMP)) THEN4           STOP 'Bad character slant value specified'
         ENDIF 
       ELSE         SL_STR='0.0'         SL_LEN=3       ENDIF "       ROTATE=CLI$PRESENT('ROTATE')#       AUTO=.NOT.CLI$PRESENT('SIZE')  C  C     Set variables  C        IXTL=0       IYTL=0       IF (VT240) THEN          IXBR=799
       ELSE         IXBR=767       ENDIF        IYBR=479       RELPLT=.FALSE.       NOT_EMPTY=.FALSE.        IPM=2        IPAT=1       SIZE=1       LAST_X=0       LAST_Y=0 C $ C     Determine plot size and offset C 6       IF (.NOT.AUTO) THEN          !Was size specified5         IF (.NOT.CLI$GET_VALUE('SIZE',SIZE_STR)) THEN 4           STOP 'No value given with /SIZE qualifier'
         ENDIF L         IF (.NOT.OTS$CVT_T_F(SIZE_STR,XMM)) THEN !Not a number - try A sizes&           IF (SIZE_STR .EQ. 'A4') THEN             IXMM=240+           ELSE IF (SIZE_STR .EQ. 'A3') THEN              IXMM=360+           ELSE IF (SIZE_STR .EQ. 'A2') THEN              IXMM=510+           ELSE IF (SIZE_STR .EQ. 'A1') THEN              IXMM=720.           ELSE IF (SIZE_STR .EQ. 'AUTO' ) THEN             AUTO=.TRUE.            ELSE)             STOP 'Invalid size parameter'            ENDIF K           IYMM=NINT(IXMM*FLOAT(IYBR)/FLOAT(IXBR))   !Get aspect ratio right D         ELSE                      !Number given - see if another one           IXMM=NINT(XMM)2           IF (CLI$GET_VALUE('SIZE',SIZE_STR)) THEN4             IF (.NOT.OTS$CVT_T_F(SIZE_STR,YMM)) THENI               IYMM=NINT(IXMM*FLOAT(IYBR)/FLOAT(IXBR))   !Get aspect ratio              ELSE               IYMM=NINT(YMM)             ENDIF            ELSEL             IYMM=NINT(IXMM*FLOAT(IYBR)/FLOAT(IXBR))   !Get aspect ratio righ           END IF             IXOFS=0            IYOFS=0 K           IF (CLI$PRESENT('OFFSET')) THEN                              !2.H K             IF (CLI$GET_VALUE('OFFSET',OFFSET_STR)) THEN               !2.H K               IF (.NOT.OTS$CVT_T_F(OFFSET_STR,XOFS)) THEN              !2.H K                 IXOFS=0                                                !2.H K               ELSE                                                     !2.H K                 IXOFS=NINT(XOFS)                                       !2.H K               END IF                                                   !2.H K               IF (CLI$GET_VALUE('OFFSET',OFFSET_STR)) THEN             !2.H K                 IF (.NOT.OTS$CVT_T_F(OFFSET_STR,YOFS)) THEN            !2.H F                   IYOFS=0 	                                       !2.HK                 ELSE                                                   !2.H K                   IYOFS=NINT(YOFS)                                     !2.H J                 END IF	                                               !2.HK               END IF                                                   !2.H K             END IF                                                     !2.H K           END IF                                                       !2.H          END IF       END IF C  C     Identify C &       IF (IDENTIFY) WRITE (LUNTO,1000)= 1000  FORMAT(' REGIS_TO_HPGL -- Issue: 2.K Date: 12-Feb-88'/) D       OPEN (UNIT=LUNIN,FILE=REGIS_FILE,STATUS='OLD',READONLY,SHARED,      &DEFAULTFILE='.RGS') -       INQUIRE (UNIT=LUNIN,CARRIAGECONTROL=CC) "       FORTRAN_CC=(CC.EQ.'FORTRAN') C  C     Initialise plotter C 4       OPEN (UNIT=LUNOUT,FILE=HPGL_FILE,STATUS='NEW',7      &CARRIAGECONTROL='LIST',SHARED,DEFAULTFILE='.HPG')        IF (INLINE) THEN%         WRITE (LUNOUT,1010) ESC//'.('  1010    FORMAT(A)        END IFK       WRITE (LUNOUT,1010) ESC//'.RIN;'//ESC//'.P1;'//ESC//'.T15229;3201;0:'       &//ESC//'.@12180:OE;'       IF (ROTATE) THEN&         WRITE (LUNOUT,1010) 'RO90;IP;'       END IF       IF (AUTO) THEN!         WRITE (LUNOUT,1010) 'IW;' 
       ELSEK         WRITE (LUNOUT,1020) -20*IXMM+40*IXOFS,-20*IYMM+40*IYOFS,       !2.H K      &  20*IXMM+40*IXOFS,20*IYMM+40*IYOFS,                             !2.H K      &  -20*IXMM+40*IXOFS-10,-20*IYMM+40*IYOFS-10,                     !2.H K      &  20*IXMM+40*IXOFS+10,20*IYMM+40*IYOFS+10                        !2.H 6 1020    FORMAT ('IP',I6,',',I6,',',I6,',',I6,';IW',I6,!      &  ',',I6,',',I6,',',I6,';')        END IF-       WRITE (LUNOUT,1030) IXTL,IXBR,IYBR,IYTL A 1030  FORMAT('SC',I3,',',I3,',',I3,',',I3,';SR0.79,2.1;VS15;LT;') 4       WRITE (LUNOUT,1010) 'SL'//SL_STR(:SL_LEN)//';' C  C     Main loop  C        DO WHILE (.TRUE.)           CALL COMAND(COMD,LENCMD)%         IF (COMD(1:1).EQ.EOF) GOTO 10 "         IF (COMD(1:1).EQ.'S') THEN C 6 C     S command -- Interpret S(E) as skip to new page,. C                S(A[u,v][x,y]) as set mapping C A           IF (INDEX(COMD(:LENCMD),'E').NE.0 .AND. NOT_EMPTY) THEN (             WRITE (LUNOUT,1010) 'SP;NR;'3             IF (IPEN.NE.0) WRITE (LUNOUT,1040) IPEN  1040        FORMAT('SP',I3,';')              NOT_EMPTY=.FALSE.            ENDIF 2           IF (INDEX(COMD(:LENCMD),'A[').NE.0) THENB             CALL COORDS(COMD(:LENCMD),I,IXTL,IYTL,XREL,YREL,ERROR)2             IF (.NOT.ERROR .AND. I.LE.LENCMD) THENE               CALL COORDS(COMD(I:LENCMD),I,IXBR,IYBR,XREL,YREL,ERROR) "               IF (.NOT.ERROR) THEN+                 XSENS=FLOAT(IXBR-IXTL)/767. +                 YSENS=FLOAT(IYTL-IYBR)/479. 7                 WRITE (LUNOUT,1050) IXTL,IXBR,IYBR,IYTL 8 1050            FORMAT('SC',I5,',',I5,',',I5,',',I5,';')               END IF             ENDIF            END IF'         ELSE IF (COMD(1:1).EQ.'W') THEN  C 1 C     W Command -- only interpret W(Pn) as select 4 C                pattern, W(P(Mn)) as set multiplier) C                and W(F..) as select pen  C $           I=INDEX(COMD(:LENCMD),'F')           IF (I.NE.0) THEN2             CALL VALUE(COMD(I+1:LENCMD),I,J,ERROR)              IF (.NOT.ERROR) THEN               IPEN=J&               WRITE (LUNOUT,1060) IPEN$ 1060          FORMAT('PU;SP',I3,';')             END IF           END IF$           I=INDEX(COMD(:LENCMD),'P')           IF (I.NE.0) THENF             J=I+1                             !COMD(J) is char after P&             IF (COMD(J:J).EQ.'(') THEN-               K=INDEX(COMD(J:LENCMD),')')+J-1                 IF (K.GT.J+2) THEN.                 IF (COMD(J+1:J+1).EQ.'M') THEN5                   CALL VALUE(COMD(J+2:K-1),J,I,ERROR) &                   IF (.NOT.ERROR) THEN                     IPM=I '                     IF (IPAT.GT.1) THEN 8                       WRITE (LUNOUT,1070) IPAT-1,IPM*0.92 1070                  FORMAT('LT',I1,',',F3.1,';')                     ENDIF                    ENDIF                  ENDIF D               ELSE IF (COMD(J:J).GE.'0' .AND. COMD(J:J).LE.'9') THEN7                 CALL VALUE(COMD(J:LENCMD),K,IPAT,ERROR) 5                 IF (.NOT.ERROR .AND. IPAT.LT.10) THEN %                   IF (IPAT.GT.1) THEN 6                     WRITE (LUNOUT,1070) IPAT-1,IPM*0.9                   ELSE'                     WRITE (LUNOUT,1080) " 1080                FORMAT ('LT;')                   END IF                 ENDIF                ENDIF              END IF           END IF'         ELSE IF (COMD(1:1).EQ.'T') THEN  C ; C     T Command -- look for T(Sn) and T'.......'/T"......."  C $           I=INDEX(COMD(:LENCMD),'(')-           J=INDEX(COMD(:LENCMD),SINGLE_QUOTE) $           K=INDEX(COMD(:LENCMD),'"')5           IF (K.NE.0 .AND. (J.EQ.0 .OR. K.LT.J)) THEN              J=K              CQT='"'            ELSE             CQT=SINGLE_QUOTE           ENDIF 5           IF (I.NE.0 .AND. (J.EQ.0 .OR. I.LT.J) .AND. $      &    COMD(I+1:I+1).EQ.'S') THEN C  C     Command is T(Snn)  C              I=I+2 3             CALL VALUE(COMD(I:LENCMD),I,ISIZ,ERROR)               IF (.NOT.ERROR) THEN               SIZE=ISIZe%               IF (ISIZ.EQ.0) SIZE=0.5 3               WRITE (LUNOUT,1090) .79*SIZE,2.1*SIZEP, 1090          FORMAT('SR',F6.2,',',F6.1,';')             END IF           END IF           IF (J.NE.0) THEN Ce" C      Command is T'...' or T"..." Cm+             K=INDEX(COMD(J+1:LENCMD),CQT)+Jt+             IF (K.NE.J .AND. K.NE.J+1) THEN  C 1 C     K-(J+1) is text length, starts at COMD(J+1)R CS?               WRITE (LUNOUT,1100) XSENS*SIZE*1.5,-YSENS*SIZE*15 / 1100          FORMAT('PR;PU',F5.1,',',F6.0,';')l               RELPLT=.TRUE. :               WRITE (LUNOUT,1010) 'LB'//COMD(J+1:K-1)//EOT?               WRITE (LUNOUT,1110) -XSENS*SIZE*1.5,YSENS*SIZE*15 , 1110          FORMAT('PU',F5.1,',',F6.0,';')               NOT_EMPTY=.TRUE.             ENDIFr           ENDIF '         ELSE IF (COMD(1:1).EQ.'P') THEN  Ce C     P Commandn COD           CALL COORDS(COMD(:LENCMD),IPT,IXPOS,IYPOS,XREL,YREL,ERROR)           IF (.NOT.ERROR) THEN#             IF (XREL.AND.YREL) THENu#               IF (.NOT.RELPLT) THEN                  RELPLT=.TRUE.0)                 WRITE (LUNOUT,1010) 'PR;'V               END IF             ELSE               IF (RELPLT) THEN                 RELPLT=.FALSE.)                 WRITE (LUNOUT,1010) 'PA;'                END IFJ               IF (XREL) THEN                                          !2.KJ                 IXPOS=LAST_X+IXPOS                                    !2.KJ               END IF                                                  !2.KJ               IF (YREL) THEN                                          !2.KJ                 IYPOS=LAST_Y+IYPOS                                    !2.KJ               END IF                                                  !2.K             END IF+             WRITE (LUNOUT,1130) IXPOS,IYPOS8& 1130        FORMAT('PU',I5,',',I5,';')J             IF (RELPLT) THEN                                          !2.KJ               LAST_X=LAST_X+IXPOS                                     !2.KJ               LAST_Y=LAST_Y+IYPOS                                     !2.KJ             ELSE                                                      !2.KJ               LAST_X=IXPOS                                            !2.KJ               LAST_Y=IYPOS                                            !2.KJ             END IF                                                    !2.K           END IF'         ELSE IF (COMD(1:1).EQ.'V') THENR C  C     V Command  C D           CALL COORDS(COMD(:LENCMD),IPT,IXPOS,IYPOS,XREL,YREL,ERROR)           IF (.NOT.ERROR) THEN#             IF (XREL.AND.YREL) THEN #               IF (.NOT.RELPLT) THENt                 RELPLT=.TRUE.y)                 WRITE (LUNOUT,1010) 'PR;'p               END IF             ELSE               IF (RELPLT) THEN                 RELPLT=.FALSE.)                 WRITE (LUNOUT,1010) 'PA;'                END IFJ               IF (XREL) THEN                                          !2.KJ                 IXPOS=LAST_X+IXPOS                                    !2.KJ               END IF                                                  !2.KJ               IF (YREL) THEN                                          !2.KJ                 IYPOS=LAST_Y+IYPOS                                    !2.KJ               END IF                                                  !2.K             END IF+             WRITE (LUNOUT,1150) IXPOS,IYPOSp& 1150        FORMAT('PD',I5,',',I5,';')J             IF (RELPLT) THEN                                          !2.KJ               LAST_X=LAST_X+IXPOS                                     !2.KJ               LAST_Y=LAST_Y+IYPOS                                     !2.KJ             ELSE                                                      !2.KJ               LAST_X=IXPOS                                            !2.KJ               LAST_Y=IYPOS                                            !2.KJ             END IF                                                    !2.K             NOT_EMPTY=.TRUE.           END IF         ELSE*           WRITE (LUNTO,1160) COMD(:LENCMD)5 1160      FORMAT(' *** Unrecognised command "',A,'"')e
         ENDIFe       END DO Ca C     End of filei Ci 10    WRITE (LUNOUT,1010) 'SP;'c Cu C     Set bypass mode  Cl       IF (INLINE) THEN%         WRITE (LUNOUT,1010) ESC//'.)'t       END IF       CLOSE (UNIT=LUNOUT)        CLOSE (UNIT=LUNIN )I
       STOP	       END 