/*
 * showkey.c -- display cooked key sequences
 *
 * Invoke this (no arguments needed) to see keycap-to-keystrokes mappings.
 *
 * by Eric S. Raymond <esr@snark.thyrsus.com>, 1 Nov 88
 * fix for little-endian machines 21 Oct 1996.
 */
#include <stdio.h>
#include <termio.h>
#include <signal.h>

#define META	0x80
#define ESC	0x1b

static char *lowchars[] =
{
    "NUL", "SOH", "STX", "ETX", "EOT", "ENQ", "ACK", "BEL",
    "BS",  "HT",  "LF",  "VT",  "FF",  "CR",  "SO",  "SI",
    "DLE", "DC1", "DC2", "DC3", "DC4", "NAK", "SYN", "ETB",
    "CAN", "EM",  "SUB", "ESC", "FS",  "GS",  "RS",  "US",
    "SP",
};

static int signalled;

static void catcher(sig)
int sig;
{
    signalled = sig;
}

main()
{
    struct termio	cooked, raw;
    unsigned char	c;
    unsigned int	i, timeouts;

    for (i = SIGHUP; i <= SIGPOLL; i++)
	(void) signal(c, catcher);

    (void) ioctl(0, TCGETA, &cooked);

    (void) memcpy(&raw, &cooked, sizeof(struct termio));
    raw.c_lflag &=~ (ICANON | ECHO);
    raw.c_cc[VEOL] = 1;
    raw.c_cc[VEOF] = 2;
    (void) ioctl(0, TCSETA, &raw);

    (void) printf("Type any key to see the sequence it sends, DEL to quit.\n");
    signalled = 0;
    timeouts = 1;
    while (!signalled)
    {
	int		meta;

	if (read(0, &c, 1) != 0)
	    timeouts = 0;
	else
	/*
	 * This is supposed to cause the program to emit a newline .2 sec
	 * after reading a key sequence, but it doesn't work, I don't know
 	 * why.
	 */
	{
	    if (timeouts++ == 0)
		(void) putchar('\n');
	    continue;
	}

	if (meta = (c & META))
	    c &=~ META;

	if (c <= ' ')
	    (void) printf("<%s%s>", meta ? "ALT-" : "", lowchars[c]);
	else if (c == 0x3F)
	    (void) printf("<%sDEL>", meta ? "ALT-" : "");
	else if (meta)
	    (void) printf("<ALT-%c>", c);
	else
	    (void) putchar(c);
	(void) fflush(stdout);
    }

    (void) printf("\nBye...\n");
    (void) ioctl(0, TCSETA, &cooked);
}

/* showkey.c ends here */
