package Wayside;
use strict;
use warnings;

use Class::MethodMaker [
    scalar => [ qw/ t trklon platform timeshift switch tcbykft registry/ ],
    scalar => [qw/ rtcstate switchstate plattccare ijlocs/],
    scalar => [
        qw/ pickupq plattwclast plattwcsame platocclast platoccsame plathastrain /
    ],
    new => [ -init => 'new' ],
];

use Database;
my $dbh = Database->new->dbh;

use Registry;

sub init {
    my ( $self, $t, $xleft, $xright ) = @_;
    $self->initstatic( $xleft, $xright );
    $self->initstates($t);
    return;
}

sub initstatic {
    my ( $self, $xleft, $xright ) = @_;
    print "before registry setup\n";
    my $registry = Registry->new;
    $self->registry($registry);
    my $sub = "";
    $sub = "where trklon between $xleft and $xright"
      if defined $xleft && defined $xright;
    print "after registry setup\n";
    my $trklon = $dbh->selectall_hashref(
        "SELECT pointname,trklen,trklon,landmark,trkid from trklon $sub",
        "pointname" )
      or die $dbh->errstr;
    print "after trklon select\n";
    $self->trklon($trklon);

    my $platform = $dbh->selectall_hashref(
"SELECT platform,trkocc1 from platform where trkocc1 = any (select pointname from trklon $sub)",
        "trkocc1"
    );
    print "after platform select\n";
    $self->platform($platform);

    my $switchl = $dbh->selectall_arrayref(
"SELECT swipos,utc,rtc,dire,leavedir,pickupat FROM switch where utc = any (select pointname from trklon $sub)"
    );
    print "after switch select\n";
    my $switch = {};

    for (@$switchl) {
        my $utc = $_->[1];
        push @{ $switch->{$utc} },
          {
            swipos   => $_->[0],
            utc      => $_->[1],
            rtc      => $_->[2],
            dire     => $_->[3],
            leavedir => $_->[4],
            pickupat => $_->[5]
          };
    }
    $self->switch($switch);
    my $tcbykft = {};
    $self->tcbykft($tcbykft);
    my $rtcstate = {};
    $self->rtcstate($rtcstate);
    my $switchstate = {};
    $self->switchstate($switchstate);
    my $plattccare = {};
    $self->plattccare($plattccare);
    $self->plattwclast(  {} );
    $self->plattwcsame(  {} );
    $self->platocclast(  {} );
    $self->platoccsame(  {} );
    $self->plathastrain( {} );
    $self->pickupq(      {} );
    $self->ijlocs(       {} );

    my $m;
    my $left;
    for my $pointname (
        sort { $trklon->{$a}->{trklon} <=> $trklon->{$b}->{trklon} }
        keys %$trklon
      )
    {
        my $ref  = $trklon->{$pointname};
        my $newm = int( $ref->{"trklon"} / 1000000 );
        if ( !defined $m || $newm != $m ) {
            $left = undef;
        }
        $m               = $newm;
        $ref->{"left"}   = $left;
        $left->{"right"} = $ref;
        $left            = $ref;
        my $leftx  = $ref->{"trklon"};
        my $rightx = $leftx + $ref->{"trklen"};
        for ( int( $leftx / 1000 ) .. int( $rightx / 1000 ) ) {
            push @{ $tcbykft->{$_} }, $ref;
        }
        $ref->{"state"} = $registry->register($pointname);

        if ( exists( $platform->{$pointname} ) ) {
            my ( $rtu, $side ) = split "-",
              $platform->{$pointname}->{"platform"};
            $side = "-" . $side if length($side) < 2;
            my $twclengthpoint = "AS1C" . $rtu . "-----" . $side;
            $ref->{"twcstate"} = $registry->register($twclengthpoint);
            $ref->{"platform"} = $platform->{$pointname}->{"platform"};
            $plattccare->{ $platform->{$pointname}->{"platform"} } = $ref;
            my $twcidpoint = "AS1A" . $rtu . "-----" . $side;
            $ref->{"idstate"} = $registry->register($twcidpoint);
        }
        if ( exists $switch->{$pointname} ) {
            for ( @{ $switch->{$pointname} } ) {
                $_->{state} = $ref->{"state"};
                $_->{used}  = 1;
                $_->{seq}   = 0;
            }
        }
    }

    for my $pointname ( keys %$switch ) {
        for ( @{ $switch->{$pointname} } ) {
            next if !$_->{used};
            $_->{rtcstate}    = $registry->register( $_->{rtc} );
            $_->{switchstate} = $registry->register( $_->{swipos} );
        }
        $trklon->{$pointname}{switch} = $switch->{$pointname};
    }

    for my $pointname ( keys %$trklon ) {
        if (   ( !defined $trklon->{$pointname}->{left} )
            || ( !defined $trklon->{$pointname}->{right} ) )
        {
            $trklon->{$pointname}->{edge} = 1;
        }
        else {
            $trklon->{$pointname}->{edge} = 0;
        }
    }
    my $lastpointname;
    my @tosort = grep { defined $trklon->{$_}->{trklon} } keys %$trklon;
    for my $pointname (
        sort { $trklon->{$a}->{trklon} <=> $trklon->{$b}->{trklon} } @tosort )
    {
        if ( defined $lastpointname
            && substr( $lastpointname, 0, 4 ) ne substr( $pointname, 0, 4 ) )
        {
            $self->ijlocs->{ $trklon->{$pointname}->{"trklon"} + 0 }++;
        }
        $lastpointname = $pointname;
    }
    return;
}

sub initstates {
    my ( $self, $t0 ) = @_;
    if ( !defined $t0 ) {
        $t0 = $dbh->selectrow_arrayref("SELECT max(time) from changes")->[0];
        $t0 = $t0 - 180;
    }
    $self->registry->initstates($t0);
    $self->t($t0);
    return;
}

sub updateto {
    my ( $self, $t9 ) = @_;
    my $twanted = $self->t + 1;
    while ( ( $dbh->selectrow_arrayref("SELECT max(time) from changes")->[0] ) <
        $twanted + 12 )
    {
        print "sleeping for data\n";
        sleep 1;
    }
    $self->registry->updateto($twanted);
    $self->t($twanted);

    #    print "new time is ", $self->t, "\n";
    return ( !defined $t9 || $self->t < $t9 );
}

sub switchexitstates {
    my ($self) = @_;

# Walk the state machine tracking switch exit sequence
# 0:no exit in progress
# 1:circuits before and after switch occupied, and switch is reverse
# 2:train has taken the exit, but before and after tc's aren't vacant.
# Go back to step 0 if we've taken the exit, and circuits before and after switch are vacant

    my $switch = $self->switch;

    for my $pointname ( keys %$switch ) {
        for ( @{ $switch->{$pointname} } ) {
            next if !$_->{used};
            my $before      = ${ $_->{state} };
            my $after       = ${ $_->{rtcstate} };
            my $switchstate = ${ $_->{switchstate} };
            my $seq         = $_->{seq};
            my $leavedir    = $_->{leavedir};
            if (   $seq == 0
                && $switchstate ne ( 3 - $leavedir )
                && $before
                && $after )
            {
                $_->{seq} = 1;
            }
            if (
                $seq != 0
                && ( $switchstate eq ( 3 - $leavedir )
                    || ( !$before && !$after ) )
              )
            {
                $_->{seq} = 0;
            }
        }
    }
    return;
}

sub switchexits {
    my ( $self, $trainlist ) = @_;
    my $switch  = $self->switch;
    my $trklon  = $self->trklon;
    my $pickupq = $self->pickupq;

    # Now loop over all switches OK to exit from.
    # If any trains overlap it, then they go bye-bye
    # And we preclude other trains from exiting at this switch until clear again

    for my $pointname ( keys %$switch ) {
        for ( @{ $switch->{$pointname} } ) {
            next if !$_->{used};
            next if $_->{seq} != 1;
            my $l0 = $trklon->{$pointname}{trklon};
            my $l9 = $trklon->{$pointname}{trklen} + $l0;
            while ( my ( $name, $train ) = each( %{ $trainlist->trains } ) ) {
                next if $train->ison !~ /$pointname/;
                my $x0 = $train->limithistory->[-1][1];
                my $x8 = $train->limithistory->[-1][2];
                my $x9 = $x8 + $train->length;
                print "train $name spans $x0 to $x9\n";
                next if $x0 > $l9;
                next if $x9 < $l0;

                print "train $name took exit at $pointname\n";
                if ( $_->{pickupat} ) {
                    print "adding to pickupq ", $_->{pickupat}, "\n";
                    $pickupq->{ ( $self->t + 120 ) . " " . $_->{pickupat} } =
                      [ $train->length, $_, $train->id ];
                }
                else {
                    print "no pickupq for ", $_->{swipos}, " ", $_->{utc},
                      " ", $_->{rtc}, "\n";
                }
                delete $trainlist->trains->{$name};
                $_->{seq} = 2;
                my $rtc = $_->{rtc};
                for my $sw2 ( keys %{$switch} ) {
                    for my $path2 ( @{ $switch->{$sw2} } ) {
                        if (   $path2->{rtc} eq $rtc
                            || $path2->{utc} eq $rtc )
                        {
                            print "disabling crossover seq at ", $_->{utc},
                              " ", $_->{rtc}, "$_\n";
                            $path2->{seq} = 2;
                        }
                    }
                }
            }
        }
    }
    return;
}

sub dopickupqs {

    my ( $self, $trainlist, $multiocc ) = @_;
    my $pickupq = $self->pickupq;
    my $trklon  = $self->trklon;
    my $t0      = $self->t;
    for my $q ( sort keys %$pickupq ) {
        print "pickupq $q\n";
        my ( $timeout, @tcneeded ) = split / /, $q;
        my $moniker = $tcneeded[0];
        my ( $neededlength, $swiref, $id ) = @{ $pickupq->{$q} };
        if ( $t0 > $timeout ) {
            print "pickupq has timed out\n";
            delete $pickupq->{$q};
        }
        else {
            my $bomb = 0;
            my ( $min, $max );
            for (@tcneeded) {
                if ( !exists $trklon->{$_} || !exists $trklon->{$_}{state} ) {
                    print "bombing because $_ doesn't exist\n";
                    $bomb++;
                    last;
                }
                print "state of $_ is ", ${ $trklon->{$_}{state} }, "\n";
                $bomb++
                  if ( ${ $trklon->{$_}{state} } ne 1
                    || exists $multiocc->{$_} );
                my $x0 = $trklon->{$_}{trklon};
                my $x9 = $trklon->{$_}{trklen} + $x0;
                $min = $x0 if !defined $min || $x0 < $min;
                $max = $x9 if !defined $max || $x9 > $max;
                last if ( $max - $min ) > $neededlength;
            }
            print "value of bomb is $bomb\n";
            if ( !$bomb ) {
                print
"creating train $moniker-$t0 at $min to $max at $t0 with length ",
                  $neededlength, "\n";
                my $train = Train->new;
                $train->length($neededlength);
                $train->nextmin($min);
                $train->nextmax($max);
                $train->createplace( int( ( $min + $max ) / 2 ) );
                $train->createtime($t0);
                $train->limithistory( [] );
                $train->fithistory(   [] );
                $train->tendency(0);
                $train->id($id);
                $train->swiref($swiref);
                $train->name("$moniker-$t0");
		$train->trainlist($trainlist);
                $trainlist->trains->{"$moniker-$t0"} = $train;
                delete $pickupq->{$q};
            }
        }
    }
}

sub xordered {
    my ($self) = @_;
    my @xs;
    my $trklon = $self->trklon;
    for my $pointname (
        sort { $trklon->{$a}{trklon} <=> $trklon->{$b}{trklon} }
        keys %$trklon
      )
    {
        push @xs, $trklon->{$pointname};
    }
    return @xs;
}

1;
