package Registry;
use strict;
use warnings;

my @hortonrtus  = qw(A02 A03 B02 B04 B06 B08 B99 C02 C05 D02 G03 G04 G05 B35);
my $hortonshift = 2;
my %hortonhash;
for (@hortonrtus) { $hortonhash{$_} = $hortonshift }

use Class::MethodMaker [
    scalar => [qw/numtodata timeshift invertflag numtype/],
    new    => [ -init => 'new' ],
];

use Database;
my $dbh = Database->new->dbh;

my $numtype;

sub init {
    my ($self) = @_;
    $self->numtodata(  {} );
    $self->timeshift(  {} );
    $self->invertflag( {} );
    if ( !defined $numtype ) {
        $numtype = {};
        my $qq = $dbh->selectall_arrayref(
            "SELECT pointname,num,tabletype FROM status" );
        for (@$qq) {
            $numtype->{ $_->[0] } =
              { pointname => $_->[0], num => $_->[1], tabletype => $_->[2] };
        }
    }
    $self->numtype($numtype);
    return;
}

sub register {
    my ( $self, $pointname ) = @_;
    if ( !defined $self->numtype->{$pointname} ) {
        print "Don't know how to register for $pointname\n";
        return;
    }
    my $numtype = $self->numtype->{$pointname};
    my ( $num, $type ) = ( $numtype->{num}, $numtype->{tabletype} );
    if ( exists $self->numtodata->{$num}{$type} ) {
        return $self->numtodata->{$num}{$type};
    }
    my $value = "?";
    $self->numtodata->{$num}{$type} = \$value;
    my $shift = 0;
    $shift = $shift + $hortonshift
      if ( exists $hortonhash{ substr( $pointname, 4, 3 ) } );
    $self->timeshift->{$num}{$type} = $shift;
    my $invertflag = 0;
    $invertflag = 1 if substr( $pointname, 0, 4 ) eq 'SM9A';
    $self->invertflag->{$num}{$type} = $invertflag;
    return $self->numtodata->{$num}{$type};
}

sub initstates {
    my ( $self, $t0 ) = @_;
    my $numtodata  = $self->numtodata;
    my $timeshift  = $self->timeshift;
    my $invertflag = $self->invertflag;
    my $sinit      = $dbh->prepare(
"SELECT time,num,value,qc,tabletype FROM changes where time<=? and num=? and tabletype=? order by time desc limit 1"
    );
    for my $num ( keys %$numtodata ) {
        for my $type ( keys %{ $numtodata->{$num} } ) {
            my $t0h = $t0 + $timeshift->{$num}{$type};

            #	    print "get init value for $num $type at time $t0h\n";
            $sinit->execute( $t0h, $num, $type );
            my $init = $sinit->fetchrow_arrayref;
            next if !$init;
            my $value = "?";
            $value = $init->[2] if !$init->[3];
            $value = 1 - $value if $invertflag->{$num}{$type} && $value ne "?";
            ${ $numtodata->{$num}{$type} } = $value;
        }
    }
    return;
}

sub updateto {
    my ( $self, $twanted ) = @_;
    my $numtodata  = $self->numtodata;
    my $timeshift  = $self->timeshift;
    my $invertflag = $self->invertflag;
    my $geth       = $dbh->prepare(
"SELECT time,num,value,qc,tabletype FROM changes WHERE time between ? and ?"
    );
    my $twantedh = $twanted + $hortonshift;
    $geth->execute( $twanted, $twantedh );
    my $row;

    while ( $row = $geth->fetchrow_arrayref ) {
        my $num  = $row->[1];
        my $type = $row->[4];
        my $time = $row->[0];
        if ( exists $numtodata->{$num}{$type} ) {
            my $value = $row->[2];
            $value = 1 - $value if $invertflag->{$num}{$type};
            $time = $time - $timeshift->{$num}{$type};
            next if $time != $twanted;
            my $r = $numtodata->{$num}{$type};
            if ( $row->[3] ) {
                $$r = "?";
            }
            else {
                $$r = $value;
            }
        }
    }
    return;
}

1;
