package Pdfpanels;

use strict;
use warnings;

use Time::Local;
use Date::Manip;
use PDF::API2;

use Wayside;

use Class::MethodMaker [
    scalar => [qw/ pdf fnt ltfnt /],
    scalar => [ { -default => [ 8.5 * 72, 11 * 72 ] }, 'papersize' ],
    scalar => [       { -default => 0.5 * 72 }, 'margins' ],
    scalar => [       { -default => 0.5 * 72 }, 'leftlab' ],
    scalar => [       { -default => 0.5 * 72 }, 'toplab' ],
    new    => [ -init => "new" ],
];

sub init {
    my $self = shift;
    my $pdf  = PDF::API2->new;
    $pdf->mediabox( @{ $self->papersize } );
    $self->pdf($pdf);
    $self->fnt( $pdf->corefont( 'Arial,Bold', '-encoding=>latin1' ) );
    $self->ltfnt( $pdf->corefont( 'Arial', '-encoding=>latin1' ) );
}

sub page {
    my ( $self, $tcenter, $xcenter ) = @_;
    my $page      = $self->pdf->page;
    my $gfx       = $page->gfx;
    my $txt       = $page->text;
    my $dataleft  = $self->margins + $self->leftlab;
    my $dataright = $self->papersize->[0] - $self->margins;
    my $databot   = $self->margins;
    my $datatop   = $self->papersize->[1] - ( $self->margins + $self->toplab );
    my $t0        = $tcenter - 60;
    my $t9        = $tcenter + 60;
    my $sectopnt  = ( $datatop - $databot ) / ( $t9 - $t0 );
    print "before call to Wayside\n";
    my $wayside = Wayside->new( $t0, $xcenter - 5000, $xcenter + 5000 );
    print "after call to Wayside\n";
    my @columns = $wayside->xordered;
    my $x0      = $columns[0]->{trklon};
    my $x9      = $columns[-1]->{trklon} + $columns[-1]->{trklen};
    my $fttopnt = ( $dataright - $dataleft ) / ( $x9 - $x0 );
    my $t       = $wayside->t;

    # The lowest layer on the graphical PDF presentation are any circles/dots
    # denoting failures.

    my $dbh = Database->new->dbh;

    my @bad;
    my $of          = "$xcenter-$tcenter.pdf";
    my $badness9    = 0;
    my $tc9         = $xcenter;
    my $wasrtalert9 = 0;
    my $fails       = $dbh->selectall_arrayref(
"SELECT time,trklon,color,badness,trainlength,historytext,blameblock,wasrtalert from fitfails where time between $t0 and $t9 and trklon between $x0 and $x9"
    );

    for my $fail (@$fails) {
        my ( $t, $x, $color, $badness, $trainlength ) = @$fail;
        push @bad,
          [
            $dataleft + $fttopnt * ( $trainlength * 2.5 + ( $x - $x0 ) ),
            $datatop - $sectopnt * ( $t - $t0 ), $badness
          ];
        $gfx->strokecolor($color);
        $gfx->fillcolor($color);
        $gfx->linewidth(2);
        $gfx->circle(
            $dataleft + $fttopnt * ( $x - $x0 ),
            $datatop - $sectopnt * ( $t - $t0 ),
            $trainlength * 2.5 * $fttopnt
        );
        $gfx->fillstroke;
    }
    $gfx->linewidth(0);

    # The next layer is any occupancy data
    for (@columns) {
        $_->{lastt} = $t;
        $_->{old}   = ${ $_->{state} };
    }
    my @rects;
    while ( $wayside->updateto($t9) ) {
        $t = $wayside->t;
        for (@columns) {
            my $old = $_->{old};
            my $new = ${ $_->{state} };
            if ( $new ne $old ) {
                push @rects, [ $_, $old, $_->{lastt}, $t ];
                $_->{lastt} = $t;
                $_->{old}   = $new;
            }
        }
    }
    $t++;
    for (@columns) {
        if ( $_->{lastt} != $t ) {
            push @rects, [ $_, $_->{old}, $_->{lastt}, $t ];
        }
    }
    $gfx->linewidth(0.1);
    for (@rects) {
        my ( $trk, $old, $tstart, $tend ) = @$_;
        next if !$old;
        my $c = "&55EEFF";
        $c = "lightgrey" if $old eq "?";
        my $px = $dataleft + $fttopnt * ( $trk->{trklon} - $x0 );
        my $py = $datatop - $sectopnt * ( $tend - $t0 );
        my $xw = $fttopnt * $trk->{trklen};
        my $yw = $sectopnt * ( $tend - $tstart );
        $gfx->strokecolor($c);
        $gfx->fillcolor($c);
        $gfx->rect( $px, $py, $xw, $yw );
        $gfx->fillstroke;
    }

    # The next layer is any grid lines and axis labels
    my $fs = $fttopnt * 200;
    $fs = 5 if $fs > 5;
    $txt->font( $self->fnt, $fs );
    for (@columns) {
        my $x0 = $dataleft + $fttopnt * ( $_->{trklon} - $x0 );
        my $y0 = $datatop;
        my $x1 = $x0;
        my $y1 = $databot;
        $gfx->strokecolor("darkgrey");
        $gfx->linewidth(0.1);
        $gfx->move( $x0, $y0 );
        $gfx->line( $x1, $y1 );
        $gfx->stroke;
        $gfx->strokecolor("black");
        $gfx->fillcolor("black");
        $txt->translate( $x0 + $fttopnt * $_->{trklen} * 0.5, $datatop );
        $txt->transform_rel( -rotate => 30 );
        my $text = $_->{trkid} . " " . ( $_->{trklen} + 0 ) . " ft";
        $txt->text($text);
    }
    my ( $dayofwk, $month, $day, undef, $year ) = split ' ',
      ( scalar localtime $t0 );
    $txt->font( $self->fnt, 8 );
    $txt->translate( $dataleft - 2,
        $self->papersize->[1] - $self->margins - 8 );
    $gfx->strokecolor("black");
    $gfx->fillcolor("black");
    $txt->text_right( join ' ', $dayofwk, $month, $day );
    $txt->translate( $dataleft - 2,
        $self->papersize->[1] - $self->margins - 15 );
    $txt->text_right($year);

    for my $t ( $t0 .. $t9 ) {
        my $issmalltic = $t % 5;
        my $x0         = $dataleft - 2;
        my $x1         = ( $issmalltic ? $dataleft : $dataright );
        my $y0         = $datatop - $sectopnt * ( $t - $t0 );
        my $y1         = $y0;
        $gfx->strokecolor("darkgrey");
        $gfx->move( $x0, $y0 );
        $gfx->line( $x1, $y1 );
        $gfx->stroke;

        if ( !$issmalltic ) {
            $txt->translate( $x0 - 1, $y0 - 3 );
            $gfx->strokecolor("black");
            $gfx->fillcolor("black");
            my ( undef, undef, undef, $tstamp, undef ) = split ' ',
              ( scalar localtime $t );
            $txt->text_right($tstamp);
        }
    }

    # The next layer is any fit lines
    my $dc = "blue";
    print
"SELECT width,fitbin from fits WHERE (time0 between $t0 and $t9 or time9 between $t0 and $t9) and (trklon0 between $x0 and $x9 or trklon9 between $x0 and $x9)\n";
    my $fits = $dbh->selectall_arrayref(
"SELECT width,fitbin,trainname from fits WHERE (time0 between $t0 and $t9 or time9 between $t0 and $t9) and (trklon0 between $x0 and $x9 or trklon9 between $x0 and $x9)"
    ) or die $dbh->errstr;

    my %fitsbytrainname;
    for my $fit (@$fits) {
        my ( undef, undef, $name ) = @$fit;
        push @{ $fitsbytrainname{$name} }, $fit;
    }

    my @sfits;

    for my $train ( sort keys %fitsbytrainname ) {
        my %sfit;
        my %wfit;
        my $wall;
        for my $fit ( @{ $fitsbytrainname{$train} } ) {
            my ( $width, $fitdata, $name ) = @$fit;
            $wall = $width;
            my ( $ti, $xi, @delts ) = unpack( "NNc*", $fitdata );
            my $n   = scalar @delts;
            my $mid = $ti + $n / 2;
            $ti = $ti - 1;
            for ( 0, @delts ) {
                $ti += 1;
                $xi += $_;
                my ( $t, $x ) = ( $ti, $xi );
                my $w = 1;
                $w = 1 - 2 * abs( $mid - $t ) / $n if $n;
                $sfit{$t} += $x * $w;
                $wfit{$t} += 1 * $w;
            }
        }
        my $sfit = [$wall];
        for my $t ( sort { $a <=> $b } keys %sfit ) {
            next if !$wfit{$t};
            my $x = $sfit{$t} / $wfit{$t};
            push @$sfit, [ $t + 0.5, $x ];
        }
        push @sfits, $sfit;
    }

    my @tedges;
    for my $sfit (@sfits) {
        my ( $width, @txlist ) = @$sfit;
        for my $o ( 0, $width ) {
            my $linbound = 0;
            for my $tx (@txlist) {
                my ( $t, $x ) = @$tx;
                $x += $o;
                my $inbound = 1;
                $inbound = 0 if ( $t < $t0 || $t > $t9 );
                $inbound = 0 if ( $x < $x0 || $x > $x9 );
                if ( $inbound && !$linbound ) {
                    push @tedges, [];
                }
                if ($inbound) {
                    push @{ $tedges[-1] }, [ $t, $x ];
                }
                $linbound = $inbound;
            }
        }
    }
    for my $edge (@tedges) {
        my @a    = @{$edge};
        my $init = shift @a;
        my ( $t, $x ) = @{$init};
        my $px = $dataleft + $fttopnt * ( $x - $x0 );
        my $py = $datatop - $sectopnt * ( $t - $t0 );
        $gfx->strokecolor($dc);
        $gfx->linewidth(0.25);
        $gfx->move( $px, $py );

        for my $step (@a) {
            my ( $t, $x ) = @{$step};
            my $px = $dataleft + $fttopnt * ( $x - $x0 );
            my $py = $datatop - $sectopnt * ( $t - $t0 );
            $gfx->line( $px, $py );
        }
        $gfx->stroke;
    }

    # And the last layer is the ft*sec labels and the historytext

    $txt->font( $self->fnt, 18 );
    for (@bad) {
        my ( $x, $y, $bad ) = @$_;
        $txt->translate( $x, $y );
        $txt->text( $bad . " ft*secs" );
    }

    for (@$fails) {
        my ( $time8, $trklon8, $color, $badness, undef, $historytext,
            $blameblock, $wasrtalert )
          = @$_;
        next if $time8 != $tcenter;
        next if $trklon8 != $xcenter;
        my ( $xht, $yht ) = ( $dataleft + 3 * 72, $datatop - 72 );
        $txt->font( $self->fnt, 30 );
        $txt->strokecolor("black");
        $txt->fillcolor("black");
        if ($blameblock) {
            my $tmp = $blameblock;
            $tmp =~ s/ST\d.//g;
            $tmp =~ s/--/-/g;
            $tmp =~ s/--/-/g;
            $txt->translate( $xht + 40, $yht + 24 );
            $txt->text_center($tmp);
            my ($tmp1) = split " ", $tmp;
            $of          = "$tmp1-$tcenter.pdf" if $tmp1;
            $wasrtalert9 = $wasrtalert;
            $badness9    = $badness;
            $tc9         = $tmp1 if $tmp1;
        }
        $txt->font( $self->fnt, 10 );
        $txt->translate( $xht, $yht + 12 );
        $txt->text("Time");
        $txt->translate( $xht + 47, $yht + 12 );
        $txt->text("ID");
        $txt->translate( $xht + 65, $yht + 12 );
        $txt->text("ft*secs");

        for my $h ( split /\n/, $historytext ) {
            next if ( $h =~ m/This and previous trains to move over/ );
            $txt->translate( $xht, $yht );
            $txt->text($h);
            $yht = $yht - 12;
        }
    }

    return ( $of, $badness9, $tc9, $wasrtalert9 );

}

sub render {
    my ($self) = shift;
    return $self->pdf->stringify;
}

1;
