package Trainlist;

use strict;
use warnings;
use Train;

use Class::MethodMaker [
    scalar => [qw/ trains /],
    new    => [ -init => "new" ],
];

my $fitquantum = 2;

sub init {
    my $self = shift;
    $self->trains( {} );
    return;
}

sub update {
    my ( $self, $wayside ) = @_;
    my $multioccs = {};
    $wayside->plathastrain( {} );
    $wayside->switchexitstates;
    print "time is ", $wayside->t, " tracking ", scalar keys %{ $self->trains },
      " trains\n";
    while ( my ( $name, $train ) = each( %{ $self->trains } ) ) {
        $train->findoverlaps( $wayside, $multioccs );
    }
    while ( my ( $name, $train ) = each( %{ $self->trains } ) ) {
        $train->label( $wayside, $multioccs );
    }
    $self->handlemultioccs( $wayside, $multioccs );
    while ( my ( $name, $train ) = each( %{ $self->trains } ) ) {
        $train->yardleadcheck( $wayside, $multioccs );
    }

    $wayside->switchexits($self);
    while ( my ( $name, $train ) = each( %{ $self->trains } ) ) {
        if ( $train->strictfit( $wayside, $multioccs ) ) {
            $train->handlefail( $wayside, $multioccs );
            delete $self->trains->{$name};
        }
    }

    $wayside->dopickupqs( $self, $multioccs );
    $self->addnewtrains($wayside);
    return;
}

sub addnewtrains {
    my ( $self, $wayside ) = @_;
    my $plattccare   = $wayside->plattccare;
    my $plattwclast  = $wayside->plattwclast;
    my $plattwcsame  = $wayside->plattwcsame;
    my $platocclast  = $wayside->platocclast;
    my $platoccsame  = $wayside->platoccsame;
    my $plathastrain = $wayside->plathastrain;
    my $t0           = $wayside->t;
    for my $platform ( sort keys %$plattccare ) {
        my $ref = $plattccare->{$platform};
        if (   defined ${ $ref->{"twcstate"} }
            && defined $plattwclast->{$platform}
            && ${ $ref->{"twcstate"} } ne "?"
            && ${ $ref->{"twcstate"} } eq $plattwclast->{$platform}
            && ${ $ref->{"twcstate"} } < 5 )
        {
            $plattwcsame->{$platform}++;
        }
        else {
            $plattwcsame->{$platform} = 0;
            $plattwclast->{$platform} = ${ $ref->{"twcstate"} }
              if defined ${ $ref->{"twcstate"} };
        }
        if (   defined ${ $ref->{"state"} }
            && defined $platocclast->{$platform}
            && ${ $ref->{"state"} } eq $platocclast->{$platform} )
        {
            $platoccsame->{$platform}++;
        }
        else {
            $platoccsame->{$platform} = 0;
            $platocclast->{$platform} = ${ $ref->{"state"} };
        }
        if (   ${ $ref->{state} } =~ /^\d+/
            && ${ $ref->{twcstate} } =~ /^\d+/
            && ${ $ref->{state} } == 1
            && ${ $ref->{twcstate} } > 0
            && $plattwcsame->{$platform} > 8
            && $platoccsame->{$platform} > 8
            && !( $t0 % $fitquantum ) )
        {
            if ( !exists $plathastrain->{$platform} ) {
                print "creating train at $platform at $t0 ";
                my $train = Train->new;
                $train->length( 150 * ${ $ref->{"twcstate"} } - 66 );
                print "with length ", $train->length, "\n";
                $train->nextmin( $ref->{"trklon"} - $train->{length} );
                $train->nextmax( $ref->{"trklon"} + $ref->{"trklen"} );
                $train->createplace( $ref->{"trklon"} );
                $train->createtime($t0);
                $train->limithistory( [] );
                $train->fithistory(   [] );
                $train->tendency(undef);
                $train->name("$platform-$t0");
		$train->trainlist($self);
                print "my trains is ", $self->trains, "\n";
                $self->trains->{"$platform-$t0"} = $train;
                print "train was added\n";
            }
        }
    }
    return;
}

sub handlemultioccs {
    my ( $self, $wayside, $multiocc ) = @_;
    my $t0 = $wayside->t;
    while ( my ( $name, $train ) = each( %{ $self->trains } ) ) {
        $train->tendency(undef)
          if !defined $train->tendencyt || $train->tendencyt < $t0 - 4;
    }
    for my $m ( sort keys %$multiocc ) {
        next if scalar @{ $multiocc->{$m} } < 2;
        print "$m is occupied ", ( scalar @{ $multiocc->{$m} } ),
          " times by trains ", ( join " ", @{ $multiocc->{$m} } ), "\n";
        my %order;
        for my $trainname ( @{ $multiocc->{$m} } ) {
            if ( !exists $self->trains->{$trainname} ) {
                print
"Danger Will Robinson train $trainname is part of a multiocc but no longer exists\n";
                next M;
            }
            $self->trains->{$trainname}->limithistory->[-1][6] =
              1;    #set multiocc for this train
            my $x =
              ( $self->trains->{$trainname}->nextmin +
                  $self->trains->{$trainname}->nextmax ) / 2;
            $order{ $x / 2 } = $trainname;
        }
        my @order = sort { $a <=> $b } keys %order;
        for (@order) {
            $self->trains->{ $order{$_} }->tendency(0);
            $self->trains->{ $order{$_} }->tendencyt($t0);
        }

# Now we doctor up the trains so their most recent limithistory, ensures no overlap and that they stay in order
# Take the leftmost train, and ensure that all the other trains stay to the right of it
        my $trainleftmost = $self->trains->{ $order{ $order[0] } };
        $trainleftmost->tendency(-1);
        $trainleftmost->tendencyt($t0);
        my $xa = $trainleftmost->nextmin;
        my $xb = $trainleftmost->limithistory->[-1][1];
        $xa = $xb if $xb > $xa;
        print "leftmost train left edge at $xa\n";
        my $followmin = $xa + $trainleftmost->length;
        print "right edge at $followmin\n";

        my $bottom = 1;
        $bottom = 1 / ( ( scalar @order ) - 1 ) if ( scalar @order ) > 2;

        for my $i ( 0 .. ( ( scalar @order ) - 1 ) ) {
            $self->trains->{ $order{ $order[$i] } }->weight( $i / $bottom );
        }

        for my $meat ( 1 .. ( ( scalar @order ) - 1 ) ) {
            print "adjusting limithistory for train number $meat name ",
              $order{ $order[$meat] }, "\n";
            my $tm       = $self->trains->{ $order{ $order[$meat] } };
            my $oldvalue = $tm->limithistory->[-1][1];
            print "old left edge was $oldvalue\n";
            print "new left edge could be as low as $followmin\n";
            if ( $oldvalue > $followmin ) {
                print "no need to adjust!\n";
            }
            else {
                $tm->limithistory->[-1][1] = $followmin;
                print "adjusted\n";
            }
            $followmin = $followmin + $tm->length;
        }
        my $trainrightmost = $self->trains->{ $order{ $order[-1] } };
        $trainrightmost->tendency(1);
        $trainrightmost->tendencyt($t0);
        $xa = $trainrightmost->nextmax;
        $xb = $trainrightmost->limithistory->[-1][2] + $trainrightmost->length;
        $xa = $xb if $xb < $xa;
        my $precedemax = $xa - $trainrightmost->length;

        for my $meat ( reverse( 0 .. ( ( scalar @order ) - 2 ) ) ) {
            print "adjusting limithistory for train number $meat name ",
              $order{ $order[$meat] }, "\n";
            my $tm       = $self->trains->{ $order{ $order[$meat] } };
            my $oldvalue = $tm->limithistory->[-1][2];
            print "old value was $oldvalue\n";
            my $newvalue = $precedemax - $tm->length;
            print "new value will be $newvalue\n";
            if ( $newvalue > $oldvalue ) {
                print "no need to adjust!\n";
            }
            else {
                $tm->limithistory->[-1][2] = $newvalue;
            }
            $precedemax = $precedemax - $tm->length;
        }
    }
    while ( my ( $name, $train ) = each( %{ $self->trains } ) ) {
        print "Train $name has tendency ", $train->tendency, "\n"
          if defined $train->tendency;
    }
    return;
}

1;
