#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

#
/*
 *			G E T C M D
 *
 * Getcmd builds command files for the Decus compiler.  For documentation,
 * see below.  Note that getcmd runs only on the Decus compiler.
 *
 */

char	*documentation[] {
"Getcmd builds command files, writing them to the standard output.  Usage:",
"	getcmd >result [flag] pattern wild_card_descriptions",
"The following switches are defined:",
"    -c		Macro command file, delete reference to RSX.MAC and RT11.MAC",
"    -d		Debug mode",
"    -m	model	\"Model\" replaces '?' in the pattern string",
"    -r		RT11 switch, preface output with R MACRO, end with ^C",
"",
"If no pattern is present, patterns and wild-card descriptions will",
"be read from the standard input.  The input format is:",
"	output_file pattern input_spec.",
"If the pattern begins with a blank, the current output_file (or stdout)",
"will be used.  If the pattern contains blanks, enclose it in quotes.",
"",
"Within a pattern, the following strings have special meaning:",
"	?	Replaced by the last model string",
"	*.*	Replaced by the filename + extension",
"	*	Replaced by the filename only",
"Note that the disk and [UIC,PPN] is never output",
"",
"Unflagged arguments are wild-card file specifications",
"",
"For example:",
"  getcmd >[5,5]rilbas.cmd -c \"OBJ:*,LST:*=SRC:RT11,SRC:*\" [5,5]*.MAC",
"The above command line builds the assembly command file for the I/O",
"library in RT11 mode.",
"",
"  getcmd >iotovm.cmd \"RDVAX::DB0:[C.OTSIO]*.*/VA=[5,5]*.*\" [5,5]*.*",
" The above command generates an indirect command file for RSTS/E DECnet",
0 };

#include <stdio.h>

#define	MAX_NAMES	500		/* Max. file names		*/
int		debug;
int		macroflag;
int		rt11flag;
char		*model;
char		*pattern;
char		*wild_spec;
char		*out_spec;
char		fullname[81];
char		filename[81];
char		line[133];		/* Input text line		*/
char		*text[MAX_NAMES];	/* store file names here	*/
char		**ttop = text;		/* Top of text pointer		*/


FILE		*infd;

main(argc, argv)
int		argc;
char		*argv[];
{

	register int		c;
	register int		i;
	register char		*ap;

	if (argv[1][0] == '?' && argv[1][1] == 0) {
		help();
		exit();
	}
	for (i = 1; i < argc; i++) {
		if (*(ap = argv[i]) == '-') {
			while ((c = tolower(*++ap)) != 0) {
				switch (c) {
				case 'd':
					debug++;
					break;

				case 'c':
					macroflag++;
					break;

				case 'm':
					if (++i >= argc)
						usage("No arg after -m");
					model = argv[i];
					goto loop;

				case 'r':
					rt11flag++;
					printf("R MACRO\n");
					break;

				default:
					bug("W", "Unknown switch '%c'\n",
							c);
					break;
				}
			}
		}
		else {
			if (pattern == 0) {
				pattern = argv[i];
				continue;
			}
			wild_spec = argv[i];
			ttop = text;
			if (process() > 0)
				doit();
		}
loop:;	}
	/*
	 * pattern will be zero if none was provided by the command line
	 */
	if (pattern == 0)
		getinput();
	if (rt11flag)
		printf("^C\n");
}

getinput()
/*
 * Read from stdin, process each line as it comes
 */
{
	register char	*lp;
	register int	c;
	register int	count;
	char		*skipbl();
	char		*findbl();

	while (fgetss(line, sizeof line, stdin) != NULL) {
		/*
		 * Skip over leading blanks and get file spec.
		 */
		count = 0;
		ttop = text;
		lp = line;
		if (*lp > ' ') {
			out_spec = lp = skipbl(line);
			lp = findbl(lp);
			if (debug)
				fprintf(stderr, "new stdout = \"%s\"\n",
						out_spec);
			if (freopen(out_spec, "w", stdout) == NULL) {
				bug("E", "Can't open \"%s\"\n", out_spec);
				continue;
			}
		}
		/*
		 * Skip over blanks and get pattern
		 */
		lp = findqbl(lp, &pattern);
		while (*lp) {
			lp = findqbl(lp, &wild_spec);
			count += process();
		}			
		if (count > 0)
			doit();
	}
}
		


process()
/*
 * Find files, return how many
 */
{
	register int		count;		/* Count files		*/

	if (debug)
		fprintf(stderr, "Wild card spec = \"%s\"\n", wild_spec);
	if ((infd = fwild(wild_spec, "r")) == NULL) {
		bug("E", "Can't open \"%s\"\n", wild_spec);
		return(0);
	}
	for (count = 0; fnext(infd) != NULL; count++) {
		setname(infd);
		if (debug)
			fprintf(stderr, "Curr file = \"%s\"\n", fullname);
		if (macroflag &&
				(streq(fullname, "RSX.MAC")
				|| streq(fullname, "RT11.MAC")))
			continue;
		save(fullname);
	}
	if (debug)
		fprintf(stderr, "%d files processed\n\n", count);
	if (count == 0)
		bug("W", "No files matched \"%s\"\n", wild_spec);
	return(count);
}

doit()
{
	register char		**textp;	/* Pointer to names	*/
	register char		*pp;		/* Pattern pointer	*/
	register int		c;		/* Current character	*/

	for (textp = text; textp < ttop; textp++) {
		/*
		 * Get file name part, too
		 */
		cpystr(filename, *textp);
		for (pp = filename; (c = *pp) && c != '.'; pp++);
		*pp = 0;

		for (pp = pattern; (c = *pp++);) {
			switch (c) {

			case '*':
				if (*pp == '.' && pp[1] == '*') {
					printf(*textp);
					pp += 2;
				}
				else 
					printf(filename);
				break;

			case '?':
				printf(model);
				break;

			default:
				putchar(c);
			}
		}
		putchar('\n');
		free(*textp);
	}
}

setname(fd)
FILE 		*fd;
/*
 * Build file name
 */
{
	register char		*wp;
	register int		c;
	char			work[81];

	iovtoa(fd, work);
	/*
	 * Skip over device name
	 */
	for (wp = work; (c = *wp) && c != ':'; wp++);
	if (c)	wp++;
	else	wp = work;
	/*
	 * Skip over [UIC] or [PPN] if present
	 */
	if (*wp == '[' || *wp == '(') {
		while ((c = *wp++) && c != ']' && c != ')')
		if (c == 0) {
			fprintf(stderr, "?GETCMD-bad file name \"%s\"\n",
					work);
			wp--;
		}
	}
	cpystr(fullname, wp);
	/*
	 * Don't include version
	 */
	for (wp = fullname; (c = *wp) && c != ';'; wp++);
	*wp = 0;
}

save()
/*
 * Save fullname, add it to the text area (in sorted order)
 */
{
	register char	**textp;
	register char	**insert;
	register int	i;

	for (textp = text; textp < ttop; textp++) {
		if ((i = strcmp(*textp, fullname)) == 0) {
			fprintf("?GETCMD-E-Duplicate file name \"%s\"\n",
				fullname);
			return;
		}
		else if (i > 0)
			break;
	}
	insert = textp;
	textp = ttop;
	if (++ttop >= &text[MAX_NAMES])
		error("?GETCMD-F-Too many file names, %d max.\n", MAX_NAMES);

	while (textp >= insert) {
		textp[1] = *textp;
		textp--;
	}
	if ((*insert = malloc(strlen(fullname) + 1)) == NULL)
		error("?GETCMD-F-No room for \"%s\"\n", fullname);
	cpystr(*insert, fullname);
}
	


findqbl(text_ptr, start)
char		*text_ptr;
char		**start;
/*
 * Skip leading blanks, find text (handle quoted text strings)
 * return true start of text in start
 */
{
	register char	*lp;
	register int	c;

	*start = lp = skipbl(text_ptr);
	if ((c = *lp) == 0)
		return(lp);
	else if (c == '"') {
		lp++;
		*start = lp;
		while ((c = *lp) && c != '"')
			lp++;
		if (c == 0) {
			bug("E", "Missing quote in pattern \"%s\"",
				pattern);
			return(lp);
		}
		*lp++ = 0;
	}
	else lp = findbl(lp);
	if (debug)
		fprintf(stderr, "unscanned (return) = \"%s\"\n", lp);
	return(lp);
}

char *
skipbl(text_ptr)
char		*text_ptr;
/*
 * Skip over blanks
 */
{
	register char	*tp;
	register int	c;

	for (tp = text_ptr; (c = *tp) && c <= ' '; tp++);
	return(tp);
}

char *
findbl(text_ptr)
char		*text_ptr;
/*
 * Skip to the next blank, terminate the string and step the pointer
 */
{
	register char	*tp;

	for (tp = text_ptr; *tp > ' '; tp++);
	if (*tp)
		*tp++ = 0;
	return(tp);
}


help()
/*
 * Give good help
 */
{
	register char	**dp;

	for (dp = documentation; *dp; dp++)
		fprintf(stderr, "%s\n", *dp);
}

usage(s)
char	*s;
{
	bug("E", "%s.  For help, GETCMD ?\n", s);
	exit(1);
}

bug(severity, s)
char		*severity;
char		*s;
/*
 * Error messages
 */
{
	fprintf(stderr, "%cGETCMD-%s-%r",
		(*severity == 'W') ? '%' : '?', severity, &s);
}
                                                                    