#
/*
 * PROPRIETARY INFORMATION.  Not to be reproduced, transmitted, or disclosed
 * in any way without permission.
 *
 * UNIX RT-11 SJ Emulator.
 *
 * Produced by Human Computing Resources Corp.,
 * 10 St. Mary Street, Toronto, Ont. Canada
 *
 * Version:	2		Date:	January 1979
 * Author:	Mike Tilson
 * Description:
 *	This module interprets and dispatches the various RT-11 system calls.
 * Revisions:
 */
#include "defns.h"
#include "decls.h"
#include "errors.h"

/*
 * Calls with arg list pointed to by r0
 */
arglist(ar0)
	int *ar0;
{
	register int code, channel;
	register int *r0;

	r0 = ar0;
	code = r0->hibyte&0377;
	channel = r0->lobyte&0377;
	switch(code) {
	case DELETE:
		delete(channel, r0);
		break;
	case ENTER:
		enter(channel, r0);
		break;
	case LOOKUP:
		lookup(channel, r0);
		break;
	case RENAME:
		rename(channel, r0);
		break;
	case REOPEN:
		reopen(channel, r0);
		break;
	case SAVESTATUS:
		savestatus(channel, r0);
		break;
	case READ:
		rtread(channel, r0);
		break;
	case SPFUN:
		error(NOSPFUN);
		break;
	case WRITE:
		rtwrite(channel, r0);
		break;
	case CSTAT:
		ignore(NOCSTAT);
		break;
	case GTIM:
		gtim(r0);
		break;
	case GTJB:
		gtjb(r0);
		break;
	case GVAL:
		gval(r0);
		break;
	case SFPA:
		sfpa(r0);
		break;
	case TRPSET:
		trpset(r0);
		break;
	case TWAIT:
		twait(r0);
		break;

	case SCCA:
		ignore(NOSCCA);
		break;

	case MRKT:
		ignore(NOMRKT);
		/****
		mrkt(r0);
		*****/
		break;
	case CMKT:
		ignore(NOCMKT);
		/*****
		cmkt(r0);
		******/
		break;
	case CDFN:
		ignore(NOCDFN);
		break;

	case PROTECT:
		break;
	default:
		invalid(0375, code);
		break;
	}
}


/*
 * One-argument system calls, code and channel in r0
 */
onearg(code, achannel) {
	register int channel;

	channel = achannel;
	switch(code) {
	case CLOSE:
		rtclose(channel);
		break;
	case PURGE:
		purge(channel);
		break;
	case CHAIN:
		chain();
		break;
	case DATE:
		date();
		break;

	case HERR:
	case SERR:
		ignore(NOHSERR);
		break;

	case WAIT:
		rtwait(channel);
		break;

	default:
		invalid(0374, code);
		break;
	}
}


/*
 * System calls with args in r0 and on the stack
 */
stackarg(code, r0, asp)
	int *asp;
{
	register int *sp;

	sp = asp;
	switch(code) {
	case PRINT:
		print(r0);
		break;
	case TTYIN:
		ttyin();
		break;
	case TTYOUT:
		ttyout(r0);
		break;
	case CSIGEN:
		csigen(sp[2], sp[1], sp[0], sp[3]);
		break;
	case CSISPC:
		csispc(sp[2], sp[1], sp[0], sp[3]);
		break;
	case DSTATUS:
		dstatus(r0, sp[0]);
		stackadjust(-1);
		break;
	case EXIT:
		rtexit();
		break;
	case FETCH:
		fetch(r0, sp[0]);
		stackadjust(-1);
		break;
	case SETTOP:
		settop(r0);
		break;

	case HRESET:
	case SRESET:
		/* the only thing we do is purge all open files */
		purgeall();
		break;

	case QSET:
		ignore(NOQSET);
		/* SPR 009 -- return a phony value for QSET */
		retval = YES;
		rvalue = sp[0] + r0*14;
		stackadjust(-1);
		break;
	case LOCK:
		ignore(NOLOCK);
		break;
	case RCTRLO:
		ignore(NORCTRLO);
		break;
	case UNLOCK:
		ignore(NOUNLOCK);
		break;

	default:
		invalid(code, 0);
		break;
	}
}

invalid(code, subcode) {
	error(INVAL_EMT, code, subcode);
}

ignore(msg) {
	if(reportignores)
		warning(msg);
}

errcode(c) {
	rt_error = c+1;
}
