/*
 * scrunch an rt11 emulator to occupy less space and load quicker.
 * This program is not part of the emulator, but manipulates the
 * emulator a.out.
 *
 * this program depends on some cooperation from the emulator.
 */
struct nl {
	char	name[8];
	int	type;
	int	value;
} nl[3];
int buf[8*1024];
int input, output;
int codeloc, start;
struct header {
	int magic;
	int text;
	int data;
	int bss;
	int symsize;
	int eloc;
	int unused;
	int reloc;
} header;

main(argc, argv)
	char **argv;
{
	int size;
	int bssav;
	struct {
		char *uns;
	};

	if(argc!=3)
		error("usage: scrunch a.out scrunch.out");
	if((input=open(argv[1],0))<0)
		error("can't open %s", argv[1]);
	if(read(input, &header, sizeof header)!=sizeof header || header.magic!=0407)
		error("bad format");
	if(!getnames(argv[1]))
		error("can't scrunch--incorrect names");
	if((output=creat(argv[2],0777))<0)
		error("can't create %s", argv[2]);
	size = header.text+header.data+header.bss;
	bssav = header.bss;
	header.text =- start-codeloc;
	header.bss =+ start-codeloc;
	if(size.uns>0160000) {
		printf("scrunching big version\n");
		header.bss =- size-0140000;
	}
	size =- bssav;
	header.symsize = 0;
	header.reloc = 1;
	get(0, codeloc);
	write(output, &header, sizeof header);
	write(output, buf, codeloc);
	get(start, size-start);
	write(output, buf, size-start);
}

get(where, nbytes) {
	if(nbytes<0 || nbytes>sizeof buf)
		error("too big to scrunch");
	seek(input, where+sizeof header, 0);
	if(read(input, buf, nbytes)!=nbytes)
		error("input error");
}

getnames(f)
	char *f;
{
	register int i;
	copyn("codeloc", nl[0].name);
	copyn("_start", nl[1].name);

	nlist(f, nl);
	if(nl[0].type == -1 || nl[1].type == -1)
		return(0);
	codeloc = nl[0].value;
	start = nl[1].value;
	return(1);
}

copyn(from, to)
	char *from, *to;
{
	int i;

	for(i=0; i<8; i++) {
		*to++ = *from;
		if(*from)
			from++;
	}
}

error(a,b,c) {
	printf(a,b,c);
	putchar('\n');
	exit();
}
