#
/*
 * PROPRIETARY INFORMATION.  Not to be reproduced, transmitted, or disclosed
 * in any way without permission.
 *
 * UNIX RT-11 SJ Emulator.
 *
 * Produced by Human Computing Resources Corp.,
 * 10 St. Mary Street, Toronto, Ont. Canada
 *
 * Version:	2		Date:	January 1979
 * Author:	Mike Tilson
 * Description:
 *	I/O system declarations
 * Revisions:
 */

/* number of files which can actually be open.  The emulator will keep
 * more files "virtually open", and open them if needed.
 */
#define NFILES	8	/* +3 STD files, +3 work descriptors == max of 14 */
#define NCHAN	16	/* number of rt11 channels */
#define OCHAN	15	/* the overlay channel */

/* maximum size of a file */
#define MAXSIZE	077777	/* SPR 010 - make MAXSIZE positive */
/* channel state bits */
#define BUSY	01	/* channel in use */
#define OPEN	02	/* channel has an open fdes associated with it */
#define ENTERED	04	/* channel in use via ENTER, filename is temporary */
#define SYSDISK	010	/* file was found on "last resort" system disk */
#define PRINTER	020	/* this is a pipe to printer spooler */
#define TTY	040	/* I/O on this is to use STDIN, STDOUT, or actual tty */
#define OVERLAY	0100	/* overlay channel, never to be closed */
#define CHARDEV	(PRINTER|TTY)	/* channel is not 512 byte block oriented */
#define DIRECTORY	0200	/* channel is the "dk" device itself	*/

/* channel status word - eof bit */
#define EOFBIT	(1<<13)

/*
 * device info for DSTATUS and others
 */
#define RK05		0
#define LP11		03
#define CONSOLE		04
#define NLDEV		025
#define RANDOM		0100000
#define WRT_ONLY	020000
#define NONDIR		010000
struct devinfo {
	char *devnm;
	word devst;
	word devsize;
};


/*
 * structure defining a device/file name
 */
#define rad50	word
struct dblock {
	rad50	device;
	rad50	fname[2];
	rad50	extension;
};
#define dblk	struct dblock

/*
 * status info on channels
 */
struct chan {
	word	flags;		/* status flags */
	int	fdes;		/* UNIX file descriptor */
	int	fsize;		/* size in blocks */
	dblk	filename;
} chan[NCHAN];

int nopen;	/* number of channels which currently have an open fdes */
char filename[32];
boolean entering;
int elen;

struct statbuf {	/* UNIX file status */
	char minor;
	char major;
	int inumber;
	int flgs;
	char nlinks;
	char uid;
	char gid;
	char size0;
	int size1;
	int addr[8];
	long int actime;
	long int modtime;
};
