#
/*
 * PROPRIETARY INFORMATION.  Not to be reproduced, transmitted, or disclosed
 * in any way without permission.
 *
 * UNIX RT-11 SJ Emulator.
 *
 * Produced by Human Computing Resources Corp.,
 * 10 St. Mary Street, Toronto, Ont. Canada
 *
 * Version:	2		Date:	January 1979
 * Author:	Mike Tilson
 * Description:
 *	init -- data structure initialization, and emulator startup (main)
 * Revisions:
 */
#include "defns.h"
#include "decls.h"
#include "stdaddrs.h"
#include "io.h"
#include "errors.h"

#define REQD_STACK	170	/* words */
#define EXTRA_STACK	(REQD_STACK*2-FIRSTOFFSET)	/* bytes */

extern ill_instruc(), trace_trap(), iot_trap(), rt_syscall();
extern flt_excp(), bus_err(), seg_err();
extern byte ldpoint;
extern mtps(), mfps();

#define KILLHIM	1	/* if used as an addr, likely to kill user */

#define JMP	000137	/* op code for "jmp *$x" */

struct init {
	word	a;
	word	b;
};
struct init sigs[] {
	ILL_INSTRUC,	ill_instruc,
	TRACE_TRAP,	trace_trap,
	IOT_TRAP,	iot_trap,
	EMT_TRAP,	rt_syscall,
	FLT_EXCP,	flt_excp,
	BUS_ERR,	bus_err,
	SEG_ERR,	seg_err,
	NULL,		NULL,
};

struct init vals[] {
	USRSIZE,	EXTRA_STACK,
	IOEXIT,		KILLHIM,
	VNUM,		3|(1<<8),
	CONFIG,		STDCONFIG,
	TTYREGS,	KILLHIM,
	TTYREGS+2,	KILLHIM,
	TTYREGS+4,	KILLHIM,
	TTYREGS+6,	KILLHIM,
	MAXFSIZE,	MAXSIZE,
	SYNCH,		KILLHIM,
	MTPS,		JMP,
	MTPS+2,		mtps,
	MFPS,		JMP,
	MFPS+2,		mfps,
	CONFIG2,	STDEXTN,
	NULL,		NULL,
};

#define INTR	2
#define QUIT	3

main(argc, argv)
	int argc;
	char **argv;
{
	register struct init *ip;
	register int ncsi;
	register char *chainline;
	extern intr(), quit();

	chainline = NULL;
	/*
	 * catch various signals
	 */
	for(ip=sigs; ip->a!=NULL; ip++)
		signal(ip->a, ip->b);

	/*
	 * set up various memory locations
	 */
	setval(USRADDR, himem());	/* "USR" occupies these words, actually
					 * used as emulator stack area
					 */
	for(ip=vals; ip->a!=NULL; ip++)
		setval(ip->a, ip->b);

	/* SPR 012 - initialize JSW in case we die before prog loaded */
	JSW->integ = 0;

	/*
	 * Disallow the execution of TRAP instruction (UNIX system calls)
	 * below the emulator.
	 *
	 * care must be taken to make sure this runs on systems which
	 * do not have the "trapcatch" system call installed.
	 */
	signal(BADSYS, 1);
	trapcatch(&ldpoint-EXTRA_STACK, EMT_TRAP);
	signal(BADSYS, 0);

	/*
	 * process the argument list
	 */
	ncsi = 0;
	while(argc>1 && argv[1][0]=='-') {
		switch(argv[1][1]) {
		case 'c':
			dumpcore = YES;
			break;

		case 'e':
			reporterrors = YES;
			break;

		case 'w':
			reportignores = YES;
			break;

		case 'f':
			commfile = YES;
			/* and promptsuppress */

		case 'p':
			promptsuppress = YES;
			break;

		case 'a':
			if(argc<4)
				error(USAGE);
			assign(argv[2], argv[3]);
			argc =- 2;
			argv =+ 2;
			break;
		case 'C':
			if(argc<3)
				error(USAGE);
			chainline = argv[2];
			argc--;
			argv++;
			break;

		case 'i':
			if(argc<3)
				error(USAGE);
			if(ncsi>=NCSILINES)
				error(CTABFULL);
			ctab[ncsi++] = argv[2];
			ctp = ctab;
			argc--;
			argv++;
			break;

		default:
			error(USAGE);
		}
		argc--;
		argv++;
	}

	/*
	 * if in command file, terminal must point to actual tty,
	 * not simply to STDIN.
	 */
	if(commfile) {
		if((terminal = open("/dev/tty", 2))<0)
			error(NOTTY);
	}
	if((signal(INTR, 1)&1)==0)
		signal(INTR, intr);
	if((signal(QUIT, 1)&1)==0)
		signal(QUIT, quit);
	/*
	 * load the program
	 */
	if(argc!=2)
		error(USAGE);
	load(argv[1], chainline);

	/*
	 * setup complete, now begin
	 */
	begin();
}

/*
 * Load a program from a named file
 */
load(nm, chainline)
	char *nm;
	char *chainline;
{
	register char *name;
	int fsav;
	register char *s, *p;
	char work[50];

	name = work;
	/* copy name, leaving slop for append and prepend */
	if(length(nm)>sizeof work-20)
		error(NAME2BIG);
	copy(nm, name);

	/* see if we need a ".sav" extension */
	if(!match('.', name))
		append(".sav", name);

	/* see if we need a "device" on the front, or default "sy" device */
	if(!match('/', name))
		prepend("dk0/", name);
	else if(name[0]=='s' && name[1]=='y') {
		name[0] = 'd';
		name[1] = 'k';
	}
	/* translate "dk" to "dk0" */
	if(name[2]=='/') {
		prepend("x", name);
		name[0] = name[1];
		name[1] = name[2];
		name[2] = '0';
	}
	if((fsav=open(name, 0))<0) {
		/* last resort, try the system library */
		prepend(rtlib, name);
		if((fsav=open(name, 0))<=0) {
			dumpcore = NO;	/* not worth a core dump */
			error(NOPROG);
		}
	}
	if((s=chainline)!=NULL) {
		/*
		 * copy chainline to chain information area.
		 * do some character translation so that chainline
		 * may contain arbitrary binary info, including nulls.
		 */
		p = CHAININFO;
		while(*s) {
			if(*s=='\\' ) {
				s++;
				if(*s=='0') {
					*p++ = 0;
					s++;
				}
				else if(*s=='\\')
					*p++ = *s++;
			}
			else
				*p++ = *s++;
		}
		loadprog(fsav, YES);
	}
	else
		loadprog(fsav, NO);
}

/* match from end looking for char, stop matching after slash is found */
match(ch, str)
	char ch;
	char *str;
{
	register char *s;
	register int len;

	s = str;
	if((len=length(s)) <= 0)
		return(NO);
	s =+ len;
	do {
		if(*--s == ch)
			return(YES);
		if(*s == '/')
			return(NO);
	} while(--len);
	return(NO);
}


/*
 * Load a sav image from a file descriptor
 */
#define COMMSIZE	10
#define ENDCINFO	(CHAININFO+CHAINSIZE)

loadprog(fsv, chaining)
	boolean chaining;
{
	register byte *ptr;
	register int fsav;
	register struct chan *oc;

	fsav = fsv;
	oc = &chan[OCHAN];

	seek(fsav, 0, 0);
	if(read(fsav, 0, STARTLOC+COMMSIZE)!=STARTLOC+COMMSIZE)	/* read from 0 to end of system comm. area */
		error(LDFAILS);
	if(unsgncmp(HIMEMLOC->integ, himem())>=0)
		error(TOOBIG);
	ptr = STARTLOC+COMMSIZE;
	if(INITSPLOC->integ==0)
		INITSPLOC->integ = 01000;
	if(chaining) {
		if((JSW->integ&CHAINBIT)==0) {
			/* read in up to the start of the chain info area */
			seek(fsav, ptr, 0);
			if(read(fsav, ptr, CHAINLOC-ptr) != CHAINLOC-ptr)
				error(LDFAILS);
			ptr = ENDCINFO;
		}
		JSW->integ =| CHAINBIT;
	}
	JSW->integ =| USRNOSWAP;
	seek(fsav, ptr, 0);
	/* SPR 008 - remove '+2' in following */
	if(read(fsav, ptr, (HIMEMLOC->integ-ptr)) != (HIMEMLOC->integ-ptr))
		error(LDFAILS);
	if(JSW->integ&OVLYBIT) {
		if(oc->flags&BUSY) {
			if((oc->flags&OVERLAY)==0)
				warning(BYE_BYE_CHANNEL, OCHAN);
			if(oc->flags&OPEN) {
				close(oc->fdes);
				nopen--;
			}
		}
		oc->fdes = fsav;
		oc->flags = OVERLAY|BUSY|OPEN;
		nopen++;
	}
	else
		close(fsav);
	RMONLOC->integ = &ldpoint;

	/* re-use fsav register */
	if( fsav = JSW->integ&SPCLTTY )
		setmode(fsav);
}

/*
 * return max memory location.  in normal case it is loadpoint minus a
 * few extra words which we use for more stack.  (the simulated "USR"
 * resides there.
 *
 * if we have a "big" emulator (emulator loading up to 32Kw mark) then
 * himem can be no more than 0140000, since there is a hole in memory.
 * (0140000 is the boundary of the second stack segmentation register.)
 */
himem() {
	register char *a;

	a = &ldpoint-EXTRA_STACK;
	if(a>0137776)
		return(0137776);
	return(a);
}
