/*
 * PROPRIETARY INFORMATION.  Not to be reproduced or transmitted in any
 * way without permission.
 *
 *
 * RT-11 V3 Command Interpreter for UNIX.
 * Version 2.0, May 1979
 *
 * Produced by:
 *	Mike Tilson
 *	Human Computing Resources Corporation
 *	10 St. Mary Street
 *	Toronto, Ontario, Canada   M4Y 1P9
 *	416-922-1937
 *
 *
 * Command parser routines
 */

yyerror() {
	error("Command syntax");
}

int colonflag;
int ptok;

/*
 * lexical analysis for parser.
 */
yylex() {
	register c;

	if(ptok) {
		c = ptok;
		ptok = 0;
		return(c);
	}
	switch(c=getch()) {
	case EOF:
	case '\n':
		ungetch(c);
		return(0);
	case ',':
	case '+':
	case '(':
	case ')':
	case ' ':
	case '\t':
	case ':':
		return(c);

	case '/':
		return(OPT);
	case 003:	/* real CNTL-C */
		return(EOFINDICATOR);
	case '^':
		c=getch();
		if(c==EOF || c=='\n')
			ungetch(c);
		return(EOFINDICATOR);
	default:
		return(str_or_dev(c));
	}
}

/*
 * if a string ends with a ':' (and colonflag==0) return "device"
 * (e.g. DK:).  Otherwise return "string", which may or may not
 * contain ':', depending on colonflag.  Parser sets colonflag as
 * appropriate during the parse.
 */
str_or_dev(c) {
	char work[100];
	register i, ret;

	ret = STRING;
	i = 0;
	for(;;) {
		if(i< sizeof work -1)
			work[i++] = c;
		c = getch();
		if(special(c))
			break;
		if(c==':' && colonflag>=0)
			break;
	}
	if(c==':' && colonflag==0) {
		work[i++] = c;
		ret = DEVICE;
	}
	else
		ungetch(c);
	colonflag = 0;
	yylval = alloc((i+2)&~1);
	work[i] = 0;
	copy(work, yylval);
	return(ret);
}

struct node {
	int type;
	int left;
	int right;
};

/* build a parse tree node */
node(a,b,c) {
	struct node *p;

	p = alloc(sizeof *p);

	p->type = a;
	p->left = b;
	p->right = c;
	return(p);
}

special(c) {
	register cs;
	register i;

	for(i=0; cs = "@!(),+/ \t\n"[i]; i++)
		if(c==cs)
			return(1);
	return(0);
}

colon(f) {
	colonflag = f;
}

/*
 * push a token to be returned on next call to yylex.
 * used to invoke special pieces of the grammar.
 */
pushtoken() {
	ptok = T_INPUT_OUTPUT;
}


char peekc;

/*
 * lowest level of lexic analysis.  handles comments, indirect, continued
 * lines, and CR deletion.
 */
getch() {
	register c;
	if(peekc) {
		c = peekc;
		peekc = 0;
	}
	else {
		do
			c = getc();
		while(c=='\r');
		if(c=='!') {
			while((c=getc())!=EOF && c!='\n')
				;
		}
		else if(c=='@') {
			if(indirect())
				c = getch();
			else
				c = '\n';
		}
		else if(c=='-') {
			do
				c = getc();
			while(c=='\r');
			if(c=='\n')
				c = getch();
			else {
				ungetch(c);
				c = '-';
			}
		}
	}
	return(ucase(c));
}

ungetch(c) {
	peekc = c;
}
