
LM ERICSSON                             PASCAL USER MANUAL                1
TN/X/TDG SEVED TORSTENDAHL              1979-08-30      E                       



 
 
 
 
 
 
 
 
 
 
			PASCAL FOR PDP 11 UNDER RSX/IAS
			===============================
 
 
			Summary
 
			This report is intended as a supplement to the
			book Pascal User Manual and Report by Jensen and
			Wirth (Second Edition, Springer Verlag, 1975).
			It describes a PDP 11 implementation of Pascal
			under the operating systems RSX-11M and IAS.
 
 
 
			Contents
			--------
 
			1	Usage of the PASCAL compiler
			  1.1	  How to compile
			  1.2	  How to link
			  1.3	  How to run a PASCAL program
			2	Extensions
			  2.1	  Character set and special symbols
			  2.2	  Standard constants
			  2.3	  Standard types
			  2.4	  Standard files
			  2.5	  The extended CASE statement
			  2.6	  The LOOP statement
			  2.7	  Standard procedures
			  2.8	  Standard functions
			  2.9	  Dynamic arrays as parameters
			  2.10	  Procedures and functions as parameters
			  2.11	  Separate compilation
			3	Restrictions
			4	Compiler options
			5	Representation
 
 
			Appendices
 
			A	Character set
			B	Special symbols
			C	Reserved words
			D	Standard procedures
			E	Standard functions
			F	Error codes
			G	Options and switches
			H	Additional procedures and functions

LM ERICSSON                             PASCAL USER MANUAL                2
                                        1979-08-30      E                       



 
 
		1	USAGE OF THE PASCAL COMPILER
			----------------------------
 
			Usage under RSX-11M is described. The author is not
			familiar with IAS, and therefore IAS procedures are
			left out.
 
		1.1	How to compile
 
			The compiler is activated in the standard way:
			>PAS  <object>,<list>=<source>...
			If no file designators are given, the compiler
			will promt with PAS>, and then the user can
			give the file specifications. The source code
			may be divided into several files, but only
			one program is compiled in each activation.
			The file descriptions follow RSX standard,
			i.e. dev:[p,pn]file.ext/sw. Default values are
			dev:	SY0:
			[p,pn]	fetched from user terminal table
			.ext	.OBJ, .LST or .PAS respectively
 
			Switches corresponding to most so called options
			( see chapter 4 ) can be given. Only one letter is
			significant, /E is equivalent to /EIS. Switches can
			be negated through - or NO, ex. /-R or /NORR.
 
			Most switches apply to the object file, only /U (spool)
			/LW (line width), /PW (page width) and /W (warnings)
			should be placed on the list file specification.
 
			Default values may differ from installation to
			installation since they are chosen at compiler
			generation time.
 
			Four switches not corresponding to options exist.
			/U on the list file tells whether the file should
			be spooled after compilation or not. Default: /U
			(spool). /PW:n and /LW:n on the list file can redefine
			the page and line widths. Default selected at
			compiler generation time. /AA:n defines which
			level of predefined identifiers to use. See ch. 4.
 
			Ex.   	PAS  EX,EX/-U=EX
				PAS  T.OBJ,L=DK1:[200,200]EX2.PAS
				PAS  EX3/AA:1,L=EX3
 
			Object and list files are optional. Ex.
				PAS  EX2=EX2
				PAS  ,EX3=EX3
 
 
			Three error signals can be generated at this point.
			All cause immediate exit from the compiler:
			-	FILE NOT FOUND  if there is no file with
				the given name
			-	FILE SPECIFICATION ERROR  if  '=' is not 
				found or if no source filename is given
			-	SWITCH ERROR if an illegal switch is given
 

LM ERICSSON                             PASCAL USER MANUAL                3
                                        1979-08-30      E                       



 
		1.2	How to link Pascal programs
 
			Pascal programs are linked by the normal
			linker: TKB. It is used as for all object modules
			>TKB  <task>,<map>,<symtab>=<object>
 
			The file names are given as above, and only
			the object file(s) are mandatory. Dynamic
			memory is reserved according to the compilation
			report. If more storage is needed, the size
			of the task can be extended. Ex.
			>TKB
			TKB>EX4,EX4=EX4
			TKB>/
			ENTER OPTIONS:
			TKB>EXTTSK=4000		; add 4000. words
			TKB>//
 
			If more than 5 files are to be used simultaneously
			it is necessary to specify this number+1 to TKB:
			TKB>UNITS=9
			This allowes 8 open files plus tty to be used.
 
			It is also possible to build overlaid tasks.
			The procedure is then to compile the program
			with option Y+ in effect, use LBR to create an
			object library and then to build the task using
			an overlay description file. Example: program P
			has three independant procedures, which can be
			overlaid:
				(*$Y+*)
				program X
				   procedure A
				   procedure B
				   procedure C
				begin (* main *)
				 A;  B;  C;
				end.
			Compile:		PAS P,P=P
			Create object library:	LBR P/CR=P
			Create a file (P.ODL) describing the overlay structure:
				.ROOT P/LB:X-*(P/LB:A,P/LB:B,P/LB:C)
			Link using this ODL:	TKB P,P=P/MP
 
			See also the files that define the compiler
			structure, e.g. FPABLD.CMD and FPABLD.ODL .
 
			The TKB option TSKVEC=$P.VEC can be specified.
			In that case an error giving abortion will 
			give an octal dump of the heap and stacks of the task.
			The dump is created by PMD, which exists only under
			RSX-11M.
 
 

LM ERICSSON                             PASCAL USER MANUAL                4
                                        1979-08-30      E                       



		1.3	How to execute a Pascal program
 
			The program is activated the ordinary way: >RUN EX4.
			The worskspace can be increased by INStall through the
			/INC switch.
 
 
 
		2	EXTENSIONS
			----------
 
			There is a special switch (/a) which can be used to
			control which extensions are to be included. A 
			default value is selected at compiler generation time.
			It can be redefined using the /A switch on the object
			file designator. See paragraph 4.15 below.
 
		2.1	Character set and special symbols
 
			Many installations have character sets with the
			bracket symbols replaced with national characters.
			In order to make it easy to write readable programs
			it was necessary to allow a special symbol
			combination as well. New special symbols are:
			(.	left bracket
			.)	right bracket
			(*	start of comment
			*)	end of comment
			#	<>   (* not equal *)
			&	and
			!	or
 
 
		2.2	Standard constants
 
			For deflevel (/AA) >= 2 some standard constants are
			predeclared. The integer constants are defined as
			CONST MAXINT = 077777B (*  32767 *);
			      MININT = 100000B (* -32768 *);
			      ALFALENG = 10;
 
			The real constants  are defined as:
			CONST	MAXREAL   = 1.7014111E+38;
				MINREAL   = 1.5224277E-39;
				SMALLREAL = 1.1983428E-7;
			They represent the absolutely greatest and
			smallest reals, and SMALLREAL is the smallest
			value that makes 1.0+SMALLREAL <> 1.0 .
 
 
		2.3	Standard types
 
			For deflevel (/AA) >= 2 the standard type TEXT
			is predeclared as
			TYPE  TEXT = PACKED FILE OF CHAR;
 
			To allow characters of full ASCII or eightbit code,
			ASCII and BYTE are defined as
			TYPE ASCII = CHR(0) .. CHR(177B) ;
			TYPE BYTE  = CHR(0) .. CHR(377B) ;
 
			For deflevel >= 3 a standard type for RSX/IAS file

LM ERICSSON                             PASCAL USER MANUAL                5
                                        1979-08-30      E                       



			handling is predeclared as
			TYPE IOSPEC = (RANDOM,UPDATE,APPEND,TEMPORARY,INSERT,
					SHARED,SPOOL,BLOCK);
			It is used in reset/rewrite, see 2.7.4 below.
 
 
		2.4	Standard files
 
			In addition to the standard textfiles
			INPUT and OUTPUT the standard textfile TTY is
			available. This file is used to communicate
			with the user's terminal ( TI: of RSX/IAS ). This
			file can be opened only through the program
			statement.
 
 
		2.5	The extended CASE statement
 
			The CASE statement may be extended with the case
			OTHERS. The statement associated with
			OTHERS will be executed if the expression of the
			CASE statement does not evaluate to one of the
			explicitly given case labels. Syntax:
 
			<case statement> ::= CASE <expression> OF
			     <case element>  [ ;<case element> ]  END
			<case element> ::= <case label list> : <statement> !
					   <empty>
			<case label list> ::= <case label>  [ ,<case label> ] !
					      OTHERS
 
			Example:
				VAR X: CHAR;
				  ...
				CASE X OF
				  'A':	P(X);
				  'B':	Q(X);
				  ...
				  OTHERS:	Z(X)
				END;
 
			It is worth noting that the case statement always
			is translated to a so called "jump table", which is
			wasteful if the table is sparse. In such cases it is
			more economical to use successive if-then-else
			statements.
 
 
		2.6	The LOOP statement
 
			The LOOP statement is an additional control
			statement which combines the effects of WHILE
			and REPEAT statements. Syntax:
 
			<loop statement> ::= LOOP
					      <statement part>
					     EXIT IF <expression>;
					      <statement part>
					     END
			<statement part> ::= <statement> [ ;<statement>   ]
 
			The expression must result in a Boolean value.

LM ERICSSON                             PASCAL USER MANUAL                6
                                        1979-08-30      E                       



 
 
		2.7	Standard procedures
 
		2.7.1	DATE and TIME
 
			The procedure DATE( <alfa variable> ) assigns
			the current date in the format '19yy-mm-dd'
			to the parameter which must be of type
			PACKED ARRAY  (.1..10.) OF CHAR.
 
			The procedure TIME( <alfa variable> ) assigns
			the daytime in the format 'hh:mm:ss.t'
			to the parameter which must be of type
			PACKED ARRAY  (.1..10.) OF CHAR.
 
 
		2.7.2	MARK and RELEASE
 
			There is no procedure DISPOSE but the pair
			MARK and RELEASE takes care of deallocation
			when a nested structure is used. MARK puts
			a mark in the heap and RELEASE releases all
			storage above the topmost mark in the heap.
			They have no parameters, but for compatibility
			with the PASREL compiler on DEC10 they may
			be called with one (unused) parameter.
 
 
		2.7.3	HALT
 
			The procedure HALT can be used to help debug
			Pascal programs. A call of HALT gives an octal dump
			of the stack and heap, and exit from the program.
			The dump is created by PMD, which is only available
			under RSX-11M. With the new symbolic debugger this
			facility is not of much value any longer. 
			In programs compiled with option D+, symbolic
			debugging, HALT will invoke the debugger.
 
 
		2.7.4	RESET and REWRITE
 
			The standard procedures RESET(f) and REWRITE(f) have
			been extended with 5 new parameters. These make
			it possible to use almost all of the RSX/IAS file
			system, but two properties are fixed:
			- all files are accessed in locate mode,
			- textfiles ( files of char, ascii or byte ) use
			  records of variable length with one line per record,
			  all other files use records of fixed length.
			The new call format is:
				RESET(f,filename,dir,dev,ioselect)   and
				REWRITE(f,filename,dir,dev,ioselect)
			Only as many parameters as necessary need be
			present. They must be declared as:
 
			f:	FILE OF <type>;
 
			filename: ARRAY OF CHAR or string constant to give
				an external file name. Examples:
				'SOURCE.PAS','TEXT;3' or  a string

LM ERICSSON                             PASCAL USER MANUAL                7
                                        1979-08-30      E                       



				variable containing 'FILE2.EX     '.
				The length is insignificant. If the name is
				shorter than the string, the string must be
				filled with trailing blanks.
			dir:	ARRAY OF CHAR or string constant to give
				a file directory. Example:
				'(40,13)','(200,200)'. The parentheses are
				automaticaly translated to brackets. The length
				is insignificant. If the directory name is
				shorter than the string, the string must be
				filled with trailing blanks.
 
			dev:	ARRAY OF CHAR or string constant to give
				device name. Example:  'SY:','LP0:'. The length
				is insignificant. If the device name is
				shorter than the string, the string must be
				filled with trailing blanks.
 
			ioselect: SET OF IOSPEC;
					IOSPEC is predeclared if DEFLEVEL >= 3.
					Otherwise it can be declared as
					TYPE IOSPEC = (RANDOM,UPDATE,APPEND
					TEMPORARY,INSERT,SHARED,SPOOL,BLOCK);
 
					The keywords mean (cf RSX/IAS):
			    RANDOM	the records of the file may be fetched
					in random order,
			    UPDATE	an existing file shall be changed.
					Because locate mode is used, a record
					must be located by GET before PUT can be
					used, even if the record doesn't exist,
			    APPEND	an existing file shall be appended,
			    TEMPORARY	a temporary file shall be used.
					The temporary file is created at the
					first execution of a REWRITE statement
					where TEMPORARY is specified. Later
					RESET/REWRITE of the same file use
					the same temporary file regardless
					of parameters.
			    INSERT	together with UPDATE this condition
					gives that the file shall not be
					truncated if written into,
			    SHARED	the file is opened  in such a way that
					other tasks may open it too,
			    SPOOL	this textfile shall, when closed,
					be handed over to the print spooler
					for printing on the line printer,
			    BLOCK	enables blockwise read and write. Only
					one file element is read or written,
					even if more than one can be contained
					in one block. QIO is used directly, so
					this is not exactly as READ and WRITE
					of RSX/IAS.
 
 
			For both RESET and REWRITE f is the only mandatory
			parameter. The other parameters have default
			values if left out in a call:
 
			filename: the internal name of the file variable
			dir:	default uic from RSX-11M
			dev:	'SY0:'	( Selectable at compiler generation )

LM ERICSSON                             PASCAL USER MANUAL                8
                                        1979-08-30      E                       



			iospec:	(..)   the empty set
			Example: RESET(F) is equivalent to
				 RESET(F,'F',,'SY0:',(..))
 
 
		2.7.5	BREAK and PAGE
 
			The procedure PAGE( <textfile> ) inserts a form
			feed in the given file. It may be called without
			parameter in which case it is assumed to be
			the standard file OUTPUT if present in the PROGRAM
			statement, otherwise TTY if present.
 
			The procedure BREAK can be called without a parameter
			or with one textfile parameter. If no parameter is
			specified and TTY is present in the program statement,
			or if the file parameter is TTY then the current line
			buffer is written without carriage return added.
			Thereby a later input from TTY can be given on the same
			line. If the file is not TTY, break is equivalent to
			writeln.
 
 
		2.7.6	GET and PUT
 
			The standard procedures GET and PUT can take a
			second parameter of type integer. This parameter
			has effect only if RANDOM or BLOCK was specified
			when opening the file. In case of RANDOM it is
			the number of the record to be input from the
			file (GET) or written to the file (PUT). If the
			file was opened with BLOCK in ioselect one file
			element is transferred to or from the block with the
			given number. Notice that locate mode is used why it
			is necessary to locate a random record with GET before
			PUT can be used.
 
 
		2.7.7	READ and WRITE
 
			See also PUM&R for detailed explanations of the
			standard features.
 
			READ can read CHAR's from a textfile, one at a time.
			It can also read CHAR's representing integers and
			reals and convert them to binary.
 
			Textfiles opened for reading (by RESET) have an input
			line buffer. If EOLN is TRUE when a read is issued,
			a new line is requested. READ then takes characters
			from the buffer to a CHAR or an array of char, or 
			convert them to integer or real before storing the
			result.
 
			READLN without parameters or with only a file variable
			as parameter requests a new line to be read into the
			line buffer. Any remaining characters in the old line
			are lost. If READLN has other parameters (variables to
			get values) the new line is requested after the
			variables are read.
 
			READ is extended to allow direct read of an array of

LM ERICSSON                             PASCAL USER MANUAL                9
                                        1979-08-30      E                       



			characters. The array is filled from the current line
			buffer. If enough characters are not left in the buffer,
			trailing spaces are inserted.
 
			When reading integers or reals, spaces preceding the
			number are skipped. Trailing spaces are also skipped
			(but see also option H below) until eof or not space,
			but for TTY only until eoln or not space.
 
			When a file is opened with RESET its first line is
			read into the internal buffer. EOLN and EOF are set
			according to the result of this READLN operation,
			i.e. normally they are both FALSE. In order to allow
			more natural interactive program execution, TTY is
			treated differently. The TTY input buffer is initiated
			empty and no automatic read is issued. Thus a program
			gets the opportunity to present itself before any data
			has to be entered from the terminal.
 
			WRITE can write items of type boolean, char, integer,
			real, string constant and (packed) array of char. After
			each of these a field width may be given as ":value".
			For reals a second value can be specified that gives
			the number of decimals.
 
			WRITE is extended to allow printing of integers in
			octal form. This is achieved by adding :O after the
			field width, e.g. WRITE(I:4:O); .
 
			The characters resulting from WRITE operations are
			stored in an internal buffer. The line is written
			on the file when a WRITELN is issued. If many
			parameters are specified, the writing is the last
			operation that takes place. To file TTY the line is
			written as <lf><buffer><cr> . To avoid the <cr> the
			procedure BREAK can be used, see 2.7.5 above.
 
 
			The standard procedures READ and WRITE are generalized
			to allow all types of files. In this case no automatic
			conversion is invoked, but the record is stored
			directly from memory in its internal representation.
			This means that pointers in a record are invalid when
			such a record is read back from a file. Example:
				type rec = record ... end;
				var  person: rec;
				     infile,outfile: file of rec;
				...
				read(infile,person);
 
 
		2.8	Standard functions
 

LM ERICSSON                             PASCAL USER MANUAL               10
                                        1979-08-30      E                       



		2.8.1	RUNTIME
 
			The function RUNTIME returns an integer giving
			the daytime in seconds modulo 8 hours (RSX/IAS
			doesn't measure CPU time ).
 
		2.8.2	TWOPOW and SPLITREAL
 
			The function TWOPOW(<integer expression>):REAL gives
			as result the real  2**<integer expression>.
 
			The function SPLITREAL(<real expression>,
			<integer variable>):REAL returns the binary
			exponent of the real expression in the integer
			variable and gives as result a  real with binary
			exponent zero but the same mantissa as the 
			expression.
 
		2.8.3	IORESULT
 
			The function IORESULT(<file>):INTEGER returns an
			integer value telling the result of the last
			operation on the given file. Result = +1 if
			OK and <0 if error. The error codes are those
			returned from RSX/IAS. For further details see
			RSX/IAS manuals. A few error codes are added,
			see appendix F.
 
 
		2.9	Dynamic arrays as parameters
 
			The parameter mechanism in Pascal is extended to
			allow procedures that can take differently declared
			arrays as parameters. This is achieved by declaring
			the parameter as VAR <params>: ARRAY[<type>,...], e.g.
			PROCEDURE MATADD(VAR A,B,C: ARRAY[INTEGER,INTEGER]);.
			Such procedures can be called with any array with the
			right number of dimensions as actual parameter.
			The same element is selected if the same indexvalue
			is applied to the formal and to the actual array.
 
			For arrays of char another extension exist. They
			can be declared as parameter string, e.g.
				PROCEDURE PRINT(STRING S);
			Such a procedure can be called with any string constant
			or array of char as actual parameter, or even a sub-
			string of one of these. E.g.
				PRINT('HELLO');  PRINT(S[2:7]);
			In the procedure body the string can be treated as if 
			it was declared as ARRAY[0..limit] OF CHAR. The limit
			can be found at execution time by use of the new
			standard function SIZE which takes the string as
			parameter and gives an integer as result. 
			Limit = SIZE - 1.
 
 

LM ERICSSON                             PASCAL USER MANUAL               11
                                        1979-08-30      E                       



		2.10	Procedures and functions as parameters
 
			In PDP-11-Pascal it is necessary to declare
			the formal parameters of a formal procedure
			or function. At the declaration of a formal
			procedure or function no identifier is required
			for the formal parameters of it, only the
			type(s) of the argument(s) must be specified.
 
 
			The declaration of  "formal formal parameters" is
			necessary for the compiler to check the actual
			procedure- and function-parameters with respect
			to their parameters and types. This avoids a
			considerable overhead of parameter- and type-checking
			at runtime of a Pascal program.
 
 
			Example:
			PROGRAM INTEGRATION;
			FUNCTION INTEGRATE ( FUNCTION F (REAL):REAL;
				LOWBOUND, HIGHBOUND, DELTA: REAL ): REAL;
				(* BODY *) ...
			FUNCTION SINUS ( ARG: REAL ): REAL;
			  BEGIN   SINUS := SIN( ARG );
			  END;
 
			BEGIN
			  WRITELN( INTEGRATE( SINUS, 0, 3.14, 0.01 );
			END.
 
			Note that external procedures and functions not
			written in Pascal and standardprocedures and
			-functions must not be used as actual parameters
			to formal procedures or functions since they
			obey different parameter conventions.
 
 
		2.11	Separate compilation
 
			It is possible to compile  one or more procedures
			without a main program. In that case no program
			statement is allowed and the source file must
			begin with an option comment stating M-. For
			further details see paragraph 4.7 below.
 
			Data declared in the main program can be used also in
			separately compiled procedures and functions. The
			declaration of variables from the main program must
			in that case be copied to the beginning of the source
			text for the separate procedures and functions and
			before these, but after the M- option selection. That
			is most easily achieved using the include facility,
			see paragraph 4.13 .
 
			Separately compiled procedures and functions
			can be accessed if they are declared with the
			procedure body replaced by EXTERN. Fortran and
			assembler-written routines can also be accessed
			if their parameter transport follows Pascal standard
			or Fortran. In  the latter case the procedure body
			should be replaced by EXTERN( FORTRAN ). If the

LM ERICSSON                             PASCAL USER MANUAL               12
                                        1979-08-30      E                       



			external name contains '$' or '.' it can be given as
			a string constant. Example:
			EXTERN( FORTRAN, '$TEST' )
 
			In this way it is possible to access the functions of
			the executive using their FORTRAN procedures.
 
 
		3	RESTRICTIONS
			------------
 
		3.1	Reserved words
 
			The folling words are also reserved:
			LOOP	EXIT	OTHERS	EXTERN
 
 
		3.2	Packed structures
 
			Packed data structures are only implemented
			for character arrays ( always packed, two
			char's per word ) and for Boolean arrays
			( packing optional, one Boolean per bit ).
			The procedures PACK and UNPACK are not implemented.
 
 
		3.3	The PROGRAM statement
 
			A Pascal program must as a first statement have:
			PROGRAM  <name> <program parameter list>;
			The first six characters in the program name may not
			be the same as the first six of a procedure or function.
			The parameter list may be empty, or give one or
			more of INPUT, OUTPUT and TTY. When a file is mentioned
			it is equivalent with a declaration of textfiles
			with these names. For files not mentioned no space
			will be reserved. The file TTY is treated in a
			special way, and is bound to the user's terminal
			( TI: in RSX/IAS ). The initial state of TTY is
			eoln(TTY) = true and no characters automatically
			input. Examples:
				PROGRAM COPY ( INPUT, OUTPUT );
				PROGRAM DIALOG ( TTY );
				PROGRAM INTROVERT;
 
 
		3.4	GOTO statement
 
			The GOTO statement is restricted to allow
			only local GOTO's.
 
 

LM ERICSSON                             PASCAL USER MANUAL               13
                                        1979-08-30      E                       



		3.5	SET size
 
			The representation of sets is chosen so that
			a set may have at most 64 members.
 
 
		3.6	File declarations
 
			Files may be declared only in the main program.
 
		3.7	FOR statement
 
			MAXINT and MININT can not be used as limits in FOR
			loops.
 
 
		3.7	Parameter transmission
 
			Standard procedures or functions or external Fortran
			routines may not be passed as actual parameters.
 
 
		3.8	Definition level 0 and 1
 
			The compiler can be generated with a predeclaration
			level of 0, 1, 2 or 3. The level can also be chosen at
			compile time through the switch /AA:n on the object
			file specification, see point 4.15 below. Level 1 is
			exactly standard Pascal, level 0 is restricted to give
			the compiler more workspace ( no arithmetic functions).
 
 
		4	COMPILER OPTIONS AND SWITCHES
			-----------------------------
 
			When compiling a Pascal program it is possible
			to select some special features called options.
			All option switches have default values. Some
			can be changed dynamically and some may be set
			only before the first statement.
			Option switches are turned on and off  through
			comments beginning with '$' ( =chr(44B)) followed
			by one or more option selectors, separated by
			commas. Each option selector consists of one
			letter followed by '+' or '-'. Example: (*$L+,C-,M+*).
			The default values listed below may be changed at
			compiler generation time.
 
			Most option switches can also be set with switches.
			Switches override all selecting of the same option
			in the source code. The switches follow RSX/IAS standard
			but only one character is significant.
			Example: /EI/-CC/MM .
 
 

LM ERICSSON                             PASCAL USER MANUAL               14
                                        1979-08-30      E                       



		4.1	Program listing: L
 
			Listing of the source program may be
			switched on and off during compilation.
			Default: L+.
			If no listing at all is wanted, the listfile
			specification can be omitted from the command line.
			There is no corresponding switch.
 
 
 
		4.2	Listing of generated code: C
 
			With the crosscompiler on DEC 10 it is possible
			to get a listing of the generated code. The
			switch can be changed dynamically. The listing
			is done on a separate file with extension .CXP .
			On PDP-11 the only effect is to print the program
			counter (octal relative address) on each line.
			Default: C-.
 
 
		4.3	Extended instruction set, EIS: E
 
			The compiler generates MUL and DIV instructions
			if option E+ is selected, otherwise these
			operations are performed through subroutines.
			Default: E-.
 
 
		4.4	Floating instruction set, FIS: G
 
			The PDP 11/35 and 40 floating point hardware
			can be used if option G is selected.
			Default: G-.
 
 
		4.5	Floating point processor, FPP: F
 
			The floating point hardware for PDP 11 model
			45 and up can be used if option F is selected.
			Default: F-.
 
 
		4.6	Runtime checks: R and T
 
			The compiler can generate checks of dynamic 
			storage and stack allocation at procedure and
			function entry and calls of NEW. Default: T+.
 
			Checks of assignment to subrange variables and
			of array indices are not generated if option
			R- is selected. Default: R+.
 
 

LM ERICSSON                             PASCAL USER MANUAL               15
                                        1979-08-30      E                       



		4.7	Main program: M
 
			It is possible to compile a set of procedures
			and functions separately. In that case no
			PROGRAM statement and no main program may
			be given, and the source text must begin
			with an option selection of M-. The last procedure
			or function should end with a period (.) instead of
			a semicolon (;).   Default: M+.
 
 
		4.8	Conditional compilation: X and Z
 
			It is possible to write test statements which
			generate code only if option X+ is selected.
			Default: X-.
 
			The conditional parts of the code must be
			enclosed in a special option parenthesis,
			(*$Z+*) <conditionally compiled code> (*$Z-*).
 
 
		4.9	Warning suppression: W
 
			Error messages classified as warnings may be
			suppressed by selecting option W-. Warning
			error numbers are > 900.
			Default: W+.
 
 
		4.10	Object module splitting: Y
 
			The generated object code can be splitted
			into several object modules (in one file)
			through insertion of option Y+ in the source text.
			All procedure bodies whose compilation start with
			Y+ in effect will become separate object modules in
			the object file. This option is implemented to allow
			the compiler to be overlaid in PDP 11. It can be
			used to create overlaid tasks from any Pascal program.
			Default: Y-.
 
 
		4.11	Object module version: V
 
			The object modules that are generated can get a version
			information, which the linker will print on the map.
			The version identifier consists of up to six alfanumeric
			characters after V+. Example: (*$V+PAS500*).
			There is no /V switch in the command line.
 
 

LM ERICSSON                             PASCAL USER MANUAL               16
                                        1979-08-30      E                       



		4.12	Frequence measurement: Q
 
			It is possible to get the compiler to insert
			instructions in the generated code that count the
			number of times the code is executed. The measuring
			points are inserted before the first beginning of a
			statement in each line of the source code.
			Example, (**) = measuring point:
				(**)	for i:=1 to 5 do
				(**)	a(.i.):=0;
				(**)	if i=3
					then	(**)	x:=2.0
					else	(**)	x:=0.0;
 
			This option must be selected before the program 
			statement, but may be switched on and off after the
			program statement.
 
			After execution of a program compiled with Q+ or /Q
			a file of name <source file name>.FQV is produced.
			It contains the measuring information in a form ready
			for printing ( i.e. PIP EX.FQV/SP ).
 
			If R- is selected only the beginnings of procedures
			and functions are measured, and if both R- and T-
			are in effect no measuring at all is performed.
 
 
		4.13	Include source file: I
 
			The compiler can include library source files in
			the compiled source. This is especially important when
			declaring global types and variables to separately
			compiled procedures. The included source may include a
			new source file to a nesting depth of three. A complete
			file specification including device and directory can be
			given after I+ . Defaults are SY0: and extension .PAS .
			Example:  (*$I+DK1:DATA.PAS*)
 
 
		4.14	Error handling and conversion selection: H
 
			When a Pascal program is executed certain errors can
			occur, i.e. index out of bounds. See appendix F for
			a complete list. They are grouped into three categories:
			messages, warnings and fatal errors. Message and
			warning printouts can be suppressed, and it is
			possible to continue execution after warnings and even
			after errors. It is also possible to chose to skip
			spaces after reading integers and reals and not only
			before. The choices are made through an integer
			following H+. The value is the sum of any of the
			following selections:
 
			Value	Meaning
			  1	print warnings
			  2	continue after warning
			  4	continue after fatal error
			  8	print messages
			 16	skip spaces after read integer/real
 
			Example:   (*$H+17*).

LM ERICSSON                             PASCAL USER MANUAL               17
                                        1979-08-30      E                       



			Default  19 = print warnings, continue after warnings
			and skip spaces. H is not selectable through a
			command line switch.
 
		4.15	Predeclaration level: A
 
			The compiler always has some names predeclared, i.e.
			INTEGER, WRITE etc. All names occupy data space when
			the compiler is run. For large programs, and for
			compatibility reasons it can be of interrest to reduce
			the number of predeclared types, functions etc. to
			a minimum or to standard Pascal. The predeclaration
			level is selected at compiler generation time, but can
			be reset for a single compilation through the switch /A
			followed by an unsigned integer. Examples: /AA:1, /A0 .
 
			Level	Restriction (-) or extension (+)
			  0	- arithmetic functions ( sin, cos etc. )
			  1	standard Pascal
			  2	+ maxint,minint,maxreal,minreal,smallreal
				+ text,ascii,byte
			  3	+ ( 2 ),   + iospec
 
 
		4.16	Page eject: P
 
			There are two ways to force the compiler to start on a
			new page after the current line. The character form
			feed and the option P+ both give this effect. P+ is
			reset afterwards.
 
 
		4.17	Page width: P
 
			It is possible to select the maximum number of lines
			printed per page through a switch on the list file
			specification. Normally a suitable page width is
			selected at compiler generation time 
			( A4 = 55, A4L = 35, ... ).
			Example:  /PW:50, /P29
 
 
		4.18	Line width: L
 
			The maximum number of characters printed per line is
			selectable in the same way as the page width. The line
			splitting can occur in the middle of a Pascal symbol.
			Example:  /LW:72, /L132.
 
 
		4.19	Spool listfile: U
 
			The listfile is normally spooled. It is retained if
			the switch /-U is given on the listfile specification.
 

LM ERICSSON                             PASCAL USER MANUAL               18
                                        1979-08-30      E                       



		4.20	Debug: D
 
			A symbolic interactive debugger can be included in a
			task. The program has to be compiled with option D+.
			The debug switch can be switch on and off in the
			program if only the program statement is compiled with
			D+ in effect. It is described in a separate document,
			DEBUG.MAN .
 
 
		4.21	Trace: S
 
			A trace of which source code lines are executed can
			be obtained on the TI: terminal. Each time the first
			statement on a new line is entered, the number of the
			line is printed on TI: . It is possible to set the 
			trace switch for any code areas wanted. Default: S-.
 
 
		5	REPRESENTATION
			--------------
 
		5.1	Scalars
 
			Integers, booleans and characters occupy one
			word each. Reals occupy two words with one
			sign bit, one exponent sign bit, seven exponent 
			bits and a mantissa of 23 bits plus one bit hidden.
			Sets of up to 16 members occupy one word and
			sets of up to 64 members occupy four words.
 
 
		5.2	Files
 
			See also RSX/IAS I/O Operations Reference Manual.
			Files are represented as fixlength record files
			except textfiles which have variable length
			records, one line per record. They are used
			in locate mode. File description blocks are
			allocated in the stack and a file declaration
			thus reserves 108 bytes plus the size of one
			record of the file. For textfiles the maximum
			line length is 132 characters for which a
			buffer is reserved.
 
 
		5.3	Stack and heap
 
			The stack and heap are given a contiguous area
			in which the stack grows from one end and the
			heap from the other. This area can be extended
			through a command to the Linker, See 1.2.
			It is a psection named 999999 and which is thus
			normally allocated at the end of the task image.
			Runtime errors will occur if it is not placed there.
 
 

LM ERICSSON                             PASCAL USER MANUAL               19
                                        1979-08-30      E                       



		5.4	Parameter transmission
 
			A Pascal program has a special stack for allocation
			of data, and for parameter transmission.
			The Pascal stack is reached through register R5.
			The first parameter is pushed first, and on the top
			a special link is pushed. This link is of no value
			in assembler routines. Thus, when entering a procedure
			the stack contains:
				R5+...:	1st parameter
				R5+...:	2nd parameter
				...
				R5+2:	last parameter
				R5:	link
			Each parameter occupies an area large enough to hold
			its value, n.b. that arrays and records are copied to
			the stack. However, parameters declared with the VAR
			attribute occupy only one word each, which then is the
			address to the actual parameter. For arrays the address
			given is the address to an imagined zeroth element of
			the array. Thus  VAR S: ARRAY(.1..80.)  used as actual
			parameter for a formal declared as VAR gives an odd
			address that points to the byte before S(.1.), because
			the allocation is always done on word boundaries.
 
			The link and the parameters must all be removed from
			the stack before return (RTS PC). For functions an area
			for the result is reserved in the stack before the
			parameters are pushed. At return R5 must point to this
			area.
 
			Example:  an assembler routine, declared in a Pascal
			program as:
				function A( I,J: integer ): integer;
					extern;
			will receive a stack as follows:
				R5+6:	reserved for result 
				R5+4:	value I (first parameter)
				R5+2:	value J ( last parameter)
				R5:	link
			At return by RTS PC the stack pointer R5 must point to
			the result word.

LM ERICSSON                             PASCAL USER MANUAL               20
                                        1979-08-30      E                       



 
			APPENDICES
			==========
 
		A	Character set
 
			The Pascal character set ( type char ) is 
			encircled in the following table. The compiler
			ignores all characters below SP except HT, which
			is transformed to SP, and FF, which gives new page.
			The compiler allows lower case characters, but
			translates them to upper case except in strings.
 
			Characters are checked to be in the right
			interval in a user program if the option
			R+ is selected, see 4.6. The type ASCII can be
			used to allow all characters in the table, and
			the type BYTE allows all characters 0 - 255 (377B).
 
				    0	1   2	3   4	5   6	7
 
				00  NUL SOH STX ETX EOT ENQ ACK BEL
				01  BS  HT  LF  VT  FF  CR  SO  SI
				02  DLE DC1 DC2 DC3 DC4 NAK SYN ETB
				03  CAN EM  SUB ESC FS  GS  RS  US
			   --------------------------------------------
			   I    04  SP  !   "   #   $   %   &   '     I
			   I    05  (   )   *   +   ,   -   .   /     I
			   I    06  0   1   2   3   4   5   6   7     I
			   I    07  8   9   :   ;   <   =   >   ?     I
			   I    10  @   A   B   C   D   E   F   G     I
			   I    11  H   I   J   K   L   M   N   O     I
			   I    12  P   Q   R   S   T   U   V   W     I
			   I    13  X   Y   Z   [   \   ]   ^   _     I
			   --------------------------------------------
			        14  `   a   b   c   d   e   f   g    
			        15  h   i   j   k   l   m   n   o    
			        16  p   q   r   s   t   u   v   w    
			        17  x   y   z   {   |   }   ~   DEL 
 
			Only A..Z are considered as letters by the
			compiler. For pointers the character
			^ is used.
 
			Because curly brackets are not of type CHAR, they
			are not allowed as comment delimiters. Comments may be
			enclosed in %comment\(backslash) as well as (* *).
 

LM ERICSSON                             PASCAL USER MANUAL               21
                                        1979-08-30      E                       



 
 
		B	Special symbols
 
			Table of special symbols with their meaning.
 
			Stand-	Altern-	Meaning
			ard	ative
 
			:=		assignment
			+		with one operand: identity
			-		with one operand: negation
			+		with two operands: addition
			-		with two operands: subtraction
			*		multiplication
			/		real division
			div		integer division
			mod		remainder
			=		equal
			<>	#	not equal
			<		less
			>		greater
			<=		less or eqaul
					set inclusion
			>=		greater or equal
			in		set membership
			not		negation
			or	+  !	disjunction
			and	&	conjunction
			or	!	set union
			-		set difference
			and	*  &	set intersection
			(*	%	start of comment
			*)	\	end of comment
			.		decimal point
					end of program
			..		subrange constructor
			,		comma
			:		colon
			;		statement separator
			'		string delimiter
			(		left parenthesis
			)		right parenthesis
			[	(.	left bracket
					set constructor
			]	.)	right bracket
					set constructor
			^		pointer constructor
			$		option constructor

LM ERICSSON                             PASCAL USER MANUAL               22
                                        1979-08-30      E                       



 
 
		C	Reserved words
 
 
			The following words are reserved:
 
			if	do	of	to	in
			or	end	for	var	div
			mod	set	and	not	then
			else	with	goto	loop	case
			type	file	exit	begin	until
			while	array	label	const	others
			repeat	record	downto	packed	extern
			forward	function	procedure

LM ERICSSON                             PASCAL USER MANUAL               23
                                        1979-08-30      E                       



 
 
		D	Standard procedures
 
			This is only a list of standard procedures,
			with an indication of parameter types.
 
			Input/output:
 
			  RESET(FILE, STRING, STRING, STRING, SET)
			  REWRITE(FILE, STRING, STRING, STRING, SET)
			  GET(FILE)
			  GET(FILE,INTEGER)
			  PUT(FILE)
			  PUT(FILE,INTEGER)
			  PAGE(FILE)
			  READ(FILE,INTEGER or REAL or CHAR or STRING, ... )
			  READLN(FILE,INTEGER or REAL or CHAR or STRING, ... )
			  WRITE(FILE,INTEGER or REAL or CHAR 
						or BOOLEAN or STRING, ... )
			  WRITELN(FILE,INTEGER or REAL or CHAR 
						or BOOLEAN or STRING, ... )
			  BREAK
 
			Execution control:
 
			  HALT
 
			Administration of dynamic storage:
 
			  NEW(POINTER,variant selector, ... )
			  MARK
			  RELEASE
 
			Miscellaneous:
 
			  DATE(STRING)		( array (.1..10.) of char )
			  TIME(STRING)		( array (.1..10.) of char )

LM ERICSSON                             PASCAL USER MANUAL               24
                                        1979-08-30      E                       



 
 
		E	Standard functions
 
			This is a list of standard functions with an
			indication of parameter types.
 
			Mathematical functions:
 
			  ABS(INTEGER or REAL):INTEGER or REAL
			  COS(INTEGER or REAL):REAL
			  EXP(INTEGER or REAL):REAL
			  LN(INTEGER or REAL):REAL
			  SIN(INTEGER or REAL):REAL
			  SQR(INTEGER or REAL):INTEGER or REAL
			  SQRT(INTEGER or REAL):REAL
 
			Conversion routines:
 
			  ROUND(REAL):INTEGER
			  TRUNC(REAL):INTEGER
			  CHR(INTEGER):CHAR
			  ORD(any scalar except REAL):INTEGER
 
			Miscellaneous:
 
			  ODD(INTEGER):BOOLEAN
			  EOF(FILE):BOOLEAN
			  EOLN(FILE):BOOLEAN
			  PRED(any scalar except REAL):same as argument
			  SUCC(any scalar except REAL):same as argument
			  RUNTIME:INTEGER
			  SPLITREAL(REAL,INTEGER):REAL
			  TWOPOW(INTEGER):REAL
			  SIZE(STRING-PARAMETER):INTEGER

LM ERICSSON                             PASCAL USER MANUAL               25
                                        1979-08-30      E                       



 
 
		F	Error codes
 
 
		F.1	Compiletime errors
			 
			 1	error in simple type
			 2	identifier expected
			 3	error in value part
			 4	')' expected
			 5	':' expected
			 6	illegal symbol
			 7	error in parameterlist
			 8	'of' expected
			 9	'(' expected
			 
			10	error in type
			11	'[' expected
			12	']' expected
			13	'end' expected
			14	';' expected
			15	integer expected
			16	'=' expected
			17	'begin' expected
			18	error in declaration part
			19	error in fieldlist
 
			20	',' expected
			21	constant expected
			22	'program' expected
			23	standard files only 'input', 'output', 'tty'
 
			50	error in constant
			51	':=' expected
			52	'then' expected
			53	'until' expected
			54	'do' expected
			55	'to'/'downto' expected
			56	'if' expected
			57	'exit' expected
			58	error in factor
			59	error in variable
 
			101	identifier declared twice
			102	low bound must not be greater than high round
			103	identifier is not of appropriate class
			104	identifier not declared
			105	sign not allowed
			106	number expected
			107	incompatible subrange type
			108	file not allowed here
			109	type must not be real
			110	tagfield must be scalar or subrange
			111	incompatible with tagfieldtype
			112	index type must not be real
			113	index type must be scalar or subrange
			114	base type must not be real
			115	base type must be scalar or subrange
			116	error in type of standard procedure parameter
			117	unsatisfied forward reference
			118	forward referenced type identifier in variable

LM ERICSSON                             PASCAL USER MANUAL               26
                                        1979-08-30      E                       



				declaration
			119	forward declared: repetition of parameterlist
				not allowed
 
			120	function result type must not be files
			121	file value parameter not allowed
			122	forward declared function:
				repetition of result type not allowed
			123	missing result type in function declaration
			124	fixed format for real only
			125	error in type of standard function parameter
			126	number of parameters does not agree with
				declaration
			127	illegal parameter substitution
			128	result type of parameter function does not
				agree with declaration
			129	type conflict of operands
 
			130	expression is not of set type
			131	tests on equality allowed only
			132	strict inclusion not allowed
			133	file comparison not allowed
			134	illegal type of operand(s)
			135	type of operand must be boolean
			136	set element type must be scalar or subrange
			137	set element types not compatible
			138	type of variable is not array
			139	index type is not compatible with declaration
 
			140	type of variable is not record
			141	type of variable must be file or pointer
			142	illegal parameter substitution
			143	illegal type of loop control variable
			144	illegal type of expression
			145	type conflict
			146	assignment of files not allowed
			147	label type incompatible with selecting 
				expression
			148	subrange bounds must be scalar
			149	index type must not be integer
 
			150	assignment to standard function not allowed
			151	assignment to formal function is not allowed
			152	no such field in this record
			153	type error in read
			154	actual parameter must be a variable
			155	control variable must not be formal
			156	multidefined case label
			157	too many cases in case statement
			158	missing corresponding variant declaration
			159	real and string tagfields not implemented
 
			160	previous declaration was not forward
			161	again forward declared
			162	slice variant separator is colon
			163	missing variant in declaration
			164	missing slice variant in declaration
			165	multidefined label
			166	multideclared label
			167	undeclared label
			168	undefined label
			169	error in tagfield

LM ERICSSON                             PASCAL USER MANUAL               27
                                        1979-08-30      E                       



 
			170	variant must have the same type as tagfield
 
			180	standard file not in program statement
			181	'input', 'output' or 'tty' missing in program
				statement
			182	parameters to extern FORTRAN procedures must
				be declared as VAR parameters. This applies to
				the preceding procedure.
			183	body not allowed when not main
			184	assignment to function only in its body
 
			201	error in real constant: digit expected
			202	string constant contains 'eol'
			203	integer constant exceeds range
			204	8 or 9 in octal number
			205	real constant exceeds range
			206	octal output format for integers only
 
			250	too many nested scopes of identifiers
			251	too many nested procedures and/or functions
			253	too much code produced
			254	too many string/set/real constants in this
				procedure
			255	too many errors in this source line
 
			399	not implemented
 
			400	compiler error
			600	indextype of boundless array must be of scalar
				type (but not of type real)
			601	colon in parameterlist must be followed by
				identifier or arraysymbol
			602	boundless arrays must be var specified
			603	standard functions/procedures are not allowed as
				actual procedure parameters
			604	ordinal numbers of setelements must lie in the
				range 0..63, or ' '..'_' for characters
			605	the setvariables in an expression do not have
				the same base type
			606	base types of sets are incompatible
			607	colon is missing in the specification of
				parameters of a formal procedure/function
				(warning only)
			608	error in parameterspecification
			609	fortran routines are not allowed as actual
				procedure parameters
 
			610	integer constants required as actual parameters
			612	parameterlist structure of formal and actual
				procedure are not the same
 
			613-616	errors when using string parameters
			613,614	indextype of string parameter not compatible
				with declaration
			615	substrings can only be taken from char arrays,
				string constants or string parameters
			616	(error)
			617	actual parameter is not of string parameter
				type
			626	parameter to size must be of string parameter
				type

LM ERICSSON                             PASCAL USER MANUAL               28
                                        1979-08-30      E                       



 
 
			900-999	warnings only
 
			900	undeclared label
			901	unused declared label
			902	undefined option switch
 
			920	program statement missing ('input' and 'output'
				assumed)
 
			930	OUTPUT must be present to allow frequence
				measurement
			931	too many procedures with the first 6 characters
				in their names equal
 
			940	source code "include" nesting > 3 not allowed

LM ERICSSON                             PASCAL USER MANUAL               29
                                        1979-08-30      E                       



 
 
		F.2	Runtime errors
 
			Runtime error messages are written on the terminal,
			and appear in the form
 
				PASRUN -- ERROR  nn mmmmm vvvvv
 
			where	nn = error number, see list below
				mmmmm = line number where error occured.
					The line number is not correct if
					the error appears in a part of the
					program where the runtime check option
					R is switched off (R-).
				vvvvv = offending value ( error 12 only ).
 
			It is possible to redefine the error handling at
			compiler generation time, or in the source code
			through the option H. Normal actions are listed.
			There are three classes of errors:
 
			F:	Fatal errors.
				Continuation of the program is normally not
				possible or useful, and the program is
				therefore terminated.
 
			W:	Warnings.
				After having printed the error message, the
				program will continue execution.
				See the comments.
 
			M:	Messages.
				Convertion errors are normally only signalled
				through IORESULT, but messages can be printed.
				Execution continues afterwards.
 
 
				RUNTIME ERROR SUMMARY
				---------------------
 
			Number	Kind of operation	Comments
			------	-----------------	--------
			    Class
			    -----
 
			10  F	Procedure entry or	Stack overruns heap
				dynamic allocation	or heap overruns stack
							Too much code + data,
							or error(s) in program
							(40 words left)
 
			11  F	Same as 10		Hardware stack overflow
							(10 words left)
 
			12  F	Assignment or		Subrange overflow
				indexing in array	Index out of bounds
 
			20  F	Integer division	An attempt was made
				or modulo		to divide by 0
 
			21  F	Integer division	Divisor was -32768

LM ERICSSON                             PASCAL USER MANUAL               30
                                        1979-08-30      E                       



				or modulo		(most negative number)
 
			23  F	Integer multiplication	First operand = -32768
 
			30  W	All real operations	Exponent overflow
							MAXREAL assumed
 
			31  W	All real operations	Exponent overflow
							Floating zero taken
 
			33  F	Trunc or round		Floating number too
							large
 
			34  F	Real division		Attempt to divide by 0
 
			40  M	Read integer		No digits after sign,
							zero taken
 
			41  M	Read integer		Number too large,
							77777B taken
 
			42  M	Read real or integer	Too many digits
 
			44  M	Read real		No char's read,
							floating zero taken
 
			50  W	Exponentiation		Exponent overflow
							MAXREAL taken
 
			60  F	Substring parameter	Substring range
							out of bounds
 
			61  F	Indexing in substring	Index out of bounds
 
			66  F	Read or get		Attempt to read beyond
							end of file
 
 
		F.3	Result codes after I/O operations
 
			The result codes received by IORESULT are the 
			RSX/IAS codes. Six new codes are added:
 
			-101	too many files (RESET/REWRITE)
			-102	file not opened (GET/PUT)
			-103	too many digits (read integer or real exponent,
				MAXINT taken)
			-104	no digits read (read integer or real exponent,
				zero taken)
			-105	integer overflow (read integer: MAXINT taken,
				read exponent: MAXREAL taken)
			-106	no digits read and "." or "E" not found
				(read real, 0.0 taken)

LM ERICSSON                             PASCAL USER MANUAL               31
                                        1979-08-30      E                       



 
 
		G	Options and switches
 
 
			All default values can be changed at compiler generation.
			The values listed are from the distribution set.
 
 
			Name	Default	Option/switch used for
 
			A	3	Predeclaration level (switch only)
			B
			C	-	Printing of octal relative addresses
			D	-	Debug ( not implemented yet )
			E	-	EIS
			F	-	FPP
			G	-	FIS
			H	19	Runtime error handling (option only)
			I		Include library source file
			J
			K
			L	+	Listing on/off (option only)
				80	Line width ( switch only )
			M	+	Main program
			N
			O
			P	-	Page eject ( option only )
				55	Page width ( switch only )
			Q	-	Frequence measurements
			R	+	Runtime checks of indexbounds etc.
			S	-	Trace
			T	+	Runtime checks if stack/heap overflow
			U	+	Spool listfile ( switch only )
			V		Object module version
			W	+	Print compiler warning messages
			X	+	Conditional compilation
			Y	-	Object module splitting
			Z		Conditional compilation
 

LM ERICSSON                             PASCAL USER MANUAL               32
                                        1979-08-30      E                       



 
 
 
 
		H	ADDITIONAL PROCEDURES AND FUNCTIONS
 
 
			The following procedures and functions are
			available in SYSLIB resp PASLIB and can be used
			if declared as:
 
			procedure GCML ( var s: line; var len: integer );
			  extern;
			  (* type line = array (.1..80.) of char .
			     Returns the MCR command line in s and its
			     length in len. *)
 
			procedure closef ( var f: <filetype> );   extern;
			  (* closes the external file associated with
			     the file parameter *)
 
			procedure attach ( var f: <filetype> );   extern;
			  (* issues a QIO with IO.ATT to the file *)
 
			procedure detach ( var f: <filetype> );   extern;
			  (* issues a QIO with IO.DET to the file *)
