{$U+}
PROGRAM MODIFY;
{************************************************
*						*
*						*
*   TRW SIGNAL PROCESSING FACILITY		*
*						*
*   MULTIPLE MINICOMPUTER ARCHITECTURE		*
*   IR&D PROJECT				*
*						*
*   PROGRAMMED BY:				*
*	DENNIS HEIMBIGNER VX1A 7/25/77		*
*						*
*   PROJECT MANAGER: ROGER A. VOSSLER		*
*						*
*   MODIFIED FOR NBS PASCAL BY:			*
*	BILL HEIDEBRECHT	24 NOV 78	*
*	TRW DSSG				*
*	90 / 2824				*
*	ONE SPACE PARK				*
*	REDONDO BEACH, CA 90278			*
*						*
*   RSX-11 USAGE:				*
*	MODIFY -option source update destin	*
*	where option = 'C' (default) or 'L'	*
*						*
*						*
************************************************}
 
CONST
  NUL = CHR(0); NL = CHR(10);
  LINELENGTH = 132;
  IDLENGTH = 12;
TYPE
  LINE = ARRAY [1..LINELENGTH] OF CHAR;
  IDENTIFIER = ARRAY [1..IDLENGTH] OF CHAR;
 
 
 
CONST
 
  DEFAULT_PREFIX='*';
 
  DECK_MAX=100;
  MAX_PACK=127; {MUST BE LESS OR EQUAL TO ORD(MAX_CHARACTER)}
 
  ACTIVE = 1;
  INACTIVE = 0;
 
  BLANKS   = IDENTIFIER
    (' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ');
  C_DELETE = IDENTIFIER
    ('D','E','L','E','T','E',' ',' ',' ',' ',' ',' ');
  C_INSERT = IDENTIFIER
    ('I','N','S','E','R','T',' ',' ',' ',' ',' ',' ');
  C_DECK   = IDENTIFIER
    ('D','E','C','K',' ',' ',' ',' ',' ',' ',' ',' ');
  C_IDENT  = IDENTIFIER
    ('I','D','E','N','T',' ',' ',' ',' ',' ',' ',' ');
  C_RESTORE= IDENTIFIER
    ('R','E','S','T','O','R','E',' ',' ',' ',' ',' ');
  C_MODNAME= IDENTIFIER
    ('M','O','D','N','A','M','E',' ',' ',' ',' ',' ');
  C_CREATE = IDENTIFIER
    ('C','R','E','A','T','E',' ',' ',' ',' ',' ',' ');
  C_WIDTH  = IDENTIFIER
    ('W','I','D','T','H',' ',' ',' ',' ',' ',' ',' ');
  C_PREFIX = IDENTIFIER
    ('P','R','E','F','I','X',' ',' ',' ',' ',' ',' ');
  C_YANK   = IDENTIFIER
    ('Y','A','N','K',' ',' ',' ',' ',' ',' ',' ',' ');
  C_UNYANK = IDENTIFIER
    ('U','N','Y','A','N','K',' ',' ',' ',' ',' ',' ');
 
TYPE
 
  DIRECTIVE_KIND=(
                  INSERT,
                  DELETE,
                  RESTORE,
                  IDENT,
                  DECK,
                  MODNAME,
                  YANK,
                  UNYANK,
                  CREATE,
                  WIDTH,
                  PREFIX,
                  COMMENT
                 );
 
  DECK_ENTRY=RECORD
               DECK_NAME: IDENTIFIER;
               MAX_LINE_NUMBER: INTEGER;
               LINE_NUMBER: INTEGER
             END;
 
 
VAR
 
  OK, END_OF_FILE, UPDATE_EOF: BOOLEAN;
  COMPILE: BOOLEAN;
  CURRENT_PREFIX: CHAR;
  VERSION: INTEGER;
 
  DECK_TABLE: ARRAY[1..DECK_MAX] OF DECK_ENTRY;
  DECK_TOP: INTEGER;
 
  INSERTING, SWITCHED: BOOLEAN;
  CREATE_ACTIVE,IDENT_ACTIVE,DECK_ACTIVE: BOOLEAN;
  CURRENT_IDENT_INDEX,CURRENT_DECK_INDEX: INTEGER;
  UPDATE_LINE_LENGTH: INTEGER;
  UPDATE_LINE: LINE;
 
  SOURCE_DECK_INDEX,
  SOURCE_STATE: INTEGER;
   
  SOURCE_PACK_STATE,
  SOURCE_PACK_COUNT,
  SINK_PACK_STATE,
  SINK_PACK_COUNT: INTEGER;
 
  SOURCE_LINE_COUNT,SINK_LINE_COUNT: INTEGER;
  ACTIVE_LINE_COUNT: INTEGER;
 
{ FILES USED BY MODIFY: }
{***********************}
 
  IN_FILE, OUT_FILE,
  SOURCE_FILE, SINK_FILE:           TEXT;
 
 
 
 
PROCEDURE COM_ERROR;
VAR I: INTEGER; C: CHAR;
BEGIN
  OK := FALSE;
  WRITELN(OUTPUT, '*** Modify error ***');  BREAK(OUTPUT);
  WRITE  (OUT_FILE, 'IDENT: ', DECK_TABLE[CURRENT_IDENT_INDEX].DECK_NAME);
  WRITELN(OUT_FILE, ' DECK: ', DECK_TABLE[CURRENT_DECK_INDEX].DECK_NAME);
  I := 0;
  REPEAT
    I := I + 1;
    C := UPDATE_LINE[I];
    WRITE(OUT_FILE, C)
  UNTIL (C=NUL) OR (C=NL) OR (I=LINELENGTH);
  WRITELN(OUT_FILE, ' ')
END {COM_ERROR};
 
 
PROCEDURE HELP;
BEGIN
  IF OK THEN
  BEGIN
    WRITELN(OUTPUT, '*** Try again:');
    WRITELN(OUTPUT, '  MOD -option source update destination');
    WRITELN(OUTPUT, '  where option = C (default) or L');
    OK:= FALSE
  END
END {HELP};
 
 
PROCEDURE GETLINE;
{ GET THE NEXT LINE FROM EITHER THE
  SOURCE FILE OR THE UPDATE FILE. }
VAR C: CHAR;
BEGIN
  UPDATE_LINE_LENGTH:=0;
  IF EOF(IN_FILE) THEN UPDATE_EOF := TRUE
  ELSE BEGIN
    REPEAT
      C := IN_FILE@; GET(IN_FILE);
      UPDATE_LINE_LENGTH:=UPDATE_LINE_LENGTH+1;
      UPDATE_LINE[UPDATE_LINE_LENGTH]:=C;
    UNTIL (C = NL) OR EOF(IN_FILE);
    UPDATE_LINE_LENGTH:=1;
  END
END {GETLINE};
 
PROCEDURE BACKUP;
BEGIN
  UPDATE_LINE_LENGTH:=UPDATE_LINE_LENGTH-1
END {BACKUP};
 
PROCEDURE GETCHR(VAR C: CHAR);
BEGIN
  C:=UPDATE_LINE[UPDATE_LINE_LENGTH];
  UPDATE_LINE_LENGTH:=UPDATE_LINE_LENGTH+1;
END {GETCHR};
 
PROCEDURE SKIP;
VAR C: CHAR;
BEGIN
  REPEAT
    GETCHR(C)
  UNTIL (C<>' ') AND (C<>',');
  BACKUP;
END {SKIP}; 
 
FUNCTION DIGIT (CH: CHAR): BOOLEAN;
BEGIN
  DIGIT := (CH >= '0') AND (CH <= '9')
END {DIGIT};
 
FUNCTION LETTER (CH: CHAR): BOOLEAN;
BEGIN
  LETTER := ((CH >= 'A') AND (CH <= 'Z'))
         OR ((CH >= 'a') AND (CH <= 'z'))
END {LETTER};
 
 
PROCEDURE GETINT(VAR I: INTEGER; VAR NONE: BOOLEAN);
VAR C: CHAR;
BEGIN
  GETCHR(C);
  NONE := NOT DIGIT(C);
  IF NOT NONE THEN
  BEGIN
    I:= 0;
    REPEAT
      I:= 10*I + (ORD(C) - ORD('0'));
      GETCHR(C);
    UNTIL NOT DIGIT(C)
  END;
  BACKUP;
END {GETINT};
 
 
PROCEDURE GETID(VAR NAME: IDENTIFIER; VAR NONE: BOOLEAN);
VAR I: INTEGER;
    C: CHAR;
BEGIN
  NAME := BLANKS;
  I:=0; GETCHR(C);
  IF LETTER(C) THEN
  REPEAT
    I:=I+1;
    IF I <= IDLENGTH THEN NAME[I]:=C;
    GETCHR(C);
  UNTIL NOT (LETTER(C) OR DIGIT(C));
  BACKUP;
  NONE:=(I=0);
END {GETID}; 
 
PROCEDURE GETLINESPEC(VAR INDEX,LINENO: INTEGER; VAR NONE: BOOLEAN);
VAR NAME: IDENTIFIER; C: CHAR;
    NO_NAME,NO_NUMBER,FOUND: BOOLEAN;
BEGIN
  NONE:=FALSE; SKIP; GETID(NAME,NO_NAME);
  IF NOT NO_NAME THEN
  BEGIN
    GETCHR(C);
    IF C <> '.' THEN
    BEGIN
      WRITELN(OUT_FILE, 'MALFORMED LINE SPECIFICATION');
      COM_ERROR
    END
  END;
  IF OK THEN
  BEGIN
    GETINT(LINENO,NO_NUMBER);
    IF NO_NAME THEN
      IF NO_NUMBER THEN NONE:=TRUE ELSE
        IF DECK_ACTIVE THEN INDEX:=CURRENT_DECK_INDEX
        ELSE BEGIN
	  WRITELN(OUT_FILE, 'NO ACTIVE DECK');
	  COM_ERROR
	END
    ELSE IF NO_NUMBER THEN
    BEGIN
      WRITELN(OUT_FILE, 'MISSING LINE NUMBER');
      COM_ERROR
    END
    ELSE BEGIN
      INDEX:=1; FOUND:=FALSE;
      WHILE NOT FOUND AND (INDEX<=DECK_TOP) DO
        IF DECK_TABLE[INDEX].DECK_NAME=NAME THEN FOUND:=TRUE
        ELSE INDEX:=INDEX+1;
      IF NOT FOUND THEN
      BEGIN
	WRITELN(OUT_FILE, 'UNKNOWN DECK NAME');
	COM_ERROR
      END;
    END;
  END;
END {GETLINESPEC}; 
 
 
PROCEDURE INIT_PASS1;
BEGIN
  IF ARGV[2]@[0] = NUL THEN HELP
    ELSE RESET (IN_FILE, ARGV[2]@);	{ PASS1 READS SOURCE FILE }
  REWRITE(SINK_FILE, "MTEMP1.TMP");
  UPDATE_EOF := FALSE;
  CURRENT_IDENT_INDEX:=1;
  CURRENT_DECK_INDEX:=1;
  WITH DECK_TABLE[CURRENT_IDENT_INDEX] DO
  BEGIN
    DECK_NAME:= BLANKS; {UNTIL CREATE FILLS IN}
    MAX_LINE_NUMBER:=0;
    LINE_NUMBER:=-1;
  END;
  SOURCE_DECK_INDEX:=1;
  SINK_PACK_COUNT:=0;
  SINK_PACK_STATE:=INACTIVE; {OF COURSE LINE 0 IS INACTIVE}
  DECK_TOP:=1;
END {INIT_PASS1};
 
PROCEDURE INIT_PASS2;
BEGIN
  IF ARGV[3]@[0] = NUL THEN HELP
    ELSE RESET (IN_FILE, ARGV[3]@);	{ PASS2 READS UPDATE FILE }
  UPDATE_EOF := FALSE;
  CURRENT_PREFIX:=DEFAULT_PREFIX;
  VERSION:=0;
  CREATE_ACTIVE:=FALSE;
  IDENT_ACTIVE:=FALSE;
  DECK_ACTIVE:=FALSE;
  END_OF_FILE:=FALSE;
END {INIT_PASS2};
 
PROCEDURE INIT_PASS3;
BEGIN
  RESET (IN_FILE, ARGV[2]@);		{ PASS3 READS SOURCE FILE AGAIN }
  UPDATE_EOF := FALSE
END {INIT_PASS3};
 
PROCEDURE CHECK_PASS1_IO;
BEGIN
END;
 
PROCEDURE CHECK_SOURCE_AND_SINK;
BEGIN
  END_OF_FILE:=FALSE;
END;
 
PROCEDURE CHECK_PASS2_IO;
VAR C: CHAR;
BEGIN
  IF NOT UPDATE_EOF THEN
    REPEAT
      GET(IN_FILE)
    UNTIL EOF(IN_FILE);
END {CHECK_PASS2_IO}; 
 
PROCEDURE CHECK_PASS3_IO;
BEGIN
END;
 
 
PROCEDURE SWITCH_SOURCE_AND_SINK;
VAR T: INTEGER;
BEGIN
  IF SWITCHED THEN
  BEGIN
    SWITCHED := FALSE;
    BREAK  (SINK_FILE);
    REWRITE(SINK_FILE,   "MTEMP1.TMP");
    RESET  (SOURCE_FILE, "MTEMP2.TMP")
  END
  ELSE BEGIN
    SWITCHED := TRUE;
    BREAK  (SINK_FILE);
    REWRITE(SINK_FILE,   "MTEMP2.TMP");
    RESET  (SOURCE_FILE, "MTEMP1.TMP")
  END;
  SOURCE_LINE_COUNT:=SINK_LINE_COUNT;
  SINK_LINE_COUNT:=0;
  ACTIVE_LINE_COUNT:=0;
  SOURCE_PACK_COUNT:=0;
  SINK_PACK_COUNT:=0;
  SINK_PACK_STATE:=ACTIVE;
  FOR T:=1 TO DECK_TOP DO
    DECK_TABLE[T].LINE_NUMBER:=-1;
END {SWITCH_SOURCE_AND_SINK};
 
PROCEDURE SOURCECHR(VAR C: CHAR);
BEGIN
  C := SOURCE_FILE@;
  GET(SOURCE_FILE)
END {SOURCECHR};
 
PROCEDURE SINKCHR(C: CHAR);
BEGIN
  SINK_FILE@ := C;
  PUT(SINK_FILE)
END {SINKCHR};
 
PROCEDURE SOURCELINE;
VAR C: CHAR;
BEGIN
  IF SOURCE_LINE_COUNT=0 THEN END_OF_FILE:=TRUE
  ELSE BEGIN
    SOURCE_LINE_COUNT:=SOURCE_LINE_COUNT-1;
    IF SOURCE_PACK_COUNT > 0
    THEN BEGIN
      SOURCE_PACK_COUNT:=SOURCE_PACK_COUNT-1;
      SOURCE_STATE:=SOURCE_PACK_STATE;
    END
    ELSE BEGIN
      SOURCECHR(C);
      SOURCE_DECK_INDEX:=ORD(C);
      SOURCECHR(C);
      SOURCE_STATE:=ORD(C);
      IF SOURCE_DECK_INDEX=1
      THEN BEGIN
        SOURCE_PACK_STATE:=SOURCE_STATE;
        SOURCECHR(C);
        SOURCE_PACK_COUNT:=ORD(C)-1;
      END;
    END;
    IF SOURCE_STATE=ACTIVE
    THEN ACTIVE_LINE_COUNT:=ACTIVE_LINE_COUNT+1;
    WITH DECK_TABLE[SOURCE_DECK_INDEX] DO BEGIN
      LINE_NUMBER:=LINE_NUMBER+1
    END;
  END;
END {SOURCELINE};
 
PROCEDURE CLOSE_PACK;
BEGIN
  IF SINK_PACK_COUNT > 0
  THEN BEGIN
    SINKCHR(CHR(1));
    SINKCHR(CHR(SINK_PACK_STATE));
    SINKCHR(CHR(SINK_PACK_COUNT));
    SINK_PACK_COUNT:=0;
  END;
END {CLOSE_PACK};
 
PROCEDURE SINKLINE;
VAR C: CHAR;
BEGIN
  IF (SINK_PACK_COUNT=MAX_PACK) OR
     (SOURCE_DECK_INDEX<>1) OR
     (SOURCE_STATE<>SINK_PACK_STATE)
  THEN CLOSE_PACK;
  IF SOURCE_DECK_INDEX=1
  THEN BEGIN
    IF SINK_PACK_COUNT=0
    THEN SINK_PACK_STATE:=SOURCE_STATE;
    SINK_PACK_COUNT:=SINK_PACK_COUNT+1;
  END
  ELSE BEGIN
    SINKCHR(CHR(SOURCE_DECK_INDEX));
    SINKCHR(CHR(SOURCE_STATE));
    REPEAT
      SOURCECHR(C);
      SINKCHR(C);
    UNTIL C=NL;
  END;
  SINK_LINE_COUNT:=SINK_LINE_COUNT+1;
END {SINKLINE};
 
PROCEDURE LINE0;
BEGIN
 CLOSE_PACK;
  WITH DECK_TABLE[CURRENT_IDENT_INDEX] DO
  IF LINE_NUMBER=-1 THEN
  BEGIN
    SINKCHR(CHR(CURRENT_IDENT_INDEX));
    SINKCHR(CHR(INACTIVE));
    SINKCHR(NL);
    SINK_LINE_COUNT:=SINK_LINE_COUNT+1;
    LINE_NUMBER:=LINE_NUMBER+1;
  END;
END {LINE0}; 
 
PROCEDURE UPDATE_TO_SINK;
VAR I: INTEGER; C: CHAR;
BEGIN
  SINKCHR(CHR(CURRENT_IDENT_INDEX));
  SINKCHR(CHR(ACTIVE));
  WITH DECK_TABLE[CURRENT_IDENT_INDEX] DO
  BEGIN
    LINE_NUMBER:=LINE_NUMBER+1;
  END;
  I:=0;
  REPEAT
    I:=I+1;
    C:=UPDATE_LINE[I];
    SINKCHR(C);
  UNTIL C=NL;
  SINK_LINE_COUNT:=SINK_LINE_COUNT+1;
END {UPDATE_TO_SINK}; 
 
PROCEDURE BEFORELINE(INDEX,LINE: INTEGER);
BEGIN
  WHILE (INDEX<>SOURCE_DECK_INDEX) OR
        (LINE<>DECK_TABLE[SOURCE_DECK_INDEX].LINE_NUMBER) DO
  BEGIN
    SINKLINE;
    SOURCELINE;
  END;
END {BEFORELINE};
 
PROCEDURE AFTERLINE(INDEX,LINE: INTEGER);
BEGIN
  BEFORELINE(INDEX,LINE);
  SINKLINE;
  SOURCELINE;
END {AFTERLINE};
 
PROCEDURE PASSLINES(INDEX,LINE,STATE: INTEGER);
BEGIN
  WHILE (INDEX<>SOURCE_DECK_INDEX) OR
        (LINE<>DECK_TABLE[SOURCE_DECK_INDEX].LINE_NUMBER) DO
  BEGIN
    IF DECK_TABLE[SOURCE_DECK_INDEX].LINE_NUMBER > 0
    THEN SOURCE_STATE:=STATE;
    SINKLINE;
    SOURCELINE;
  END;
  SOURCE_STATE:=STATE;
  SINKLINE;
  SOURCELINE;
END {PASSLINES};
 
PROCEDURE SCAN_CREATE;
VAR NAME: IDENTIFIER; NONE: BOOLEAN;
BEGIN
  IF CREATE_ACTIVE THEN
  BEGIN
    WRITELN(OUT_FILE, 'ONLY ONE CREATE ALLOWED');
    COM_ERROR
  END
  ELSE BEGIN
    SKIP; GETID(NAME,NONE);
    IF NONE THEN
    BEGIN
      WRITELN(OUT_FILE, 'NO CREATE NAME');
      COM_ERROR
    END
    ELSE BEGIN
      {ADD THE CREATE NAME TO THE DECK TABLE AS FIRST ELEMENT}
      DECK_TABLE[1].DECK_NAME:=NAME;
      {PASS1 HAS WRITTEN OUT THE SOURCE TEXT WITH REFERENCE TO
       DECK INDEX 1, WHICH WE HAVE JUST FILLED IN.}
      CREATE_ACTIVE:=TRUE;
    END;
  END;
  GETLINE;
  INSERTING:=FALSE;
END {SCAN_CREATE}; 
 
PROCEDURE OPEN_NEW_IDENT;
BEGIN
  SWITCH_SOURCE_AND_SINK;
  DECK_ACTIVE:=FALSE;
  IDENT_ACTIVE:=TRUE;
  SOURCELINE;
END {OPEN_NEW_IDENT}; 
 
 
PROCEDURE CLOSE_PREVIOUS_IDENT;
BEGIN
  WHILE NOT END_OF_FILE DO
  BEGIN SINKLINE; SOURCELINE END;
  CLOSE_PACK;
  WITH DECK_TABLE[CURRENT_IDENT_INDEX] DO
    MAX_LINE_NUMBER:=LINE_NUMBER;
  CHECK_SOURCE_AND_SINK;
END {CLOSE_PREVIOUS_IDENT}; 
 
PROCEDURE SCAN_IDENT;
VAR NAME: IDENTIFIER; I: INTEGER;
    NONE: BOOLEAN;
BEGIN
  IF NOT CREATE_ACTIVE THEN
  BEGIN
    WRITELN(OUT_FILE, 'NO CREATE DEFINED');
    COM_ERROR
  END
  ELSE BEGIN
    SKIP; GETID(NAME,NONE);
    IF NONE THEN
    BEGIN
      WRITELN(OUT_FILE, 'NO IDENT NAME');
      COM_ERROR
    END
    ELSE BEGIN
      I:=1;
      WHILE (I<=DECK_TOP) AND OK DO
        IF DECK_TABLE[I].DECK_NAME=NAME THEN
	BEGIN
	  WRITELN(OUT_FILE, 'DUPLICATE IDENT');
	  COM_ERROR
	END
          ELSE I:=I+1;
      IF OK THEN
      BEGIN
        IF DECK_TOP = DECK_MAX THEN
	BEGIN
	  WRITELN(OUT_FILE, 'TOO MANY IDENTS');
	  COM_ERROR
	END
        ELSE BEGIN
          DECK_TOP := DECK_TOP + 1;
          WITH DECK_TABLE[DECK_TOP] DO
          BEGIN
            DECK_NAME:=NAME;
            MAX_LINE_NUMBER:=0;
          END;
          CLOSE_PREVIOUS_IDENT;
          OPEN_NEW_IDENT;
          CURRENT_IDENT_INDEX:=DECK_TOP;
        END;
      END;
    END;
  END;
  GETLINE;
  INSERTING:=FALSE;
END {SCAN_IDENT}; 
 
 
PROCEDURE SCAN_DECK(MODNAME: BOOLEAN);
VAR NAME: IDENTIFIER; I: INTEGER;
    NONE,FOUND: BOOLEAN;
BEGIN
  IF NOT IDENT_ACTIVE THEN
  BEGIN
    WRITELN(OUT_FILE, 'NO ACTIVE IDENT');
    COM_ERROR
  END
  ELSE BEGIN
    SKIP; GETID(NAME,NONE);
    IF NONE THEN
    BEGIN
      WRITELN(OUT_FILE, 'NO DECK NAME');
      COM_ERROR
    END
    ELSE IF NAME=DECK_TABLE[CURRENT_IDENT_INDEX].DECK_NAME THEN
    BEGIN
      WRITELN(OUT_FILE, 'CANT MODIFY SELF');
      COM_ERROR
    END
    ELSE IF (NAME<>DECK_TABLE[1].DECK_NAME) AND NOT MODNAME THEN
    BEGIN
      WRITELN(OUT_FILE, '*MODNAME SHOULD BE USED INSTEAD OF *DECK DIRECTIVE');
      COM_ERROR
    END
    ELSE IF (NAME=DECK_TABLE[1].DECK_NAME) AND MODNAME THEN
    BEGIN
      WRITELN(OUT_FILE, '*DECK SHOULD BE USED INSTEAD OF *MODNAME DIRECTIVE');
      COM_ERROR
    END
    ELSE BEGIN
      I:=1;
      FOUND := FALSE;
      WHILE NOT FOUND AND (I<=DECK_TOP) DO
        IF DECK_TABLE[I].DECK_NAME=NAME THEN FOUND:=TRUE
          ELSE I:=I+1;
      IF NOT FOUND THEN
      BEGIN
	WRITELN(OUT_FILE, 'UNKNOWN DECK NAME');
	COM_ERROR
      END
      ELSE BEGIN
        CURRENT_DECK_INDEX := I;
        DECK_ACTIVE:=TRUE;
      END;
    END;
  END;
  GETLINE;
  INSERTING:=FALSE;
END {SCAN_DECK}; 
 
PROCEDURE RANGE_CHECK(INDEX,LINE: INTEGER);
BEGIN
  WITH DECK_TABLE[INDEX] DO
  BEGIN
    IF (LINE<0) OR (LINE>MAX_LINE_NUMBER) THEN
    BEGIN
      WRITELN(OUT_FILE, 'LINE NUMBER OUT OF RANGE');
      COM_ERROR
    END
    ELSE IF LINE < LINE_NUMBER THEN
    BEGIN
      WRITELN(OUT_FILE, 'LINE NUMBER ALREADY PASSED');
      COM_ERROR
    END
  END;
END {RANGE_CHECK}; 
 
PROCEDURE SCAN_DELETE(STATE: INTEGER);
VAR L,U: INTEGER;
    LINDEX,UINDEX: INTEGER; NONE: BOOLEAN;
BEGIN
  IF NOT IDENT_ACTIVE THEN
  BEGIN
    WRITELN(OUT_FILE, 'NO ACTIVE IDENT');
    COM_ERROR
  END
  ELSE BEGIN
    GETLINESPEC(LINDEX,L,NONE);
    IF OK THEN
    BEGIN
      IF NONE THEN
      BEGIN
	WRITELN(OUT_FILE, 'LINE SPECIFICATION EXPECTED');
	COM_ERROR
      END
      ELSE BEGIN
        GETLINESPEC(UINDEX,U,NONE);
        IF OK THEN
        BEGIN
          IF NONE THEN BEGIN U:=L; UINDEX:=LINDEX END
          ELSE IF (U<L) AND (UINDEX=LINDEX) THEN
	  BEGIN
	    WRITELN(OUT_FILE, 'ILLEGAL LINE NUMBER ORDER');
	    COM_ERROR
	  END;
          IF OK THEN
          BEGIN
            RANGE_CHECK(LINDEX,L); RANGE_CHECK(UINDEX,U);
            IF OK THEN
            BEGIN
              BEFORELINE(LINDEX,L);
              PASSLINES(UINDEX,U,STATE);
              INSERTING:=TRUE;
              LINE0;
            END;
          END;
        END;
      END;
    END;
  END;
  GETLINE;
END {SCAN_DELETE}; 
 
PROCEDURE SCAN_INSERT;
VAR L,INDEX: INTEGER;
    NONE: BOOLEAN;
BEGIN
  IF NOT IDENT_ACTIVE THEN
  BEGIN
    WRITELN(OUT_FILE, 'NO ACTIVE IDENT');
    COM_ERROR
  END
  ELSE BEGIN
    GETLINESPEC(INDEX,L,NONE);
    IF OK THEN
    IF NONE THEN
    BEGIN
      WRITELN(OUT_FILE, 'LINE SPECIFICATION EXPECTED');
      COM_ERROR
    END
    ELSE BEGIN
      RANGE_CHECK(INDEX,L);
      IF OK THEN
      BEGIN
        AFTERLINE(INDEX,L);
        INSERTING:=TRUE;
        LINE0;
      END;
    END;
  END;
  GETLINE;
END {SCAN_INSERT}; 
 
PROCEDURE SCAN_PREFIX;
VAR C: CHAR;
BEGIN
  REPEAT GETCHR(C) UNTIL C<>' ';
  IF C < ' ' THEN
  BEGIN
    WRITELN(OUT_FILE, 'ILLEGAL PREFIX CHARACTER');
    COM_ERROR
  END
    ELSE CURRENT_PREFIX:=C;
  GETLINE;
  INSERTING:=FALSE;
END {SCAN_PREFIX}; 
 
PROCEDURE PASS1;
VAR C: CHAR; LINE_COUNT: INTEGER;
BEGIN
  INIT_PASS1;
  {PRECEDE THE SOURCE FILE BY AN
   INACTIVE LINE 0}
  SOURCE_STATE:=INACTIVE;
  SINKLINE; {LINE 0}
  SOURCE_STATE:=ACTIVE; {REST OF SOURCE IS ACTIVE}
  LINE_COUNT:=0;
  GETLINE;
  WHILE NOT UPDATE_EOF DO
  BEGIN
    SINKLINE;
    LINE_COUNT:=LINE_COUNT+1;
    GETLINE
  END;
  CLOSE_PACK;
  WITH DECK_TABLE[1] DO
  BEGIN
    MAX_LINE_NUMBER:=LINE_COUNT;
  END;
  CHECK_PASS1_IO;
END {PASS1}; 
 
PROCEDURE PASS2;
VAR C: CHAR; COMMAND: IDENTIFIER;
    NONE: BOOLEAN;
BEGIN
  INIT_PASS2; SWITCH_SOURCE_AND_SINK; SOURCELINE;
  GETLINE;
  WHILE (NOT UPDATE_EOF) AND OK DO
  BEGIN
    GETCHR(C);
    IF C<>CURRENT_PREFIX THEN
      IF INSERTING THEN
      BEGIN
	UPDATE_TO_SINK;
	GETLINE
      END
      ELSE BEGIN
	WRITELN(OUT_FILE, 'NON DIRECTIVE ENCOUNTERED');
	COM_ERROR
      END
    ELSE BEGIN
      GETID(COMMAND,NONE);
      IF NONE THEN COMMAND:=BLANKS;
      IF COMMAND = C_DELETE  THEN SCAN_DELETE(INACTIVE) ELSE
      IF COMMAND = C_INSERT  THEN SCAN_INSERT ELSE
      IF COMMAND = C_DECK    THEN SCAN_DECK(FALSE) ELSE
      IF COMMAND = C_IDENT   THEN SCAN_IDENT ELSE
      IF COMMAND = C_RESTORE THEN SCAN_DELETE(ACTIVE) ELSE
      IF COMMAND = C_MODNAME THEN SCAN_DECK(TRUE) ELSE
      IF UPDATE_LINE[2] = '/' THEN BEGIN GETLINE; INSERTING:=FALSE END ELSE
      IF COMMAND = C_CREATE  THEN SCAN_CREATE ELSE
      IF COMMAND = C_WIDTH   THEN BEGIN GETLINE; INSERTING:=FALSE END ELSE
      IF COMMAND = C_PREFIX  THEN SCAN_PREFIX ELSE
      IF COMMAND = C_YANK    THEN
      BEGIN
	WRITELN(OUT_FILE, 'YANK NOT IMPLEMENTED');
	COM_ERROR
      END ELSE
      IF COMMAND = C_UNYANK  THEN
      BEGIN
	WRITELN(OUT_FILE, 'UNYANK NOT IMPLEMENTED');
	COM_ERROR
      END ELSE
      IF INSERTING THEN
      BEGIN
	UPDATE_TO_SINK;
	GETLINE
      END
      ELSE BEGIN
	WRITELN(OUT_FILE, 'ILLEGAL DIRECTIVE');
	COM_ERROR
      END
    END;
  END;
  CLOSE_PREVIOUS_IDENT;
  CHECK_PASS2_IO;
END {PASS2}; 
 
PROCEDURE PASS3;
VAR C: CHAR; I: INTEGER;
BEGIN
  INIT_PASS3; SWITCH_SOURCE_AND_SINK;
  SOURCELINE; SOURCELINE; {SKIP LINE 0 OF THE CREATE DECK}
  WHILE NOT END_OF_FILE DO
  BEGIN
    IF NOT COMPILE AND (SOURCE_STATE=ACTIVE) THEN
      WITH DECK_TABLE[SOURCE_DECK_INDEX] DO
      BEGIN
	WRITE(OUT_FILE, DECK_NAME, LINE_NUMBER:5, ' ')
      END;
    REPEAT
      IF SOURCE_DECK_INDEX=1
	THEN READ(IN_FILE, C)
	ELSE SOURCECHR(C);
      IF SOURCE_STATE=ACTIVE THEN WRITE(OUT_FILE, C);
    UNTIL C=NL;
    SOURCELINE;
  END; {WHILE}
  CHECK_PASS3_IO;
END {PASS3}; 
 
PROCEDURE INITIALIZE;
VAR I: INTEGER; CH: CHAR;
BEGIN
  OK := TRUE;
  COMPILE := TRUE; {DEFAULT}
  SWITCHED := FALSE;
  IF ARGV[1]@[0] = '-' THEN
  { GET OPTION FROM COMMAND LINE: }
  BEGIN
    I := 1;
    LOOP
      CH := ARGV[1]@[I];
    EXIT IF CH = NUL;
      IF (CH='c') OR (CH='C') THEN COMPILE := TRUE
      ELSE IF (CH='l') OR (CH='L') THEN COMPILE := FALSE
      ELSE HELP;
      I := I + 1
    END {LOOP}
  END;
  IF ARGV[4]@[0] = NUL THEN HELP ELSE REWRITE(OUT_FILE, ARGV[4]@, 2);
END {INITIALIZE};
 
 
BEGIN {MODIFY}
  INITIALIZE;
  IF OK THEN PASS1;
  IF OK THEN PASS2;
  IF OK THEN PASS3
END.
