.; DECUS C Runtime library build command file for RSX-11M.
.; By
.;	Bob Denny
.;	12-Sep-80
.;
; MMAKLB.CMD
;
;
; Build the DECUS C runtime library -- for RSX-11M
;
; The tasks ...MAC, ...LBR, ...PIP, and ...TKB must be installed for this
; command file to execute properly. If any of these are not found, MMAKLB
; will now exit. Install 'em and try again.
.IFNINS ...MAC .EXIT
.IFNINS ...LBR .EXIT
.IFNINS ...PIP .EXIT
.IFNINS ...TKB .EXIT
;
; You must override the assignments in this file if you want the following
; logical devices to be assigned to other than SY:
;
;	SR:	Source and command files must be on this device.
;	LS:	Listings go to this device.
;	OB:	Objects go to this device.
;
; NOTE: The library C.OLB will be created in LB:[1,1]. Don't forget to
;       copy STDIO.H there also.
;
ASN SY:=SR:
ASN SY:=LS:
ASN SY:=OB:
;
.ASK OK Are the above assignments OK?
.IFT OK .GOTO 100
;
; We will now pause so that you may change assignment(s)...
.PAUSE
.100:
;
; Normally, a system running RSX-11M has a processor which supports
; the PDP-11 Extended Instruction Set (EIS), and the sign-extend
; instruction. If your processor supports EIS (and therefore SXT), the
; library will be OK. If not, you must edit the file RSX.MAC in both
; [5,4] and [5,5]. To turn off EIS support, equate C$$EIS to 0. To turn
; off SXT (if you have an 11/05, 11/20, 11/35 or 11/40), equate C$$SXT
; to 0.
;
; In addition, you may want to change the number of block buffers
; allocated in the FCS file storage region. Unfortunately, this must
; be done at library assembly time, it cannot be changed once the
; FOPEN.MAC module has been assembled. The default is 8 simultaneously
; open files (not including stdin, stdout or stderr unless they are
; reopened to other than a terminal). Each simultaneously open file
; requires 512(10) bytes of space for its block buffer. So 8 files
; use up 4K bytes. A more reasonable number might be 4 open files.
; This would chop 2K bytes off of the task size. To change the number
; of block buffers, edit RSX.MAC to change the value of N$$FIL.
;
;
.ASK CHG Do you wish to edit the assembly prefix file RSX.MAC
.IFF CHG .GOTO 110
;
; We will now pause so that you may edit RSX.MAC...
.PAUSE
.110:
;
TIM
; Assemble the Op. Syst. non-specific modules in [5,4]
SET /UIC=[5,4]
TIM
MAC @SR:XCLBAS
;
; And now the OS specific ones in [5,5]
SET /UIC=[5,5]
TIM
MAC @SR:XILBAS
;
;
TIM
; Concatenate all modules and build the library
;
PIP OB:OTS.TMP=OB:[5,4]*.OBJ,[5,5]*.OBJ
LBR LB:[1,1]C/CR=OB:OTS.TMP
PIP OB:OTS.TMP;*/DE
;
; Library build complete
;
                                                                                                                                                                                                                                                                                                                                                                                                                              