#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

#include <stdio.h>
#include "asm.h"

/*
 * Note an error.
 * If the error is already in the
 * error buffer don't note it again.
 * If the error is serious enough to
 * stop the parse (a `q' error) just
 * give up.
 */
err(c)
register c;
{
	register char *p;

	p = eb;
	while (p < ep)
		if (*p++ == c)
			return;
	if (p < &eb[NERR]) {
		*p++ = c;
		ep = p;
	}
	if (c == 'q')
		unwind();
}

/*
 * Send errors to the standard output.
 */
diag()
{
	register char *p;

	p = eb;
	while (p < ep)
		printf("%c %04d\n", *p++, line);
}

/*
 * Note an 'r' error.
 */
rerr()
{
	err('r');
}

/*
 * Note an 'a' error.
 */
aerr()
{
	err('a');
}

/*
 * Note a 'q' error.
 */
qerr()
{
	err('q');
}
                                                                                                                            