#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * Assembler header.
 */
#define NCPS	8		/* Chars. per symbol */
#define	HUGE	1000		/* A huge number */
#define NERR	10		/* Errors per line */
#define NINPUT	128		/* Input buffer size */
#define NCODE	128		/* Listing code buffer size */
#define NTIT	64		/* Title buffer size */
#define	NHASH	64		/* Buckets in hash table */
#define	HMASK	077		/* Hash mask */
#define	NLPP	60		/* Lines per page */

#define NLIST	0		/* No listing */
#define SLIST	1		/* Source only */
#define ALIST	2		/* Address only */
#define CLIST	3		/* Code */

#define	dot	(&sym[0])	/* Dot, current loc */
#define	dda	(&sym[1])	/* Dda, default data area */

typedef	unsigned addr_t;

struct	area
{
	struct	area *a_ap;	/* Area link */
	struct	sym *a_sp;	/* Symbol back link */
	int	a_ref;		/* Ref. number */
	addr_t	a_size;		/* Area size */
	addr_t	a_fuzz;		/* Area fuzz (bropt) */
	int	a_flag;		/* Area flags */
};

#define	A_D	00		/* D space */
#define	A_I	01		/* I space */
#define	A_PRV	00		/* Private */
#define	A_SHR	02		/* Shared */
#define	A_CON	00		/* Concatenating */
#define	A_OVR	04		/* Overlaying */

struct	sym
{
	struct	sym  *s_sp;	/* Hash link */
	char	s_id[NCPS];	/* Name */
	char	s_type;		/* Symbol subtype */
	char	s_flag;		/* Symbol flags */
	struct	area *s_area;	/* Area line, 0 if absolute */
	int	s_ref;		/* Ref. number */
	addr_t	s_addr;		/* Address */
};

#define	S_GBL	01		/* Global */
#define	S_ASG	02		/* Assigned */
#define	S_MDF	04		/* Mult. def */
#define	S_END	010		/* End mark for pst. */

#define	S_NEW	0		/* New name */
#define	S_USER	1		/* User name */
#define	S_AREA	2		/* Area name */
#define	S_BYTE	3		/* .byte */
#define	S_WORD	4		/* .word */
#define	S_ASCII	5		/* .ascii */
#define	S_ASCIZ	6		/* .asciz */
#define	S_BLK	7		/* .blkb or .blkw */
#define	S_INCL	8		/* .include */
#define	S_DAREA	9		/* .area */
#define	S_GLOBL	10		/* .globl */
#define	S_PAGE	11		/* .page */
#define	S_TITLE	12		/* .title */
#define	S_IF	13		/* .if */
#define	S_ELSE	14		/* .else */
#define	S_ENDIF	15		/* .endif */

struct	tsym
{
	struct	tsym *t_fp;	/* Link to next */
	struct	area *t_area;	/* Area */
	addr_t	t_addr;		/* Address */
};

struct	tsymp
{
	struct	tsym *tp_fp;	/* Symbol for `n'f */
	struct	tsym *tp_bp;	/* Symbol for `n'b */
	struct	tsym *tp_lfp;	/* First symbol */
	struct	tsym *tp_llp;	/* Last symbol */
};

extern	int	flevel;
extern	int	tlevel;
extern	char	*new();
extern	struct	sym sym[];
extern	int	line;
extern	int	page;
extern	int	lop;
extern	int	pass;
extern	int	lflag;
extern	int	gflag;
extern	int	oflag;
extern	int	eflag;
extern	addr_t	laddr;
extern	addr_t	fuzz;
extern	int	lmode;
extern	struct	sym *symhash[NHASH];
extern	struct	area *areap;
extern	char	*ep;
extern	char	eb[NERR];
extern	char	*ip;
extern	char	ib[NINPUT];
extern	char	*cp;
extern	char	cb[NCODE];
extern	char	tb[NTIT];
extern	struct	tsymp tsymp[10];
extern	FILE	*lfp;
extern	FILE	*ofp;
extern	FILE	*sfp;
extern	char	*cpu;
extern	char	*dsft;
extern	char	ctype[];

#define	LETTER	0
#define	DIGIT	1
#define	BINOP	2
#define ETC	3
#define	ILL	4
#define	SPACE	5

/*
 * Expression.
 */
struct	expr
{
	char	e_mode;		/* Address mode */
	char	e_flag;		/* Symbol baseed flag */
	addr_t	e_addr;		/* Address */
	union	{
		struct area *e_ap;
		struct sym  *e_sp;
	} e_base;		/* Rel. base */
};
                         