#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * asm84.c
 * Code and listing.
 */
#include <stdio.h>
#include "asm80.h"

/*
 * Output code byte.
 * Save it in the per line
 * buffer for outlisting.
 * Update dot.
 */
codeb(b)
{
	b &= 0377;
	if(cptr < &cbuf[CLMAX])
		*cptr++ = b;
	else
		err('z');
	if(pass && !nflag) {
		if(crec>=CBMAX || cadr+crec!=dot->s_value) {
			cflush(0);
			cadr = dot->s_value;
		}
		crbf[crec++] = b;
	}
	++dot->s_value;
}

/*
 * Output a word.
 * Low then high.
 */
codew(w)
{
	codeb(w);
	codeb(w>>8);
}

/*
 * Signal error.
 * Add it to the error buffer
 * if not already there.
 */
err(c)
{
	register char *p;

	p = ebuf;
	while(p < eptr)
		if(*p++ == c)
			return;
	if(p >= &ebuf[ERRMAX])
		abort();
	*p++ = c;
	eptr = p;
}

/*
 * Format a line for the
 * listing.
 * More work than you would
 * think.
 * Only called if -l.
 */
outlisting()
{
	register int nbytes;
	register char *cp;
	int w1, w2, w3;

	if(listmode == NLIST)
		return;
	for(cp = eptr; cp < &ebuf[ERRMAX]; *cp++ = ' ');
	if(listmode == SLIST)
		fprintf(lst, "%10s      ", ebuf);
	else
		fprintf(lst, "%10s %04x ", ebuf, listaddr);
	if(listmode == ALIST)
		fprintf(lst, "%9s%6d %s\n", "", lineno, sbuf);
	else {
		nbytes = cptr-cbuf;
		w1 = cbuf[0]&0377;
		w2 = cbuf[1]&0377;
		w3 = cbuf[2]&0377;
		switch(nbytes) {

		case 0:
			fprintf(lst, "%9s", "");
			break;

		case 1:
			fprintf(lst, "%02x%7s", w1, "");
			break;

		case 2:
			fprintf(lst, "%02x %02x%4s", w1, w2, "");
			break;

		default:
			fprintf(lst, "%02x %02x %02x ", w1, w2, w3);
		}
		fprintf(lst, "%6d %s\n", lineno, sbuf);
		cp = &cbuf[3];
		while((nbytes -= 3) > 0) {
			fprintf(lst, "%16s", "");
			switch(nbytes) {

			case 1:
				w1 = cp[0]&0377;
				fprintf(lst, "%02x\n", w1);
				break;

			case 2:
				w1 = cp[0]&0377;
				w2 = cp[1]&0377;
				fprintf(lst, "%02x %02x\n", w1, w2);
				break;

			default:
				w1 = cp[0]&0377;
				w2 = cp[1]&0377;
				w3 = cp[2]&0377;
				fprintf(lst, "%02x %02x %02x\n", w1, w2, w3);
			}
			cp += 3;
		}
	}
}

/*
 * Write errors to the tty.
 */
outerrors()
{
	register char *p;

	p = ebuf;
	while(p < eptr)
		printf("%c %04d\n", *p++, lineno);
}

/*
 * Flush the binary code
 * buffer.
 * J. Morse Z-80 Format
 * The lf flag, if true, says that
 * this is the last line.
 */
cflush(lf)
{
	register int i;

	if(crec == 0)
		return;
	fprintf(obj, "^%04x/", cadr);
	for(i=0; i<crec; ++i)
		fprintf(obj, "%02x", crbf[i]&0377);
		fprintf(obj, "\n");
	crec = 0;
}

/*
 * Print out the symbol table to Listing
 */
symprt()
{
	register struct sym *stp;
	register struct reflst *ref;
	struct reflst *ref1, *ref2;
	int i,r;
	char c1;

	fprintf(lst,"\14\n");
	for (stp=ust; stp < uptr; stp++) {
		if (stp->s_flag && SF_ASG) c1='='; else c1=' ';
		fprintf(lst,"\t%-8s    %c %04x    ",stp->s_name,c1,stp->s_value);
		ref1 = stp->s_ref;
		ref = NULL;
		while (ref1!=NULL) {
			ref2=ref1;
			ref1=ref1->r_chain;
			ref2->r_chain=ref;
			ref=ref2;
		}
		i=LREFMAX;
		while (ref!=NULL) {
			r=ref->r_stmtno;
			if(r<0) {
				r = -r;
				c1 = '#';
			} else c1 = ' ';
			fprintf(lst,"%5d%c",r,c1);
			ref=ref->r_chain;
			i--;
			if (!i && ref!=NULL) {
				fprintf(lst,"\n\t\t\t      ");
				i=LREFMAX;
			}
		}
		fprintf(lst,"\n");
	}
	fprintf(lst,"\n%6d Symbols\n%6d References\n",symcnt,refcnt);
	return;
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          