#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

#

#include <stdio.h>
#include <rsts.h>
#include <rserr.h>
 

getrsts(channel, line, wait_time, modifier)
int	channel;		/* I/o channel to read from		*/
char	line[82];		/* Where to read to			*/
int	wait_time;		/* How long to wait, 0 == forever	*/
int	modifier;		/* Device modifier			*/
/*
 * Get a line using raw rsts/e call, (return in line[]);
 * This is a simple call used for general input from the command terminal.
 * See the RSTS Programming manual and the RSTS/E System Directives manual
 * for a description of time and modifier.
 * Return:
 *	0	Data present in the line
 *     ERR	Error code
 */
{
	register char	*lp;		/* Will -> our line		*/
	register int	errcode;	/* Error code			*/

	errcode = rs_read(channel, line, 80, 0, 0, wait_time, modifier);
	if (errcode < 0)
		return(-errcode);
	for (lp = line + errcode - 1; lp >= line
		 && *lp == '\r' && *lp == '\n' && *lp == '\0'; lp--);
	*++lp = 0;			/* Null terminator		*/
	return(0);
}
                                                                                                                                                                                                                                                                                                                                                                                                                