/*	Copyright (c) 1990 UNIX System Laboratories, Inc.	*/
/*	Copyright (c) 1984, 1986, 1987, 1988, 1989, 1990 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF     	*/
/*	UNIX System Laboratories, Inc.                     	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)kern-ml:tables1.c	1.3"

#include	"sys/types.h"
#include	"sys/immu.h"


/*
 * The page directory and tables need to be aligned on page frame 
 * boundaries. Currently the only way to do that is to put them at the
 * start of the data segment and make sure it starts on a page
 * frame boundary when loaded.
 */

typedef uint	kpte_t;		/* Full page table entry */

/* kernel's first page table */
kpte_t	kpt0[NPGPT] = {
			mkpte(PG_V, 0x000),
			mkpte(PG_V, 0x001),
			mkpte(PG_V, 0x002),
			mkpte(PG_V, 0x003),
			mkpte(PG_V, 0x004),
			mkpte(PG_V, 0x005),
			mkpte(PG_V, 0x006),
			mkpte(PG_V, 0x007),
			mkpte(PG_V, 0x008),
			mkpte(PG_V, 0x009),
			mkpte(PG_V, 0x00A),
			mkpte(PG_V, 0x00B),
			mkpte(PG_V, 0x00C),
			mkpte(PG_V, 0x00D),
			mkpte(PG_V, 0x00E),
			mkpte(PG_V, 0x00F),
			mkpte(PG_V, 0x010),
			mkpte(PG_V, 0x011),
			mkpte(PG_V, 0x012),
			mkpte(PG_V, 0x013),
			mkpte(PG_V, 0x014),
			mkpte(PG_V, 0x015),
			mkpte(PG_V, 0x016),
			mkpte(PG_V, 0x017),
			mkpte(PG_V, 0x018),
			mkpte(PG_V, 0x019),
			mkpte(PG_V, 0x01A),
			mkpte(PG_V, 0x01B),
			mkpte(PG_V, 0x01C),
			mkpte(PG_V, 0x01D),
			mkpte(PG_V, 0x01E),
			mkpte(PG_V, 0x01F),
			mkpte(PG_V, 0x020),
			mkpte(PG_V, 0x021),
			mkpte(PG_V, 0x022),
			mkpte(PG_V, 0x023),
			mkpte(PG_V, 0x024),
			mkpte(PG_V, 0x025),
			mkpte(PG_V, 0x026),
			mkpte(PG_V, 0x027),
			mkpte(PG_V, 0x028),
			mkpte(PG_V, 0x029),
			mkpte(PG_V, 0x02A),
			mkpte(PG_V, 0x02B),
			mkpte(PG_V, 0x02C),
			mkpte(PG_V, 0x02D),
			mkpte(PG_V, 0x02E),
			mkpte(PG_V, 0x02F),
			mkpte(PG_V, 0x030),
			mkpte(PG_V, 0x031),
			mkpte(PG_V, 0x032),
			mkpte(PG_V, 0x033),
			mkpte(PG_V, 0x034),
			mkpte(PG_V, 0x035),
			mkpte(PG_V, 0x036),
			mkpte(PG_V, 0x037),
			mkpte(PG_V, 0x038),
			mkpte(PG_V, 0x039),
			mkpte(PG_V, 0x03A),
			mkpte(PG_V, 0x03B),
			mkpte(PG_V, 0x03C),
			mkpte(PG_V, 0x03D),
			mkpte(PG_V, 0x03E),
			mkpte(PG_V, 0x03F),
			mkpte(PG_V, 0x040),
			mkpte(PG_V, 0x041),
			mkpte(PG_V, 0x042),
			mkpte(PG_V, 0x043),
			mkpte(PG_V, 0x044),
			mkpte(PG_V, 0x045),
			mkpte(PG_V, 0x046),
			mkpte(PG_V, 0x047),
			mkpte(PG_V, 0x048),
			mkpte(PG_V, 0x049),
			mkpte(PG_V, 0x04A),
			mkpte(PG_V, 0x04B),
			mkpte(PG_V, 0x04C),
			mkpte(PG_V, 0x04D),
			mkpte(PG_V, 0x04E),
			mkpte(PG_V, 0x04F),
			mkpte(PG_V, 0x050),
			mkpte(PG_V, 0x051),
			mkpte(PG_V, 0x052),
			mkpte(PG_V, 0x053),
			mkpte(PG_V, 0x054),
			mkpte(PG_V, 0x055),
			mkpte(PG_V, 0x056),
			mkpte(PG_V, 0x057),
			mkpte(PG_V, 0x058),
			mkpte(PG_V, 0x059),
			mkpte(PG_V, 0x05A),
			mkpte(PG_V, 0x05B),
			mkpte(PG_V, 0x05C),
			mkpte(PG_V, 0x05D),
			mkpte(PG_V, 0x05E),
			mkpte(PG_V, 0x05F),
			mkpte(PG_V, 0x060),
			mkpte(PG_V, 0x061),
			mkpte(PG_V, 0x062),
			mkpte(PG_V, 0x063),
			mkpte(PG_V, 0x064),
			mkpte(PG_V, 0x065),
			mkpte(PG_V, 0x066),
			mkpte(PG_V, 0x067),
			mkpte(PG_V, 0x068),
			mkpte(PG_V, 0x069),
			mkpte(PG_V, 0x06A),
			mkpte(PG_V, 0x06B),
			mkpte(PG_V, 0x06C),
			mkpte(PG_V, 0x06D),
			mkpte(PG_V, 0x06E),
			mkpte(PG_V, 0x06F),
			mkpte(PG_V, 0x070),
			mkpte(PG_V, 0x071),
			mkpte(PG_V, 0x072),
			mkpte(PG_V, 0x073),
			mkpte(PG_V, 0x074),
			mkpte(PG_V, 0x075),
			mkpte(PG_V, 0x076),
			mkpte(PG_V, 0x077),
			mkpte(PG_V, 0x078),
			mkpte(PG_V, 0x079),
			mkpte(PG_V, 0x07A),
			mkpte(PG_V, 0x07B),
			mkpte(PG_V, 0x07C),
			mkpte(PG_V, 0x07D),
			mkpte(PG_V, 0x07E),
			mkpte(PG_V, 0x07F),
			mkpte(PG_V, 0x080),
			mkpte(PG_V, 0x081),
			mkpte(PG_V, 0x082),
			mkpte(PG_V, 0x083),
			mkpte(PG_V, 0x084),
			mkpte(PG_V, 0x085),
			mkpte(PG_V, 0x086),
			mkpte(PG_V, 0x087),
			mkpte(PG_V, 0x088),
			mkpte(PG_V, 0x089),
			mkpte(PG_V, 0x08A),
			mkpte(PG_V, 0x08B),
			mkpte(PG_V, 0x08C),
			mkpte(PG_V, 0x08D),
			mkpte(PG_V, 0x08E),
			mkpte(PG_V, 0x08F),
			mkpte(PG_V, 0x090),
			mkpte(PG_V, 0x091),
			mkpte(PG_V, 0x092),
			mkpte(PG_V, 0x093),
			mkpte(PG_V, 0x094),
			mkpte(PG_V, 0x095),
			mkpte(PG_V, 0x096),
			mkpte(PG_V, 0x097),
			mkpte(PG_V, 0x098),
			mkpte(PG_V, 0x099),
			mkpte(PG_V, 0x09A),
			mkpte(PG_V, 0x09B),
			mkpte(PG_V, 0x09C),
			mkpte(PG_V, 0x09D),
			mkpte(PG_V, 0x09E),
			mkpte(PG_V, 0x09F),
			mkpte(PG_V, 0x0A0),
			mkpte(PG_V, 0x0A1),
			mkpte(PG_V, 0x0A2),
			mkpte(PG_V, 0x0A3),
			mkpte(PG_V, 0x0A4),
			mkpte(PG_V, 0x0A5),
			mkpte(PG_V, 0x0A6),
			mkpte(PG_V, 0x0A7),
			mkpte(PG_V, 0x0A8),
			mkpte(PG_V, 0x0A9),
			mkpte(PG_V, 0x0AA),
			mkpte(PG_V, 0x0AB),
			mkpte(PG_V, 0x0AC),
			mkpte(PG_V, 0x0AD),
			mkpte(PG_V, 0x0AE),
			mkpte(PG_V, 0x0AF),
			mkpte(PG_V, 0x0B0),
			mkpte(PG_V, 0x0B1),
			mkpte(PG_V, 0x0B2),
			mkpte(PG_V, 0x0B3),
			mkpte(PG_V, 0x0B4),
			mkpte(PG_V, 0x0B5),
			mkpte(PG_V, 0x0B6),
			mkpte(PG_V, 0x0B7),
			mkpte(PG_V, 0x0B8),
			mkpte(PG_V, 0x0B9),
			mkpte(PG_V, 0x0BA),
			mkpte(PG_V, 0x0BB),
			mkpte(PG_V, 0x0BC),
			mkpte(PG_V, 0x0BD),
			mkpte(PG_V, 0x0BE),
			mkpte(PG_V, 0x0BF),
			mkpte(PG_V, 0x0C0),
			mkpte(PG_V, 0x0C1),
			mkpte(PG_V, 0x0C2),
			mkpte(PG_V, 0x0C3),
			mkpte(PG_V, 0x0C4),
			mkpte(PG_V, 0x0C5),
			mkpte(PG_V, 0x0C6),
			mkpte(PG_V, 0x0C7),
			mkpte(PG_V, 0x0C8),
			mkpte(PG_V, 0x0C9),
			mkpte(PG_V, 0x0CA),
			mkpte(PG_V, 0x0CB),
			mkpte(PG_V, 0x0CC),
			mkpte(PG_V, 0x0CD),
			mkpte(PG_V, 0x0CE),
			mkpte(PG_V, 0x0CF),
			mkpte(PG_V, 0x0D0),
			mkpte(PG_V, 0x0D1),
			mkpte(PG_V, 0x0D2),
			mkpte(PG_V, 0x0D3),
			mkpte(PG_V, 0x0D4),
			mkpte(PG_V, 0x0D5),
			mkpte(PG_V, 0x0D6),
			mkpte(PG_V, 0x0D7),
			mkpte(PG_V, 0x0D8),
			mkpte(PG_V, 0x0D9),
			mkpte(PG_V, 0x0DA),
			mkpte(PG_V, 0x0DB),
			mkpte(PG_V, 0x0DC),
			mkpte(PG_V, 0x0DD),
			mkpte(PG_V, 0x0DE),
			mkpte(PG_V, 0x0DF),
			mkpte(PG_V, 0x0E0),
			mkpte(PG_V, 0x0E1),
			mkpte(PG_V, 0x0E2),
			mkpte(PG_V, 0x0E3),
			mkpte(PG_V, 0x0E4),
			mkpte(PG_V, 0x0E5),
			mkpte(PG_V, 0x0E6),
			mkpte(PG_V, 0x0E7),
			mkpte(PG_V, 0x0E8),
			mkpte(PG_V, 0x0E9),
			mkpte(PG_V, 0x0EA),
			mkpte(PG_V, 0x0EB),
			mkpte(PG_V, 0x0EC),
			mkpte(PG_V, 0x0ED),
			mkpte(PG_V, 0x0EE),
			mkpte(PG_V, 0x0EF),
			mkpte(PG_V, 0x0F0),
			mkpte(PG_V, 0x0F1),
			mkpte(PG_V, 0x0F2),
			mkpte(PG_V, 0x0F3),
			mkpte(PG_V, 0x0F4),
			mkpte(PG_V, 0x0F5),
			mkpte(PG_V, 0x0F6),
			mkpte(PG_V, 0x0F7),
			mkpte(PG_V, 0x0F8),
			mkpte(PG_V, 0x0F9),
			mkpte(PG_V, 0x0FA),
			mkpte(PG_V, 0x0FB),
			mkpte(PG_V, 0x0FC),
			mkpte(PG_V, 0x0FD),
			mkpte(PG_V, 0x0FE),
			mkpte(PG_V, 0x0FF),
			mkpte(PG_V, 0x100),
			mkpte(PG_V, 0x101),
			mkpte(PG_V, 0x102),
			mkpte(PG_V, 0x103),
			mkpte(PG_V, 0x104),
			mkpte(PG_V, 0x105),
			mkpte(PG_V, 0x106),
			mkpte(PG_V, 0x107),
			mkpte(PG_V, 0x108),
			mkpte(PG_V, 0x109),
			mkpte(PG_V, 0x10A),
			mkpte(PG_V, 0x10B),
			mkpte(PG_V, 0x10C),
			mkpte(PG_V, 0x10D),
			mkpte(PG_V, 0x10E),
			mkpte(PG_V, 0x10F),
			mkpte(PG_V, 0x110),
			mkpte(PG_V, 0x111),
			mkpte(PG_V, 0x112),
			mkpte(PG_V, 0x113),
			mkpte(PG_V, 0x114),
			mkpte(PG_V, 0x115),
			mkpte(PG_V, 0x116),
			mkpte(PG_V, 0x117),
			mkpte(PG_V, 0x118),
			mkpte(PG_V, 0x119),
			mkpte(PG_V, 0x11A),
			mkpte(PG_V, 0x11B),
			mkpte(PG_V, 0x11C),
			mkpte(PG_V, 0x11D),
			mkpte(PG_V, 0x11E),
			mkpte(PG_V, 0x11F),
			mkpte(PG_V, 0x120),
			mkpte(PG_V, 0x121),
			mkpte(PG_V, 0x122),
			mkpte(PG_V, 0x123),
			mkpte(PG_V, 0x124),
			mkpte(PG_V, 0x125),
			mkpte(PG_V, 0x126),
			mkpte(PG_V, 0x127),
			mkpte(PG_V, 0x128),
			mkpte(PG_V, 0x129),
			mkpte(PG_V, 0x12A),
			mkpte(PG_V, 0x12B),
			mkpte(PG_V, 0x12C),
			mkpte(PG_V, 0x12D),
			mkpte(PG_V, 0x12E),
			mkpte(PG_V, 0x12F),
			mkpte(PG_V, 0x130),
			mkpte(PG_V, 0x131),
			mkpte(PG_V, 0x132),
			mkpte(PG_V, 0x133),
			mkpte(PG_V, 0x134),
			mkpte(PG_V, 0x135),
			mkpte(PG_V, 0x136),
			mkpte(PG_V, 0x137),
			mkpte(PG_V, 0x138),
			mkpte(PG_V, 0x139),
			mkpte(PG_V, 0x13A),
			mkpte(PG_V, 0x13B),
			mkpte(PG_V, 0x13C),
			mkpte(PG_V, 0x13D),
			mkpte(PG_V, 0x13E),
			mkpte(PG_V, 0x13F),
			mkpte(PG_V, 0x140),
			mkpte(PG_V, 0x141),
			mkpte(PG_V, 0x142),
			mkpte(PG_V, 0x143),
			mkpte(PG_V, 0x144),
			mkpte(PG_V, 0x145),
			mkpte(PG_V, 0x146),
			mkpte(PG_V, 0x147),
			mkpte(PG_V, 0x148),
			mkpte(PG_V, 0x149),
			mkpte(PG_V, 0x14A),
			mkpte(PG_V, 0x14B),
			mkpte(PG_V, 0x14C),
			mkpte(PG_V, 0x14D),
			mkpte(PG_V, 0x14E),
			mkpte(PG_V, 0x14F),
			mkpte(PG_V, 0x150),
			mkpte(PG_V, 0x151),
			mkpte(PG_V, 0x152),
			mkpte(PG_V, 0x153),
			mkpte(PG_V, 0x154),
			mkpte(PG_V, 0x155),
			mkpte(PG_V, 0x156),
			mkpte(PG_V, 0x157),
			mkpte(PG_V, 0x158),
			mkpte(PG_V, 0x159),
			mkpte(PG_V, 0x15A),
			mkpte(PG_V, 0x15B),
			mkpte(PG_V, 0x15C),
			mkpte(PG_V, 0x15D),
			mkpte(PG_V, 0x15E),
			mkpte(PG_V, 0x15F),
			mkpte(PG_V, 0x160),
			mkpte(PG_V, 0x161),
			mkpte(PG_V, 0x162),
			mkpte(PG_V, 0x163),
			mkpte(PG_V, 0x164),
			mkpte(PG_V, 0x165),
			mkpte(PG_V, 0x166),
			mkpte(PG_V, 0x167),
			mkpte(PG_V, 0x168),
			mkpte(PG_V, 0x169),
			mkpte(PG_V, 0x16A),
			mkpte(PG_V, 0x16B),
			mkpte(PG_V, 0x16C),
			mkpte(PG_V, 0x16D),
			mkpte(PG_V, 0x16E),
			mkpte(PG_V, 0x16F),
			mkpte(PG_V, 0x170),
			mkpte(PG_V, 0x171),
			mkpte(PG_V, 0x172),
			mkpte(PG_V, 0x173),
			mkpte(PG_V, 0x174),
			mkpte(PG_V, 0x175),
			mkpte(PG_V, 0x176),
			mkpte(PG_V, 0x177),
			mkpte(PG_V, 0x178),
			mkpte(PG_V, 0x179),
			mkpte(PG_V, 0x17A),
			mkpte(PG_V, 0x17B),
			mkpte(PG_V, 0x17C),
			mkpte(PG_V, 0x17D),
			mkpte(PG_V, 0x17E),
			mkpte(PG_V, 0x17F),
			mkpte(PG_V, 0x180),
			mkpte(PG_V, 0x181),
			mkpte(PG_V, 0x182),
			mkpte(PG_V, 0x183),
			mkpte(PG_V, 0x184),
			mkpte(PG_V, 0x185),
			mkpte(PG_V, 0x186),
			mkpte(PG_V, 0x187),
			mkpte(PG_V, 0x188),
			mkpte(PG_V, 0x189),
			mkpte(PG_V, 0x18A),
			mkpte(PG_V, 0x18B),
			mkpte(PG_V, 0x18C),
			mkpte(PG_V, 0x18D),
			mkpte(PG_V, 0x18E),
			mkpte(PG_V, 0x18F),
			mkpte(PG_V, 0x190),
			mkpte(PG_V, 0x191),
			mkpte(PG_V, 0x192),
			mkpte(PG_V, 0x193),
			mkpte(PG_V, 0x194),
			mkpte(PG_V, 0x195),
			mkpte(PG_V, 0x196),
			mkpte(PG_V, 0x197),
			mkpte(PG_V, 0x198),
			mkpte(PG_V, 0x199),
			mkpte(PG_V, 0x19A),
			mkpte(PG_V, 0x19B),
			mkpte(PG_V, 0x19C),
			mkpte(PG_V, 0x19D),
			mkpte(PG_V, 0x19E),
			mkpte(PG_V, 0x19F),
			mkpte(PG_V, 0x1A0),
			mkpte(PG_V, 0x1A1),
			mkpte(PG_V, 0x1A2),
			mkpte(PG_V, 0x1A3),
			mkpte(PG_V, 0x1A4),
			mkpte(PG_V, 0x1A5),
			mkpte(PG_V, 0x1A6),
			mkpte(PG_V, 0x1A7),
			mkpte(PG_V, 0x1A8),
			mkpte(PG_V, 0x1A9),
			mkpte(PG_V, 0x1AA),
			mkpte(PG_V, 0x1AB),
			mkpte(PG_V, 0x1AC),
			mkpte(PG_V, 0x1AD),
			mkpte(PG_V, 0x1AE),
			mkpte(PG_V, 0x1AF),
			mkpte(PG_V, 0x1B0),
			mkpte(PG_V, 0x1B1),
			mkpte(PG_V, 0x1B2),
			mkpte(PG_V, 0x1B3),
			mkpte(PG_V, 0x1B4),
			mkpte(PG_V, 0x1B5),
			mkpte(PG_V, 0x1B6),
			mkpte(PG_V, 0x1B7),
			mkpte(PG_V, 0x1B8),
			mkpte(PG_V, 0x1B9),
			mkpte(PG_V, 0x1BA),
			mkpte(PG_V, 0x1BB),
			mkpte(PG_V, 0x1BC),
			mkpte(PG_V, 0x1BD),
			mkpte(PG_V, 0x1BE),
			mkpte(PG_V, 0x1BF),
			mkpte(PG_V, 0x1C0),
			mkpte(PG_V, 0x1C1),
			mkpte(PG_V, 0x1C2),
			mkpte(PG_V, 0x1C3),
			mkpte(PG_V, 0x1C4),
			mkpte(PG_V, 0x1C5),
			mkpte(PG_V, 0x1C6),
			mkpte(PG_V, 0x1C7),
			mkpte(PG_V, 0x1C8),
			mkpte(PG_V, 0x1C9),
			mkpte(PG_V, 0x1CA),
			mkpte(PG_V, 0x1CB),
			mkpte(PG_V, 0x1CC),
			mkpte(PG_V, 0x1CD),
			mkpte(PG_V, 0x1CE),
			mkpte(PG_V, 0x1CF),
			mkpte(PG_V, 0x1D0),
			mkpte(PG_V, 0x1D1),
			mkpte(PG_V, 0x1D2),
			mkpte(PG_V, 0x1D3),
			mkpte(PG_V, 0x1D4),
			mkpte(PG_V, 0x1D5),
			mkpte(PG_V, 0x1D6),
			mkpte(PG_V, 0x1D7),
			mkpte(PG_V, 0x1D8),
			mkpte(PG_V, 0x1D9),
			mkpte(PG_V, 0x1DA),
			mkpte(PG_V, 0x1DB),
			mkpte(PG_V, 0x1DC),
			mkpte(PG_V, 0x1DD),
			mkpte(PG_V, 0x1DE),
			mkpte(PG_V, 0x1DF),
			mkpte(PG_V, 0x1E0),
			mkpte(PG_V, 0x1E1),
			mkpte(PG_V, 0x1E2),
			mkpte(PG_V, 0x1E3),
			mkpte(PG_V, 0x1E4),
			mkpte(PG_V, 0x1E5),
			mkpte(PG_V, 0x1E6),
			mkpte(PG_V, 0x1E7),
			mkpte(PG_V, 0x1E8),
			mkpte(PG_V, 0x1E9),
			mkpte(PG_V, 0x1EA),
			mkpte(PG_V, 0x1EB),
			mkpte(PG_V, 0x1EC),
			mkpte(PG_V, 0x1ED),
			mkpte(PG_V, 0x1EE),
			mkpte(PG_V, 0x1EF),
			mkpte(PG_V, 0x1F0),
			mkpte(PG_V, 0x1F1),
			mkpte(PG_V, 0x1F2),
			mkpte(PG_V, 0x1F3),
			mkpte(PG_V, 0x1F4),
			mkpte(PG_V, 0x1F5),
			mkpte(PG_V, 0x1F6),
			mkpte(PG_V, 0x1F7),
			mkpte(PG_V, 0x1F8),
			mkpte(PG_V, 0x1F9),
			mkpte(PG_V, 0x1FA),
			mkpte(PG_V, 0x1FB),
			mkpte(PG_V, 0x1FC),
			mkpte(PG_V, 0x1FD),
			mkpte(PG_V, 0x1FE),
			mkpte(PG_V, 0x1FF),
			mkpte(PG_V, 0x200),
			mkpte(PG_V, 0x201),
			mkpte(PG_V, 0x202),
			mkpte(PG_V, 0x203),
			mkpte(PG_V, 0x204),
			mkpte(PG_V, 0x205),
			mkpte(PG_V, 0x206),
			mkpte(PG_V, 0x207),
			mkpte(PG_V, 0x208),
			mkpte(PG_V, 0x209),
			mkpte(PG_V, 0x20A),
			mkpte(PG_V, 0x20B),
			mkpte(PG_V, 0x20C),
			mkpte(PG_V, 0x20D),
			mkpte(PG_V, 0x20E),
			mkpte(PG_V, 0x20F),
			mkpte(PG_V, 0x210),
			mkpte(PG_V, 0x211),
			mkpte(PG_V, 0x212),
			mkpte(PG_V, 0x213),
			mkpte(PG_V, 0x214),
			mkpte(PG_V, 0x215),
			mkpte(PG_V, 0x216),
			mkpte(PG_V, 0x217),
			mkpte(PG_V, 0x218),
			mkpte(PG_V, 0x219),
			mkpte(PG_V, 0x21A),
			mkpte(PG_V, 0x21B),
			mkpte(PG_V, 0x21C),
			mkpte(PG_V, 0x21D),
			mkpte(PG_V, 0x21E),
			mkpte(PG_V, 0x21F),
			mkpte(PG_V, 0x220),
			mkpte(PG_V, 0x221),
			mkpte(PG_V, 0x222),
			mkpte(PG_V, 0x223),
			mkpte(PG_V, 0x224),
			mkpte(PG_V, 0x225),
			mkpte(PG_V, 0x226),
			mkpte(PG_V, 0x227),
			mkpte(PG_V, 0x228),
			mkpte(PG_V, 0x229),
			mkpte(PG_V, 0x22A),
			mkpte(PG_V, 0x22B),
			mkpte(PG_V, 0x22C),
			mkpte(PG_V, 0x22D),
			mkpte(PG_V, 0x22E),
			mkpte(PG_V, 0x22F),
			mkpte(PG_V, 0x230),
			mkpte(PG_V, 0x231),
			mkpte(PG_V, 0x232),
			mkpte(PG_V, 0x233),
			mkpte(PG_V, 0x234),
			mkpte(PG_V, 0x235),
			mkpte(PG_V, 0x236),
			mkpte(PG_V, 0x237),
			mkpte(PG_V, 0x238),
			mkpte(PG_V, 0x239),
			mkpte(PG_V, 0x23A),
			mkpte(PG_V, 0x23B),
			mkpte(PG_V, 0x23C),
			mkpte(PG_V, 0x23D),
			mkpte(PG_V, 0x23E),
			mkpte(PG_V, 0x23F),
			mkpte(PG_V, 0x240),
			mkpte(PG_V, 0x241),
			mkpte(PG_V, 0x242),
			mkpte(PG_V, 0x243),
			mkpte(PG_V, 0x244),
			mkpte(PG_V, 0x245),
			mkpte(PG_V, 0x246),
			mkpte(PG_V, 0x247),
			mkpte(PG_V, 0x248),
			mkpte(PG_V, 0x249),
			mkpte(PG_V, 0x24A),
			mkpte(PG_V, 0x24B),
			mkpte(PG_V, 0x24C),
			mkpte(PG_V, 0x24D),
			mkpte(PG_V, 0x24E),
			mkpte(PG_V, 0x24F),
			mkpte(PG_V, 0x250),
			mkpte(PG_V, 0x251),
			mkpte(PG_V, 0x252),
			mkpte(PG_V, 0x253),
			mkpte(PG_V, 0x254),
			mkpte(PG_V, 0x255),
			mkpte(PG_V, 0x256),
			mkpte(PG_V, 0x257),
			mkpte(PG_V, 0x258),
			mkpte(PG_V, 0x259),
			mkpte(PG_V, 0x25A),
			mkpte(PG_V, 0x25B),
			mkpte(PG_V, 0x25C),
			mkpte(PG_V, 0x25D),
			mkpte(PG_V, 0x25E),
			mkpte(PG_V, 0x25F),
			mkpte(PG_V, 0x260),
			mkpte(PG_V, 0x261),
			mkpte(PG_V, 0x262),
			mkpte(PG_V, 0x263),
			mkpte(PG_V, 0x264),
			mkpte(PG_V, 0x265),
			mkpte(PG_V, 0x266),
			mkpte(PG_V, 0x267),
			mkpte(PG_V, 0x268),
			mkpte(PG_V, 0x269),
			mkpte(PG_V, 0x26A),
			mkpte(PG_V, 0x26B),
			mkpte(PG_V, 0x26C),
			mkpte(PG_V, 0x26D),
			mkpte(PG_V, 0x26E),
			mkpte(PG_V, 0x26F),
			mkpte(PG_V, 0x270),
			mkpte(PG_V, 0x271),
			mkpte(PG_V, 0x272),
			mkpte(PG_V, 0x273),
			mkpte(PG_V, 0x274),
			mkpte(PG_V, 0x275),
			mkpte(PG_V, 0x276),
			mkpte(PG_V, 0x277),
			mkpte(PG_V, 0x278),
			mkpte(PG_V, 0x279),
			mkpte(PG_V, 0x27A),
			mkpte(PG_V, 0x27B),
			mkpte(PG_V, 0x27C),
			mkpte(PG_V, 0x27D),
			mkpte(PG_V, 0x27E),
			mkpte(PG_V, 0x27F),
			mkpte(PG_V, 0x280),
			mkpte(PG_V, 0x281),
			mkpte(PG_V, 0x282),
			mkpte(PG_V, 0x283),
			mkpte(PG_V, 0x284),
			mkpte(PG_V, 0x285),
			mkpte(PG_V, 0x286),
			mkpte(PG_V, 0x287),
			mkpte(PG_V, 0x288),
			mkpte(PG_V, 0x289),
			mkpte(PG_V, 0x28A),
			mkpte(PG_V, 0x28B),
			mkpte(PG_V, 0x28C),
			mkpte(PG_V, 0x28D),
			mkpte(PG_V, 0x28E),
			mkpte(PG_V, 0x28F),
			mkpte(PG_V, 0x290),
			mkpte(PG_V, 0x291),
			mkpte(PG_V, 0x292),
			mkpte(PG_V, 0x293),
			mkpte(PG_V, 0x294),
			mkpte(PG_V, 0x295),
			mkpte(PG_V, 0x296),
			mkpte(PG_V, 0x297),
			mkpte(PG_V, 0x298),
			mkpte(PG_V, 0x299),
			mkpte(PG_V, 0x29A),
			mkpte(PG_V, 0x29B),
			mkpte(PG_V, 0x29C),
			mkpte(PG_V, 0x29D),
			mkpte(PG_V, 0x29E),
			mkpte(PG_V, 0x29F),
			mkpte(PG_V, 0x2A0),
			mkpte(PG_V, 0x2A1),
			mkpte(PG_V, 0x2A2),
			mkpte(PG_V, 0x2A3),
			mkpte(PG_V, 0x2A4),
			mkpte(PG_V, 0x2A5),
			mkpte(PG_V, 0x2A6),
			mkpte(PG_V, 0x2A7),
			mkpte(PG_V, 0x2A8),
			mkpte(PG_V, 0x2A9),
			mkpte(PG_V, 0x2AA),
			mkpte(PG_V, 0x2AB),
			mkpte(PG_V, 0x2AC),
			mkpte(PG_V, 0x2AD),
			mkpte(PG_V, 0x2AE),
			mkpte(PG_V, 0x2AF),
			mkpte(PG_V, 0x2B0),
			mkpte(PG_V, 0x2B1),
			mkpte(PG_V, 0x2B2),
			mkpte(PG_V, 0x2B3),
			mkpte(PG_V, 0x2B4),
			mkpte(PG_V, 0x2B5),
			mkpte(PG_V, 0x2B6),
			mkpte(PG_V, 0x2B7),
			mkpte(PG_V, 0x2B8),
			mkpte(PG_V, 0x2B9),
			mkpte(PG_V, 0x2BA),
			mkpte(PG_V, 0x2BB),
			mkpte(PG_V, 0x2BC),
			mkpte(PG_V, 0x2BD),
			mkpte(PG_V, 0x2BE),
			mkpte(PG_V, 0x2BF),
			mkpte(PG_V, 0x2C0),
			mkpte(PG_V, 0x2C1),
			mkpte(PG_V, 0x2C2),
			mkpte(PG_V, 0x2C3),
			mkpte(PG_V, 0x2C4),
			mkpte(PG_V, 0x2C5),
			mkpte(PG_V, 0x2C6),
			mkpte(PG_V, 0x2C7),
			mkpte(PG_V, 0x2C8),
			mkpte(PG_V, 0x2C9),
			mkpte(PG_V, 0x2CA),
			mkpte(PG_V, 0x2CB),
			mkpte(PG_V, 0x2CC),
			mkpte(PG_V, 0x2CD),
			mkpte(PG_V, 0x2CE),
			mkpte(PG_V, 0x2CF),
			mkpte(PG_V, 0x2D0),
			mkpte(PG_V, 0x2D1),
			mkpte(PG_V, 0x2D2),
			mkpte(PG_V, 0x2D3),
			mkpte(PG_V, 0x2D4),
			mkpte(PG_V, 0x2D5),
			mkpte(PG_V, 0x2D6),
			mkpte(PG_V, 0x2D7),
			mkpte(PG_V, 0x2D8),
			mkpte(PG_V, 0x2D9),
			mkpte(PG_V, 0x2DA),
			mkpte(PG_V, 0x2DB),
			mkpte(PG_V, 0x2DC),
			mkpte(PG_V, 0x2DD),
			mkpte(PG_V, 0x2DE),
			mkpte(PG_V, 0x2DF),
			mkpte(PG_V, 0x2E0),
			mkpte(PG_V, 0x2E1),
			mkpte(PG_V, 0x2E2),
			mkpte(PG_V, 0x2E3),
			mkpte(PG_V, 0x2E4),
			mkpte(PG_V, 0x2E5),
			mkpte(PG_V, 0x2E6),
			mkpte(PG_V, 0x2E7),
			mkpte(PG_V, 0x2E8),
			mkpte(PG_V, 0x2E9),
			mkpte(PG_V, 0x2EA),
			mkpte(PG_V, 0x2EB),
			mkpte(PG_V, 0x2EC),
			mkpte(PG_V, 0x2ED),
			mkpte(PG_V, 0x2EE),
			mkpte(PG_V, 0x2EF),
			mkpte(PG_V, 0x2F0),
			mkpte(PG_V, 0x2F1),
			mkpte(PG_V, 0x2F2),
			mkpte(PG_V, 0x2F3),
			mkpte(PG_V, 0x2F4),
			mkpte(PG_V, 0x2F5),
			mkpte(PG_V, 0x2F6),
			mkpte(PG_V, 0x2F7),
			mkpte(PG_V, 0x2F8),
			mkpte(PG_V, 0x2F9),
			mkpte(PG_V, 0x2FA),
			mkpte(PG_V, 0x2FB),
			mkpte(PG_V, 0x2FC),
			mkpte(PG_V, 0x2FD),
			mkpte(PG_V, 0x2FE),
			mkpte(PG_V, 0x2FF),
			mkpte(PG_V, 0x300),
			mkpte(PG_V, 0x301),
			mkpte(PG_V, 0x302),
			mkpte(PG_V, 0x303),
			mkpte(PG_V, 0x304),
			mkpte(PG_V, 0x305),
			mkpte(PG_V, 0x306),
			mkpte(PG_V, 0x307),
			mkpte(PG_V, 0x308),
			mkpte(PG_V, 0x309),
			mkpte(PG_V, 0x30A),
			mkpte(PG_V, 0x30B),
			mkpte(PG_V, 0x30C),
			mkpte(PG_V, 0x30D),
			mkpte(PG_V, 0x30E),
			mkpte(PG_V, 0x30F),
			mkpte(PG_V, 0x310),
			mkpte(PG_V, 0x311),
			mkpte(PG_V, 0x312),
			mkpte(PG_V, 0x313),
			mkpte(PG_V, 0x314),
			mkpte(PG_V, 0x315),
			mkpte(PG_V, 0x316),
			mkpte(PG_V, 0x317),
			mkpte(PG_V, 0x318),
			mkpte(PG_V, 0x319),
			mkpte(PG_V, 0x31A),
			mkpte(PG_V, 0x31B),
			mkpte(PG_V, 0x31C),
			mkpte(PG_V, 0x31D),
			mkpte(PG_V, 0x31E),
			mkpte(PG_V, 0x31F),
			mkpte(PG_V, 0x320),
			mkpte(PG_V, 0x321),
			mkpte(PG_V, 0x322),
			mkpte(PG_V, 0x323),
			mkpte(PG_V, 0x324),
			mkpte(PG_V, 0x325),
			mkpte(PG_V, 0x326),
			mkpte(PG_V, 0x327),
			mkpte(PG_V, 0x328),
			mkpte(PG_V, 0x329),
			mkpte(PG_V, 0x32A),
			mkpte(PG_V, 0x32B),
			mkpte(PG_V, 0x32C),
			mkpte(PG_V, 0x32D),
			mkpte(PG_V, 0x32E),
			mkpte(PG_V, 0x32F),
			mkpte(PG_V, 0x330),
			mkpte(PG_V, 0x331),
			mkpte(PG_V, 0x332),
			mkpte(PG_V, 0x333),
			mkpte(PG_V, 0x334),
			mkpte(PG_V, 0x335),
			mkpte(PG_V, 0x336),
			mkpte(PG_V, 0x337),
			mkpte(PG_V, 0x338),
			mkpte(PG_V, 0x339),
			mkpte(PG_V, 0x33A),
			mkpte(PG_V, 0x33B),
			mkpte(PG_V, 0x33C),
			mkpte(PG_V, 0x33D),
			mkpte(PG_V, 0x33E),
			mkpte(PG_V, 0x33F),
			mkpte(PG_V, 0x340),
			mkpte(PG_V, 0x341),
			mkpte(PG_V, 0x342),
			mkpte(PG_V, 0x343),
			mkpte(PG_V, 0x344),
			mkpte(PG_V, 0x345),
			mkpte(PG_V, 0x346),
			mkpte(PG_V, 0x347),
			mkpte(PG_V, 0x348),
			mkpte(PG_V, 0x349),
			mkpte(PG_V, 0x34A),
			mkpte(PG_V, 0x34B),
			mkpte(PG_V, 0x34C),
			mkpte(PG_V, 0x34D),
			mkpte(PG_V, 0x34E),
			mkpte(PG_V, 0x34F),
			mkpte(PG_V, 0x350),
			mkpte(PG_V, 0x351),
			mkpte(PG_V, 0x352),
			mkpte(PG_V, 0x353),
			mkpte(PG_V, 0x354),
			mkpte(PG_V, 0x355),
			mkpte(PG_V, 0x356),
			mkpte(PG_V, 0x357),
			mkpte(PG_V, 0x358),
			mkpte(PG_V, 0x359),
			mkpte(PG_V, 0x35A),
			mkpte(PG_V, 0x35B),
			mkpte(PG_V, 0x35C),
			mkpte(PG_V, 0x35D),
			mkpte(PG_V, 0x35E),
			mkpte(PG_V, 0x35F),
			mkpte(PG_V, 0x360),
			mkpte(PG_V, 0x361),
			mkpte(PG_V, 0x362),
			mkpte(PG_V, 0x363),
			mkpte(PG_V, 0x364),
			mkpte(PG_V, 0x365),
			mkpte(PG_V, 0x366),
			mkpte(PG_V, 0x367),
			mkpte(PG_V, 0x368),
			mkpte(PG_V, 0x369),
			mkpte(PG_V, 0x36A),
			mkpte(PG_V, 0x36B),
			mkpte(PG_V, 0x36C),
			mkpte(PG_V, 0x36D),
			mkpte(PG_V, 0x36E),
			mkpte(PG_V, 0x36F),
			mkpte(PG_V, 0x370),
			mkpte(PG_V, 0x371),
			mkpte(PG_V, 0x372),
			mkpte(PG_V, 0x373),
			mkpte(PG_V, 0x374),
			mkpte(PG_V, 0x375),
			mkpte(PG_V, 0x376),
			mkpte(PG_V, 0x377),
			mkpte(PG_V, 0x378),
			mkpte(PG_V, 0x379),
			mkpte(PG_V, 0x37A),
			mkpte(PG_V, 0x37B),
			mkpte(PG_V, 0x37C),
			mkpte(PG_V, 0x37D),
			mkpte(PG_V, 0x37E),
			mkpte(PG_V, 0x37F),
			mkpte(PG_V, 0x380),
			mkpte(PG_V, 0x381),
			mkpte(PG_V, 0x382),
			mkpte(PG_V, 0x383),
			mkpte(PG_V, 0x384),
			mkpte(PG_V, 0x385),
			mkpte(PG_V, 0x386),
			mkpte(PG_V, 0x387),
			mkpte(PG_V, 0x388),
			mkpte(PG_V, 0x389),
			mkpte(PG_V, 0x38A),
			mkpte(PG_V, 0x38B),
			mkpte(PG_V, 0x38C),
			mkpte(PG_V, 0x38D),
			mkpte(PG_V, 0x38E),
			mkpte(PG_V, 0x38F),
			mkpte(PG_V, 0x390),
			mkpte(PG_V, 0x391),
			mkpte(PG_V, 0x392),
			mkpte(PG_V, 0x393),
			mkpte(PG_V, 0x394),
			mkpte(PG_V, 0x395),
			mkpte(PG_V, 0x396),
			mkpte(PG_V, 0x397),
			mkpte(PG_V, 0x398),
			mkpte(PG_V, 0x399),
			mkpte(PG_V, 0x39A),
			mkpte(PG_V, 0x39B),
			mkpte(PG_V, 0x39C),
			mkpte(PG_V, 0x39D),
			mkpte(PG_V, 0x39E),
			mkpte(PG_V, 0x39F),
			mkpte(PG_V, 0x3A0),
			mkpte(PG_V, 0x3A1),
			mkpte(PG_V, 0x3A2),
			mkpte(PG_V, 0x3A3),
			mkpte(PG_V, 0x3A4),
			mkpte(PG_V, 0x3A5),
			mkpte(PG_V, 0x3A6),
			mkpte(PG_V, 0x3A7),
			mkpte(PG_V, 0x3A8),
			mkpte(PG_V, 0x3A9),
			mkpte(PG_V, 0x3AA),
			mkpte(PG_V, 0x3AB),
			mkpte(PG_V, 0x3AC),
			mkpte(PG_V, 0x3AD),
			mkpte(PG_V, 0x3AE),
			mkpte(PG_V, 0x3AF),
			mkpte(PG_V, 0x3B0),
			mkpte(PG_V, 0x3B1),
			mkpte(PG_V, 0x3B2),
			mkpte(PG_V, 0x3B3),
			mkpte(PG_V, 0x3B4),
			mkpte(PG_V, 0x3B5),
			mkpte(PG_V, 0x3B6),
			mkpte(PG_V, 0x3B7),
			mkpte(PG_V, 0x3B8),
			mkpte(PG_V, 0x3B9),
			mkpte(PG_V, 0x3BA),
			mkpte(PG_V, 0x3BB),
			mkpte(PG_V, 0x3BC),
			mkpte(PG_V, 0x3BD),
			mkpte(PG_V, 0x3BE),
			mkpte(PG_V, 0x3BF),
			mkpte(PG_V, 0x3C0),
			mkpte(PG_V, 0x3C1),
			mkpte(PG_V, 0x3C2),
			mkpte(PG_V, 0x3C3),
			mkpte(PG_V, 0x3C4),
			mkpte(PG_V, 0x3C5),
			mkpte(PG_V, 0x3C6),
			mkpte(PG_V, 0x3C7),
			mkpte(PG_V, 0x3C8),
			mkpte(PG_V, 0x3C9),
			mkpte(PG_V, 0x3CA),
			mkpte(PG_V, 0x3CB),
			mkpte(PG_V, 0x3CC),
			mkpte(PG_V, 0x3CD),
			mkpte(PG_V, 0x3CE),
			mkpte(PG_V, 0x3CF),
			mkpte(PG_V, 0x3D0),
			mkpte(PG_V, 0x3D1),
			mkpte(PG_V, 0x3D2),
			mkpte(PG_V, 0x3D3),
			mkpte(PG_V, 0x3D4),
			mkpte(PG_V, 0x3D5),
			mkpte(PG_V, 0x3D6),
			mkpte(PG_V, 0x3D7),
			mkpte(PG_V, 0x3D8),
			mkpte(PG_V, 0x3D9),
			mkpte(PG_V, 0x3DA),
			mkpte(PG_V, 0x3DB),
			mkpte(PG_V, 0x3DC),
			mkpte(PG_V, 0x3DD),
			mkpte(PG_V, 0x3DE),
			mkpte(PG_V, 0x3DF),
			mkpte(PG_V, 0x3E0),
			mkpte(PG_V, 0x3E1),
			mkpte(PG_V, 0x3E2),
			mkpte(PG_V, 0x3E3),
			mkpte(PG_V, 0x3E4),
			mkpte(PG_V, 0x3E5),
			mkpte(PG_V, 0x3E6),
			mkpte(PG_V, 0x3E7),
			mkpte(PG_V, 0x3E8),
			mkpte(PG_V, 0x3E9),
			mkpte(PG_V, 0x3EA),
			mkpte(PG_V, 0x3EB),
			mkpte(PG_V, 0x3EC),
			mkpte(PG_V, 0x3ED),
			mkpte(PG_V, 0x3EE),
			mkpte(PG_V, 0x3EF),
			mkpte(PG_V, 0x3F0),
			mkpte(PG_V, 0x3F1),
			mkpte(PG_V, 0x3F2),
			mkpte(PG_V, 0x3F3),
			mkpte(PG_V, 0x3F4),
			mkpte(PG_V, 0x3F5),
			mkpte(PG_V, 0x3F6),
			mkpte(PG_V, 0x3F7),
			mkpte(PG_V, 0x3F8),
			mkpte(PG_V, 0x3F9),
			mkpte(PG_V, 0x3FA),
			mkpte(PG_V, 0x3FB),
			mkpte(PG_V, 0x3FC),
			mkpte(PG_V, 0x3FD),
			mkpte(PG_V, 0x3FE),
			mkpte(PG_V, 0x3FF)
};


/* The page table to allow PTM to access the PROMs */
kpte_t	kptn[NPGPT] = {
			mkpte(PG_V, 0xFFC00L),
			mkpte(PG_V, 0xFFC01L),
			mkpte(PG_V, 0xFFC02L),
			mkpte(PG_V, 0xFFC03L),
			mkpte(PG_V, 0xFFC04L),
			mkpte(PG_V, 0xFFC05L),
			mkpte(PG_V, 0xFFC06L),
			mkpte(PG_V, 0xFFC07L),
			mkpte(PG_V, 0xFFC08L),
			mkpte(PG_V, 0xFFC09L),
			mkpte(PG_V, 0xFFC0AL),
			mkpte(PG_V, 0xFFC0BL),
#ifdef WEITEK
/* 
	the following entry will be temporarily changed so that the Weitek
	chip may be detected;  it will be restored.  See the code in ml/misc.s
	that detects the Weitek chip and sets the "weitek_kind" variable.
*/
#endif
			mkpte(PG_V, 0xFFC0CL),
			mkpte(PG_V, 0xFFC0DL),
			mkpte(PG_V, 0xFFC0EL),
			mkpte(PG_V, 0xFFC0FL),
			mkpte(PG_V, 0xFFC10L),
			mkpte(PG_V, 0xFFC11L),
			mkpte(PG_V, 0xFFC12L),
			mkpte(PG_V, 0xFFC13L),
			mkpte(PG_V, 0xFFC14L),
			mkpte(PG_V, 0xFFC15L),
			mkpte(PG_V, 0xFFC16L),
			mkpte(PG_V, 0xFFC17L),
			mkpte(PG_V, 0xFFC18L),
			mkpte(PG_V, 0xFFC19L),
			mkpte(PG_V, 0xFFC1AL),
			mkpte(PG_V, 0xFFC1BL),
			mkpte(PG_V, 0xFFC1CL),
			mkpte(PG_V, 0xFFC1DL),
			mkpte(PG_V, 0xFFC1EL),
			mkpte(PG_V, 0xFFC1FL),
			mkpte(PG_V, 0xFFC20L),
			mkpte(PG_V, 0xFFC21L),
			mkpte(PG_V, 0xFFC22L),
			mkpte(PG_V, 0xFFC23L),
			mkpte(PG_V, 0xFFC24L),
			mkpte(PG_V, 0xFFC25L),
			mkpte(PG_V, 0xFFC26L),
			mkpte(PG_V, 0xFFC27L),
			mkpte(PG_V, 0xFFC28L),
			mkpte(PG_V, 0xFFC29L),
			mkpte(PG_V, 0xFFC2AL),
			mkpte(PG_V, 0xFFC2BL),
			mkpte(PG_V, 0xFFC2CL),
			mkpte(PG_V, 0xFFC2DL),
			mkpte(PG_V, 0xFFC2EL),
			mkpte(PG_V, 0xFFC2FL),
			mkpte(PG_V, 0xFFC30L),
			mkpte(PG_V, 0xFFC31L),
			mkpte(PG_V, 0xFFC32L),
			mkpte(PG_V, 0xFFC33L),
			mkpte(PG_V, 0xFFC34L),
			mkpte(PG_V, 0xFFC35L),
			mkpte(PG_V, 0xFFC36L),
			mkpte(PG_V, 0xFFC37L),
			mkpte(PG_V, 0xFFC38L),
			mkpte(PG_V, 0xFFC39L),
			mkpte(PG_V, 0xFFC3AL),
			mkpte(PG_V, 0xFFC3BL),
			mkpte(PG_V, 0xFFC3CL),
			mkpte(PG_V, 0xFFC3DL),
			mkpte(PG_V, 0xFFC3EL),
			mkpte(PG_V, 0xFFC3FL),
			mkpte(PG_V, 0xFFC40L),
			mkpte(PG_V, 0xFFC41L),
			mkpte(PG_V, 0xFFC42L),
			mkpte(PG_V, 0xFFC43L),
			mkpte(PG_V, 0xFFC44L),
			mkpte(PG_V, 0xFFC45L),
			mkpte(PG_V, 0xFFC46L),
			mkpte(PG_V, 0xFFC47L),
			mkpte(PG_V, 0xFFC48L),
			mkpte(PG_V, 0xFFC49L),
			mkpte(PG_V, 0xFFC4AL),
			mkpte(PG_V, 0xFFC4BL),
			mkpte(PG_V, 0xFFC4CL),
			mkpte(PG_V, 0xFFC4DL),
			mkpte(PG_V, 0xFFC4EL),
			mkpte(PG_V, 0xFFC4FL),
			mkpte(PG_V, 0xFFC50L),
			mkpte(PG_V, 0xFFC51L),
			mkpte(PG_V, 0xFFC52L),
			mkpte(PG_V, 0xFFC53L),
			mkpte(PG_V, 0xFFC54L),
			mkpte(PG_V, 0xFFC55L),
			mkpte(PG_V, 0xFFC56L),
			mkpte(PG_V, 0xFFC57L),
			mkpte(PG_V, 0xFFC58L),
			mkpte(PG_V, 0xFFC59L),
			mkpte(PG_V, 0xFFC5AL),
			mkpte(PG_V, 0xFFC5BL),
			mkpte(PG_V, 0xFFC5CL),
			mkpte(PG_V, 0xFFC5DL),
			mkpte(PG_V, 0xFFC5EL),
			mkpte(PG_V, 0xFFC5FL),
			mkpte(PG_V, 0xFFC60L),
			mkpte(PG_V, 0xFFC61L),
			mkpte(PG_V, 0xFFC62L),
			mkpte(PG_V, 0xFFC63L),
			mkpte(PG_V, 0xFFC64L),
			mkpte(PG_V, 0xFFC65L),
			mkpte(PG_V, 0xFFC66L),
			mkpte(PG_V, 0xFFC67L),
			mkpte(PG_V, 0xFFC68L),
			mkpte(PG_V, 0xFFC69L),
			mkpte(PG_V, 0xFFC6AL),
			mkpte(PG_V, 0xFFC6BL),
			mkpte(PG_V, 0xFFC6CL),
			mkpte(PG_V, 0xFFC6DL),
			mkpte(PG_V, 0xFFC6EL),
			mkpte(PG_V, 0xFFC6FL),
			mkpte(PG_V, 0xFFC70L),
			mkpte(PG_V, 0xFFC71L),
			mkpte(PG_V, 0xFFC72L),
			mkpte(PG_V, 0xFFC73L),
			mkpte(PG_V, 0xFFC74L),
			mkpte(PG_V, 0xFFC75L),
			mkpte(PG_V, 0xFFC76L),
			mkpte(PG_V, 0xFFC77L),
			mkpte(PG_V, 0xFFC78L),
			mkpte(PG_V, 0xFFC79L),
			mkpte(PG_V, 0xFFC7AL),
			mkpte(PG_V, 0xFFC7BL),
			mkpte(PG_V, 0xFFC7CL),
			mkpte(PG_V, 0xFFC7DL),
			mkpte(PG_V, 0xFFC7EL),
			mkpte(PG_V, 0xFFC7FL),
			mkpte(PG_V, 0xFFC80L),
			mkpte(PG_V, 0xFFC81L),
			mkpte(PG_V, 0xFFC82L),
			mkpte(PG_V, 0xFFC83L),
			mkpte(PG_V, 0xFFC84L),
			mkpte(PG_V, 0xFFC85L),
			mkpte(PG_V, 0xFFC86L),
			mkpte(PG_V, 0xFFC87L),
			mkpte(PG_V, 0xFFC88L),
			mkpte(PG_V, 0xFFC89L),
			mkpte(PG_V, 0xFFC8AL),
			mkpte(PG_V, 0xFFC8BL),
			mkpte(PG_V, 0xFFC8CL),
			mkpte(PG_V, 0xFFC8DL),
			mkpte(PG_V, 0xFFC8EL),
			mkpte(PG_V, 0xFFC8FL),
			mkpte(PG_V, 0xFFC90L),
			mkpte(PG_V, 0xFFC91L),
			mkpte(PG_V, 0xFFC92L),
			mkpte(PG_V, 0xFFC93L),
			mkpte(PG_V, 0xFFC94L),
			mkpte(PG_V, 0xFFC95L),
			mkpte(PG_V, 0xFFC96L),
			mkpte(PG_V, 0xFFC97L),
			mkpte(PG_V, 0xFFC98L),
			mkpte(PG_V, 0xFFC99L),
			mkpte(PG_V, 0xFFC9AL),
			mkpte(PG_V, 0xFFC9BL),
			mkpte(PG_V, 0xFFC9CL),
			mkpte(PG_V, 0xFFC9DL),
			mkpte(PG_V, 0xFFC9EL),
			mkpte(PG_V, 0xFFC9FL),
			mkpte(PG_V, 0xFFCA0L),
			mkpte(PG_V, 0xFFCA1L),
			mkpte(PG_V, 0xFFCA2L),
			mkpte(PG_V, 0xFFCA3L),
			mkpte(PG_V, 0xFFCA4L),
			mkpte(PG_V, 0xFFCA5L),
			mkpte(PG_V, 0xFFCA6L),
			mkpte(PG_V, 0xFFCA7L),
			mkpte(PG_V, 0xFFCA8L),
			mkpte(PG_V, 0xFFCA9L),
			mkpte(PG_V, 0xFFCAAL),
			mkpte(PG_V, 0xFFCABL),
			mkpte(PG_V, 0xFFCACL),
			mkpte(PG_V, 0xFFCADL),
			mkpte(PG_V, 0xFFCAEL),
			mkpte(PG_V, 0xFFCAFL),
			mkpte(PG_V, 0xFFCB0L),
			mkpte(PG_V, 0xFFCB1L),
			mkpte(PG_V, 0xFFCB2L),
			mkpte(PG_V, 0xFFCB3L),
			mkpte(PG_V, 0xFFCB4L),
			mkpte(PG_V, 0xFFCB5L),
			mkpte(PG_V, 0xFFCB6L),
			mkpte(PG_V, 0xFFCB7L),
			mkpte(PG_V, 0xFFCB8L),
			mkpte(PG_V, 0xFFCB9L),
			mkpte(PG_V, 0xFFCBAL),
			mkpte(PG_V, 0xFFCBBL),
			mkpte(PG_V, 0xFFCBCL),
			mkpte(PG_V, 0xFFCBDL),
			mkpte(PG_V, 0xFFCBEL),
			mkpte(PG_V, 0xFFCBFL),
			mkpte(PG_V, 0xFFCC0L),
			mkpte(PG_V, 0xFFCC1L),
			mkpte(PG_V, 0xFFCC2L),
			mkpte(PG_V, 0xFFCC3L),
			mkpte(PG_V, 0xFFCC4L),
			mkpte(PG_V, 0xFFCC5L),
			mkpte(PG_V, 0xFFCC6L),
			mkpte(PG_V, 0xFFCC7L),
			mkpte(PG_V, 0xFFCC8L),
			mkpte(PG_V, 0xFFCC9L),
			mkpte(PG_V, 0xFFCCAL),
			mkpte(PG_V, 0xFFCCBL),
			mkpte(PG_V, 0xFFCCCL),
			mkpte(PG_V, 0xFFCCDL),
			mkpte(PG_V, 0xFFCCEL),
			mkpte(PG_V, 0xFFCCFL),
			mkpte(PG_V, 0xFFCD0L),
			mkpte(PG_V, 0xFFCD1L),
			mkpte(PG_V, 0xFFCD2L),
			mkpte(PG_V, 0xFFCD3L),
			mkpte(PG_V, 0xFFCD4L),
			mkpte(PG_V, 0xFFCD5L),
			mkpte(PG_V, 0xFFCD6L),
			mkpte(PG_V, 0xFFCD7L),
			mkpte(PG_V, 0xFFCD8L),
			mkpte(PG_V, 0xFFCD9L),
			mkpte(PG_V, 0xFFCDAL),
			mkpte(PG_V, 0xFFCDBL),
			mkpte(PG_V, 0xFFCDCL),
			mkpte(PG_V, 0xFFCDDL),
			mkpte(PG_V, 0xFFCDEL),
			mkpte(PG_V, 0xFFCDFL),
			mkpte(PG_V, 0xFFCE0L),
			mkpte(PG_V, 0xFFCE1L),
			mkpte(PG_V, 0xFFCE2L),
			mkpte(PG_V, 0xFFCE3L),
			mkpte(PG_V, 0xFFCE4L),
			mkpte(PG_V, 0xFFCE5L),
			mkpte(PG_V, 0xFFCE6L),
			mkpte(PG_V, 0xFFCE7L),
			mkpte(PG_V, 0xFFCE8L),
			mkpte(PG_V, 0xFFCE9L),
			mkpte(PG_V, 0xFFCEAL),
			mkpte(PG_V, 0xFFCEBL),
			mkpte(PG_V, 0xFFCECL),
			mkpte(PG_V, 0xFFCEDL),
			mkpte(PG_V, 0xFFCEEL),
			mkpte(PG_V, 0xFFCEFL),
			mkpte(PG_V, 0xFFCF0L),
			mkpte(PG_V, 0xFFCF1L),
			mkpte(PG_V, 0xFFCF2L),
			mkpte(PG_V, 0xFFCF3L),
			mkpte(PG_V, 0xFFCF4L),
			mkpte(PG_V, 0xFFCF5L),
			mkpte(PG_V, 0xFFCF6L),
			mkpte(PG_V, 0xFFCF7L),
			mkpte(PG_V, 0xFFCF8L),
			mkpte(PG_V, 0xFFCF9L),
			mkpte(PG_V, 0xFFCFAL),
			mkpte(PG_V, 0xFFCFBL),
			mkpte(PG_V, 0xFFCFCL),
			mkpte(PG_V, 0xFFCFDL),
			mkpte(PG_V, 0xFFCFEL),
			mkpte(PG_V, 0xFFCFFL),
			mkpte(PG_V, 0xFFD00L),
			mkpte(PG_V, 0xFFD01L),
			mkpte(PG_V, 0xFFD02L),
			mkpte(PG_V, 0xFFD03L),
			mkpte(PG_V, 0xFFD04L),
			mkpte(PG_V, 0xFFD05L),
			mkpte(PG_V, 0xFFD06L),
			mkpte(PG_V, 0xFFD07L),
			mkpte(PG_V, 0xFFD08L),
			mkpte(PG_V, 0xFFD09L),
			mkpte(PG_V, 0xFFD0AL),
			mkpte(PG_V, 0xFFD0BL),
			mkpte(PG_V, 0xFFD0CL),
			mkpte(PG_V, 0xFFD0DL),
			mkpte(PG_V, 0xFFD0EL),
			mkpte(PG_V, 0xFFD0FL),
			mkpte(PG_V, 0xFFD10L),
			mkpte(PG_V, 0xFFD11L),
			mkpte(PG_V, 0xFFD12L),
			mkpte(PG_V, 0xFFD13L),
			mkpte(PG_V, 0xFFD14L),
			mkpte(PG_V, 0xFFD15L),
			mkpte(PG_V, 0xFFD16L),
			mkpte(PG_V, 0xFFD17L),
			mkpte(PG_V, 0xFFD18L),
			mkpte(PG_V, 0xFFD19L),
			mkpte(PG_V, 0xFFD1AL),
			mkpte(PG_V, 0xFFD1BL),
			mkpte(PG_V, 0xFFD1CL),
			mkpte(PG_V, 0xFFD1DL),
			mkpte(PG_V, 0xFFD1EL),
			mkpte(PG_V, 0xFFD1FL),
			mkpte(PG_V, 0xFFD20L),
			mkpte(PG_V, 0xFFD21L),
			mkpte(PG_V, 0xFFD22L),
			mkpte(PG_V, 0xFFD23L),
			mkpte(PG_V, 0xFFD24L),
			mkpte(PG_V, 0xFFD25L),
			mkpte(PG_V, 0xFFD26L),
			mkpte(PG_V, 0xFFD27L),
			mkpte(PG_V, 0xFFD28L),
			mkpte(PG_V, 0xFFD29L),
			mkpte(PG_V, 0xFFD2AL),
			mkpte(PG_V, 0xFFD2BL),
			mkpte(PG_V, 0xFFD2CL),
			mkpte(PG_V, 0xFFD2DL),
			mkpte(PG_V, 0xFFD2EL),
			mkpte(PG_V, 0xFFD2FL),
			mkpte(PG_V, 0xFFD30L),
			mkpte(PG_V, 0xFFD31L),
			mkpte(PG_V, 0xFFD32L),
			mkpte(PG_V, 0xFFD33L),
			mkpte(PG_V, 0xFFD34L),
			mkpte(PG_V, 0xFFD35L),
			mkpte(PG_V, 0xFFD36L),
			mkpte(PG_V, 0xFFD37L),
			mkpte(PG_V, 0xFFD38L),
			mkpte(PG_V, 0xFFD39L),
			mkpte(PG_V, 0xFFD3AL),
			mkpte(PG_V, 0xFFD3BL),
			mkpte(PG_V, 0xFFD3CL),
			mkpte(PG_V, 0xFFD3DL),
			mkpte(PG_V, 0xFFD3EL),
			mkpte(PG_V, 0xFFD3FL),
			mkpte(PG_V, 0xFFD40L),
			mkpte(PG_V, 0xFFD41L),
			mkpte(PG_V, 0xFFD42L),
			mkpte(PG_V, 0xFFD43L),
			mkpte(PG_V, 0xFFD44L),
			mkpte(PG_V, 0xFFD45L),
			mkpte(PG_V, 0xFFD46L),
			mkpte(PG_V, 0xFFD47L),
			mkpte(PG_V, 0xFFD48L),
			mkpte(PG_V, 0xFFD49L),
			mkpte(PG_V, 0xFFD4AL),
			mkpte(PG_V, 0xFFD4BL),
			mkpte(PG_V, 0xFFD4CL),
			mkpte(PG_V, 0xFFD4DL),
			mkpte(PG_V, 0xFFD4EL),
			mkpte(PG_V, 0xFFD4FL),
			mkpte(PG_V, 0xFFD50L),
			mkpte(PG_V, 0xFFD51L),
			mkpte(PG_V, 0xFFD52L),
			mkpte(PG_V, 0xFFD53L),
			mkpte(PG_V, 0xFFD54L),
			mkpte(PG_V, 0xFFD55L),
			mkpte(PG_V, 0xFFD56L),
			mkpte(PG_V, 0xFFD57L),
			mkpte(PG_V, 0xFFD58L),
			mkpte(PG_V, 0xFFD59L),
			mkpte(PG_V, 0xFFD5AL),
			mkpte(PG_V, 0xFFD5BL),
			mkpte(PG_V, 0xFFD5CL),
			mkpte(PG_V, 0xFFD5DL),
			mkpte(PG_V, 0xFFD5EL),
			mkpte(PG_V, 0xFFD5FL),
			mkpte(PG_V, 0xFFD60L),
			mkpte(PG_V, 0xFFD61L),
			mkpte(PG_V, 0xFFD62L),
			mkpte(PG_V, 0xFFD63L),
			mkpte(PG_V, 0xFFD64L),
			mkpte(PG_V, 0xFFD65L),
			mkpte(PG_V, 0xFFD66L),
			mkpte(PG_V, 0xFFD67L),
			mkpte(PG_V, 0xFFD68L),
			mkpte(PG_V, 0xFFD69L),
			mkpte(PG_V, 0xFFD6AL),
			mkpte(PG_V, 0xFFD6BL),
			mkpte(PG_V, 0xFFD6CL),
			mkpte(PG_V, 0xFFD6DL),
			mkpte(PG_V, 0xFFD6EL),
			mkpte(PG_V, 0xFFD6FL),
			mkpte(PG_V, 0xFFD70L),
			mkpte(PG_V, 0xFFD71L),
			mkpte(PG_V, 0xFFD72L),
			mkpte(PG_V, 0xFFD73L),
			mkpte(PG_V, 0xFFD74L),
			mkpte(PG_V, 0xFFD75L),
			mkpte(PG_V, 0xFFD76L),
			mkpte(PG_V, 0xFFD77L),
			mkpte(PG_V, 0xFFD78L),
			mkpte(PG_V, 0xFFD79L),
			mkpte(PG_V, 0xFFD7AL),
			mkpte(PG_V, 0xFFD7BL),
			mkpte(PG_V, 0xFFD7CL),
			mkpte(PG_V, 0xFFD7DL),
			mkpte(PG_V, 0xFFD7EL),
			mkpte(PG_V, 0xFFD7FL),
			mkpte(PG_V, 0xFFD80L),
			mkpte(PG_V, 0xFFD81L),
			mkpte(PG_V, 0xFFD82L),
			mkpte(PG_V, 0xFFD83L),
			mkpte(PG_V, 0xFFD84L),
			mkpte(PG_V, 0xFFD85L),
			mkpte(PG_V, 0xFFD86L),
			mkpte(PG_V, 0xFFD87L),
			mkpte(PG_V, 0xFFD88L),
			mkpte(PG_V, 0xFFD89L),
			mkpte(PG_V, 0xFFD8AL),
			mkpte(PG_V, 0xFFD8BL),
			mkpte(PG_V, 0xFFD8CL),
			mkpte(PG_V, 0xFFD8DL),
			mkpte(PG_V, 0xFFD8EL),
			mkpte(PG_V, 0xFFD8FL),
			mkpte(PG_V, 0xFFD90L),
			mkpte(PG_V, 0xFFD91L),
			mkpte(PG_V, 0xFFD92L),
			mkpte(PG_V, 0xFFD93L),
			mkpte(PG_V, 0xFFD94L),
			mkpte(PG_V, 0xFFD95L),
			mkpte(PG_V, 0xFFD96L),
			mkpte(PG_V, 0xFFD97L),
			mkpte(PG_V, 0xFFD98L),
			mkpte(PG_V, 0xFFD99L),
			mkpte(PG_V, 0xFFD9AL),
			mkpte(PG_V, 0xFFD9BL),
			mkpte(PG_V, 0xFFD9CL),
			mkpte(PG_V, 0xFFD9DL),
			mkpte(PG_V, 0xFFD9EL),
			mkpte(PG_V, 0xFFD9FL),
			mkpte(PG_V, 0xFFDA0L),
			mkpte(PG_V, 0xFFDA1L),
			mkpte(PG_V, 0xFFDA2L),
			mkpte(PG_V, 0xFFDA3L),
			mkpte(PG_V, 0xFFDA4L),
			mkpte(PG_V, 0xFFDA5L),
			mkpte(PG_V, 0xFFDA6L),
			mkpte(PG_V, 0xFFDA7L),
			mkpte(PG_V, 0xFFDA8L),
			mkpte(PG_V, 0xFFDA9L),
			mkpte(PG_V, 0xFFDAAL),
			mkpte(PG_V, 0xFFDABL),
			mkpte(PG_V, 0xFFDACL),
			mkpte(PG_V, 0xFFDADL),
			mkpte(PG_V, 0xFFDAEL),
			mkpte(PG_V, 0xFFDAFL),
			mkpte(PG_V, 0xFFDB0L),
			mkpte(PG_V, 0xFFDB1L),
			mkpte(PG_V, 0xFFDB2L),
			mkpte(PG_V, 0xFFDB3L),
			mkpte(PG_V, 0xFFDB4L),
			mkpte(PG_V, 0xFFDB5L),
			mkpte(PG_V, 0xFFDB6L),
			mkpte(PG_V, 0xFFDB7L),
			mkpte(PG_V, 0xFFDB8L),
			mkpte(PG_V, 0xFFDB9L),
			mkpte(PG_V, 0xFFDBAL),
			mkpte(PG_V, 0xFFDBBL),
			mkpte(PG_V, 0xFFDBCL),
			mkpte(PG_V, 0xFFDBDL),
			mkpte(PG_V, 0xFFDBEL),
			mkpte(PG_V, 0xFFDBFL),
			mkpte(PG_V, 0xFFDC0L),
			mkpte(PG_V, 0xFFDC1L),
			mkpte(PG_V, 0xFFDC2L),
			mkpte(PG_V, 0xFFDC3L),
			mkpte(PG_V, 0xFFDC4L),
			mkpte(PG_V, 0xFFDC5L),
			mkpte(PG_V, 0xFFDC6L),
			mkpte(PG_V, 0xFFDC7L),
			mkpte(PG_V, 0xFFDC8L),
			mkpte(PG_V, 0xFFDC9L),
			mkpte(PG_V, 0xFFDCAL),
			mkpte(PG_V, 0xFFDCBL),
			mkpte(PG_V, 0xFFDCCL),
			mkpte(PG_V, 0xFFDCDL),
			mkpte(PG_V, 0xFFDCEL),
			mkpte(PG_V, 0xFFDCFL),
			mkpte(PG_V, 0xFFDD0L),
			mkpte(PG_V, 0xFFDD1L),
			mkpte(PG_V, 0xFFDD2L),
			mkpte(PG_V, 0xFFDD3L),
			mkpte(PG_V, 0xFFDD4L),
			mkpte(PG_V, 0xFFDD5L),
			mkpte(PG_V, 0xFFDD6L),
			mkpte(PG_V, 0xFFDD7L),
			mkpte(PG_V, 0xFFDD8L),
			mkpte(PG_V, 0xFFDD9L),
			mkpte(PG_V, 0xFFDDAL),
			mkpte(PG_V, 0xFFDDBL),
			mkpte(PG_V, 0xFFDDCL),
			mkpte(PG_V, 0xFFDDDL),
			mkpte(PG_V, 0xFFDDEL),
			mkpte(PG_V, 0xFFDDFL),
			mkpte(PG_V, 0xFFDE0L),
			mkpte(PG_V, 0xFFDE1L),
			mkpte(PG_V, 0xFFDE2L),
			mkpte(PG_V, 0xFFDE3L),
			mkpte(PG_V, 0xFFDE4L),
			mkpte(PG_V, 0xFFDE5L),
			mkpte(PG_V, 0xFFDE6L),
			mkpte(PG_V, 0xFFDE7L),
			mkpte(PG_V, 0xFFDE8L),
			mkpte(PG_V, 0xFFDE9L),
			mkpte(PG_V, 0xFFDEAL),
			mkpte(PG_V, 0xFFDEBL),
			mkpte(PG_V, 0xFFDECL),
			mkpte(PG_V, 0xFFDEDL),
			mkpte(PG_V, 0xFFDEEL),
			mkpte(PG_V, 0xFFDEFL),
			mkpte(PG_V, 0xFFDF0L),
			mkpte(PG_V, 0xFFDF1L),
			mkpte(PG_V, 0xFFDF2L),
			mkpte(PG_V, 0xFFDF3L),
			mkpte(PG_V, 0xFFDF4L),
			mkpte(PG_V, 0xFFDF5L),
			mkpte(PG_V, 0xFFDF6L),
			mkpte(PG_V, 0xFFDF7L),
			mkpte(PG_V, 0xFFDF8L),
			mkpte(PG_V, 0xFFDF9L),
			mkpte(PG_V, 0xFFDFAL),
			mkpte(PG_V, 0xFFDFBL),
			mkpte(PG_V, 0xFFDFCL),
			mkpte(PG_V, 0xFFDFDL),
			mkpte(PG_V, 0xFFDFEL),
			mkpte(PG_V, 0xFFDFFL),
			mkpte(PG_V, 0xFFE00L),
			mkpte(PG_V, 0xFFE01L),
			mkpte(PG_V, 0xFFE02L),
			mkpte(PG_V, 0xFFE03L),
			mkpte(PG_V, 0xFFE04L),
			mkpte(PG_V, 0xFFE05L),
			mkpte(PG_V, 0xFFE06L),
			mkpte(PG_V, 0xFFE07L),
			mkpte(PG_V, 0xFFE08L),
			mkpte(PG_V, 0xFFE09L),
			mkpte(PG_V, 0xFFE0AL),
			mkpte(PG_V, 0xFFE0BL),
			mkpte(PG_V, 0xFFE0CL),
			mkpte(PG_V, 0xFFE0DL),
			mkpte(PG_V, 0xFFE0EL),
			mkpte(PG_V, 0xFFE0FL),
			mkpte(PG_V, 0xFFE10L),
			mkpte(PG_V, 0xFFE11L),
			mkpte(PG_V, 0xFFE12L),
			mkpte(PG_V, 0xFFE13L),
			mkpte(PG_V, 0xFFE14L),
			mkpte(PG_V, 0xFFE15L),
			mkpte(PG_V, 0xFFE16L),
			mkpte(PG_V, 0xFFE17L),
			mkpte(PG_V, 0xFFE18L),
			mkpte(PG_V, 0xFFE19L),
			mkpte(PG_V, 0xFFE1AL),
			mkpte(PG_V, 0xFFE1BL),
			mkpte(PG_V, 0xFFE1CL),
			mkpte(PG_V, 0xFFE1DL),
			mkpte(PG_V, 0xFFE1EL),
			mkpte(PG_V, 0xFFE1FL),
			mkpte(PG_V, 0xFFE20L),
			mkpte(PG_V, 0xFFE21L),
			mkpte(PG_V, 0xFFE22L),
			mkpte(PG_V, 0xFFE23L),
			mkpte(PG_V, 0xFFE24L),
			mkpte(PG_V, 0xFFE25L),
			mkpte(PG_V, 0xFFE26L),
			mkpte(PG_V, 0xFFE27L),
			mkpte(PG_V, 0xFFE28L),
			mkpte(PG_V, 0xFFE29L),
			mkpte(PG_V, 0xFFE2AL),
			mkpte(PG_V, 0xFFE2BL),
			mkpte(PG_V, 0xFFE2CL),
			mkpte(PG_V, 0xFFE2DL),
			mkpte(PG_V, 0xFFE2EL),
			mkpte(PG_V, 0xFFE2FL),
			mkpte(PG_V, 0xFFE30L),
			mkpte(PG_V, 0xFFE31L),
			mkpte(PG_V, 0xFFE32L),
			mkpte(PG_V, 0xFFE33L),
			mkpte(PG_V, 0xFFE34L),
			mkpte(PG_V, 0xFFE35L),
			mkpte(PG_V, 0xFFE36L),
			mkpte(PG_V, 0xFFE37L),
			mkpte(PG_V, 0xFFE38L),
			mkpte(PG_V, 0xFFE39L),
			mkpte(PG_V, 0xFFE3AL),
			mkpte(PG_V, 0xFFE3BL),
			mkpte(PG_V, 0xFFE3CL),
			mkpte(PG_V, 0xFFE3DL),
			mkpte(PG_V, 0xFFE3EL),
			mkpte(PG_V, 0xFFE3FL),
			mkpte(PG_V, 0xFFE40L),
			mkpte(PG_V, 0xFFE41L),
			mkpte(PG_V, 0xFFE42L),
			mkpte(PG_V, 0xFFE43L),
			mkpte(PG_V, 0xFFE44L),
			mkpte(PG_V, 0xFFE45L),
			mkpte(PG_V, 0xFFE46L),
			mkpte(PG_V, 0xFFE47L),
			mkpte(PG_V, 0xFFE48L),
			mkpte(PG_V, 0xFFE49L),
			mkpte(PG_V, 0xFFE4AL),
			mkpte(PG_V, 0xFFE4BL),
			mkpte(PG_V, 0xFFE4CL),
			mkpte(PG_V, 0xFFE4DL),
			mkpte(PG_V, 0xFFE4EL),
			mkpte(PG_V, 0xFFE4FL),
			mkpte(PG_V, 0xFFE50L),
			mkpte(PG_V, 0xFFE51L),
			mkpte(PG_V, 0xFFE52L),
			mkpte(PG_V, 0xFFE53L),
			mkpte(PG_V, 0xFFE54L),
			mkpte(PG_V, 0xFFE55L),
			mkpte(PG_V, 0xFFE56L),
			mkpte(PG_V, 0xFFE57L),
			mkpte(PG_V, 0xFFE58L),
			mkpte(PG_V, 0xFFE59L),
			mkpte(PG_V, 0xFFE5AL),
			mkpte(PG_V, 0xFFE5BL),
			mkpte(PG_V, 0xFFE5CL),
			mkpte(PG_V, 0xFFE5DL),
			mkpte(PG_V, 0xFFE5EL),
			mkpte(PG_V, 0xFFE5FL),
			mkpte(PG_V, 0xFFE60L),
			mkpte(PG_V, 0xFFE61L),
			mkpte(PG_V, 0xFFE62L),
			mkpte(PG_V, 0xFFE63L),
			mkpte(PG_V, 0xFFE64L),
			mkpte(PG_V, 0xFFE65L),
			mkpte(PG_V, 0xFFE66L),
			mkpte(PG_V, 0xFFE67L),
			mkpte(PG_V, 0xFFE68L),
			mkpte(PG_V, 0xFFE69L),
			mkpte(PG_V, 0xFFE6AL),
			mkpte(PG_V, 0xFFE6BL),
			mkpte(PG_V, 0xFFE6CL),
			mkpte(PG_V, 0xFFE6DL),
			mkpte(PG_V, 0xFFE6EL),
			mkpte(PG_V, 0xFFE6FL),
			mkpte(PG_V, 0xFFE70L),
			mkpte(PG_V, 0xFFE71L),
			mkpte(PG_V, 0xFFE72L),
			mkpte(PG_V, 0xFFE73L),
			mkpte(PG_V, 0xFFE74L),
			mkpte(PG_V, 0xFFE75L),
			mkpte(PG_V, 0xFFE76L),
			mkpte(PG_V, 0xFFE77L),
			mkpte(PG_V, 0xFFE78L),
			mkpte(PG_V, 0xFFE79L),
			mkpte(PG_V, 0xFFE7AL),
			mkpte(PG_V, 0xFFE7BL),
			mkpte(PG_V, 0xFFE7CL),
			mkpte(PG_V, 0xFFE7DL),
			mkpte(PG_V, 0xFFE7EL),
			mkpte(PG_V, 0xFFE7FL),
			mkpte(PG_V, 0xFFE80L),
			mkpte(PG_V, 0xFFE81L),
			mkpte(PG_V, 0xFFE82L),
			mkpte(PG_V, 0xFFE83L),
			mkpte(PG_V, 0xFFE84L),
			mkpte(PG_V, 0xFFE85L),
			mkpte(PG_V, 0xFFE86L),
			mkpte(PG_V, 0xFFE87L),
			mkpte(PG_V, 0xFFE88L),
			mkpte(PG_V, 0xFFE89L),
			mkpte(PG_V, 0xFFE8AL),
			mkpte(PG_V, 0xFFE8BL),
			mkpte(PG_V, 0xFFE8CL),
			mkpte(PG_V, 0xFFE8DL),
			mkpte(PG_V, 0xFFE8EL),
			mkpte(PG_V, 0xFFE8FL),
			mkpte(PG_V, 0xFFE90L),
			mkpte(PG_V, 0xFFE91L),
			mkpte(PG_V, 0xFFE92L),
			mkpte(PG_V, 0xFFE93L),
			mkpte(PG_V, 0xFFE94L),
			mkpte(PG_V, 0xFFE95L),
			mkpte(PG_V, 0xFFE96L),
			mkpte(PG_V, 0xFFE97L),
			mkpte(PG_V, 0xFFE98L),
			mkpte(PG_V, 0xFFE99L),
			mkpte(PG_V, 0xFFE9AL),
			mkpte(PG_V, 0xFFE9BL),
			mkpte(PG_V, 0xFFE9CL),
			mkpte(PG_V, 0xFFE9DL),
			mkpte(PG_V, 0xFFE9EL),
			mkpte(PG_V, 0xFFE9FL),
			mkpte(PG_V, 0xFFEA0L),
			mkpte(PG_V, 0xFFEA1L),
			mkpte(PG_V, 0xFFEA2L),
			mkpte(PG_V, 0xFFEA3L),
			mkpte(PG_V, 0xFFEA4L),
			mkpte(PG_V, 0xFFEA5L),
			mkpte(PG_V, 0xFFEA6L),
			mkpte(PG_V, 0xFFEA7L),
			mkpte(PG_V, 0xFFEA8L),
			mkpte(PG_V, 0xFFEA9L),
			mkpte(PG_V, 0xFFEAAL),
			mkpte(PG_V, 0xFFEABL),
			mkpte(PG_V, 0xFFEACL),
			mkpte(PG_V, 0xFFEADL),
			mkpte(PG_V, 0xFFEAEL),
			mkpte(PG_V, 0xFFEAFL),
			mkpte(PG_V, 0xFFEB0L),
			mkpte(PG_V, 0xFFEB1L),
			mkpte(PG_V, 0xFFEB2L),
			mkpte(PG_V, 0xFFEB3L),
			mkpte(PG_V, 0xFFEB4L),
			mkpte(PG_V, 0xFFEB5L),
			mkpte(PG_V, 0xFFEB6L),
			mkpte(PG_V, 0xFFEB7L),
			mkpte(PG_V, 0xFFEB8L),
			mkpte(PG_V, 0xFFEB9L),
			mkpte(PG_V, 0xFFEBAL),
			mkpte(PG_V, 0xFFEBBL),
			mkpte(PG_V, 0xFFEBCL),
			mkpte(PG_V, 0xFFEBDL),
			mkpte(PG_V, 0xFFEBEL),
			mkpte(PG_V, 0xFFEBFL),
			mkpte(PG_V, 0xFFEC0L),
			mkpte(PG_V, 0xFFEC1L),
			mkpte(PG_V, 0xFFEC2L),
			mkpte(PG_V, 0xFFEC3L),
			mkpte(PG_V, 0xFFEC4L),
			mkpte(PG_V, 0xFFEC5L),
			mkpte(PG_V, 0xFFEC6L),
			mkpte(PG_V, 0xFFEC7L),
			mkpte(PG_V, 0xFFEC8L),
			mkpte(PG_V, 0xFFEC9L),
			mkpte(PG_V, 0xFFECAL),
			mkpte(PG_V, 0xFFECBL),
			mkpte(PG_V, 0xFFECCL),
			mkpte(PG_V, 0xFFECDL),
			mkpte(PG_V, 0xFFECEL),
			mkpte(PG_V, 0xFFECFL),
			mkpte(PG_V, 0xFFED0L),
			mkpte(PG_V, 0xFFED1L),
			mkpte(PG_V, 0xFFED2L),
			mkpte(PG_V, 0xFFED3L),
			mkpte(PG_V, 0xFFED4L),
			mkpte(PG_V, 0xFFED5L),
			mkpte(PG_V, 0xFFED6L),
			mkpte(PG_V, 0xFFED7L),
			mkpte(PG_V, 0xFFED8L),
			mkpte(PG_V, 0xFFED9L),
			mkpte(PG_V, 0xFFEDAL),
			mkpte(PG_V, 0xFFEDBL),
			mkpte(PG_V, 0xFFEDCL),
			mkpte(PG_V, 0xFFEDDL),
			mkpte(PG_V, 0xFFEDEL),
			mkpte(PG_V, 0xFFEDFL),
			mkpte(PG_V, 0xFFEE0L),
			mkpte(PG_V, 0xFFEE1L),
			mkpte(PG_V, 0xFFEE2L),
			mkpte(PG_V, 0xFFEE3L),
			mkpte(PG_V, 0xFFEE4L),
			mkpte(PG_V, 0xFFEE5L),
			mkpte(PG_V, 0xFFEE6L),
			mkpte(PG_V, 0xFFEE7L),
			mkpte(PG_V, 0xFFEE8L),
			mkpte(PG_V, 0xFFEE9L),
			mkpte(PG_V, 0xFFEEAL),
			mkpte(PG_V, 0xFFEEBL),
			mkpte(PG_V, 0xFFEECL),
			mkpte(PG_V, 0xFFEEDL),
			mkpte(PG_V, 0xFFEEEL),
			mkpte(PG_V, 0xFFEEFL),
			mkpte(PG_V, 0xFFEF0L),
			mkpte(PG_V, 0xFFEF1L),
			mkpte(PG_V, 0xFFEF2L),
			mkpte(PG_V, 0xFFEF3L),
			mkpte(PG_V, 0xFFEF4L),
			mkpte(PG_V, 0xFFEF5L),
			mkpte(PG_V, 0xFFEF6L),
			mkpte(PG_V, 0xFFEF7L),
			mkpte(PG_V, 0xFFEF8L),
			mkpte(PG_V, 0xFFEF9L),
			mkpte(PG_V, 0xFFEFAL),
			mkpte(PG_V, 0xFFEFBL),
			mkpte(PG_V, 0xFFEFCL),
			mkpte(PG_V, 0xFFEFDL),
			mkpte(PG_V, 0xFFEFEL),
			mkpte(PG_V, 0xFFEFFL),
			mkpte(PG_V, 0xFFF00L),
			mkpte(PG_V, 0xFFF01L),
			mkpte(PG_V, 0xFFF02L),
			mkpte(PG_V, 0xFFF03L),
			mkpte(PG_V, 0xFFF04L),
			mkpte(PG_V, 0xFFF05L),
			mkpte(PG_V, 0xFFF06L),
			mkpte(PG_V, 0xFFF07L),
			mkpte(PG_V, 0xFFF08L),
			mkpte(PG_V, 0xFFF09L),
			mkpte(PG_V, 0xFFF0AL),
			mkpte(PG_V, 0xFFF0BL),
			mkpte(PG_V, 0xFFF0CL),
			mkpte(PG_V, 0xFFF0DL),
			mkpte(PG_V, 0xFFF0EL),
			mkpte(PG_V, 0xFFF0FL),
			mkpte(PG_V, 0xFFF10L),
			mkpte(PG_V, 0xFFF11L),
			mkpte(PG_V, 0xFFF12L),
			mkpte(PG_V, 0xFFF13L),
			mkpte(PG_V, 0xFFF14L),
			mkpte(PG_V, 0xFFF15L),
			mkpte(PG_V, 0xFFF16L),
			mkpte(PG_V, 0xFFF17L),
			mkpte(PG_V, 0xFFF18L),
			mkpte(PG_V, 0xFFF19L),
			mkpte(PG_V, 0xFFF1AL),
			mkpte(PG_V, 0xFFF1BL),
			mkpte(PG_V, 0xFFF1CL),
			mkpte(PG_V, 0xFFF1DL),
			mkpte(PG_V, 0xFFF1EL),
			mkpte(PG_V, 0xFFF1FL),
			mkpte(PG_V, 0xFFF20L),
			mkpte(PG_V, 0xFFF21L),
			mkpte(PG_V, 0xFFF22L),
			mkpte(PG_V, 0xFFF23L),
			mkpte(PG_V, 0xFFF24L),
			mkpte(PG_V, 0xFFF25L),
			mkpte(PG_V, 0xFFF26L),
			mkpte(PG_V, 0xFFF27L),
			mkpte(PG_V, 0xFFF28L),
			mkpte(PG_V, 0xFFF29L),
			mkpte(PG_V, 0xFFF2AL),
			mkpte(PG_V, 0xFFF2BL),
			mkpte(PG_V, 0xFFF2CL),
			mkpte(PG_V, 0xFFF2DL),
			mkpte(PG_V, 0xFFF2EL),
			mkpte(PG_V, 0xFFF2FL),
			mkpte(PG_V, 0xFFF30L),
			mkpte(PG_V, 0xFFF31L),
			mkpte(PG_V, 0xFFF32L),
			mkpte(PG_V, 0xFFF33L),
			mkpte(PG_V, 0xFFF34L),
			mkpte(PG_V, 0xFFF35L),
			mkpte(PG_V, 0xFFF36L),
			mkpte(PG_V, 0xFFF37L),
			mkpte(PG_V, 0xFFF38L),
			mkpte(PG_V, 0xFFF39L),
			mkpte(PG_V, 0xFFF3AL),
			mkpte(PG_V, 0xFFF3BL),
			mkpte(PG_V, 0xFFF3CL),
			mkpte(PG_V, 0xFFF3DL),
			mkpte(PG_V, 0xFFF3EL),
			mkpte(PG_V, 0xFFF3FL),
			mkpte(PG_V, 0xFFF40L),
			mkpte(PG_V, 0xFFF41L),
			mkpte(PG_V, 0xFFF42L),
			mkpte(PG_V, 0xFFF43L),
			mkpte(PG_V, 0xFFF44L),
			mkpte(PG_V, 0xFFF45L),
			mkpte(PG_V, 0xFFF46L),
			mkpte(PG_V, 0xFFF47L),
			mkpte(PG_V, 0xFFF48L),
			mkpte(PG_V, 0xFFF49L),
			mkpte(PG_V, 0xFFF4AL),
			mkpte(PG_V, 0xFFF4BL),
			mkpte(PG_V, 0xFFF4CL),
			mkpte(PG_V, 0xFFF4DL),
			mkpte(PG_V, 0xFFF4EL),
			mkpte(PG_V, 0xFFF4FL),
			mkpte(PG_V, 0xFFF50L),
			mkpte(PG_V, 0xFFF51L),
			mkpte(PG_V, 0xFFF52L),
			mkpte(PG_V, 0xFFF53L),
			mkpte(PG_V, 0xFFF54L),
			mkpte(PG_V, 0xFFF55L),
			mkpte(PG_V, 0xFFF56L),
			mkpte(PG_V, 0xFFF57L),
			mkpte(PG_V, 0xFFF58L),
			mkpte(PG_V, 0xFFF59L),
			mkpte(PG_V, 0xFFF5AL),
			mkpte(PG_V, 0xFFF5BL),
			mkpte(PG_V, 0xFFF5CL),
			mkpte(PG_V, 0xFFF5DL),
			mkpte(PG_V, 0xFFF5EL),
			mkpte(PG_V, 0xFFF5FL),
			mkpte(PG_V, 0xFFF60L),
			mkpte(PG_V, 0xFFF61L),
			mkpte(PG_V, 0xFFF62L),
			mkpte(PG_V, 0xFFF63L),
			mkpte(PG_V, 0xFFF64L),
			mkpte(PG_V, 0xFFF65L),
			mkpte(PG_V, 0xFFF66L),
			mkpte(PG_V, 0xFFF67L),
			mkpte(PG_V, 0xFFF68L),
			mkpte(PG_V, 0xFFF69L),
			mkpte(PG_V, 0xFFF6AL),
			mkpte(PG_V, 0xFFF6BL),
			mkpte(PG_V, 0xFFF6CL),
			mkpte(PG_V, 0xFFF6DL),
			mkpte(PG_V, 0xFFF6EL),
			mkpte(PG_V, 0xFFF6FL),
	/* The following selectors are set up for DMON */
	/* The top 1/2 meg is set linear = physical (prom space)  */
	/* The 64k below that is mapped to 0 for DMON's ram space */
			mkpte(PG_V, 0x00000L),	/* 0xFFF70000 linear */
			mkpte(PG_V, 0x00001L),	/* 0xFFF71000 linear */
			mkpte(PG_V, 0x00002L),	/* 0xFFF72000 linear */
			mkpte(PG_V, 0x00003L),	/* 0xFFF73000 linear */
			mkpte(PG_V, 0x00004L),	/* 0xFFF74000 linear */
			mkpte(PG_V, 0x00005L),	/* 0xFFF75000 linear */
			mkpte(PG_V, 0x00006L),	/* 0xFFF76000 linear */
			mkpte(PG_V, 0x00007L),	/* 0xFFF77000 linear */
			mkpte(PG_V, 0x00008L),	/* 0xFFF78000 linear */
			mkpte(PG_V, 0x00009L),	/* 0xFFF79000 linear */
			mkpte(PG_V, 0x0000AL),	/* 0xFFF7a000 linear */
			mkpte(PG_V, 0x0000BL),	/* 0xFFF7b000 linear */
			mkpte(PG_V, 0x0000CL),	/* 0xFFF7c000 linear */
			mkpte(PG_V, 0x0000DL),	/* 0xFFF7d000 linear */
			mkpte(PG_V, 0x0000EL),	/* 0xFFF7e000 linear */
			mkpte(PG_V, 0x0000FL),	/* 0xFFF7f000 linear */
			mkpte(PG_V, 0xFFF80L),
			mkpte(PG_V, 0xFFF81L),
			mkpte(PG_V, 0xFFF82L),
			mkpte(PG_V, 0xFFF83L),
			mkpte(PG_V, 0xFFF84L),
			mkpte(PG_V, 0xFFF85L),
			mkpte(PG_V, 0xFFF86L),
			mkpte(PG_V, 0xFFF87L),
			mkpte(PG_V, 0xFFF88L),
			mkpte(PG_V, 0xFFF89L),
			mkpte(PG_V, 0xFFF8AL),
			mkpte(PG_V, 0xFFF8BL),
			mkpte(PG_V, 0xFFF8CL),
			mkpte(PG_V, 0xFFF8DL),
			mkpte(PG_V, 0xFFF8EL),
			mkpte(PG_V, 0xFFF8FL),
			mkpte(PG_V, 0xFFF90L),
			mkpte(PG_V, 0xFFF91L),
			mkpte(PG_V, 0xFFF92L),
			mkpte(PG_V, 0xFFF93L),
			mkpte(PG_V, 0xFFF94L),
			mkpte(PG_V, 0xFFF95L),
			mkpte(PG_V, 0xFFF96L),
			mkpte(PG_V, 0xFFF97L),
			mkpte(PG_V, 0xFFF98L),
			mkpte(PG_V, 0xFFF99L),
			mkpte(PG_V, 0xFFF9AL),
			mkpte(PG_V, 0xFFF9BL),
			mkpte(PG_V, 0xFFF9CL),
			mkpte(PG_V, 0xFFF9DL),
			mkpte(PG_V, 0xFFF9EL),
			mkpte(PG_V, 0xFFF9FL),
			mkpte(PG_V, 0xFFFA0L),
			mkpte(PG_V, 0xFFFA1L),
			mkpte(PG_V, 0xFFFA2L),
			mkpte(PG_V, 0xFFFA3L),
			mkpte(PG_V, 0xFFFA4L),
			mkpte(PG_V, 0xFFFA5L),
			mkpte(PG_V, 0xFFFA6L),
			mkpte(PG_V, 0xFFFA7L),
			mkpte(PG_V, 0xFFFA8L),
			mkpte(PG_V, 0xFFFA9L),
			mkpte(PG_V, 0xFFFAAL),
			mkpte(PG_V, 0xFFFABL),
			mkpte(PG_V, 0xFFFACL),
			mkpte(PG_V, 0xFFFADL),
			mkpte(PG_V, 0xFFFAEL),
			mkpte(PG_V, 0xFFFAFL),
			mkpte(PG_V, 0xFFFB0L),
			mkpte(PG_V, 0xFFFB1L),
			mkpte(PG_V, 0xFFFB2L),
			mkpte(PG_V, 0xFFFB3L),
			mkpte(PG_V, 0xFFFB4L),
			mkpte(PG_V, 0xFFFB5L),
			mkpte(PG_V, 0xFFFB6L),
			mkpte(PG_V, 0xFFFB7L),
			mkpte(PG_V, 0xFFFB8L),
			mkpte(PG_V, 0xFFFB9L),
			mkpte(PG_V, 0xFFFBAL),
			mkpte(PG_V, 0xFFFBBL),
			mkpte(PG_V, 0xFFFBCL),
			mkpte(PG_V, 0xFFFBDL),
			mkpte(PG_V, 0xFFFBEL),
			mkpte(PG_V, 0xFFFBFL),
			mkpte(PG_V, 0xFFFC0L),
			mkpte(PG_V, 0xFFFC1L),
			mkpte(PG_V, 0xFFFC2L),
			mkpte(PG_V, 0xFFFC3L),
			mkpte(PG_V, 0xFFFC4L),
			mkpte(PG_V, 0xFFFC5L),
			mkpte(PG_V, 0xFFFC6L),
			mkpte(PG_V, 0xFFFC7L),
			mkpte(PG_V, 0xFFFC8L),
			mkpte(PG_V, 0xFFFC9L),
			mkpte(PG_V, 0xFFFCAL),
			mkpte(PG_V, 0xFFFCBL),
			mkpte(PG_V, 0xFFFCCL),
			mkpte(PG_V, 0xFFFCDL),
			mkpte(PG_V, 0xFFFCEL),
			mkpte(PG_V, 0xFFFCFL),
			mkpte(PG_V, 0xFFFD0L),
			mkpte(PG_V, 0xFFFD1L),
			mkpte(PG_V, 0xFFFD2L),
			mkpte(PG_V, 0xFFFD3L),
			mkpte(PG_V, 0xFFFD4L),
			mkpte(PG_V, 0xFFFD5L),
			mkpte(PG_V, 0xFFFD6L),
			mkpte(PG_V, 0xFFFD7L),
			mkpte(PG_V, 0xFFFD8L),
			mkpte(PG_V, 0xFFFD9L),
			mkpte(PG_V, 0xFFFDAL),
			mkpte(PG_V, 0xFFFDBL),
			mkpte(PG_V, 0xFFFDCL),
			mkpte(PG_V, 0xFFFDDL),
			mkpte(PG_V, 0xFFFDEL),
			mkpte(PG_V, 0xFFFDFL),
			mkpte(PG_V, 0xFFFE0L),
			mkpte(PG_V, 0xFFFE1L),
			mkpte(PG_V, 0xFFFE2L),
			mkpte(PG_V, 0xFFFE3L),
			mkpte(PG_V, 0xFFFE4L),
			mkpte(PG_V, 0xFFFE5L),
			mkpte(PG_V, 0xFFFE6L),
			mkpte(PG_V, 0xFFFE7L),
			mkpte(PG_V, 0xFFFE8L),
			mkpte(PG_V, 0xFFFE9L),
			mkpte(PG_V, 0xFFFEAL),
			mkpte(PG_V, 0xFFFEBL),
			mkpte(PG_V, 0xFFFECL),
			mkpte(PG_V, 0xFFFEDL),
			mkpte(PG_V, 0xFFFEEL),
			mkpte(PG_V, 0xFFFEFL),
			mkpte(PG_V, 0xFFFF0L),
			mkpte(PG_V, 0xFFFF1L),
			mkpte(PG_V, 0xFFFF2L),
			mkpte(PG_V, 0xFFFF3L),
			mkpte(PG_V, 0xFFFF4L),
			mkpte(PG_V, 0xFFFF5L),
			mkpte(PG_V, 0xFFFF6L),
			mkpte(PG_V, 0xFFFF7L),
			mkpte(PG_V, 0xFFFF8L),
			mkpte(PG_V, 0xFFFF9L),
			mkpte(PG_V, 0xFFFFAL),
			mkpte(PG_V, 0xFFFFBL),
			mkpte(PG_V, 0xFFFFCL),
			mkpte(PG_V, 0xFFFFDL),
			mkpte(PG_V, 0xFFFFEL),
			mkpte(PG_V, 0xFFFFFL)
};
