/*	Copyright (c) 1990 UNIX System Laboratories, Inc.	*/
/*	Copyright (c) 1984, 1986, 1987, 1988, 1989, 1990 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF     	*/
/*	UNIX System Laboratories, Inc.                     	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	Copyright (c) 1988, 1989 Intel Corp.		*/
/*	  All Rights Reserved	*/
/*
 *	INTEL CORPORATION PROPRIETARY INFORMATION
 *
 *	This software is supplied under the terms of a license
 *	agreement or nondisclosure agreement with Intel Corpo-
 *	ration and may not be copied or disclosed except in
 *	accordance with the terms of that agreement.
 */
/*
 *
 *	Copyright (c) 1989 by Interactive Systems Corporation. 
 *	All rights reserved.  Contains confidential information and
 *	trade secrets proprietary to
 *
 *		Interactive Systems Corporation
 *		2401 Colorado Avenue
 *		Santa Monica, California  90404
 */

#ident	"@(#)at:uts/i386/io/kd/vtables.c	1.2.3.2"

#include "sys/types.h"
#include "sys/at_ansi.h"
#include "sys/kd.h"
#include "sys/vid.h"
#include "sys/vdc.h"
#ifdef	EVC
#include "sys/evc.h"
#endif /* EVC */

/*
 * Register values for CGA modes
 */

struct cgareginfo	kd_cgaregtab[] = {
	{ M_ENABLE|M_BLINK|M_BW,	  0x30, 0 }, /* 40x25 A/N B&W */
	{ M_ENABLE|M_BLINK,		  0x30, 0 }, /* 40x25 A/N Col */
	{ M_ENABLE|M_BLINK|M_BW|M_ALPHA80,0x30, 1 }, /* 80x25 A/N B&W */
	{ M_ENABLE|M_BLINK|M_ALPHA80,	  0x30, 1 }, /* 80x25 A/N Col */
	{ M_ENABLE|M_BW|M_GRAPH,	  0x30, 2 }, /* 320x200 Graph B&W */
	{ M_ENABLE|M_GRAPH,		  0x30, 2 }, /* 320x200 Graph Col */
	{ M_ENABLE|M_HIGHRES|M_BW|M_GRAPH,0x3f, 2 }, /* 640x200 Graph B&W */
};

/*
 * kd_cgainittab[] contains the values used in programming the 6845 CRT
 * controller registers for the various modes.  This array is indexed by the
 * cga_index value taken from the desired entry in the cgareginfo array.
 */

struct m6845init kd_cgainittab[] = {
	/* 40X25 alphanumeric */
	{ 0x38, 0x28, 0x2d, 0x0a, 0x1f, 0x06, 0x19, 0x1c,
	  0x02, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00 },
	/* 80X25 alphanumeric */
	{ 0x71, 0x50, 0x5a, 0x0a, 0x1f, 0x06, 0x19, 0x1c,
	  0x02, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00 },
	/* Graphics */
	{ 0x38, 0x28, 0x2d, 0x0a, 0x7f, 0x06, 0x64, 0x70,
	  0x02, 0x01, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00 },
};

struct m6845init kd_monoinittab[] = {
	{ 0x61, 0x50, 0x52, 0x0f, 0x19, 0x06, 0x19, 0x19,
	  0x02, 0x0d, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00 },
};

/*
 * initialization for the EGA.
 * There are 5 sets of registers to be initialized: sequencer, miscellaneous,
 * CRT controller, attribute, and graphics.  The values depend on the mode of
 * operation.  The initialization table is an array of structures, within each
 * of which there are five fields corresponding to the five sets of registers,
 * and this table is indexed by a mode index.
 *
 * The mode index is determined from the switch settings on the EGA, which
 * tell us what kind of display is attached.  For the indicated display, we
 * then initialize an appropriate alphanumeric mode.
 *
 * The switch setting is converted to a mode number by using it as an index into
 * the following table.  The switch setting is represented by a number between
 * 0 and 15, with switch 3 being the high-order bit, switch 0 being the
 * low-order bit, and logical 0 meaning the switch is closed (on).  -1 marks
 * reserved modes.
 */

char kd_swmode[] = {
	DM_C40x25, DM_C80x25, DM_C80x25, DM_ENH_C80x25, DM_EGAMONO80x25,
	DM_EGAMONO80x25, DM_C40x25, DM_C80x25, DM_C80x25, DM_ENH_C80x25,
	DM_EGAMONO80x25, DM_EGAMONO80x25, DM_ENH_C80x25, DM_EGAMONO80x25,
	DM_C80x25, DM_ATT_640, -1
};

struct b_param	kd_inittab[] = {
	/* DM_ENH_B80x43 (mode 10), 80x43 black & white text */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x03, 0x00, 0x03,
	/* misc */
	0xa7,
	/* CRTC */
	0x5b, 0x4f, 0x53, 0x37, 0x51, 0x5b, 0x6c, 0x1f,
	0x00, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00,
	0x5e, 0x2b, 0x57, 0x28, 0x0f, 0x5e, 0x0a, 0xa3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11,
	0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x08, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
	/* DM_ENH_C80x43 (mode 11), 80x43 color text */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x03, 0x00, 0x03,
	/* misc */
	0xa7,
	/* CRTC */
	0x5b, 0x4f, 0x53, 0x37, 0x51, 0x5b, 0x6c, 0x1f,
	0x00, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00,
	0x5e, 0x2b, 0x57, 0x28, 0x0f, 0x5e, 0x0a, 0xa3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11,
	0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x08, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
  /* DM_ENH_CGA (mode 23), 80x25 Super-Vu ATT  400 line emulation  (CGA) */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x03, 0x00, 0x03,
	/* misc */
	0xa7,
	/* CRTC */
	0x72, 0x4f, 0x57, 0x2e, 0x59, 0x46, 0xae, 0x1d, 
	0x00, 0x0d, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00,
	0x91, 0x31, 0x8f, 0x28, 0x11, 0x91, 0x1f, 0xa3, 0xff,
	/* graphics */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x08, 0x00, 0x0f, 0x00,
	/* attributes */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
	/* DM_ATT_640 (mode 24), Super-Vu ATT 640 x 400 x 16 color */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06, 
	/* misc */
	0xa7,
	/* CRTC */
	0x72, 0x4f, 0x57, 0x2e, 0x59, 0x66, 0xae, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x8f, 0x2f, 0x8f, 0x28, 0x11, 0x8f, 0x1f, 0xe3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,
	/* DM_ATT_640 (mode 24), Super-Vu ATT 640 x 400 x 16 color on VDC-600 */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06, 
	/* misc */
	0x63,
	/* CRTC */
	0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80, 0xbf, 0x1f,
	0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x9c, 0x8e, 0x8f, 0x28, 0x0f, 0x96, 0xb9, 0xe3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,
	/* DM_VDC800x600E */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06, 
	/* misc */
	0xef,
	/* CRTC */
	0x7b, 0x63, 0x64, 0x9e, 0x69, 0x92, 0x6f, 0xf0,
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x58, 0x8a, 0x57, 0x32, 0x00, 0x58, 0x6f, 0xe3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,
	/* DM_VDC640x400V */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x0e, 
	/* misc */
	0x63,
	/* CRTC */
	0x5f, 0x4f, 0x50, 0x82, 0x53, 0x9f, 0xbf, 0x1f,
	0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x9c, 0x8e, 0x8f, 0x50, 0x40, 0x96, 0xb9, 0xa3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09,
	0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x41, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x05, 0x0f, 0xff,
#ifdef	EVC
	/* DM_EVC640x480V */
        /* software parameters */
        0x00, 0x00, 0x00, 0x00, 0x00,
        /* sequencer */
        0x01, 0x0f, 0x00, 0x0e,
        /* misc NOTE: Feature ctrl = 01. */
        0xeb,
        /* CRTC */
        0xc3, 0x9f, 0xa2, 0x86, 0xa8, 0x00, 0x0b, 0x3e,
        0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x07, 0x87,
        0xea, 0x8c, 0xdf, 0x50, 0x00, 0xe7, 0x04, 0xe3, 0xff,
        /* attributes */
        0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09,
        0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x41, 0x00, 0x0f, 0x00,
        /* graphics */
        0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x05, 0x0f, 0xff,

	/* DM_EVC1024x768D and DM_EVC1024x768E */
        /* software parameters */
        0x00, 0x00, 0x00, 0x00, 0x00,
        /* sequencer */
        0x01, 0x0f, 0x00, 0x06,
        /* misc NOTE: Feature ctrl = 02. */
        0x2b,
        /* CRTC */
        0xa3, 0x7f, 0x80, 0x86, 0x87, 0x81, 0x23, 0xfd,
        0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x87,
        0x02, 0x85, 0xff, 0x40, 0x00, 0x00, 0x23, 0xe3, 0xff,
        /* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
        0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0f, 0xff,
#endif	/*EVC*/
#ifdef EVGA
/* Type 0, EGA 	640x350 16 color */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xa7,
	/* CRTC */
	0x5b, 0x4f, 0x53, 0x37, 0x52, 0x00, 0x6c, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x5e, 0x2b, 0x5d, 0x28, 0x0f, 0x5f, 0x0a, 0xe3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,


/* Type 1, Paradise PEGA2 enhanced video mode 640x480 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xab,
	/* CRTC */
	0x66, 0x4f, 0x53, 0x3d, 0x55, 0x1f, 0xfa, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xe1, 0x29, 0xdf, 0x28, 0x0f, 0xe0, 0x1a, 0xe3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,

/* Type 2, VGA 640x480 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xe3,
	/* CRTC */
	0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80, 0x0b, 0x3e,
	0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xea, 0x0c, 0xdf, 0x28, 0x00, 0xe7, 0x04, 0xe3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,

/* Type 3, VEGA 720x540 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xef,
	/* CRTC */
	0x73, 0x59, 0x5a, 0x96, 0x60, 0x8c, 0x1b, 0x1f,
	0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0e, 0x20, 0x0b, 0x2d, 0x00, 0x0e, 0x16, 0xe7, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,

/* Type 4, VEGA 800x600 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xef,
	/* CRTC */
	0x7d, 0x63, 0x64, 0x80, 0x6b, 0x16, 0x3a, 0x1f,
	0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x2f, 0x21, 0x2b, 0x32, 0x00, 0x2e, 0x38, 0xe7, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,

/* Type 5, Tseng Labs 800x560 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xeb,
	/* CRTC */
	0x7b, 0x63, 0x68, 0x98, 0x68, 0x8d, 0x5e, 0xf0,
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x3c, 0x23, 0x2f, 0x32, 0x00, 0x34, 0x52, 0xc3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,

/* Type 6, Tseng Labs 800x600 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xeb,
	/* CRTC */
	0x7b, 0x63, 0x68, 0x98, 0x68, 0x8d, 0x86, 0xf0,
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x64, 0x27, 0x57, 0x32, 0x00, 0x5c, 0x7a, 0xc3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,

/* Type 7, Tseng Labs 960x720 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xbf,
	/* CRTC */
	0x43, 0x3b, 0x3c, 0x03, 0x3a, 0x1f, 0xf1, 0xe0,
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xd3, 0x37, 0xcf, 0x1e, 0x00, 0xd3, 0xd7, 0xc3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0f, 0xff,

/* Type 8, Tseng Labs 1024x768 interlaced 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0x3f,
	/* CRTC */
	0x4a, 0x3f, 0x41, 0x0d, 0x44, 0x0c, 0x97, 0x1f,
	0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x80, 0x24, 0x7f, 0x20, 0x00, 0x80, 0x95, 0xc3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0f, 0xff,

/* Type 9, Tseng Labs 1024x768 non-interlaced 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0x2f,
	/* CRTC */
	0x4e, 0x3f, 0x40, 0x11, 0x44, 0x0f, 0x26, 0xfd,
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x04, 0xff, 0x20, 0x00, 0x04, 0x23, 0xc3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0f, 0xff,

/* Type 10, Sigma VGA/H 800x600 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xaf,
	/* CRTC */
	0x7b, 0x63, 0x67, 0x3a, 0x67, 0x3a, 0x37, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x2e, 0x00, 0x2b, 0x32, 0x00, 0x2e, 0x17, 0xe7, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,

/* Type 11, Paradise PVGA1A chip 800x600 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xef,
	/* CRTC */
	0x7b, 0x63, 0x64, 0x80, 0x66, 0x12, 0x70, 0xf0,
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x59, 0x86, 0x57, 0x32, 0x00, 0x59, 0x69, 0xe3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,

/* Type 12, Video 7 V7VGA 640x480 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xe3,
	/* CRTC */
	0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80, 0x0b, 0x3e,
	0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xea, 0x0c, 0xdf, 0x28, 0x00, 0xe7, 0x04, 0xe3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,

/* Type 13, Video 7 V7VGA 720x540 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x09, 0x0f, 0x00, 0x06,
	/* misc */
	0xe7,
	/* CRTC */
	0x6f, 0x59, 0x5a, 0x92, 0x5c, 0x85, 0x47, 0xf0,
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x26, 0x08, 0x1b, 0x2d, 0x00, 0x24, 0x3f, 0xe3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,

/* Type 14, Video 7 V7VGA 800x600 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xef,
	/* CRTC */
/*
	0x7f, 0x63, 0x64, 0x82, 0x67, 0x18, 0x77, 0xf0,
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x5c, 0x0e, 0x57, 0x32, 0x00, 0x5c, 0x74, 0xe3, 0xff,
*/
	0x85, 0x63, 0x64, 0x88, 0x67, 0x18, 0x77, 0xf0,
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x5c, 0x0e, 0x57, 0x32, 0x00, 0x5c, 0x74, 0xe3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,

/* Type 15, Video 7 V7VGA 1024x768 2 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x05, 0x03, 0x00, 0x02,
	/* misc */
	0xe7,
	/* CRTC */
	0xa3, 0x7f, 0x83, 0xa5, 0x8d, 0x82, 0x29, 0xfd,
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x07, 0x8a, 0xff, 0x20, 0x00, 0x07, 0x22, 0xeb, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x01, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0xff,

/* Type 16, Video 7 V7VGA 1024x768 4 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x05, 0x0f, 0x00, 0x02,
	/* misc */
	0xe7,
	/* CRTC */
	0xa3, 0x7f, 0x83, 0xa5, 0x8d, 0x82, 0x29, 0xfd,
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x07, 0x8a, 0xff, 0x20, 0x00, 0x07, 0x22, 0xeb, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x05, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0xff,

/* Type 17, Video 7 V7VGA 1024x768 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xc7,
	/* CRTC */
	0xa3, 0x7f, 0x82, 0xa6, 0x8d, 0x82, 0x29, 0xfd,
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x07, 0x8a, 0xff, 0x40, 0x00, 0x07, 0x22, 0xe3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0f, 0xff,

/* Type 18, Genoa EGA 640x480 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xaf,
	/* CRTC */
	0x6d, 0x4f, 0x53, 0x37, 0x55, 0x59, 0xf5, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xe0, 0x23, 0xdf, 0x28, 0x08, 0xe0, 0x04, 0xe3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,

/* Type 19, Genoa EGA 800x600 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xab,
	/* CRTC */
	0x86, 0x63, 0x66, 0x3e, 0x66, 0x3e, 0x3b, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x2f, 0x38, 0x2c, 0x32, 0x08, 0x2d, 0x18, 0xe7, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,

/* Type 20, Orchid Designer 800x600 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x03, 0x0f, 0x00, 0x06,
	/* misc */
	0xe7,
	/* CRTC */
	0x77, 0x63, 0x64, 0x06, 0x68, 0xaa, 0x77, 0xf0,
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x63, 0x22, 0x57, 0x32, 0x00, 0x5b, 0x75, 0xc3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,

/* Type 21, Genoa SuperVGA 5200 800x600 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xef,
	/* CRTC */
	0x7b, 0x63, 0x68, 0x98, 0x68, 0x8d, 0x86, 0xf0,
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x64, 0x27, 0x57, 0x32, 0x00, 0x5c, 0x7a, 0xc3, 0xff,
/*
	0x49, 0x31, 0x32, 0x0b, 0x32, 0x01, 0x6e, 0xf0,
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x58, 0x23, 0x57, 0x19, 0x00, 0x5b, 0x65, 0xc3, 0xff,
*/
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,

/* Type 22, Dell VGA (Video 7) 720x540 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xe3,
	/* CRTC */
	0x6f, 0x59, 0x5a, 0x92, 0x5c, 0x85, 0x47, 0xf0,
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x26, 0x08, 0x1b, 0x2d, 0x00, 0x24, 0x3f, 0xe3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,

/* Type 23, Dell VGA (Video 7) 800x600 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xe7,
	/* CRTC */
	0x85, 0x63, 0x64, 0x88, 0x67, 0x18, 0x77, 0xf0,
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x5c, 0x0e, 0x57, 0x32, 0x00, 0x5c, 0x74, 0xe3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,


/* Type 24, ATI VGA Wonder 800x600 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xef,
	/* CRTC */
	0x7a, 0x63, 0x65, 0x9d, 0x69, 0x92, 0x38, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x2d, 0x0e, 0x2c, 0x32, 0x0f, 0x30, 0x34, 0xe7, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,


/* Type 25, Western Digital Paradise VGA 1024  1024x768 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0x23,
	/* CRTC */
	0x99, 0x7f, 0x7f, 0x1c, 0x83, 0x19, 0x97, 0x1f,
	0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0x83, 0x7f, 0x40, 0x00, 0x7f, 0x96, 0xe3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0f, 0xff,


/* Type 26, Western Digital Paradise VGA 1024  800x600 16 colors */
	/* software parameters */
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* sequencer */
	0x01, 0x0f, 0x00, 0x06,
	/* misc */
	0xeb,
	/* CRTC */
	0x7b, 0x63, 0x64, 0x9e, 0x69, 0x92, 0x6f, 0xf0,
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x58, 0x8a, 0x57, 0x32, 0x00, 0x58, 0x6f, 0xe3, 0xff,
	/* attributes */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00,
	/* graphics */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,


#endif /* EVGA */
};

/*
 * Defines to make kd_modeinfo table easier to read.
 */

#define MBSE	MONO_BASE
#define MSZE	MONO_SIZE
#define CBSE	COLOR_BASE
#define CSZE	COLOR_SIZE
#define EBSE	EGA_BASE
#define ESZE	EGA_SIZE
#define ELSZ	EGA_LGSIZE

#define F8x8	FONT8x8
#define F8x14m	FONT8x14m
#define F8x14	FONT8x14
#define F9x16	FONT9x16
#define GRAPH	0

#define BIOS	KD_BIOS
#define TBLE	KD_TBLE

#ifdef	EVC
#define VBSE	EVC_BASE
#define VSZE	EVC_SIZE
#define EHSZ	EVC_HGSIZE
#endif	/*EVC*/

/*
 * EGA mode information.
 */

struct modeinfo kd_modeinfo[] = {
	{ 40,  25,    0,    0, 1, CBSE, CSZE,   F8x8, BIOS,  0, 2}, /*  0  */
	{ 40,  25,    0,    0, 1, CBSE, CSZE,   F8x8, BIOS,  1, 2}, /*  1  */
	{ 80,  25,    0,    0, 1, CBSE, CSZE,   F8x8, BIOS,  2, 2}, /*  2  */
	{ 80,  25,    0,    0, 1, CBSE, CSZE,   F8x8, BIOS,  3, 2}, /*  3  */
	{  0,   0,  320,  200, 1, CBSE, CSZE,  GRAPH, BIOS,  4, 2}, /*  4  */
	{  0,   0,  320,  200, 1, CBSE, CSZE,  GRAPH, BIOS,  5, 2}, /*  5  */
	{  0,   0,  640,  200, 1, CBSE, CSZE,  GRAPH, BIOS,  6, 2}, /*  6  */
	{ 80,  25,    0,    0, 0, MBSE, MSZE, F8x14m, BIOS,  7, 0}, /*  7  */
	{  0,   0,    0,    0, 1,    0,    0,  GRAPH, BIOS, 12, 0}, /*  8  */
	{  0,   0,    0,    0, 0,    0,    0,  GRAPH, BIOS, 11, 0}, /*  9  */
	{ 80,  43,    0,    0, 1, CBSE, CSZE,   F8x8, TBLE,  0, (unchar)-1},/*  a  */
	{ 80,  43,    0,    0, 1, CBSE, CSZE,   F8x8, TBLE,  1, (unchar)-1},/*  b  */
	{  0,   0,    0,    0, 0,    0,    0,  GRAPH, BIOS, 12, (unchar)-1},/*  c  */
	{  0,   0,  320,  200, 1, EBSE, ESZE,  GRAPH, BIOS, 13, 2}, /*  d  */
	{  0,   0,  640,  200, 1, EBSE, ESZE,  GRAPH, BIOS, 14, 2}, /*  e  */
	{  0,   0,  640,  350, 0, EBSE, ESZE,  GRAPH, BIOS, 15, 0}, /*  f  */
	{  0,   0,  640,  350, 1, EBSE, ESZE,  GRAPH, BIOS, 16, 1}, /* 10  */
	{  0,   0,  640,  480, 0, EBSE, ELSZ,  GRAPH, BIOS, 17, 1}, /*  f* */
	{  0,   0,  640,  480, 1, EBSE, ELSZ,  GRAPH, BIOS, 18, 1}, /* 10* */
	{ 40,  25,    0,    0, 1, CBSE, CSZE,  F8x14, BIOS, 19, 1}, /*  0* */
	{ 40,  25,    0,    0, 1, CBSE, CSZE,  F8x14, BIOS, 20, 1}, /*  1* */
	{ 80,  25,    0,    0, 1, CBSE, CSZE,  F8x14, BIOS, 21, 1}, /*  2* */
	{ 80,  25,    0,    0, 1, CBSE, CSZE,  F8x14, BIOS, 22, 1}, /*  3* */
	{ 40,  25,    0,    0, 1, CBSE, CSZE,  F9x16, BIOS, 23, 1}, /* 0,1+ */
	{ 80,  25,    0,    0, 1, CBSE, CSZE,  F9x16, BIOS, 24, 1}, /* 2,3+ */
	{ 80,  25,    0,    0, 0, MBSE, MSZE,  F9x16, BIOS, 25, 0}, /*  7+ */
	{  0,   0,  640,  480, 1, EBSE, ELSZ,  GRAPH, BIOS, 26, 1}, /* 11  */
	{  0,   0,  640,  480, 1, EBSE, ELSZ,  GRAPH, BIOS, 27, 1}, /* 12  */
	{  0,   0,  320,  200, 1, EBSE, ESZE,  GRAPH, BIOS, 28, 3}, /* 13  */
	{ 40,  25,    0,    0, 1, CBSE, CSZE,  F9x16, BIOS, 23, 1}, /*  0+ */
	{ 80,  25,    0,    0, 1, CBSE, CSZE,  F9x16, BIOS, 24, 1}, /*  2+ */
	{  0,   0,  640,  480, 0, EBSE, ELSZ,  GRAPH, BIOS, 17, 1}, /*  f* */
	{  0,   0,  640,  480, 1, EBSE, ELSZ,  GRAPH, BIOS, 18, 1}, /* 10* */
	{ 80,  25,    0,    0, 1, CBSE, CSZE,  F8x14, TBLE,  2, (unchar)-1},/* 40  */
	{  0,   0,  640,  400, 1, EBSE, ELSZ,  GRAPH, TBLE,  3, 1}, /* 42  */
	{0,  0,    0,    0, 0, 0, 0,  0, 0,  0, 0}, /* 132x25 placeholder */
	{0,  0,    0,    0, 0, 0, 0,  0, 0,  0, 0}, /* 132x25 placeholder */
	{0,  0,    0,    0, 0, 0, 0,  0, 0,  0, 0}, /* 132x43 placeholder */
	{0,  0,    0,    0, 0, 0, 0,  0, 0,  0, 0}, /* 132x43 placeholder */
	{  0,   0,  800,  600, 1, EBSE, ESZE,  GRAPH, TBLE,  5, 1}, /* ??  */
	{  0,   0,  640,  400, 1, EBSE, ELSZ,  GRAPH, TBLE,  6, 3}, /* ??  */
#ifdef	EVC
	{  0,	0,  640,  480, 1, EBSE, EHSZ,  GRAPH, TBLE,  7, 3}, /* ??  */
	{  0,	0, 1024,  768, 1, EBSE, ELSZ,  GRAPH, TBLE,  8, 1}, /* ??  */
	{  0,	0, 1024,  768, 1, VBSE, VSZE,  GRAPH, TBLE,  8, 3}, /* ??  */
#endif	/*EVC*/
#ifdef EVGA
  {0,0,  640,  480, 1, EBSE, 64*1024,  GRAPH, TBLE,  VT_VGA+STEVGA, (unchar)-1}, 
  {0,0,  720,  540, 1, EBSE, 64*1024,  GRAPH, TBLE,  VT_VEGA720+STEVGA, (unchar)-1}, 
  {0,0,  800,  600, 1, EBSE, 64*1024,  GRAPH, TBLE,  VT_VEGA800+STEVGA, (unchar)-1}, 
  {0,0,  800,  560, 1, EBSE, 64*1024,  GRAPH, TBLE, VT_TSL8005_16+STEVGA,(unchar)-1}, 
  {0,0,  800,  600, 1, EBSE, 64*1024,  GRAPH, TBLE, VT_TSL8006_16+STEVGA,(unchar)-1}, 
  {0,0,  960,  720, 1, EBSE, 128*1024,  GRAPH, TBLE,  VT_TSL960+STEVGA, (unchar)-1}, 
  {0,0,  1024, 768, 1, EBSE, 128*1024,  GRAPH, TBLE,  VT_TSL1024+STEVGA, (unchar)-1}, 
  {0,0,  800,  560, 1, EBSE, 64*1024,  GRAPH, TBLE, VT_TSL8005_16+STEVGA,(unchar)-1}, 
  {0,0,  800,  600, 1, EBSE, 64*1024,  GRAPH, TBLE, VT_TSL8006_16+STEVGA,(unchar)-1}, 
  {0,0,  800,  600, 1, EBSE, 64*1024,  GRAPH, TBLE,  VT_PVGA1A+STEVGA, (unchar)-1}, 
  {0,0,  720,  540, 1, EBSE, 64*1024,  GRAPH, TBLE,  VT_DELL7+STEVGA, (unchar)-1}, 
  {0,0,  800,  600, 1, EBSE, 64*1024,  GRAPH, TBLE,  VT_DELL8+STEVGA, (unchar)-1}, 
  {0,0,  640,  480, 1, EBSE, 64*1024,  GRAPH, TBLE,  VT_V7VRAM6+STEVGA, (unchar)-1}, 
  {0,0,  720,  540, 1, EBSE, 64*1024,  GRAPH, TBLE,  VT_V7VRAM7+STEVGA, (unchar)-1}, 
  {0,0,  800,  600, 1, EBSE, 64*1024,  GRAPH, TBLE,  VT_V7VRAM8+STEVGA, (unchar)-1}, 
  {0,0,  1024, 768, 0, EBSE, 128*1024,  GRAPH, TBLE,  VT_V7VRAM1_2+STEVGA,(unchar)-1}, 
  {0,0,  1024, 768, 1, EBSE, 128*1024,  GRAPH, TBLE,  VT_V7VRAM1_4+STEVGA,(unchar)-1}, 
  {0,0,  1024, 768, 1, EBSE, 128*1024,  GRAPH, TBLE, VT_V7VRAM1_16+STEVGA,(unchar)-1}, 
  {0,0,  800,  600, 1, EBSE, 64*1024,  GRAPH, TBLE,/*VT_ORVGA8*/VT_TSL8006_16+STEVGA, (unchar)-1}, 
  {0,0,  1024, 768, 1, EBSE, 128*1024,  GRAPH, TBLE,  VT_TSL1024+STEVGA, (unchar)-1}, 
  {0,0,  1024, 768, 1, EBSE, 128*1024,  GRAPH, TBLE,  VT_TSL1024ni+STEVGA,(unchar)-1}, 
  {0,0,  800,  560, 1, EBSE, 64*1024,  GRAPH, TBLE, VT_TSL8005_16+STEVGA,(unchar)-1}, 
  {0,0,  800,  600, 1, EBSE, 64*1024,  GRAPH, TBLE, VT_TSL8006_16+STEVGA,(unchar)-1}, 
  {0,0,  1024, 768, 1, EBSE, 128*1024,  GRAPH, TBLE,  VT_TSL1024+STEVGA, (unchar)-1}, 
  {0,0,  1024, 768, 1, EBSE, 128*1024,  GRAPH, TBLE,  VT_TSL1024ni+STEVGA,(unchar)-1}, 
  {0,0,  800,  600, 1, EBSE, 64*1024,  GRAPH, TBLE,  VT_GVGA8_6+STEVGA, (unchar)-1}, 
  {0,0,  1024, 768, 1, EBSE, 128*1024,  GRAPH, TBLE,  VT_TSL1024+STEVGA, (unchar)-1}, 
  {0,0,  640,  350, 1, EBSE, 32*1024,  GRAPH, TBLE,  VT_EGA+STEVGA, (unchar)-1}, 
  {0,0,  640,  480, 1, EBSE, 64*1024,  GRAPH, TBLE,  VT_PEGA+STEVGA, (unchar)-1}, 
  {0,0,  640,  480, 1, EBSE, 64*1024,  GRAPH, TBLE,  VT_GENEGA_6+STEVGA, (unchar)-1}, 
  {0,0,  800,  600, 1, EBSE, 64*1024,  GRAPH, TBLE,  VT_GENEGA_8+STEVGA, (unchar)-1}, 
  {0,0,  640,  480, 1, EBSE, 64*1024,  GRAPH, TBLE,  VT_V7VRAM6+STEVGA, (unchar)-1}, 
  {0,0,  720,  540, 1, EBSE, 64*1024,  GRAPH, TBLE,  VT_V7VRAM7+STEVGA, (unchar)-1}, 
  {0,0,  800,  600, 1, EBSE, 64*1024,  GRAPH, TBLE,  VT_V7VRAM8+STEVGA, (unchar)-1}, 
  {0,0, 1024, 768, 0, EBSE, 128*1024,  GRAPH, TBLE,  VT_V7VRAM1_2+STEVGA, (unchar)-1}, 
  {0,0, 1024, 768, 1, EBSE, 128*1024,  GRAPH, TBLE, VT_V7VRAM1_4+STEVGA, (unchar )-1}, 
  {0,0,  800, 600, 1, EBSE, 64*1024,  GRAPH, TBLE,  VT_VGAWON+STEVGA, (unchar )-1}, 
  {0,0,  1024, 768, 1, EBSE, 128*1024,  GRAPH, TBLE,  VT_PVGA1024+STEVGA, (unchar )-1}, 
  {0,0,  800,  600, 1, EBSE, 64*1024,  GRAPH, TBLE,  VT_PVGA1024_8+STEVGA, (unchar)-1}, 

#endif /* EVGA */
};

unchar kd_ramdactab[] = {  /* modes 7/400, 7/350, F, 56, 57, 59 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x2a, 
	0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 
	0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 
	0x2a, 0x2a, 0x2a, 
	0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 
	0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 
	0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 
	0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
	0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
	0x3f, 0x3f, 0x3f, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x2a,
	0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 
	0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 
	0x2a, 0x2a, 0x2a, 
	0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 
	0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 
	0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 
	0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 
	0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 
	0x3f, 0x3f, 0x3f, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
/* modes 1/400, 1/350, 3/400, 3/350, 10, 11, 12, 54, 55, 58 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x2a, 0x00,
	0x00, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x2a, 0x00, 0x2a, 
	0x2a, 0x2a, 0x00, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x15, 
	0x00, 0x00, 0x3f, 0x00, 0x2a, 0x15, 0x00, 0x2a, 0x3f, 
	0x2a, 0x00, 0x15, 0x2a, 0x00, 0x3f, 0x2a, 0x2a, 0x15, 
	0x2a, 0x2a, 0x3f, 
	0x00, 0x15, 0x00, 0x00, 0x15, 0x2a, 0x00, 0x3f, 0x00, 
	0x00, 0x3f, 0x2a, 0x2a, 0x15, 0x00, 0x2a, 0x15, 0x2a, 
	0x00, 0x3f, 0x00, 0x00, 0x3f, 0x2a, 0x00, 0x15, 0x15, 
	0x00, 0x15, 0x3f, 0x00, 0x3f, 0x15, 0x00, 0x3f, 0x3f,
	0x2a, 0x15, 0x15, 0x2a, 0x15, 0x3f, 0x2a, 0x3f, 0x15,
	0x2a, 0x3f, 0x3f, 
	0x15, 0x00, 0x00, 0x15, 0x00, 0x2a, 0x15, 0x2a, 0x00,
	0x15, 0x2a, 0x2a, 0x3f, 0x00, 0x00, 0x3f, 0x00, 0x2a,
	0x3f, 0x2a, 0x00, 0x3f, 0x2a, 0x2a, 0x15, 0x00, 0x15,
	0x15, 0x00, 0x3f, 0x15, 0x2a, 0x15, 0x15, 0x2a, 0x3f, 
	0x3f, 0x00, 0x15, 0x3f, 0x00, 0x3f, 0x3f, 0x2a, 0x15, 
	0x3f, 0x2a, 0x3f, 
	0x15, 0x15, 0x00, 0x15, 0x15, 0x2a, 0x15, 0x3f, 0x00, 
	0x15, 0x3f, 0x2a, 0x3f, 0x15, 0x00, 0x3f, 0x15, 0x2a, 
	0x3f, 0x3f, 0x00, 0x3f, 0x3f, 0x2a, 0x15, 0x15, 0x15, 
	0x15, 0x15, 0x3f, 0x15, 0x3f, 0x15, 0x15, 0x3f, 0x3f, 
	0x3f, 0x15, 0x15, 0x3f, 0x15, 0x3f, 0x3f, 0x3f, 0x15, 
	0x3f, 0x3f, 0x3f, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
/* modes 1/200, 3/200, 4, 5, 6, D, E */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x2a, 0x00,
	0x00, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x2a, 0x00, 0x2a, 
	0x2a, 0x15, 0x00, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x2a, 0x00, 0x2a, 0x00, 0x00, 0x2a, 0x2a, 
	0x2a, 0x00, 0x00, 0x2a, 0x00, 0x2a, 0x2a, 0x15, 0x00, 
	0x2a, 0x2a, 0x2a, 
	0x15, 0x15, 0x15, 0x15, 0x15, 0x3f, 0x15, 0x3f, 0x15, 
	0x15, 0x3f, 0x3f, 0x3f, 0x15, 0x15, 0x3f, 0x15, 0x3f, 
	0x3f, 0x3f, 0x15, 0x3f, 0x3f, 0x3f, 0x15, 0x15, 0x15, 
	0x15, 0x15, 0x3f, 0x15, 0x3f, 0x15, 0x15, 0x3f, 0x3f,
	0x3f, 0x15, 0x15, 0x3f, 0x15, 0x3f, 0x3f, 0x3f, 0x15, 
	0x3f, 0x3f, 0x3f, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x2a, 0x00,
	0x00, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x2a, 0x00, 0x2a,
	0x2a, 0x15, 0x00, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x2a, 0x00, 0x2a, 0x00, 0x00, 0x2a, 0x2a, 
	0x2a, 0x00, 0x00, 0x2a, 0x00, 0x2a, 0x2a, 0x15, 0x00, 
	0x2a, 0x2a, 0x2a, 
	0x15, 0x15, 0x15, 0x15, 0x15, 0x3f, 0x15, 0x3f, 0x15, 
	0x15, 0x3f, 0x3f, 0x3f, 0x15, 0x15, 0x3f, 0x15, 0x3f, 
	0x3f, 0x3f, 0x15, 0x3f, 0x3f, 0x3f, 0x15, 0x15, 0x15, 
	0x15, 0x15, 0x3f, 0x15, 0x3f, 0x15, 0x15, 0x3f, 0x3f, 
	0x3f, 0x15, 0x15, 0x3f, 0x15, 0x3f, 0x3f, 0x3f, 0x15, 
	0x3f, 0x3f, 0x3f, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	/* modes 13, 5E, 5F */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x2a, 0x00,
	0x00, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x2a, 0x00, 0x2a,
	0x2a, 0x15, 0x00, 0x2a, 0x2a, 0x2a, 0x15, 0x15, 0x15,
	0x15, 0x15, 0x3f, 0x15, 0x3f, 0x15, 0x15, 0x3f, 0x3f,
	0x3f, 0x15, 0x15, 0x3f, 0x15, 0x3f, 0x3f, 0x3f, 0x15,
	0x3f, 0x3f, 0x3f, 
	0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x08, 0x08, 0x08, 
	0x0b, 0x0b, 0x0b, 0x0e, 0x0e, 0x0e, 0x11, 0x11, 0x11, 
	0x14, 0x14, 0x14, 0x18, 0x18, 0x18, 0x1c, 0x1c, 0x1c, 
	0x20, 0x20, 0x20, 0x24, 0x24, 0x24, 0x28, 0x28, 0x28, 
	0x2d, 0x2d, 0x2d, 0x32, 0x32, 0x32, 0x38, 0x38, 0x38, 
	0x3f, 0x3f, 0x3f, 
	0x00, 0x00, 0x3f, 0x10, 0x00, 0x3f, 0x1f, 0x00, 0x3f, 
	0x2f, 0x00, 0x3f, 0x3f, 0x00, 0x3f, 0x3f, 0x00, 0x2f, 
	0x3f, 0x00, 0x1f, 0x3f, 0x00, 0x10, 0x3f, 0x00, 0x00, 
	0x3f, 0x10, 0x00, 0x3f, 0x1f, 0x00, 0x3f, 0x2f, 0x00, 
	0x3f, 0x3f, 0x00, 0x2f, 0x3f, 0x00, 0x1f, 0x3f, 0x00, 
	0x10, 0x3f, 0x00, 
	0x00, 0x3f, 0x00, 0x00, 0x3f, 0x10, 0x00, 0x3f, 0x1f,
	0x00, 0x3f, 0x2f, 0x00, 0x3f, 0x3f, 0x00, 0x2f, 0x3f,
	0x00, 0x1f, 0x3f, 0x00, 0x10, 0x3f, 0x1f, 0x1f, 0x3f,
	0x27, 0x1f, 0x3f, 0x2f, 0x1f, 0x3f, 0x37, 0x1f, 0x3f,
	0x3f, 0x1f, 0x3f, 0x3f, 0x1f, 0x37, 0x3f, 0x1f, 0x2f,
	0x3f, 0x1f, 0x27, 
	0x3f, 0x1f, 0x1f, 0x3f, 0x27, 0x1f, 0x3f, 0x2f, 0x1f, 
	0x3f, 0x37, 0x1f, 0x3f, 0x3f, 0x1f, 0x37, 0x3f, 0x1f, 
	0x2f, 0x3f, 0x1f, 0x27, 0x3f, 0x1f, 0x1f, 0x3f, 0x1f, 
	0x1f, 0x3f, 0x27, 0x1f, 0x3f, 0x2f, 0x1f, 0x3f, 0x37, 
	0x1f, 0x3f, 0x3f, 0x1f, 0x37, 0x3f, 0x1f, 0x2f, 0x3f, 
	0x1f, 0x27, 0x3f, 
	0x2d, 0x2d, 0x3f, 0x31, 0x2d, 0x3f, 0x36, 0x2d, 0x3f, 
	0x3a, 0x2d, 0x3f, 0x3f, 0x2d, 0x3f, 0x3f, 0x2d, 0x3a, 
	0x3f, 0x2d, 0x36, 0x3f, 0x2d, 0x31, 0x3f, 0x2d, 0x2d, 
	0x3f, 0x31, 0x2d, 0x3f, 0x36, 0x2d, 0x3f, 0x3a, 0x2d, 
	0x3f, 0x3f, 0x2d, 0x3a, 0x3f, 0x2d, 0x36, 0x3f, 0x2d, 
	0x31, 0x3f, 0x2d,
	0x2d, 0x3f, 0x2d, 0x2d, 0x3f, 0x31, 0x2d, 0x3f, 0x36,
	0x2d, 0x3f, 0x3a, 0x2d, 0x3f, 0x3f, 0x2d, 0x3a, 0x3f,
	0x2d, 0x36, 0x3f, 0x2d, 0x31, 0x3f, 0x00, 0x00, 0x1c,
	0x07, 0x00, 0x1c, 0x0e, 0x00, 0x1c, 0x15, 0x00, 0x1c,
	0x1c, 0x00, 0x1c, 0x1c, 0x00, 0x15, 0x1c, 0x00, 0x0e,
	0x1c, 0x00, 0x07, 
	0x1c, 0x00, 0x00, 0x1c, 0x07, 0x00, 0x1c, 0x0e, 0x00, 
	0x1c, 0x15, 0x00, 0x1c, 0x1c, 0x00, 0x15, 0x1c, 0x00, 
	0x0e, 0x1c, 0x00, 0x07, 0x1c, 0x00, 0x00, 0x1c, 0x00, 
	0x00, 0x1c, 0x07, 0x00, 0x1c, 0x0e, 0x00, 0x1c, 0x15, 
	0x00, 0x1c, 0x1c, 0x00, 0x15, 0x1c, 0x00, 0x0e, 0x1c, 
	0x00, 0x07, 0x1c, 
	0x0e, 0x0e, 0x1c, 0x11, 0x0e, 0x1c, 0x15, 0x0e, 0x1c, 
	0x18, 0x0e, 0x1c, 0x1c, 0x0e, 0x1c, 0x1c, 0x0e, 0x18, 
	0x1c, 0x0e, 0x15, 0x1c, 0x0e, 0x11, 0x1c, 0x0e, 0x0e, 
	0x1c, 0x11, 0x0e, 0x1c, 0x15, 0x0e, 0x1c, 0x18, 0x0e, 
	0x1c, 0x1c, 0x0e, 0x18, 0x1c, 0x0e, 0x15, 0x1c, 0x0e, 
	0x11, 0x1c, 0x0e,
	0x0e, 0x1c, 0x0e, 0x0e, 0x1c, 0x11, 0x0e, 0x1c, 0x15,
	0x0e, 0x1c, 0x18, 0x0e, 0x1c, 0x1c, 0x0e, 0x18, 0x1c,		
	0x0e, 0x15, 0x1c, 0x0e, 0x11, 0x1c, 0x14, 0x14, 0x1c,
	0x16, 0x14, 0x1c, 0x18, 0x14, 0x1c, 0x1a, 0x14, 0x1c,
	0x1c, 0x14, 0x1c, 0x1c, 0x14, 0x1a, 0x1c, 0x14, 0x18,
	0x1c, 0x14, 0x16, 
	0x1c, 0x14, 0x14, 0x1c, 0x16, 0x14, 0x1c, 0x18, 0x14, 
	0x1c, 0x1a, 0x14, 0x1c, 0x1c, 0x14, 0x1a, 0x1c, 0x14, 
	0x18, 0x1c, 0x14, 0x16, 0x1c, 0x14, 0x14, 0x1c, 0x14, 
	0x14, 0x1c, 0x16, 0x14, 0x1c, 0x18, 0x14, 0x1c, 0x1a, 
	0x14, 0x1c, 0x1c, 0x14, 0x1a, 0x1c, 0x14, 0x18, 0x1c, 
	0x14, 0x16, 0x1c, 
	0x00, 0x00, 0x10, 0x04, 0x00, 0x10, 0x08, 0x00, 0x10, 
	0x0c, 0x00, 0x10, 0x10, 0x00, 0x10, 0x10, 0x00, 0x0c, 
	0x10, 0x00, 0x08, 0x10, 0x00, 0x04, 0x10, 0x00, 0x00, 
	0x10, 0x04, 0x00, 0x10, 0x08, 0x00, 0x10, 0x0c, 0x00, 
	0x10, 0x10, 0x00, 0x0c, 0x10, 0x00, 0x08, 0x10, 0x00, 
	0x04, 0x10, 0x00,
	0x00, 0x10, 0x00, 0x00, 0x10, 0x04, 0x00, 0x10, 0x08,
	0x00, 0x10, 0x0c, 0x00, 0x10, 0x10, 0x00, 0x0c, 0x10,
	0x00, 0x08, 0x10, 0x00, 0x04, 0x10, 0x08, 0x08, 0x10,
	0x0a, 0x08, 0x10, 0x0c, 0x08, 0x10, 0x0e, 0x08, 0x10,
	0x10, 0x08, 0x10, 0x10, 0x08, 0x0e, 0x10, 0x08, 0x0c,
	0x10, 0x08, 0x0a,
	0x10, 0x08, 0x08, 0x10, 0x0a, 0x08, 0x10, 0x0c, 0x08,
	0x10, 0x0e, 0x08, 0x10, 0x10, 0x08, 0x0e, 0x10, 0x08,
	0x0c, 0x10, 0x08, 0x0a, 0x10, 0x08, 0x08, 0x10, 0x08,
	0x08, 0x10, 0x0a, 0x08, 0x10, 0x0c, 0x08, 0x10, 0x0e,
	0x08, 0x10, 0x10, 0x08, 0x0e, 0x10, 0x08, 0x0c, 0x10,
	0x08, 0x0a, 0x10,
	0x0b, 0x0b, 0x10, 0x0c, 0x0b, 0x10, 0x0d, 0x0b, 0x10,
	0x0f, 0x0b, 0x10, 0x10, 0x0b, 0x10, 0x10, 0x0b, 0x0f,
	0x10, 0x0b, 0x0d, 0x10, 0x0b, 0x0c, 0x10, 0x0b, 0x0b,
	0x10, 0x0c, 0x0b, 0x10, 0x0d, 0x0b, 0x10, 0x0f, 0x0b,
	0x10, 0x10, 0x0b, 0x0f, 0x10, 0x0b, 0x0d, 0x10, 0x0b,
	0x0c, 0x10, 0x0b,
	0x0b, 0x10, 0x0b, 0x0b, 0x10, 0x0c, 0x0b, 0x10, 0x0d,
	0x0b, 0x10, 0x0f, 0x0b, 0x10, 0x10, 0x0b, 0x0f, 0x10,
	0x0b, 0x0d, 0x10, 0x0b, 0x0c, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00
};

/*
 * Table giving the information needed to use the initialization tables above.
 * This consists of the number of elements in the structure, the location of
 * the address register, and the location of the data register.
 */

struct reginfo kd_regtab[] = {
	16, 0x3b4, 0x3b5, 	/* m6845init, monochrome */
	16, 0x3d4, 0x3d5, 	/* m6845init, color/graphics */
	25, 0x3b4, 0x3b5, 	/* egainit, monochrome */
	25, 0x3d4, 0x3d5, 	/* egainit, color */
	NSEQ, 0x3c4, 0x3c5, 	/* seqinit */
	NGRAPH, 0x3ce, 0x3cf,	/* graphinit */
	NATTR, 0x3c0, 0x3c0, 	/* attrinit */
	NATTR, 0x3c0, 0x3c1, 	/* attrinit */
};

/*
   For now all I/O addresses will be the same to ease VP/ix
   integration from iopl 3 to iopl 0.  Hopefully it will be
   changed to only be the ports that are valid for each adapter
   at some point.

ushort kd_adtiotab[MKDIOADDR] = {
	0x60, 0x64,
	0x3b0,0x3b1,0x3b2,0x3b3,0x3b4,0x3b5,0x3b6,0x3b7,
	0x3b8,0x3b9,0x3ba,0x3bb,0x3bc,0x3bd,0x3be,0x3bf,
	0x3c0,0x3c1,0x3c2,0x3c3,0x3c4,0x3c5,0x3c6,0x3c7,
	0x3c8,0x3c9,0x3ca,0x3cb,0x3cc,0x3cd,0x3ce,0x3cf,
	0x3d0,0x3d1,0x3d2,0x3d3,0x3d4,0x3d5,0x3d6,0x3d7,
	0x3d8,0x3d9,0x3da,0x3db,0x3dc,0x3dd,0x3de,0x3df
};
*/

ushort kd_iotab[4][MKDBASEIO] = {
	/* Mono */
	{ 0x3d0, 0x3d1, 0x3d4, 0x3d5, 0x3d8, 0x3d9, 0x3b4, 0x3b5,
	  0x3b8, 0x3ba, 0x3da, 0x3db, 0x3c0, 0x3c1, 0x3c2, 0x3c3,
	  0x3c4, 0x3c5, 0x3c6, 0x3c7, 0x3c8, 0x3c9, 0x3ca, 0x3cb,
	  0x3cc, 0x3cd, 0x3ce, 0x3cf, 0x3dc, 0x3de, },
	/* Hercules */
	{ 0x3d0, 0x3d1, 0x3d4, 0x3d5, 0x3d8, 0x3d9, 0x3b4, 0x3b5,
	  0x3b8, 0x3ba, 0x3da, 0x3db, 0x3c0, 0x3c1, 0x3c2, 0x3c3,
	  0x3c4, 0x3c5, 0x3c6, 0x3c7, 0x3c8, 0x3c9, 0x3ca, 0x3cb,
	  0x3cc, 0x3cd, 0x3ce, 0x3cf, 0x3dc, 0x3de, 0x3bb, 0x3bf, },
	/* color */
	{ 0x3b4, 0x3b5, 0x3ba, 0x3c0, 0x3c2, 0x3c4, 0x3b8, 0x3d0,
	  0x3d1, 0x3d8, 0x3db, 0x3dc, 0x3c1, 0x3c3, 0x3c6, 0x3c7,
	  0x3c8, 0x3c9, 0x3cb, 0x3cd, 0x3c5, 0x3ca, 0x3cc, 0x3ce,
	  0x3cf, 0x3d4, 0x3d5, 0x3da, 0x3de, 0x3d9, 0x3bb, },
	/* EGA */
	{ 0x3b4, 0x3b5, 0x3ba, 0x3c0, 0x3c2, 0x3c4, 0x3b8, 0x3d0,
	  0x3d1, 0x3d8, 0x3db, 0x3dc, 0x3c1, 0x3c3, 0x3c6, 0x3c7,
	  0x3c8, 0x3c9, 0x3cb, 0x3cd, 0x3c5, 0x3ca, 0x3cc, 0x3ce,
#ifdef	EVC
          0x3cf, 0x3d4, 0x3d5, 0x3da, 0x3de, 0x3d9, 0x3bb, 0x3d6, 0x3d7 },
#else	/*EVC*/
          0x3cf, 0x3d4, 0x3d5, 0x3da, 0x3de, 0x3d9, 0x3bb, },
#endif	/*EVC*/
};

struct attrmask kb_attrmask[] = {
	NORM,	0x00,			/*  0   attributes off */
	BRIGHT,	ALLATTR,		/*  1   bold intensity */
	0x00,	ALLATTR,		/*  2   not used */
	0x00,	ALLATTR,		/*  3   not used */
	0x00,	BLINK|BRIGHT,		/*  4   underline */
	BLINK,	ALLATTR,		/*  5   blink */
	BLINK,	ALLATTR,		/*  6   not used */
	REVERSE,BLINK|BRIGHT,		/*  7   negative(reverse) image */
	0x00,	0x00,			/*  8   blank (non-display) */
	0x00,	ALLATTR,		/*  9   not used */
	0x00,	ALLATTR,		/* 10   not used */
	0x00,	ALLATTR,		/* 11   not used */
	0x00,	ALLATTR,		/* 12   not used */
	0x00,	ALLATTR,		/* 13   not used */
	0x00,	ALLATTR,		/* 14   not used */
	0x00,	ALLATTR,		/* 15   not used */
	0x00,	ALLATTR,		/* 16   not used */
	0x00,	ALLATTR,		/* 17   not used */
	0x00,	ALLATTR,		/* 18   not used */
	0x00,	ALLATTR,		/* 19   not used */
	0x00,	ALLATTR,		/* 20   not used */
	0x00,	ALLATTR,		/* 21   not used */
	0x00,	ALLATTR,		/* 22   not used */
	0x00,	ALLATTR,		/* 23   not used */
	0x00,	ALLATTR,		/* 24   not used */
	0x00,	ALLATTR,		/* 25   not used */
	0x00,	ALLATTR,		/* 26   not used */
	0x00,	ALLATTR,		/* 27   not used */
	0x00,	ALLATTR,		/* 28   not used */
	0x00,	ALLATTR,		/* 29   not used */
	0x00,	NOTFGRND,		/* 30   black foreground */
	0x04,	NOTFGRND,		/* 31   red foreground */
	0x02,	NOTFGRND,		/* 32   green foreground */
	0x06,	NOTFGRND,		/* 33   yellow foreground */
	0x01,	NOTFGRND,		/* 34   blue foreground */
	0x05,	NOTFGRND,		/* 35   magenta foreground */
	0x03,	NOTFGRND,		/* 36   cyan foreground */
	0x07,	NOTFGRND,		/* 37   white foreground */
	0x00,	ALLATTR,		/* 38   not used */
	0x00,	ALLATTR,		/* 39   not used */
	0x00,	NOTBGRND,		/* 40   black background */
	0x40,	NOTBGRND,		/* 41   red background */
	0x20,	NOTBGRND,		/* 42   green background */
	0x60,	NOTBGRND,		/* 43   yellow background */
	0x10,	NOTBGRND,		/* 44   blue background */
	0x50,	NOTBGRND,		/* 45   magenta background */
	0x30,	NOTBGRND,		/* 46   cyan background */
	0x70,	NOTBGRND		/* 47   white background */
};

int	nattrmsks = (sizeof(kb_attrmask) / sizeof(struct attrmask));

/*
 * Conversion table from standard adapter type numbers to the adapter type
 * numbers expected by Xenix applications.
 */

unchar kd_adtconv[] = {
	0, MONO, MONO, CGA, EGA, EGA
};

struct font_info fontinfo[] = {
	{ 0,	0,	0 },	/* No font */
	{ 0,	8,	256 },	/* 8x8 font */
	{ 0,	14,	256 },	/* 8x14 font */
	{ 0,	14,	0 },	/* 9x14 font (null terminated (no count)) */
	{ 0,	16,	256 },	/* 8x16 font */
	{ 0,	16,	0 },	/* 9x16 font (null terminated (no count)) */
	{ 0,	9,	256 },	/* 7x9 font */
	{ 0,	16,	256 },	/* 7x16 font */
};

#define	FONT_INFO_SIZE	sizeof(fontinfo)/sizeof(struct font_info)
struct font_info kd_romfonts [ FONT_INFO_SIZE ] = {0};

struct vertim kd_l350[] = {
	0x06, 0xae,
	0x10, 0x77,
	0x11, 0x27,
	0x15, 0x76,
	0x16, 0x12
} ;

struct vertim kd_l400[] = {
	0x00, 0x72,
	0x01, 0x4f,
	0x02, 0x57,
	0x03, 0x2e,
	0x04, 0x59,
	0x05, 0x66,
	0x06, 0xae,
	0x07, 0x1f,
	0x10, 0x8f,
	0x11, 0x2f,
	0x12, 0x8f,
	0x13, 0x28,
	0x15, 0x8f,
	0x16, 0x1f,
	0x17, 0xe3
} ;

struct vdc_info	Vdc = { 0 };

unsigned int	kd_font_offset[] = {0, 4, 12, 12, 26, 42};
