#INCLUDE <UPPERCASE>
#INCLUDE <SYSCALL>
#DEFINE SECTOR 256        /*SYSTEM SECTOR LENGTH*/
#DEFINE ESECT  0X04

#DEFINE READ 0
STATIC STRUCT \(
    CHAR     IOLAB;
    CHAR     IODIR;
    CHAR    *IOBUFF;
    INT      IOLENG;
    UNSIGNED IOSECT;
\) IOCB;
STATIC INT FLENG;

INT IO();

INT *
RRESET( LABEL, PLENG )
    CHAR LABEL;
    INT *PLENG;
\(
    STRUCT \( INT EREG,AREG,XREG \) LRET, LABADR();

    LRET = LABADR( LABEL );
    IOCB.IOLAB = (LRET.AREG != 0) ? LABEL : 0;
    IOCB.IOSECT = 0;
    IOCB.IODIR = READ;
    *PLENG = FLENG = LRET.XREG;
    RETURN (INT*) LRET.AREG;
\)

RBLOCK( ADDR, LENG )
    CHAR *ADDR;
    INT LENG;
\(
    INT RC;
    INT XLENG;                                  /*COMPLEMENTED LENGTH*/

    IOCB.IOBUFF = ADDR;
    IOCB.IOLENG = LENG;
    IF( IOCB.IOSECT >= FLENG ) ABORT( \^ ESECT );       /*EOF REACHED*/
    XLENG = (LENG+(SECTOR-1)) / SECTOR;
    IF( IOCB.IOSECT + XLENG > FLENG )\(
        IOCB.IOLENG = (FLENG - IOCB.IOSECT) * SECTOR;
    \)
    IF( (CHAR*) (RC = IO( &IOCB )) != &IOCB ) ABORT( RC );
    IOCB.IOSECT += XLENG;
\)
