/******************** HEADER INFO  ****************************
*
*   File name   :  proc.h
*/
/*  DATE        :  Thu May 18 20:36:34 2000                   */
/*  AUTHOR      :  Jan Erik Nilsen (jen@nilsenelektronikk.no) */
/*  VERSION     :  3.1                                        */
/*
*   Compiler    :  ANSI C
*
*   Contents    :  Prototypes and defines for proc.c
*
*
* Copyright (c) nilsen elektronikk as, Norway. (www.nilsenelektronikk.no)
* This software is the property of nilsen elektronikk as, Norway.
*
* The proc RTOS is free software; you can use it, redistribute it
* and/or modify it under the following terms:
* 1. You are not allowed to remove or modify this copyright notice
*    and License paragraphs, even if parts of the software is used.
* 2. The improvements and/or extentions you make SHALL be available
*    for the community under THIS license, source code included.
*    Improvements or extentions, including adaptions to new architectures,
*    SHALL be reported and transmitted to Nilsen Elektronikk AS.
* 3. You must cause the modified files to carry prominent notices stating
*    that you changed the files, what you did and the date of changes.
* 4. You may NOT distribute this software under another license without
*    explisit permission from Nilsen Elektronikk AS, Norway.
* 5. This software is free, and distributed in the hope that it will be
*    useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*    You SHALL NOT use this software unless you accept to carry all
*    risk and cost of defects or limitations.
*
*    ------------  CHANGE RECORD  ----------------
*    Jan Erik Nilsen (jen@nilsenelektronikk.no) July 26. 1999:
*        First free version of this software published.
*
*    K. I. Hosum 15.11.1999
*        Added support for GNU CC / 196E
*
*    Eugeny Matsuef May 16. 2000
*        Added suppoer for Siemens C167 family.
*
*    Jan Erik Nilsen May 18. 2000:
*      Typo: procGetUsedWSSise --> procGetUsedWSSize
*      ALIGN introduced for i960. See packet.c
*
*    Fabien Hue E2S / France ( fh@e2s-net.com) Dec. 30. 2001
*      Added support for Hitachi HEW 1.0a / H8S advanced mode
*
*/
#ifndef PROC_DEFINED
#define PROC_DEFINED

#ifdef __IAR_SYSTEMS_ICC            /* IAR compilers   */
#define IAR_SYSTEMS_ICC
#endif
#ifdef IAR_SYSTEMS_ICC              /* IAR compilers   */
#if (((__TID__ >> 8) & 0x7F) == 10)
#define IAR_H8                      /*    H8-300       */
#define CRIT_REG_FUNC
#endif
#if (((__TID__ >> 8) & 0x7F) == 3)
#define IAR_68HC11                  /*    68HC11       */
#endif
#if (((__TID__ >> 8) & 0x7F) == 90)
#define IAR_AVR                     /*     AVR         */
#define CRIT_REG_FUNC
#include <ina90.h>
#endif
#if (((__TID__ >> 8) & 0x7F) == 0x1A)
#define IAR_196 1                    /* IAR 80C196     */
#define CRIT_REG_FUNC
#include <intrins.h>
#endif
														/*    H8S - LARGE  */
#if (((__TID__  & 0xFF) == 0x11) || ((__TID__  & 0xFF) == 0x21) || ((__TID__  & 0xFF) == 0x31))
#define IAR_H8S
#define CRIT_REG_FUNC
#include <inh8.h>
#endif
														/*    H8S - HUGE   */
#if (((__TID__  & 0xFF) == 0x12) || ((__TID__  & 0xFF) == 0x22) || ((__TID__  & 0xFF) == 0x32))
#define IAR_H8S
#define CRIT_REG_FUNC
#include <inh8.h>
#endif
#endif

#ifdef _MSC_VER                     /* Microsoft C     */
#define DOS_86
#define ASM      _asm
#endif
#ifdef __TURBOC__               /* Borland Turbo C */
#define DOS_86
#define ASM      asm
#endif

#ifdef __CC62__                 /* Introl C 68332  */
#define MC68K
#define REINT
#endif

#ifdef _MCC                     /* Microtec C 68k/5200 */
#define MC68K
#define REINT
#ifdef _5200                    /* ColdFire 5200       */
#define INT_ATOMIC
#endif
#endif

#ifdef __i960__                 /* GNU CC i960  */
#define ALIGN_VAL  4
#define PROC_USE_STDARG
#define CRIT_REG_FUNC
#if defined(__i960SA) || defined(__i960SA__) || (_80960SA == 1)
#define REINT
#endif
#else
#ifdef __GNUC__  /* Kjell-Ivar Hosum */
#ifndef __pdp11__
#define GCC_H8S
#endif
#endif
#endif

#ifdef CXH11                    /* Whitesmiths M68HC11 */
#define enable_interrupt()  _asm("cli\n")
#define disable_interrupt() _asm("sei\n")
#endif

#ifdef _C196_                   /* Boston Systems Office Tasking 80c196 */
#define enable_interrupt()  asm ei
#define disable_interrupt() asm di
#define CRIT_REG_FUNC           /* functions for crit. regions */
#endif

#ifdef IAR_H8
#define enable_interrupt()  set_interrupt_mask(0)
#define disable_interrupt() set_interrupt_mask(1)
#endif

#ifdef IAR_H8S
#define enable_interrupt()  set_interrupt_mask(0)
#define disable_interrupt() set_interrupt_mask(1)
#endif

#ifdef DOS_86
#define  enable_interrupt()  ASM  sti
#define  disable_interrupt() ASM  cli
#endif

#ifdef GCC_H8S  /* Kjell-Ivar Hosum */
#define enable_interrupt() asm(" andc #127, ccr")
#define disable_interrupt() asm(" orc #128, ccr")
#endif

#ifdef __pdp11__
#define enable_interrupt() asm(" bic $0x00e0,0xfffe")
#define disable_interrupt() asm("bis $0x00e0,0xfffe")
#endif

#ifdef _C166                    /* Boston Systems Office Tasking 80c166 */
#include <reg167.h>
#define INT_ATOMIC
#define REINT
#endif


#ifdef CRIT_REG_FUNC      /* use functions for critical regions */
#ifdef __i960__                 /* GNU CC i960  */
#include "asmext.h"
#define BEGIN_CRITICAL_REGION()  atadd(&proc_nodisp, 1)
#define END_CRITICAL_REGION()    atadd(&proc_nodisp, -1)
#define INT_ATOMIC
#else
void begin_critical_region(void);
void end_critical_region(void);
#define  BEGIN_CRITICAL_REGION()  begin_critical_region()
#define  END_CRITICAL_REGION()    end_critical_region()
#endif
#else
#define  BEGIN_CRITICAL_REGION()  ++proc_nodisp
#define  END_CRITICAL_REGION()    --proc_nodisp
#endif

/*
    The ALIGN value can be used to align memory to an address dividable
    by 2^ALIGN_VAL. (Example: ALIGN == 4, gives address dividable by 16.
    I.e. The 4 LS bits are zero.)
    NB: An ALIGN value must be >= 2 to make sense.
    (ALIGN_VAL and the macros below is used in packet.c)
*/
#ifdef ALIGN_VAL
#define ALIGN_M1   ((1 << ALIGN_VAL) - 1)

/* If the input number is not dividable by 2^ALIGN, the calculated
   number is increased such that it is dividable */
#define ALIGNED_NUMBER(v) ((ALIGN_M1 + (v)) & ~ALIGN_M1)

/* The calculated addon value is such that added with the input value, the
   result is dividable by 2^ALIGN */
#define ALIGN_ADDON(v) ((1 << ALIGN_VAL) - ((v) & ALIGN_M1))
#endif


/*
    PID struct
------------------------------------------------------------*/
typedef struct pid {
  struct pid *next;    /* next pid on list                  */
  char       *stack;   /* stack of process when not running */
  char       *ws;      /* work space ptr                    */
  int        wssize;   /* work space size                   */
  int        age;      /* awake age                         */
  int        susp;     /* suspended if != 0                 */
  int        priority; /* priority. 0 is highest            */
  struct pid *sema;    /* ptr to next pid on semaphore list */
} PID;


/*
    Error states. Return values for function
    procTerminate();  and  procRemoveProcess();
----------------------------------------------------------*/
#define  PROC_YOU_OK    2     /* ok not current pid */
#define  PROC_ME_OK     1     /* ok current pid     */
#define  PROC_BADPID    0     /* pid not found      */


/*
    Number of priorities.
    0 is highest, PROC_PRISIZE - 1 is lowest priority
----------------------------------------------------------*/
#define  PROC_PRISIZE   8     /* or any other value */


/*
    SEMAPHORE struct
----------------------------------------------------------*/
typedef struct sem {
  struct pid *ph;  /* head ptr - the next waiting process */
  struct pid *pt;  /* tail ptr - the last waiting process */
  int      value;  /* semaphore value                     */
} SEMAPHORE;


#ifndef THIS_IS_PROC_C
extern PID   *proc_curpid;         /* pointer to current process         */
#ifdef INT_ATOMIC
extern int  proc_nodisp;           /* disallow tick dispatch if not zero */
#else
extern char  proc_nodisp;          /* disallow tick dispatch if not zero */
#endif
extern int   proc_runcnt;          /* number of running processes        */
extern int   proc_maxage;          /* max age before pre-emtive dispatch */
extern char  proc_pattern;         /* workspace filled with pattern      */
extern void (*proc_at_next)(void); /* to be done after contex switching  */
#endif


#ifdef __cplusplus  /* Kjell-Ivar Hosum */
extern "C" {
#endif

int procGetCCR(void);       /* not always defined */
void procSetCCR(int ccr);   /* not always defined */

#ifndef PROC_USE_STDARG
char *stack_frame(char *ws, int wssize, PID *pid,
                   void (*func)(), int *nparam);
#else
#include <stdarg.h>
char *stack_frame(char *ws, int wssize, PID *pid,
                   void (*func)(), int nparam, va_list ap);
#endif

#ifdef REINT  /* processors with interrupt levels. int sr must excist */
void procSetSR(int sr);
int procGetSR_DisIntr(void);
#define disable_interrupt()  sr = procGetSR_DisIntr()
#define enable_interrupt()   procSetSR(sr)
#endif

#ifdef MC68K
int procGetSR(void);
int procSetInterruptLevel(int ilev);
int procGetInterruptLevel(void);
#endif

#ifdef __i960__
unsigned int procSetPriorityLevel(unsigned int newpriority);
int procGetPriorityLevel(void);
#endif


void procInitialize(PID *pid, int priority);
void procCreateProcess(
  PID  *pid,                               /* process descriptor         */
  void (*func)(),                          /* process function           */
  int priority,                            /* priority                   */
  char *ws,                                /* work space (stack etc.)    */
  int  wssize,                             /* work space size [Bytes]    */
  int  nparam,                             /* # of parameters to process */
  ...);                                    /* parameters to process      */
int  procTerminate(PID *pid);
void procChangePriority(PID *pid, int priority);
void procReschedule(void);
int  procGetUsedWSSize(PID *pid);
void procSemInit(SEMAPHORE *sp, int value);
void procSemSignal(SEMAPHORE *sp);
int procSemSignalCareful(SEMAPHORE *sp);
void procSemWait(SEMAPHORE *sp);

#define procSemValue(s) (&(s)->value)

void procInsertProcess(PID *pid);   /* Private, dont use this function */
int  procRemoveProcess(PID *pid);   /* Private, dont use this function */

/*
    If the user defines USE_MALLOC,
    the following functions must be supplied by the user.
*/
void *procMalloc(unsigned int size);
void procFree(void *memptr);

#ifdef __cplusplus  /* Kjell-Ivar Hosum */
}
#endif

#endif
