/******************** MODULE INFO  ****************************
*
*  File name   :   pdp11.s
*
*  AUTHOR      :   Naohiko Shimizu (nshimizu@keyaki.cc.u-tokai.ac.jp)
*  VERSION     :   1.0                                        
*  DATE        :   Wen Oct 09 2002
*
*  Assembler   :   GNU GAS
*  Project     :   proc  Real-Time Kernel
*  Contents    :   Real-Time Kernel low level functions
*                  Processor dependent: pdp11
*
*
* Copyright (c) nilsen elektronikk as, Norway. (www.nilsenelektronikk.no)
* This software is the property of nilsen elektronikk as, Norway.
* Porting for PDP/11 by Naohiko Shimizu, Tokai University, Japan.
*
* The proc RTOS is free software; you can use it, redistribute it
* and/or modify it under the following terms:
* 1. You are not allowed to remove or modify this copyright notice
*    and License paragraphs, even if parts of the software is used.
* 2. The improvements and/or extentions you make SHALL be available
*    for the community under THIS license, source code included.
*    Improvements or extentions, including adaptions to new architectures,
*    SHALL be reported and transmitted to Nilsen Elektronikk AS.
* 3. You must cause the modified files to carry prominent notices stating
*    that you changed the files, what you did and the date of changes.
* 4. You may NOT distribute this software under another license without
*    explisit permission from Nilsen Elektronikk AS, Norway.
* 5. This software is free, and distributed in the hope that it will be
*    useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*    You SHALL NOT use this software unless you accept to carry all
*    risk and cost of defects or limitations.
*
*    ------------  CHANGE RECORD  ----------------
*    Naohiko Shimizu (nshimizu@keyaki.cc.u-tokai.ac.jp) October 09. 2002:
*        Porting for PDP/11
*    Jan Erik Nilsen (jen@nilsenelektronikk.no) July 26. 1999:
*        First free version of this software published.
*
*/
//* typedef struct pid {
//*   struct pid *next;	/* next pid on list                  */
//*   char	*stack;	/* stack of process when not running    */
//*   char	*ws;	/* work space ptr                       */
//*   int	wssize;	/* work space size                      */
//*   int	age;	/* awake age                            */
//*   int	sleep;	/* sleeping if != 0                     */
//*   int	priority;	/* priority. 0 is highest               */
//*   struct pid *sema;	/*                                      */
//* } PID;
//*
//*
//*    The only slots used in this file is: PID_STACK, PID_AGE
//*

PID_NEXT     =   0
PID_STACK    =   2
PID_WS       =   4
PID_WSSIZE   =   6
PID_AGE      =   8
PID_SLEEP    =   10
PID_PRIORITY =   12
PID_SEMA     =   14

PS	=	0177776

	.globl _forcereschedule

	.data
	.even

_forcereschedule:
		.word 0

	.text
	.even


/*------  Global variables  ---------------------------------------------*/
//*
//*  extern PID   *proc_curpid;   /* pointer to current process         */
//*  extern char  proc_nodisp;    /* disallow tick dispatch if not zero */
//*  extern int   proc_runcnt;    /* number of running processes        */
//*

//   .globl  _procCheckReschedule
   .globl  _procReschedule

/*===========  procCheckReschedule  ============================
*
*   Purpose:      Check _forcereschedule
*                 If TRUE, switch to another process
*                 else rti
*
*/
/*
_procCheckReschedule:
     tst      _forcereschedule
     bne      pcr4
     rti
pcr4:
     tst      _proc_nodisp
     beq      pcr5
     rti
pcr5:
     sub     $2,sp
     mov     2(sp),(sp)
     mov     4(sp),2(sp)
     mov     (sp),4(sp)
     mov     $_procReschedule,(sp)
     rti

*/

/*===========  procReschedule  ============================
*
*   Purpose:      Switch to another process
*
*   Input:        none
*   Output:       none
*   Return:       none
*
*  void procReschedule(void)
*/
_procReschedule:
     mov      PS,-(sp)
     tst      _proc_nodisp
     beq      prgo
     mov      $1,_forcereschedule
     mov      (sp)+,PS
     rts      pc

prgo:
     mov      r0,-(sp)
     mov      r1,-(sp)
     mov      r2,-(sp)
     mov      r3,-(sp)
     mov      r4,-(sp)
     mov      r5,-(sp)
     add      $1,_proc_nodisp
     mov      _proc_curpid,r1
     mov      sp,PID_STACK(r1)

     jsr      pc, _procNextProcess

     mov      _proc_curpid,r1
     mov      PID_STACK(r1),sp
     clr      PID_AGE(r1)
     sub      $1,_proc_nodisp
     clr      _forcereschedule
     mov      (sp)+,r5
     mov      (sp)+,r4
     mov      (sp)+,r3
     mov      (sp)+,r2
     mov      (sp)+,r1
     mov      (sp)+,r0
     mov      (sp)+,PS
     rts      pc

