////////////////////////////////////////////////////////////////////////////////
// MAIN.C - BBterm: A simple dumb terminal v0.02   by Athlor
////////////////////////////////////////////////////////////////////////////////
#include <Pager.h>
#include <Ribbon.h>
#include "icon.h"

char VersionPtr[] = "BBterm";
int AppStackSize = 1000;

static LcdConfig LCD; // Height & Width of LCD

void putchar(char c)
{
  if(LcdPutStringXY(-1,-1,&c,1,LCD_MULTILINE)==0||c=='\n')
  {
    LcdScroll(LcdGetFontHeight(-1));
    LcdSetCursorPoint(0,LCD.height-LcdGetFontHeight(-1));
    LcdPutStringXY(-1,-1,&c,1,0);
  }
}

void TermThread(void)
{
  int c;
  MESSAGE msg;
  PID pid;
  pid.Name = VersionPtr;
  pid.EnableForeground = TRUE;
  pid.Icon = NULL;
  RimSetPID(&pid);
  LcdGetConfig(&LCD); // Get LCD configuration
  RimRequestForeground(RimGetCurrentTaskID());
  LcdCopyBitmapToDisplay(&IconBMP, 0, 0);
  LcdPutStringXY(20,8,"BBterm v0.02\n\n",-1,LCD_MULTILINE);
  CommOpenPort(9600,8,COMM_NO_PARITY,1,2048,2048);

  for (;;)              // Start main loop
  {
    RimGetMessage(&msg);
    switch (msg.Device) // Msg loop
    {
      case DEVICE_KEYPAD:
        switch (msg.Event)
        {
          case KEY_DOWN:
          {
            c=msg.SubMsg;
            switch (c)
            {
              case KEY_ESCAPE: // ESCAPE key exits
                CommClosePort();
                RibbonShowRibbon();
                RimTerminateThread();
                break;
              default:
                CommSendChar(c);
                putchar(c); // Echo char
            }
            break;
          }
        }
      case DEVICE_COM1:
        switch (msg.Event)
        {
          case COMM_RX_AVAILABLE:
            putchar(CommReadChar());
        }
    } // Msg
  }   // Main
}

void PagerMain(void)
{
  RibbonRegisterFunction(VersionPtr, &IconBMP, 0, 40, TermThread, AppStackSize);
  return;
}
