/****************************************************************************
 ****************************************************************************
Recipient has requested a license and Intel Corporation ("Intel") is willing
to grant a license for the software entitled Linux Base Driver for the 
Intel(R) PRO/1000 Family of Adapters (e1000) (the "Software") being provided 
by Intel Corporation. 

"Licensed Patents" means patent claims licensable by Intel Corporation which are
 necessarily infringed by the use or sale of the Software alone or when combined
 with the operating system referred to below.
"Recipient" means the party to whom Intel delivers this Software.
"Licensee" means Recipient and those third parties that receive a license to any
 operating system available under the GNU Public License version 2.0 or later.

Copyright (c) 1996-2001 Intel Corporation 
All rights reserved. 

The license is provided to Recipient and Recipient's Licensees under the 
following terms.  

Redistribution and use in source and binary forms of the Software, with or 
without modification, are permitted provided that the following conditions are
met: 

Redistributions of source code of the Software may retain the above copyright
notice, this list of conditions and the following disclaimer. 
Redistributions in binary form of the Software may reproduce the above
copyright notice, this list of conditions and the following disclaimer in the 
documentation and/or other materials provided with the distribution. 
Neither the name of Intel Corporation nor the names of its contributors shall be
used to endorse or promote products derived from this Software without specific 
prior written permission.

Intel hereby grants Recipient and Licensees a non-exclusive, worldwide, royalty-
free patent license under Licensed Patents to make, use, sell, offer to sell, 
import and otherwise transfer the Software, if any, in source code and object 
code form. This license shall include changes to the Software that are error 
corrections or other minor changes to the Software that do not add functionality
or features when the Software is incorporated in any version of a operating 
system that has been distributed under the GNU General Public License 2.0 or 
later.  This patent license shall apply to the combination of the Software and 
any operating system licensed under the GNU Public License version 2.0 or later 
if, at the time Intel provides the Software to Recipient, such addition of the 
Software to the then publicly available versions of such operating system 
available under the GNU Public License version 2.0 or later (whether in gold,
beta or alpha form) causes such combination to be covered by the Licensed 
Patents. The patent license shall not apply to any other combinations which 
include the Software. No hardware per se is licensed hereunder. 
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED.IN NO EVENT SHALL INTEL OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************
 ***************************************************************************/

/**********************************************************************
 *                                                                     *
 * INTEL CORPORATION                                                   *
 *                                                                     *
 * This software is supplied under the terms of the license included   *
 * above.  All use of this software must be in accordance with the     *
 * terms of that license.                                              *
 *                                                                     *
 * Module Name:  idiag_e1000.h                                         *
 *                                                                     *
 * Abstract:     Header file for data structure definition for common  *
 *               diagnostics support                                   *
 *                                                                     *
 **********************************************************************/

#ifndef _IDIAG_E1000_H
#define _IDIAG_E1000_H

/* Unique base driver identifier */

#define IDIAG_E1000_DRIVER                      0x02

/* e1000 diagnostic commands */

#define IDIAG_E1000_DIAG_REG_TEST               0x01
#define IDIAG_E1000_DIAG_FIFO_TEST              0x02
#define IDIAG_E1000_DIAG_XSUM_TEST              0x03
#define IDIAG_E1000_DIAG_INTR_TEST              0x04
#define IDIAG_E1000_DIAG_LOOPBACK_TEST          0x05
#define IDIAG_E1000_DIAG_LINK_TEST              0x06
#define IDIAG_E1000_DIAG_GET_PHY_INFORMATION    0x0C

typedef struct {
    unsigned short Reg;
    unsigned short Pad;
    unsigned long WriteValue;
    unsigned long ReadValue;
} idiag_e1000_diag_reg_test_param_t;

typedef struct {
    unsigned short Offset;
    unsigned short Pad;
    unsigned long WriteValue;
    unsigned long ReadValue;
} idiag_e1000_diag_fifo_test_param_t;

typedef struct {
    unsigned long ExpectedChecksum;
    unsigned long ActualChecksum;
} idiag_e1000_diag_eeprom_test_param_t;

typedef struct {
  unsigned short line_speed;
  unsigned char media_type;
  unsigned char cable_length;
  unsigned char extended_10b_t_distance;
  unsigned char cable_polarity;
  unsigned char polarity_reversal;
  unsigned long idle_errors;
  unsigned char link_reset;
  unsigned long receive_errors;
  unsigned char mdi_x_mode;
  unsigned char local_rx;
  unsigned char remote_rx;
  unsigned char pci_mode;
  unsigned char bus_speed;
  unsigned char slot_size;
} idiag_e1000_diag_phy_information_param_t;

typedef enum {
    IDIAG_E1000_INTR_TEST_OK,
    IDIAG_E1000_INTR_TEST_NOT_EXEC,
    IDIAG_E1000_INTR_TEST_FAILED_WHILE_DISABLED,
    IDIAG_E1000_INTR_TEST_FAILED_WHILE_ENABLED,
    IDIAG_E1000_INTR_TEST_FAILED_MASKED_ENABLED
} idiag_e1000_diag_intr_test_param_t;

#define IDIAG_E1000_DIAG_MAC_LB     0x01
#define IDIAG_E1000_DIAG_TCVR_LB    0x02
#define IDIAG_E1000_DIAG_EXT_LB     0x04

#define IDIAG_E1000_ALL_LB        (IDIAG_E1000_DIAG_MAC_LB  | \
                                 IDIAG_E1000_DIAG_TCVR_LB | \
                                 IDIAG_E1000_DIAG_EXT_LB)

#define IDIAG_E1000_DEFAULT_LB    (IDIAG_E1000_DIAG_MAC_LB  | \
                                 IDIAG_E1000_DIAG_TCVR_LB)

typedef enum {
    IDIAG_E1000_LOOPBACK_TEST_OK,
    IDIAG_E1000_LOOPBACK_TEST_NOT_EXEC,
    IDIAG_E1000_LOOPBACK_TEST_FAILED
} idiag_e1000_diag_loopback_result_t;

typedef struct {
    /* input - loopback modes to run (MAC, TCVR, EXT) */
    unsigned int mode;

    /* results */
    idiag_e1000_diag_loopback_result_t mac;
    idiag_e1000_diag_loopback_result_t tcvr;
    idiag_e1000_diag_loopback_result_t ext;
} idiag_e1000_diag_loopback_test_param_t;

typedef enum {
    IDIAG_E1000_LINK_TEST_UP,
    IDIAG_E1000_LINK_TEST_DOWN,
    IDIAG_E1000_LINK_TEST_NOT_EXEC
} idiag_e1000_diag_link_test_param_t;

#endif
